/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcPayRefundBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcPayRefundBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushNewYcPayRefundBillService;
import com.tydic.fsc.common.busi.api.FscPushNewYcPayRefundBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushNewYcPayRefundBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcPayRefundBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPushNewYcPayRefundBillBusiServiceImpl
implements FscPushNewYcPayRefundBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcPayRefundBillBusiServiceImpl.class);
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private FscPushNewYcPayRefundBillService fscPushNewYcPayRefundBillService;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @Override
    public FscPushNewYcPayRefundBillBusiRspBO dealPushPayRefundBill(FscPushNewYcPayRefundBillBusiReqBO reqBO) {
        FscPushNewYcPayRefundBillBusiRspBO rspBO = new FscPushNewYcPayRefundBillBusiRspBO();
        FscClaimDetailPO fscClaimDetailPO = reqBO.getFscClaimDetailPO();
        FscOrderRefundPO fscOrderRefundPO = reqBO.getFscOrderRefundPO();
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO.setClaimId(fscClaimDetailPO.getClaimId());
        FscPushNewYcPayRefundBillReqBO pushReq = new FscPushNewYcPayRefundBillReqBO();
        pushReq.setData(reqBO.getParseData());
        pushReq.setToken(reqBO.getToken());
        pushReq.setIsPre(reqBO.getIsPrePay());
        FscPushNewYcPayRefundBillRspBO fscPushNewYcClaimRefundBillRspBO = this.fscPushNewYcPayRefundBillService.pushNewYcPayRefundBill(pushReq);
        FscPushLogPO pushLogPo = new FscPushLogPO();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(fscOrderRefundPO.getRefundId());
        if (pushReq.getIsPre().booleanValue()) {
            pushLogPo.setType(FscConstants.FscPushType.PRE_PAY_REFUND);
        } else {
            pushLogPo.setType(FscConstants.FscPushType.PAY_REFUND);
        }
        pushLogPo.setRespParseData(JSONObject.toJSONString((Object)fscPushNewYcClaimRefundBillRspBO));
        pushLogPo.setObjData(reqBO.getReqData());
        pushLogPo.setCreateTime(new Date());
        pushLogPo.setObjectNo(fscOrderRefundPO.getRefundNo());
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(fscOrderRefundPO.getRefundId());
        if (!fscPushNewYcClaimRefundBillRspBO.getRespCode().equals("0000")) {
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(fscPushNewYcClaimRefundBillRspBO.getMsg());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            pushLogPo.setRespData(decryptionAbilityRspBO.getData());
            pushLogPo.setPushParseData(reqBO.getParseData());
            pushLogPo.setStatus(FscConstants.FscPushStatus.FAIL);
            this.fscPushLogMapper.insert(pushLogPo);
            fscClaimDetailPO.setPushStatus(FscConstants.FscClaimPushStatus.PUSH_FAIL);
            fscClaimDetailPO.setFailReason(decryptionAbilityRspBO.getData());
            this.fscClaimDetailMapper.updatePushStatusBatch(Collections.singletonList(fscClaimDetailPO));
            fscRecvClaimPO.setStatus(FscConstants.FscClaimPushStatus.PUSH_FAIL);
            fscRecvClaimPO.setFailReason(decryptionAbilityRspBO.getData());
            this.fscRecvClaimMapper.update(fscRecvClaimPO);
            refundPO.setPushStatus(FscConstants.RefundPushStatus.PUSH_FAIL);
            refundPO.setExt2(decryptionAbilityRspBO.getData());
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(decryptionAbilityRspBO.getData());
        } else {
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(fscPushNewYcClaimRefundBillRspBO.getData());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            pushLogPo.setStatus(FscConstants.FscPushStatus.SUCCESS);
            pushLogPo.setPushParseData(reqBO.getParseData());
            pushLogPo.setRespData(decryptionAbilityRspBO.getData());
            this.fscPushLogMapper.insert(pushLogPo);
            fscClaimDetailPO.setPushStatus(FscConstants.FscClaimPushStatus.PUSH_SUCCESS);
            this.fscClaimDetailMapper.updatePushStatusBatch(Collections.singletonList(fscClaimDetailPO));
            int count = this.fscClaimDetailMapper.getNotPushDetailCount(fscClaimDetailPO.getClaimId());
            if (count == 0) {
                fscRecvClaimPO.setStatus(FscConstants.FscClaimPushStatus.PUSH_SUCCESS);
                this.fscRecvClaimMapper.update(fscRecvClaimPO);
            }
            refundPO.setPushStatus(FscConstants.RefundPushStatus.PUSH_SUCCESS);
            refundPO.setExt2("");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        this.fscOrderRefundMapper.updateById(refundPO);
        return rspBO;
    }

    @Override
    public FscPushNewYcPayRefundBillBusiRspBO dealPushStatusSync(FscPushNewYcPayRefundBillBusiReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u51b2\u9500\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPushResult() == null) {
            throw new FscBusinessException("198888", "\u63a8\u9001\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List detailPOList = this.fscClaimDetailMapper.getListByRefundId(reqBO.getRefundId());
        if (FscConstants.RefundPushStatus.PUSH_FAIL.equals(reqBO.getPushResult())) {
            for (FscClaimDetailPO fscClaimDetailPO : detailPOList) {
                fscClaimDetailPO.setPushStatus(FscConstants.FscClaimPushStatus.PUSH_FAIL);
                FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
                fscRecvClaimPO.setClaimId(fscClaimDetailPO.getClaimId());
                fscRecvClaimPO.setStatus(FscConstants.FscClaimPushStatus.PUSH_FAIL);
                this.fscRecvClaimMapper.update(fscRecvClaimPO);
                FscOrderRefundPO refundPO = new FscOrderRefundPO();
                refundPO.setRefundId(fscClaimDetailPO.getRefundId());
                refundPO.setPushStatus(FscConstants.RefundPushStatus.PUSH_FAIL);
                this.fscOrderRefundMapper.updateById(refundPO);
            }
            this.fscClaimDetailMapper.updatePushStatusBatch(detailPOList);
        } else {
            HashSet<Long> updateRecv = new HashSet<Long>();
            for (FscClaimDetailPO fscClaimDetailPO : detailPOList) {
                fscClaimDetailPO.setPushStatus(FscConstants.FscClaimPushStatus.PUSH_SUCCESS);
                updateRecv.add(fscClaimDetailPO.getClaimId());
                FscOrderRefundPO refundPO = new FscOrderRefundPO();
                refundPO.setRefundId(fscClaimDetailPO.getRefundId());
                refundPO.setPushStatus(FscConstants.RefundPushStatus.PUSH_SUCCESS);
                this.fscOrderRefundMapper.updateById(refundPO);
            }
            this.fscClaimDetailMapper.updatePushStatusBatch(detailPOList);
            for (Long claimId : updateRecv) {
                FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
                fscRecvClaimPO.setClaimId(claimId);
                int count = this.fscClaimDetailMapper.getNotPushDetailCount(claimId);
                if (count != 0) continue;
                fscRecvClaimPO.setStatus(FscConstants.FscClaimPushStatus.PUSH_SUCCESS);
                this.fscRecvClaimMapper.update(fscRecvClaimPO);
            }
        }
        FscPushNewYcPayRefundBillBusiRspBO rspBO = new FscPushNewYcPayRefundBillBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRefundIdList(detailPOList.stream().map(FscClaimDetailPO::getRefundId).collect(Collectors.toList()));
        return rspBO;
    }
}

