/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyRefundInvoiceBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyRefundInvoiceBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushUnifyRefundInvoiceBillService;
import com.tydic.fsc.common.busi.api.FscPushUnifyRefundInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.FscPushUnifyRefundInvoiceBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushUnifyRefundInvoiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPushUnifyRefundInvoiceBusiServiceImpl
implements FscPushUnifyRefundInvoiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushUnifyRefundInvoiceBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscPushUnifyRefundInvoiceBillService fscPushUnifyRefundInvoiceBillService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String BUSI_NAME = "\u7edf\u4e00\u7ed3\u7b97\u5ba1\u6279\u4e2d";

    @Override
    public FscPushUnifyRefundInvoiceBusiRspBO dealPushUnifyRefundInvoice(FscPushUnifyRefundInvoiceBusiReqBO reqBO) {
        FscPushUnifyRefundInvoiceBusiRspBO busiRspBO = new FscPushUnifyRefundInvoiceBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO.getPushUnifyStatus() != null && refundPO.getPushUnifyStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscOrderRefundPO updateVo = new FscOrderRefundPO();
        updateVo.setRefundId(reqBO.getRefundId());
        FscPurchasePushLogPo pushLogPo = this.initPushLog(reqBO);
        FscPushUnifyRefundInvoiceBillReqBO invoiceBillReqBO = new FscPushUnifyRefundInvoiceBillReqBO();
        invoiceBillReqBO.setToken(reqBO.getToken());
        invoiceBillReqBO.setData(reqBO.getData());
        FscPushUnifyRefundInvoiceBillRspBO invoiceBillRspBO = this.fscPushUnifyRefundInvoiceBillService.dealPushRefundInvoice(invoiceBillReqBO);
        if (!invoiceBillRspBO.getRespCode().equals("0000")) {
            updateVo.setPushUnifyStatus(FscConstants.FscPushStatus.FAIL);
            pushLogPo.setPushStatus(FscConstants.FscPushStatus.FAIL);
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(invoiceBillRspBO.getMsg());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            updateVo.setUnifyFailReason(decryptionAbilityRspBO.getData());
            pushLogPo.setRespData(decryptionAbilityRspBO.getData());
            pushLogPo.setRespParseData(invoiceBillRspBO.getRspData());
        } else {
            updateVo.setPushUnifyStatus(FscConstants.FscPushStatus.SUCCESS);
            pushLogPo.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(invoiceBillRspBO.getData());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            if (!StringUtils.isEmpty((Object)decryptionAbilityRspBO.getData())) {
                pushLogPo.setRespData(decryptionAbilityRspBO.getData());
                pushLogPo.setRespParseData(invoiceBillRspBO.getRspData());
                JSONObject object = JSONObject.parseObject((String)decryptionAbilityRspBO.getData());
                if (object.get((Object)"INST_ID") != null) {
                    updateVo.setInstanceId(object.get((Object)"INST_ID").toString());
                }
            }
            this.dealStatusFlow(refundPO);
        }
        this.fscOrderRefundMapper.updateById(updateVo);
        this.fscPurchasePushLogMapper.insert(pushLogPo);
        return busiRspBO;
    }

    private void dealStatusFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setOrderId(refundPO.getRefundId());
        flowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(flowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            log.error("\u6d41\u8f6c\u9000\u7968\u4e3b\u5355\u5931\u8d25:" + fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private FscPurchasePushLogPo initPushLog(FscPushUnifyRefundInvoiceBusiReqBO reqBO) {
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setObjectId(reqBO.getRefundId());
        pushLogPo.setObjectNo(reqBO.getRefundNo());
        pushLogPo.setPushData(JSONObject.toJSONString(reqBO.getPushData()));
        pushLogPo.setPushParseData(reqBO.getData());
        pushLogPo.setCreateTime(new Date());
        pushLogPo.setType(reqBO.getType());
        return pushLogPo;
    }
}

