/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleasePayInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleasePayInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.common.busi.api.finance.FscFinanceDealChargeAuditBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealChargeAuditBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealChargeAuditBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceDealChargeAuditBusiServiceImpl
implements FscFinanceDealChargeAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceDealChargeAuditBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private FscFinanceReleasePayInfoAtomService fscFinanceReleasePayInfoAtomService;

    @Override
    public FscFinanceDealChargeAuditBusiRspBO dealFinanceChargeAudit(FscFinanceDealChargeAuditBusiReqBO reqBO) {
        FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO;
        FscAccountChargePO fscAccountChargePo = this.fscAccountChargeMapper.queryById(reqBO.getChargeId());
        if (fscAccountChargePo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5145\u503c\u4fe1\u606f\uff01");
        }
        Integer count = this.fscOrderMapper.getAuditCount(reqBO.getChargeId(), reqBO.getStationsList());
        if (count == 0) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getChargeId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL;
        String stepId = this.fscAccountChargeMapper.selectStepId(reqBO.getChargeId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(paramMap);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditRemark())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditRemark());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getChargeId());
        }
        catch (Exception e) {
            log.error("dealOrderApproval get stationId error:{}", (Throwable)e);
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        this.dealFinanceInfo(reqBO);
        try {
            if (Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                todoFscWaitAbilityReqBO.setCenterCode("settle");
                todoFscWaitAbilityReqBO.setBusiCode("1050");
                todoFscWaitAbilityReqBO.setBusiName("\u9884\u5b58\u6b3e\u5145\u503c");
                todoFscWaitAbilityReqBO.setObjId(reqBO.getChargeId());
                todoFscWaitAbilityReqBO.setOperatorType("1");
                todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("dealOrderApproval error:{}", (Throwable)e);
        }
        UacNoneInstanceBO noneInstanceBO = auditRspBO.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscAccountChargePO updateVo = new FscAccountChargePO();
        updateVo.setChargeId(reqBO.getChargeId());
        updateVo.setAuditRemark(reqBO.getAuditRemark());
        updateVo.setAuditTime(new Date());
        updateVo.setAuditUserId(reqBO.getUserId());
        updateVo.setAuditUserName(reqBO.getName());
        Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        if (finish.booleanValue() && auditResult.equals(FscConstants.AuditResultFlagKey.PASS.toString())) {
            updateVo.setAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
            fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setTitel(fscAccountChargePo.getAdvanceDepositNo() + "\u9884\u5b58\u6b3e\u5145\u503c_" + (String)busiTypeMap.get(fscAccountChargePo.getBusiType() + "") + "_" + fscAccountChargePo.getChargeAmount().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u901a\u8fc7");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u9884\u5b58\u6b3e\u7533\u8bf7\u5355" + fscAccountChargePo.getAdvanceDepositNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\u3002");
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscAccountChargePo.getUserId()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        } else if (finish.booleanValue() && auditResult.equals(FscConstants.AuditResultFlagKey.REFUSE.toString())) {
            updateVo.setAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
            fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setTitel(fscAccountChargePo.getAdvanceDepositNo() + "\u9884\u5b58\u6b3e\u5145\u503c_" + (String)busiTypeMap.get(fscAccountChargePo.getBusiType() + "") + "_" + fscAccountChargePo.getChargeAmount().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u9a73\u56de");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u9884\u5b58\u6b3e\u7533\u8bf7\u5355" + fscAccountChargePo.getAdvanceDepositNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscAccountChargePo.getUserId()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        FscTaskCandidatePO fscTaskCandidateQueryVo = new FscTaskCandidatePO();
        fscTaskCandidateQueryVo.setFscOrderId(fscAccountChargePo.getChargeId());
        List auditedList = this.fscTaskCandidateMapper.getAuditedPostIdAndOperIdList(fscTaskCandidateQueryVo);
        List auditedIdList = auditedList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
        String auditedIds = String.join((CharSequence)",", auditedIdList);
        updateVo.setAuditOperId("," + auditedIds + ",");
        this.fscAccountChargeMapper.update(updateVo);
        if (!finish.booleanValue()) {
            FscTaskCandidatePO fscTaskCandidatePO = new FscTaskCandidatePO();
            fscTaskCandidatePO.setFscOrderId(fscAccountChargePo.getChargeId());
            List auditedPostIdAndOperIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(fscTaskCandidatePO);
            if (!CollectionUtils.isEmpty((Collection)auditedPostIdAndOperIdList)) {
                StringBuilder auditedPostIds = new StringBuilder();
                auditedPostIds.append(",");
                for (FscApprovalTaskQueryBO fscApprovalTaskQueryBO : auditedPostIdAndOperIdList) {
                    auditedPostIds.append(fscApprovalTaskQueryBO.getTaskOperId()).append(",");
                }
                fscAccountChargePo.setTaskOperId(auditedPostIds.toString());
                this.fscAccountChargeMapper.updateTaskOperById(fscAccountChargePo);
            }
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)auditedPostIdAndOperIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO2 = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO2.setTitel(fscAccountChargePo.getAdvanceDepositNo() + "\u9884\u5b58\u6b3e\u5145\u503c_" + (String)busiTypeMap.get(fscAccountChargePo.getBusiType() + "") + "_" + fscAccountChargePo.getChargeAmount().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO2.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9884\u5b58\u6b3e\u7533\u8bf7\u5355" + fscAccountChargePo.getAdvanceDepositNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            fscSendNotificationExtAtomReqBO2.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO2.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO2);
        } else {
            this.fscAccountChargeMapper.updateTaskOperById(fscAccountChargePo);
        }
        FscFinanceDealChargeAuditBusiRspBO rspBO = new FscFinanceDealChargeAuditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFinish(finish);
        return rspBO;
    }

    private void dealFinanceInfo(FscFinanceDealChargeAuditBusiReqBO reqBO) {
        int count;
        FscOrderFinancePO financeQueryPo = new FscOrderFinancePO();
        financeQueryPo.setFscOrderId(reqBO.getChargeId());
        financeQueryPo = this.fscOrderFinanceMapper.getModelBy(financeQueryPo);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setFscOrderId(reqBO.getChargeId());
        financePO.setUpdateTime(new Date());
        financePO.setUpdateUserId(reqBO.getUserName());
        financePO.setUpdateUserName(reqBO.getName());
        if (!StringUtils.isEmpty((Object)financeQueryPo.getFinanceAuditAccount())) {
            financePO.setFinanceAuditAccount(financeQueryPo.getFinanceAuditAccount() + "," + reqBO.getUserName());
            financePO.setFinanceAuditName(financeQueryPo.getFinanceAuditName() + "," + reqBO.getName());
        } else {
            financePO.setFinanceAuditAccount(reqBO.getUserName());
            financePO.setFinanceAuditName(reqBO.getName());
        }
        this.fscOrderFinanceMapper.updateById(financePO);
        FscAccountChargePO updateChargePo = new FscAccountChargePO();
        updateChargePo.setChargeId(reqBO.getChargeId());
        updateChargePo.setChargeAmount(reqBO.getChargeAmount());
        this.fscAccountChargeMapper.update(updateChargePo);
        if (!CollectionUtils.isEmpty(reqBO.getDelDetailIds())) {
            this.fscAccountChargeDetailMapper.deleteByIds(reqBO.getDelDetailIds(), reqBO.getChargeId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getAddChargeList())) {
            this.fscAccountChargeDetailMapper.insertBatch(reqBO.getAddChargeList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getUpdChargeList())) {
            this.fscAccountChargeMapper.updateBath(reqBO.getUpdChargeList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getDelFinanceItemIds()) && (count = this.fscFinancePayItemMapper.deleteByIds(reqBO.getChargeId(), reqBO.getDelFinanceItemIds())) != reqBO.getDelFinanceItemIds().size()) {
            throw new FscBusinessException("190000", "\u5220\u9664\u4ed8\u6b3e\u4fe1\u606f\u884c\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getDelDraftIds()) && (count = this.fscFinanceDraftInfoMapper.deleteByIds(reqBO.getChargeId(), reqBO.getDelDraftIds())) != reqBO.getDelDraftIds().size()) {
            throw new FscBusinessException("190000", "\u5220\u9664\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.dealRelease(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getFinanceAddList())) {
            this.fscFinancePayItemMapper.insertBatch(reqBO.getFinanceAddList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getFinanceUpdList())) {
            this.fscFinancePayItemMapper.updateBatch(reqBO.getFinanceUpdList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getDraftAddList())) {
            this.fscFinanceDraftInfoMapper.insertBatch(reqBO.getDraftAddList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
            this.fscFinanceDraftInfoMapper.updateBatch(reqBO.getDraftUpdList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getPlanAddList())) {
            this.fscFinanceCapitalPlanMapper.insertBatch(reqBO.getPlanAddList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
            this.fscFinanceCapitalPlanMapper.updateBatch(reqBO.getPlanUpdList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getDelPlanIds())) {
            this.fscFinanceCapitalPlanMapper.deleteByIds(reqBO.getChargeId(), reqBO.getDelPlanIds());
        }
        ArrayList<FscFinanceDraftInfoPO> draftList = new ArrayList<FscFinanceDraftInfoPO>();
        if (!CollectionUtils.isEmpty(reqBO.getDraftAddList()) || !CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
            if (!CollectionUtils.isEmpty(reqBO.getDraftAddList())) {
                draftList.addAll(reqBO.getDraftAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getDraftUpdList())) {
                draftList.addAll(reqBO.getDraftUpdList());
            }
        }
        ArrayList<FscFinanceCapitalPlanPO> capitalPlanList = new ArrayList<FscFinanceCapitalPlanPO>();
        if (!CollectionUtils.isEmpty(reqBO.getPlanAddList()) || !CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
            if (!CollectionUtils.isEmpty(reqBO.getPlanAddList())) {
                capitalPlanList.addAll(reqBO.getPlanAddList());
            }
            if (!CollectionUtils.isEmpty(reqBO.getPlanUpdList())) {
                capitalPlanList.addAll(reqBO.getPlanUpdList());
            }
        }
        if (!CollectionUtils.isEmpty(draftList) || !CollectionUtils.isEmpty(capitalPlanList)) {
            FscFinanceOccupyAtomReqBO atomReqBO = new FscFinanceOccupyAtomReqBO();
            atomReqBO.setDraftList(draftList);
            atomReqBO.setCapitalList(capitalPlanList);
            atomReqBO.setBankList(new ArrayList());
            atomReqBO.setUserName(reqBO.getUserName());
            atomReqBO.setName(reqBO.getName());
            atomReqBO.setFinanceOrgId(reqBO.getFinanceOrgId());
            atomReqBO.setFinanceOrgName(reqBO.getFinanceOrgName());
            atomReqBO.setObjId(reqBO.getChargeId());
            atomReqBO.setObjNo(reqBO.getChargeNo());
            FscFinanceOccupyAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealOccupyFinanceInfo(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException(atomRspBO.getRespDesc(), atomRspBO.getRespDesc());
            }
        }
    }

    private void dealRelease(FscFinanceDealChargeAuditBusiReqBO reqBO) {
        FscFinanceReleasePayInfoAtomReqBO atomReqBO = new FscFinanceReleasePayInfoAtomReqBO();
        atomReqBO.setBankExtIds(new ArrayList());
        atomReqBO.setReleasePlanList(reqBO.getReleasePlanList());
        atomReqBO.setSupplyExtIds(reqBO.getSupplyExtIds());
        atomReqBO.setDraftExtIds(reqBO.getDraftExtIds());
        atomReqBO.setObjId(reqBO.getChargeId());
        atomReqBO.setObjNo(reqBO.getChargeNo());
        FscFinanceReleasePayInfoAtomRspBO atomRspBO = this.fscFinanceReleasePayInfoAtomService.dealReleasePayInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }
}

