/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.bo.FscSearchEsSQLRspBO;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundInvoiceApprovalListQryRspListBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceEsRefundInvoiceApprovalListQryBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceRefundInvoiceApprovalListBusiReqBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceRefundInvoiceApprovalListBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.utils.FscBuildEsQrySqlConditionUtil;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceEsRefundInvoiceApprovalListQryBusiServiceImpl
implements FscFinanceEsRefundInvoiceApprovalListQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceEsRefundInvoiceApprovalListQryBusiServiceImpl.class);
    @Value(value="${es.max.page.size:10000}")
    private Integer maxPageSize;
    @Value(value="${FSC_DEL_PRINT_FLAG:true}")
    private Boolean delFlag;
    private final FscEsConfig fscEsConfig;
    private final FscElasticsearchUtil fscElasticsearchUtil;
    private final FscBuildEsQrySqlConditionUtil buildEsQrySqlConditionUtil;

    @Autowired
    public FscFinanceEsRefundInvoiceApprovalListQryBusiServiceImpl(FscEsConfig fscEsConfig, FscElasticsearchUtil fscElasticsearchUtil) {
        this.fscEsConfig = fscEsConfig;
        this.fscElasticsearchUtil = fscElasticsearchUtil;
        this.buildEsQrySqlConditionUtil = new FscBuildEsQrySqlConditionUtil();
    }

    @Override
    public FscFinanceRefundInvoiceApprovalListBusiRspBO esQryRefundInvoiceApprovalList(FscFinanceRefundInvoiceApprovalListBusiReqBO reqBO) {
        FscFinanceRefundInvoiceApprovalListBusiRspBO rspBO = new FscFinanceRefundInvoiceApprovalListBusiRspBO();
        String qryString = this.esQryRefundInvoiceApproval(reqBO);
        log.debug("ES\u67e5\u8be2\u9000\u7968\u4e3b\u5355\u67e5\u8be2\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.fscEsConfig.getRefundIndexName() + "/" + this.fscEsConfig.getRefundIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.fscElasticsearchUtil.createIndex(this.fscEsConfig.getOrderIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("191001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("\u5931\u8d25");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5931\u8d25!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
            return rspBO;
        }
        log.info("ES\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355result---->" + result);
        if (!CollectionUtils.isEmpty(reqBO.getSumField())) {
            this.resolveReturnSum(result, rspBO, reqBO);
        } else {
            rspBO = this.resolveReturnData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        }
        return rspBO;
    }

    public String esQryRefundInvoiceApproval(FscFinanceRefundInvoiceApprovalListBusiReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((CharSequence)reqBO.getRefundNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"refundNo.keyword", (String)("*" + reqBO.getRefundNo() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getAuditStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"auditStatus", (String)reqBO.getAuditStatus()));
        }
        if (reqBO.getPushFinanceStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"pushFinanceStatus", (Object)reqBO.getPushFinanceStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPreviousHandler())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"previousHandler", (String)reqBO.getPreviousHandler()));
        }
        if (reqBO.getArrivalTimeStart() != null || reqBO.getArrivalTimeEnd() != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"arrivalTime");
            if (reqBO.getArrivalTimeStart() != null) {
                rangeQueryBuilder.gte((Object)reqBO.getArrivalTimeStart());
            }
            if (reqBO.getArrivalTimeEnd() != null) {
                rangeQueryBuilder.lte((Object)reqBO.getArrivalTimeStart());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"refundStatus", (Object)FscConstants.RefundInvoiceStatus.DELETE));
        if (!CollectionUtils.isEmpty(reqBO.getSumField())) {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(1);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.from(0);
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            List<String> sumField = reqBO.getSumField();
            for (String field : sumField) {
                if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                searchSourceBuilder.aggregation((AggregationBuilder)((SumAggregationBuilder)AggregationBuilders.sum((String)field).field(field)).format("0.00"));
            }
            queryJson.put("aggs", (Object)JSON.parseObject((String)searchSourceBuilder.aggregations().toString()));
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        SortOrder order = SortOrder.DESC;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getOrderBy())) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = !StringUtils.isEmpty((CharSequence)reqBO.getOrderByDesc()) ? (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderByDesc()).order(order) : ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"refundId").order(order);
        fieldSortBuilders.add(sortQueryFirst);
        fieldSortBuilders.add(sortQuery);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    private String getQueryString(FscSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(Integer.valueOf(1));
        }
        JSONObject queryJson = new JSONObject();
        if (this.maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)this.maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }

    private FscFinanceRefundInvoiceApprovalListBusiRspBO resolveReturnData(String result, FscFinanceRefundInvoiceApprovalListBusiRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSON.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<FscFinanceRefundInvoiceApprovalListQryRspListBO> rows = new ArrayList<FscFinanceRefundInvoiceApprovalListQryRspListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSON.parseObject((String)objJsonStr);
            FscFinanceRefundInvoiceApprovalListQryRspListBO fscComRefundListBO = (FscFinanceRefundInvoiceApprovalListQryRspListBO)JSON.toJavaObject((JSON)objJson, FscFinanceRefundInvoiceApprovalListQryRspListBO.class);
            rows.add(fscComRefundListBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }

    public void resolveReturnSum(String result, FscFinanceRefundInvoiceApprovalListBusiRspBO rspBO, FscFinanceRefundInvoiceApprovalListBusiReqBO reqBO) {
        JSONObject resultObj = JSON.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        Integer total = hitsObj.getInteger("total");
        rspBO.setRecordsTotal(total);
        HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>();
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        Iterator<String> iterator = reqBO.getSumField().iterator();
        while (iterator.hasNext()) {
            String sumField;
            JSONObject sum = (JSONObject)aggregationsObj.get((Object)(sumField = iterator.next()));
            String value = (String)sum.get((Object)"value_as_string");
            sumMap.put(sumField, value == null ? new BigDecimal("0.00") : new BigDecimal(value));
        }
        rspBO.setSumFieldInfo(sumMap);
    }
}

