/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveProjectRefundReturnTempBankStatementReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveProjectRefundReturnTempDraftInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveProjectRefundReturnTempRefundItemReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveProjectRefundReturnTempRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveProjectReturnTempBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempBankStatementReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempDraftInfoReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempRefundItemReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempRefundTempReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSaveRefundReturnTempRspBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceRefundTempBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceSaveProjectRefundTempBusiBO;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceSaveRefundTempBusiBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinanceRefundItemTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceRefundTempBusiServiceImpl
implements FscFinanceRefundTempBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundTempBusiServiceImpl.class);
    @Resource
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Resource
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Resource
    private FscFinanceRefundItemTempMapper fscFinanceRefundItemTempMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscFinanceSaveRefundReturnTempRspBO saveFinanceRefundTemp(FscFinanceSaveRefundTempBusiBO reqBo) {
        this.valid(reqBo);
        this.deleteAllByContractIdAndTempId(reqBo);
        ArrayList itemTempPOList = Lists.newArrayList();
        ArrayList draftInfoTempPOList = Lists.newArrayList();
        ArrayList bankStatementTempPOList = Lists.newArrayList();
        ArrayList attachmentTempPOList = Lists.newArrayList();
        Date createTime = new Date();
        for (FscFinanceSaveRefundReturnTempRefundTempReqBO bo : reqBo.getRefundTemp()) {
            Object refundItemTempPO2;
            Long refundId = bo.getRefundId();
            Long tempId = bo.getTempId();
            Long contractId = bo.getContractId();
            List refundItemTempPOList = JSON.parseArray((String)JSON.toJSONString((Object)bo.getRefundItem()), FscFinanceRefundItemTempPO.class);
            for (Object refundItemTempPO2 : refundItemTempPOList) {
                refundItemTempPO2.setRefundItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
                refundItemTempPO2.setRefundId(refundId);
                refundItemTempPO2.setTempId(tempId);
                refundItemTempPO2.setContractId(contractId);
                refundItemTempPO2.setDelFlag(Integer.valueOf(0));
                itemTempPOList.add(refundItemTempPO2);
            }
            List draftInfoBo = JSON.parseArray((String)JSON.toJSONString((Object)bo.getDraftInfo()), FscFinanceDraftInfoTempPO.class);
            refundItemTempPO2 = draftInfoBo.iterator();
            while (refundItemTempPO2.hasNext()) {
                FscFinanceDraftInfoTempPO draftInfoTempPO = (FscFinanceDraftInfoTempPO)refundItemTempPO2.next();
                draftInfoTempPO.setFinanceDraftTempId(Long.valueOf(Sequence.getInstance().nextId()));
                draftInfoTempPO.setTempId(tempId);
                draftInfoTempPO.setRefundId(refundId);
                draftInfoTempPO.setContractId(contractId);
                draftInfoTempPO.setCreateTime(createTime);
                draftInfoTempPO.setDelFlag(Integer.valueOf(0));
                draftInfoTempPOList.add(draftInfoTempPO);
            }
            List bankStatementBo = JSON.parseArray((String)JSON.toJSONString((Object)bo.getBankStatement()), FscFinanceBankStatementTempPO.class);
            for (FscFinanceBankStatementTempPO bankStatementTempPO : bankStatementBo) {
                bankStatementTempPO.setStatementTempId(Long.valueOf(Sequence.getInstance().nextId()));
                bankStatementTempPO.setTempId(tempId);
                bankStatementTempPO.setRefundId(refundId);
                bankStatementTempPO.setContractId(contractId);
                bankStatementTempPO.setCreateTime(createTime);
                bankStatementTempPO.setDelFlag(Integer.valueOf(0));
                bankStatementTempPOList.add(bankStatementTempPO);
            }
            List attachment = JSON.parseArray((String)JSON.toJSONString((Object)bo.getAttachments()), FscAttachmentTempPO.class);
            for (FscAttachmentTempPO attachmentTempPO : attachment) {
                attachmentTempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentTempPO.setCreateTime(createTime);
                attachmentTempPO.setFscOrderId(tempId);
                attachmentTempPO.setObjId(contractId);
                attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentTempPO.setObjType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentTempPOList.add(attachmentTempPO);
            }
        }
        if (CollUtil.isNotEmpty((Collection)itemTempPOList)) {
            this.fscFinanceRefundItemTempMapper.insertOrUpdateBatch((List)itemTempPOList);
        }
        if (CollUtil.isNotEmpty((Collection)draftInfoTempPOList)) {
            this.fscFinanceDraftInfoTempMapper.insertOrUpdateBatch((List)draftInfoTempPOList);
        }
        if (CollUtil.isNotEmpty((Collection)bankStatementTempPOList)) {
            this.fscFinanceBankStatementTempMapper.insertOrUpdateBatch((List)bankStatementTempPOList);
        }
        if (CollUtil.isNotEmpty((Collection)attachmentTempPOList)) {
            this.fscAttachmentTempMapper.insertOrUpdateBatch((List)attachmentTempPOList);
        }
        FscFinanceSaveRefundReturnTempRspBO rspBO = new FscFinanceSaveRefundReturnTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscFinanceSaveProjectRefundReturnTempRspBO saveFinanceProjectRefundTemp(FscFinanceSaveProjectRefundTempBusiBO reqBo) {
        this.validProject(reqBo);
        this.deleteProjectAllByContractIdAndTempId(reqBo);
        ArrayList itemTempPOList = Lists.newArrayList();
        ArrayList draftInfoTempPOList = Lists.newArrayList();
        ArrayList bankStatementTempPOList = Lists.newArrayList();
        ArrayList attachmentTempPOList = Lists.newArrayList();
        Date createTime = new Date();
        for (FscFinanceSaveProjectReturnTempBO bo : reqBo.getRefundTemp()) {
            Object refundItemTempPO2;
            Long refundId = bo.getRefundId();
            Long tempId = bo.getTempId();
            Long contractId = bo.getContractId();
            List refundItemTempPOList = JSON.parseArray((String)JSON.toJSONString((Object)bo.getRefundItem()), FscFinanceRefundItemTempPO.class);
            for (Object refundItemTempPO2 : refundItemTempPOList) {
                refundItemTempPO2.setRefundItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
                refundItemTempPO2.setRefundId(refundId);
                refundItemTempPO2.setTempId(tempId);
                refundItemTempPO2.setContractId(contractId);
                refundItemTempPO2.setDelFlag(Integer.valueOf(0));
                itemTempPOList.add(refundItemTempPO2);
            }
            List draftInfoBo = JSON.parseArray((String)JSON.toJSONString((Object)bo.getDraftInfo()), FscFinanceDraftInfoTempPO.class);
            refundItemTempPO2 = draftInfoBo.iterator();
            while (refundItemTempPO2.hasNext()) {
                FscFinanceDraftInfoTempPO draftInfoTempPO = (FscFinanceDraftInfoTempPO)refundItemTempPO2.next();
                draftInfoTempPO.setFinanceDraftTempId(Long.valueOf(Sequence.getInstance().nextId()));
                draftInfoTempPO.setTempId(tempId);
                draftInfoTempPO.setRefundId(refundId);
                draftInfoTempPO.setContractId(contractId);
                draftInfoTempPO.setCreateTime(createTime);
                draftInfoTempPO.setDelFlag(Integer.valueOf(0));
                draftInfoTempPOList.add(draftInfoTempPO);
            }
            List bankStatementBo = JSON.parseArray((String)JSON.toJSONString((Object)bo.getBankStatement()), FscFinanceBankStatementTempPO.class);
            for (FscFinanceBankStatementTempPO bankStatementTempPO : bankStatementBo) {
                bankStatementTempPO.setStatementTempId(Long.valueOf(Sequence.getInstance().nextId()));
                bankStatementTempPO.setTempId(tempId);
                bankStatementTempPO.setRefundId(refundId);
                bankStatementTempPO.setContractId(contractId);
                bankStatementTempPO.setCreateTime(createTime);
                bankStatementTempPO.setDelFlag(Integer.valueOf(0));
                bankStatementTempPOList.add(bankStatementTempPO);
            }
            List attachment = JSON.parseArray((String)JSON.toJSONString((Object)bo.getAttachments()), FscAttachmentTempPO.class);
            for (FscAttachmentTempPO attachmentTempPO : attachment) {
                attachmentTempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentTempPO.setCreateTime(createTime);
                attachmentTempPO.setFscOrderId(tempId);
                attachmentTempPO.setObjId(contractId);
                attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentTempPO.setObjType(FscConstants.AttachmentType.REFUND_PAY);
                attachmentTempPOList.add(attachmentTempPO);
            }
        }
        if (CollUtil.isNotEmpty((Collection)itemTempPOList)) {
            this.fscFinanceRefundItemTempMapper.insertOrUpdateBatch((List)itemTempPOList);
        }
        if (CollUtil.isNotEmpty((Collection)draftInfoTempPOList)) {
            this.fscFinanceDraftInfoTempMapper.insertOrUpdateBatch((List)draftInfoTempPOList);
        }
        if (CollUtil.isNotEmpty((Collection)bankStatementTempPOList)) {
            this.fscFinanceBankStatementTempMapper.insertOrUpdateBatch((List)bankStatementTempPOList);
        }
        if (CollUtil.isNotEmpty((Collection)attachmentTempPOList)) {
            this.fscAttachmentTempMapper.insertOrUpdateBatch((List)attachmentTempPOList);
        }
        FscFinanceSaveProjectRefundReturnTempRspBO rspBO = new FscFinanceSaveProjectRefundReturnTempRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceSaveRefundTempBusiBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscFinanceSaveRefundReturnTempRefundTempReqBO bo : reqBo.getRefundTemp()) {
            if (bo.getRefundId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getTempId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getContractId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceSaveRefundReturnTempRefundItemReqBO refundItemReqBO : bo.getRefundItem()) {
                if (refundItemReqBO.getRefundAmt() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d(\u539f\u5e01)[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (refundItemReqBO.getRefundAmtLocal() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d(\u672c\u4f4d\u5e01)[refundAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)refundItemReqBO.getPayItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (refundItemReqBO.getPayItemId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6[payItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (refundItemReqBO.getRefundShouldPayId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6\u5e94\u9000\u5355id[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceSaveRefundReturnTempDraftInfoReqBO draftInfoReqBO : bo.getDraftInfo()) {
                if (draftInfoReqBO.getRefundDetailId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (draftInfoReqBO.getRefundShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (draftInfoReqBO.getFinanceRefundItemId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceSaveRefundReturnTempBankStatementReqBO bankStatementReqBO : bo.getBankStatement()) {
                if (bankStatementReqBO.getRefundDetailId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bankStatementReqBO.getRefundShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bankStatementReqBO.getFinanceRefundItemId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void validProject(FscFinanceSaveProjectRefundTempBusiBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscFinanceSaveProjectReturnTempBO bo : reqBo.getRefundTemp()) {
            if (bo.getRefundId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getTempId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getContractId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceSaveProjectRefundReturnTempRefundItemReqBO refundItemReqBO : bo.getRefundItem()) {
                if (refundItemReqBO.getRefundAmt() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d(\u539f\u5e01)[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (refundItemReqBO.getRefundAmtLocal() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6\u7533\u8bf7\u9000\u6b3e\u91d1\u989d(\u672c\u4f4d\u5e01)[refundAmtLocal]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)refundItemReqBO.getPayItemNo())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (refundItemReqBO.getPayItemId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6[payItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (refundItemReqBO.getRefundShouldPayId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u660e\u7ec6\u5e94\u9000\u5355id[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceSaveProjectRefundReturnTempDraftInfoReqBO draftInfoReqBO : bo.getDraftInfo()) {
                if (draftInfoReqBO.getRefundDetailId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (draftInfoReqBO.getRefundShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (draftInfoReqBO.getFinanceRefundItemId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u7968\u636e[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (FscFinanceSaveProjectRefundReturnTempBankStatementReqBO bankStatementReqBO : bo.getBankStatement()) {
                if (bankStatementReqBO.getRefundDetailId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34[refundDetailId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bankStatementReqBO.getRefundShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34[refundShouldPayId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bankStatementReqBO.getFinanceRefundItemId() != null) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u6d41\u6c34[financeRefundItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public void deleteAllByContractIdAndTempId(FscFinanceSaveRefundTempBusiBO reqBo) {
        for (FscFinanceSaveRefundReturnTempRefundTempReqBO bo : reqBo.getRefundTemp()) {
            Long contractId = bo.getContractId();
            Long tempId = bo.getTempId();
            FscFinanceRefundItemTempPO fscFinanceRefundItemTempPO = new FscFinanceRefundItemTempPO();
            fscFinanceRefundItemTempPO.setContractId(contractId);
            fscFinanceRefundItemTempPO.setTempId(tempId);
            this.fscFinanceRefundItemTempMapper.deleteBy(fscFinanceRefundItemTempPO);
            FscFinanceDraftInfoTempPO draftInfoTempPO = new FscFinanceDraftInfoTempPO();
            draftInfoTempPO.setContractId(contractId);
            draftInfoTempPO.setTempId(tempId);
            this.fscFinanceDraftInfoTempMapper.deleteBy(draftInfoTempPO);
            FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO = new FscFinanceBankStatementTempPO();
            fscFinanceBankStatementTempPO.setContractId(contractId);
            fscFinanceBankStatementTempPO.setTempId(tempId);
            this.fscFinanceBankStatementTempMapper.deleteBy(fscFinanceBankStatementTempPO);
            FscAttachmentTempPO attachmentTempPO = new FscAttachmentTempPO();
            attachmentTempPO.setFscOrderId(tempId);
            attachmentTempPO.setContractId(contractId);
            this.fscAttachmentTempMapper.deleteBy(attachmentTempPO);
        }
    }

    public void deleteProjectAllByContractIdAndTempId(FscFinanceSaveProjectRefundTempBusiBO reqBo) {
        for (FscFinanceSaveProjectReturnTempBO bo : reqBo.getRefundTemp()) {
            Long contractId = bo.getContractId();
            Long tempId = bo.getTempId();
            FscFinanceRefundItemTempPO fscFinanceRefundItemTempPO = new FscFinanceRefundItemTempPO();
            fscFinanceRefundItemTempPO.setContractId(contractId);
            fscFinanceRefundItemTempPO.setTempId(tempId);
            this.fscFinanceRefundItemTempMapper.deleteBy(fscFinanceRefundItemTempPO);
            FscFinanceDraftInfoTempPO draftInfoTempPO = new FscFinanceDraftInfoTempPO();
            draftInfoTempPO.setContractId(contractId);
            draftInfoTempPO.setTempId(tempId);
            this.fscFinanceDraftInfoTempMapper.deleteBy(draftInfoTempPO);
            FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO = new FscFinanceBankStatementTempPO();
            fscFinanceBankStatementTempPO.setContractId(contractId);
            fscFinanceBankStatementTempPO.setTempId(tempId);
            this.fscFinanceBankStatementTempMapper.deleteBy(fscFinanceBankStatementTempPO);
            FscAttachmentTempPO attachmentTempPO = new FscAttachmentTempPO();
            attachmentTempPO.setFscOrderId(tempId);
            attachmentTempPO.setContractId(contractId);
            this.fscAttachmentTempMapper.deleteBy(attachmentTempPO);
        }
    }
}

