/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountChargeApprovalAbilityService;
import com.tydic.fsc.common.ability.api.FscPushTodoAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountChargeApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountChargeApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushTodoAbilityServiceRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.common.busi.api.FscAccountChargeApprovalBusiService;
import com.tydic.fsc.common.busi.api.finance.FscFinanceReleasePayInfoBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountChargeApprovalAbilityService"})
public class FscAccountChargeApprovalAbilityServiceImpl
implements FscAccountChargeApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargeApprovalAbilityServiceImpl.class);
    @Autowired
    private FscAccountChargeApprovalBusiService fscAccountChargeApprovalBusiService;
    @Autowired
    private FscFinanceReleasePayInfoBusiService fscFinanceReleasePayInfoBusiService;
    @Value(value="${es.FSC_PUSH_FINANCE_CHARGE_TOPIC:FSC_PUSH_FINANCE_CHARGE_TOPIC}")
    private String fscPushFinanceChargeTopic;
    @Value(value="${es.FSC_PUSH_FINANCE_CHARGE_TAG:FSC_PUSH_FINANCE_CHARGE_TAG}")
    private String fscPushFinanceChargeTag;
    @Resource(name="fscPushFinanceChargeListMqServiceProvider")
    private ProxyMessageProducer fscPushFinanceChargeListMqServiceProvider;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscPushTodoAbilityService fscPushTodoAbilityService;

    @PostMapping(value={"dealAccountChargeApproval"})
    public FscAccountChargeApprovalAbilityRspBO dealAccountChargeApproval(@RequestBody FscAccountChargeApprovalAbilityReqBO reqBO) {
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscAccountChargeApprovalBusiReqBO busiReqBO = (FscAccountChargeApprovalBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscAccountChargeApprovalBusiReqBO.class));
        FscAccountChargeApprovalBusiRspBO busiRspBO = this.fscAccountChargeApprovalBusiService.dealAccountChargeApproval(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode()) && busiRspBO.getFinish().booleanValue()) {
            FscOrderFinancePO financePO = new FscOrderFinancePO();
            financePO.setFscOrderId(reqBO.getChargeId());
            financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
            if (reqBO.getAuditResult() == 0 && financePO != null) {
                FscFinancePushChargeAbilityReqBO abilityReqBO = new FscFinancePushChargeAbilityReqBO();
                abilityReqBO.setChargeId(reqBO.getChargeId());
                this.fscPushFinanceChargeListMqServiceProvider.send(new ProxyMessage(this.fscPushFinanceChargeTopic, this.fscPushFinanceChargeTag, JSONObject.toJSONString((Object)abilityReqBO)));
            } else if (reqBO.getAuditResult() == 1 && financePO != null) {
                FscFinanceReleasePayInfoReqBO infoReqBO = new FscFinanceReleasePayInfoReqBO();
                infoReqBO.setFscOrderId(reqBO.getChargeId());
                this.fscFinanceReleasePayInfoBusiService.dealReleasePayInfo(infoReqBO);
            }
        }
        this.sendFinanceApprovalNoticeAndTodo(reqBO, busiRspBO);
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscAccountChargeApprovalAbilityRspBO)JSONObject.parseObject((String)respString, FscAccountChargeApprovalAbilityRspBO.class);
    }

    private void sendFinanceApprovalNoticeAndTodo(FscAccountChargeApprovalAbilityReqBO reqBO, FscAccountChargeApprovalBusiRspBO busiRspBO) {
        FscAccountChargePO fscAccountChargePO = this.getAccountChargeById(reqBO.getChargeId());
        this.sendFinanceApprovalNotice(reqBO, fscAccountChargePO, busiRspBO);
        this.sendFinanceApprovalTodo(reqBO, fscAccountChargePO);
    }

    private FscAccountChargePO getAccountChargeById(Long chargeId) {
        FscAccountChargePO qryFscAccountCharge = new FscAccountChargePO();
        qryFscAccountCharge.setChargeId(chargeId);
        FscAccountChargePO fscAccountChargePO = this.fscAccountChargeMapper.getModelBy(qryFscAccountCharge);
        if (ObjectUtil.isEmpty((Object)fscAccountChargePO)) {
            throw new FscBusinessException("198888", "\u8d26\u6237\u5145\u503c\u8bb0\u5f55\u4e3a\u7a7a");
        }
        return fscAccountChargePO;
    }

    private void sendFinanceApprovalNotice(FscAccountChargeApprovalAbilityReqBO reqBO, FscAccountChargePO fscAccountChargePO, FscAccountChargeApprovalBusiRspBO busiRspBO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscAccountChargePO.getSettlePlatform())) {
            return;
        }
        if (!busiRspBO.getFinish().booleanValue()) {
            return;
        }
        Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        String busiTypeStr = (String)busiTypeMap.get(String.valueOf(fscAccountChargePO.getBusiType()));
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscAccountChargePO.getAdvanceDepositNo() + "\u8d26\u6237\u5145\u503c\u7533\u8bf7\u5355_" + "_" + busiTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setReceiveIds((List)CollectionUtil.newArrayList((Object[])new Long[]{fscAccountChargePO.getUserId()}));
            if (FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u8d26\u6237\u5145\u503c\u7533\u8bf7\u5355" + fscAccountChargePO.getAdvanceDepositNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            }
            if (FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u8d26\u6237\u5145\u503c\u7533\u8bf7\u5355" + fscAccountChargePO.getAdvanceDepositNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            }
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u8d26\u6237\u5145\u503c\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u8d26\u6237\u5145\u503c\u5ba1\u6279\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceApprovalTodo(FscAccountChargeApprovalAbilityReqBO reqBO, FscAccountChargePO fscAccountChargePO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscAccountChargePO.getSettlePlatform())) {
            return;
        }
        try {
            FscPushTodoAbilityServiceReqBO fscPushTodoAbilityServiceReqBO = new FscPushTodoAbilityServiceReqBO();
            fscPushTodoAbilityServiceReqBO.setBusiCode("1303");
            fscPushTodoAbilityServiceReqBO.setBusiName("\u9884\u5b58\u6b3e\u5145\u503c\u5ba1\u6279");
            fscPushTodoAbilityServiceReqBO.setObjId(reqBO.getChargeId());
            fscPushTodoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT);
            FscPushTodoAbilityServiceRspBO fscPushTodoAbilityServiceRspBO = this.fscPushTodoAbilityService.dealPushTodo(fscPushTodoAbilityServiceReqBO);
            if (!"0000".equals(fscPushTodoAbilityServiceRspBO.getRespCode())) {
                throw new FscBusinessException(fscPushTodoAbilityServiceRspBO.getRespCode(), fscPushTodoAbilityServiceRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8d26\u6237\u5145\u503c\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u8d26\u6237\u5145\u503c\u5ba1\u6279\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }
}

