/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.FscModelEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountDetailQueryAbilityService"})
public class FscAccountDetailQueryAbilityServiceImpl
implements FscAccountDetailQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountDetailQueryAbilityServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    private static final Integer ADVANCE_TAB_ID = 60001;
    private static final Integer CREDIT_TAB_ID = 60003;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"queryAccountDetail"})
    public FscAccountDetailQueryAbilityRspBO queryAccountDetail(@RequestBody FscAccountDetailQueryAbilityReqBO reqBO) {
        FscAccountDetailQueryAbilityRspBO rspBO = new FscAccountDetailQueryAbilityRspBO();
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getId() && null == reqBO.getOrgIdWeb()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[id]\u548c[orgIdWeb]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        }
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setId(reqBO.getId());
        if (reqBO.getOrgIdWeb() != null) {
            fscAccountPO.setOrgId(reqBO.getOrgIdWeb());
        }
        if (reqBO.getBusiType() != null) {
            fscAccountPO.setBusiType(reqBO.getBusiType());
        }
        if ((fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO)) == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        if (fscAccountPO.getRemainAmount().compareTo(BigDecimal.ZERO) < 0) {
            fscAccountPO.setRemainAmount(BigDecimal.ZERO);
        }
        if (fscAccountPO.getOverDraftRemaining().compareTo(BigDecimal.ZERO) < 0) {
            fscAccountPO.setOverDraftRemaining(BigDecimal.ZERO);
        }
        fscAccountPO.setOverdraft(fscAccountPO.getOverdraft().subtract(fscAccountPO.getDistributeOverdraftAmount()));
        FscAccountDetailQueryAbilityRspBO fscAccountDetailQueryAbilityRspBO = (FscAccountDetailQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)fscAccountPO), FscAccountDetailQueryAbilityRspBO.class);
        Map fscAccountCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_CATEGORY");
        Map fscAccountCreateMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_CREATE_METHOD");
        Map fscAccountStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_STATUS");
        fscAccountDetailQueryAbilityRspBO.setAccountCategoryStr((String)fscAccountCategoryMap.get(fscAccountPO.getAccountCategory().toString()));
        fscAccountDetailQueryAbilityRspBO.setCreateMethodStr((String)fscAccountCreateMethodMap.get(fscAccountPO.getCreateMethod().toString()));
        fscAccountDetailQueryAbilityRspBO.setStatusStr((String)fscAccountStatusMap.get(fscAccountPO.getStatus().toString()));
        if (StringUtils.isEmpty((Object)fscAccountPO.getBusiType())) {
            fscAccountPO.setBusiType("0");
        }
        List<Object> busiTypeList = new ArrayList();
        if (!StringUtils.isEmpty((Object)fscAccountPO.getBusiType())) {
            busiTypeList = Arrays.asList(fscAccountPO.getBusiType().split(","));
            fscAccountDetailQueryAbilityRspBO.setBusiTypeList(busiTypeList);
        }
        if (fscAccountPO.getAccountCategory() != null && fscAccountPO.getAccountCategory() == 3) {
            fscAccountDetailQueryAbilityRspBO.setOverdraftAmount(fscAccountPO.getOverdraft());
            BigDecimal subtract1 = fscAccountPO.getOverdraft().subtract(fscAccountPO.getDistributeOverdraftAmount() == null ? BigDecimal.ZERO : fscAccountPO.getDistributeOverdraftAmount());
            fscAccountDetailQueryAbilityRspBO.setAvailableOverdraftAmount(subtract1.subtract(fscAccountPO.getOverDraftRemaining()));
        } else if (reqBO.getOrgIdWeb() != null) {
            FscMerchantPO fscMerchantPo = new FscMerchantPO();
            fscMerchantPo.setOrgId(this.operationOrgId);
            fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
            fscMerchantPo.setPayBusiSceneRangeLike("1");
            fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            fscMerchantPo.setEnable(Integer.valueOf(1));
            fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
            if (null != fscMerchantPo) {
                BigDecimal payCreditAmount = BigDecimal.ZERO;
                BigDecimal overdraft = BigDecimal.ZERO;
                if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscMerchantPo.getPayType())) {
                    payCreditAmount = fscMerchantPo.getPayCreditAmount();
                    fscMerchantPo.setOverdraft(BigDecimal.ZERO);
                } else if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(fscMerchantPo.getPayType())) {
                    overdraft = fscMerchantPo.getOverdraft();
                    fscMerchantPo.setPayCreditAmount(BigDecimal.ZERO);
                }
                if (busiTypeList.contains("0") || busiTypeList.contains("1")) {
                    FscMerchantPO merchantElectricity = new FscMerchantPO();
                    merchantElectricity.setPayBusiSceneRangeLike("1");
                    merchantElectricity.setParentId(fscMerchantPo.getMerchantId());
                    merchantElectricity.setDelFlag(FscConstants.DicDelFlag.NO);
                    merchantElectricity.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                    merchantElectricity.setPayObjId(reqBO.getOrgIdWeb());
                    merchantElectricity.setEnable(Integer.valueOf(1));
                    merchantElectricity = this.fscMerchantMapper.getModelBy(merchantElectricity);
                    if (null != merchantElectricity) {
                        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(merchantElectricity.getPayType())) {
                            merchantElectricity.setOverdraft(overdraft);
                        }
                        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(merchantElectricity.getPayType())) {
                            merchantElectricity.setPayCreditAmount(payCreditAmount);
                        }
                        this.dealMerchantInfo(merchantElectricity, fscAccountDetailQueryAbilityRspBO, fscAccountPO, 1);
                    } else {
                        this.dealMerchantInfo(fscMerchantPo, fscAccountDetailQueryAbilityRspBO, fscAccountPO, 1);
                    }
                }
                if (busiTypeList.contains("0") || busiTypeList.contains("2")) {
                    FscMerchantPO merchantAgree = new FscMerchantPO();
                    merchantAgree.setPayBusiSceneRangeLike("2");
                    merchantAgree.setParentId(fscMerchantPo.getMerchantId());
                    merchantAgree.setDelFlag(FscConstants.DicDelFlag.NO);
                    merchantAgree.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                    merchantAgree.setPayObjId(reqBO.getOrgIdWeb());
                    merchantAgree.setEnable(Integer.valueOf(1));
                    merchantAgree = this.fscMerchantMapper.getModelBy(merchantAgree);
                    if (null != merchantAgree) {
                        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(merchantAgree.getPayType())) {
                            merchantAgree.setOverdraft(overdraft);
                        }
                        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(merchantAgree.getPayType())) {
                            merchantAgree.setPayCreditAmount(payCreditAmount);
                        }
                        this.dealMerchantInfo(merchantAgree, fscAccountDetailQueryAbilityRspBO, fscAccountPO, 2);
                    } else {
                        this.dealMerchantInfo(fscMerchantPo, fscAccountDetailQueryAbilityRspBO, fscAccountPO, 2);
                    }
                }
                if (busiTypeList.contains("0") || busiTypeList.contains("3")) {
                    FscMerchantPO merchantNoAgree = new FscMerchantPO();
                    merchantNoAgree.setPayBusiSceneRangeLike("3");
                    merchantNoAgree.setParentId(fscMerchantPo.getMerchantId());
                    merchantNoAgree.setDelFlag(FscConstants.DicDelFlag.NO);
                    merchantNoAgree.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                    merchantNoAgree.setPayObjId(reqBO.getOrgIdWeb());
                    merchantNoAgree.setEnable(Integer.valueOf(1));
                    merchantNoAgree = this.fscMerchantMapper.getModelBy(merchantNoAgree);
                    if (null != merchantNoAgree) {
                        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(merchantNoAgree.getPayType())) {
                            merchantNoAgree.setOverdraft(overdraft);
                        }
                        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(merchantNoAgree.getPayType())) {
                            merchantNoAgree.setPayCreditAmount(payCreditAmount);
                        }
                        this.dealMerchantInfo(merchantNoAgree, fscAccountDetailQueryAbilityRspBO, fscAccountPO, 3);
                    } else {
                        this.dealMerchantInfo(fscMerchantPo, fscAccountDetailQueryAbilityRspBO, fscAccountPO, 3);
                    }
                }
            } else {
                fscAccountDetailQueryAbilityRspBO.setOverdraftAmount(BigDecimal.ZERO);
                fscAccountDetailQueryAbilityRspBO.setAvailableOverdraftAmount(BigDecimal.ZERO);
            }
        }
        BigDecimal needReturnAmount = fscAccountDetailQueryAbilityRspBO.getAdvanceAmount().subtract(fscAccountDetailQueryAbilityRspBO.getFreezeAmount()).subtract(fscAccountDetailQueryAbilityRspBO.getUseAmount());
        needReturnAmount = needReturnAmount.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : needReturnAmount.abs();
        fscAccountDetailQueryAbilityRspBO.setNeedRetrunAmount(needReturnAmount);
        log.info("===========fscAccountDetailQueryAbilityRspBO" + fscAccountDetailQueryAbilityRspBO);
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setOrgId(reqBO.getOrgIdWeb());
        fscAccountDetailQueryAbilityRspBO.setAdvanceNeedBackAmt(this.fscPayLogMapper.getOverdraftNotBackAmount(fscPayLogPO));
        fscPayLogPO.setPayBusiness("1");
        fscAccountDetailQueryAbilityRspBO.setElectricityCreditNeedBackAmtAmount(this.fscPayLogMapper.getCreditNotBackAmount(fscPayLogPO));
        fscPayLogPO.setPayBusiness("2");
        fscAccountDetailQueryAbilityRspBO.setAgreeCreditNeedBackAmtAmount(this.fscPayLogMapper.getCreditNotBackAmount(fscPayLogPO));
        fscPayLogPO.setPayBusiness("3");
        fscAccountDetailQueryAbilityRspBO.setNoAgreeCreditNeedBackAmtAmount(this.fscPayLogMapper.getCreditNotBackAmount(fscPayLogPO));
        return fscAccountDetailQueryAbilityRspBO;
    }

    private void dealMerchantInfo(FscMerchantPO fscMerchantPo, FscAccountDetailQueryAbilityRspBO fscAccountDetailQueryAbilityRspBO, FscAccountPO fscAccountPO, Integer busiType) {
        if (busiType == 1) {
            Integer fscModel = fscMerchantPo.getPayType();
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE.equals(fscMerchantPo.getPayType()) && fscMerchantPo.getOverdraft() != null && !BigDecimal.ZERO.equals(fscMerchantPo.getOverdraft())) {
                fscModel = 3;
            }
            fscAccountDetailQueryAbilityRspBO.setFscModel(fscModel);
            fscAccountDetailQueryAbilityRspBO.setFscModelStr(Objects.requireNonNull(FscModelEnum.getInstance((Integer)fscModel)).getCodeDesc());
            fscAccountDetailQueryAbilityRspBO.setOverdraftAmount(fscMerchantPo.getOverdraft() == null ? BigDecimal.ZERO : fscMerchantPo.getOverdraft());
            BigDecimal subtract1 = fscAccountPO.getOverdraft().subtract(fscAccountPO.getDistributeOverdraftAmount() == null ? BigDecimal.ZERO : fscAccountPO.getDistributeOverdraftAmount());
            fscAccountDetailQueryAbilityRspBO.setAvailableOverdraftAmount(subtract1.subtract(fscAccountPO.getOverDraftRemaining()));
            fscAccountDetailQueryAbilityRspBO.setElectricityPayCreditAmount(fscMerchantPo.getPayCreditAmount());
            FscCreditBalancePO fscCreditBalancePO = new FscCreditBalancePO();
            fscCreditBalancePO.setMerchantId(fscMerchantPo.getMerchantId());
            fscCreditBalancePO.setPayBusiness("1");
            fscCreditBalancePO.setPurOrgId(fscAccountPO.getOrgId());
            FscCreditBalancePO creditPo = null;
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscMerchantPo.getPayType()) && FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(fscMerchantPo.getExceptionFlag()) || FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(fscMerchantPo.getExceptionFlag())) {
                creditPo = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
            }
            if (creditPo == null && fscMerchantPo.getParentId() != null) {
                fscCreditBalancePO.setMerchantId(fscMerchantPo.getParentId());
                creditPo = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
            }
            if (creditPo == null) {
                fscAccountDetailQueryAbilityRspBO.setElectricityAvailableCreditAmount(fscMerchantPo.getPayCreditAmount());
            } else {
                fscAccountDetailQueryAbilityRspBO.setElectricityAvailableCreditAmount(fscMerchantPo.getPayCreditAmount() == null ? BigDecimal.ZERO : fscMerchantPo.getPayCreditAmount().subtract(creditPo.getUsedAmount()));
            }
        } else if (busiType == 2) {
            fscAccountDetailQueryAbilityRspBO.setAgreePayCreditAmount(fscMerchantPo.getPayCreditAmount());
            FscCreditBalancePO fscCreditBalancePO = new FscCreditBalancePO();
            fscCreditBalancePO.setMerchantId(fscMerchantPo.getMerchantId());
            fscCreditBalancePO.setPayBusiness("2");
            fscCreditBalancePO.setPurOrgId(fscAccountPO.getOrgId());
            FscCreditBalancePO creditPo = null;
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscMerchantPo.getPayType()) && FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(fscMerchantPo.getExceptionFlag()) || FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(fscMerchantPo.getExceptionFlag())) {
                creditPo = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
            }
            if (creditPo == null && fscMerchantPo.getParentId() != null) {
                fscCreditBalancePO.setMerchantId(fscMerchantPo.getParentId());
                creditPo = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
            }
            if (creditPo == null) {
                fscAccountDetailQueryAbilityRspBO.setAgreeAvailableCreditAmount(fscMerchantPo.getPayCreditAmount());
            } else {
                fscAccountDetailQueryAbilityRspBO.setAgreeAvailableCreditAmount(fscMerchantPo.getPayCreditAmount() == null ? BigDecimal.ZERO : fscMerchantPo.getPayCreditAmount().subtract(creditPo.getUsedAmount()));
            }
        } else if (busiType == 3) {
            fscAccountDetailQueryAbilityRspBO.setNoAgreePayCreditAmount(fscMerchantPo.getPayCreditAmount());
            FscCreditBalancePO fscCreditBalancePO = new FscCreditBalancePO();
            fscCreditBalancePO.setMerchantId(fscMerchantPo.getMerchantId());
            fscCreditBalancePO.setPayBusiness("3");
            fscCreditBalancePO.setPurOrgId(fscAccountPO.getOrgId());
            FscCreditBalancePO creditPo = null;
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscMerchantPo.getPayType()) && FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(fscMerchantPo.getExceptionFlag()) || FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(fscMerchantPo.getExceptionFlag())) {
                creditPo = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
            }
            if (creditPo == null && fscMerchantPo.getParentId() != null) {
                fscCreditBalancePO.setMerchantId(fscMerchantPo.getParentId());
                creditPo = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
            }
            if (creditPo == null) {
                fscAccountDetailQueryAbilityRspBO.setNoAgreeAvailableCreditAmount(fscMerchantPo.getPayCreditAmount());
            } else {
                fscAccountDetailQueryAbilityRspBO.setNoAgreeAvailableCreditAmount(fscMerchantPo.getPayCreditAmount() == null ? BigDecimal.ZERO : fscMerchantPo.getPayCreditAmount().subtract(creditPo.getUsedAmount()));
            }
        }
    }
}

