/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.common.ability.api.FscBillSaleOrderDetailsExportAbliltyService;
import com.tydic.fsc.common.ability.bo.FscBillSaleOrderDetailsImportAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBillSaleOrderDetailsImportAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscBillSaleOrderInfoBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillSaleOrderDetailsExportAbliltyService"})
public class FscBillSaleOrderDetailsExportAbliltyServiceImpl
implements FscBillSaleOrderDetailsExportAbliltyService {
    @PostMapping(value={"importOrderPrice"})
    public FscBillSaleOrderDetailsImportAbilityRspBO importOrderPrice(@RequestBody FscBillSaleOrderDetailsImportAbilityReqBO reqBO) {
        FscBillSaleOrderDetailsImportAbilityRspBO rspBO = new FscBillSaleOrderDetailsImportAbilityRspBO();
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)reqBO.getUrl())) {
            throw new FscBusinessException("191000", "\u6a21\u677f\u5730\u5740[url]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)reqBO.getOrderType())) {
            throw new FscBusinessException("191000", "\u660e\u7ec6\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        URL url = null;
        try {
            url = new URL(reqBO.getUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            InputStream fis = conn.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(fis);
            Sheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            ArrayList<FscBillSaleOrderInfoBO> bos = new ArrayList<FscBillSaleOrderInfoBO>();
            BigDecimal big = BigDecimal.ZERO;
            for (int i = 0; i < lastRowNum - 1; ++i) {
                FscBillSaleOrderInfoBO bo = new FscBillSaleOrderInfoBO();
                Row row = sheet.getRow(i + 3);
                if (!this.isEmptyRow(row)) {
                    BigDecimal salesUnitPrice;
                    BigDecimal procureUnitPrice;
                    String skuUpcCode;
                    if ("2".equals(reqBO.getOrderType())) {
                        skuUpcCode = FscBillSaleOrderDetailsExportAbliltyServiceImpl.getCellValue(row.getCell(13));
                        if (ObjectUtils.isEmpty((Object)skuUpcCode)) {
                            rspBO.setRespDesc("\u7269\u8d44\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
                            rspBO.setRespCode("190000");
                            return rspBO;
                        }
                        procureUnitPrice = new BigDecimal(FscBillSaleOrderDetailsExportAbliltyServiceImpl.getCellValue(row.getCell(7)));
                        if (ObjectUtils.isEmpty((Object)procureUnitPrice)) {
                            rspBO.setRespDesc("\u91c7\u8d2d\u5355\u4ef7\uff08\u8c03\u4ef7\u540e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                            rspBO.setRespCode("190000");
                            return rspBO;
                        }
                        salesUnitPrice = new BigDecimal(FscBillSaleOrderDetailsExportAbliltyServiceImpl.getCellValue(row.getCell(11)));
                        if (ObjectUtils.isEmpty((Object)salesUnitPrice)) {
                            rspBO.setRespDesc("\u9500\u552e\u5355\u4ef7\uff08\u8c03\u4ef7\u540e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                            rspBO.setRespCode("190000");
                            return rspBO;
                        }
                    } else {
                        skuUpcCode = FscBillSaleOrderDetailsExportAbliltyServiceImpl.getCellValue(row.getCell(15));
                        if (ObjectUtils.isEmpty((Object)skuUpcCode)) {
                            rspBO.setRespDesc("\u7269\u8d44\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
                            rspBO.setRespCode("190000");
                            return rspBO;
                        }
                        procureUnitPrice = new BigDecimal(FscBillSaleOrderDetailsExportAbliltyServiceImpl.getCellValue(row.getCell(9)));
                        if (ObjectUtils.isEmpty((Object)procureUnitPrice)) {
                            rspBO.setRespDesc("\u91c7\u8d2d\u5355\u4ef7\uff08\u8c03\u4ef7\u540e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                            rspBO.setRespCode("190000");
                            return rspBO;
                        }
                        salesUnitPrice = new BigDecimal(FscBillSaleOrderDetailsExportAbliltyServiceImpl.getCellValue(row.getCell(13)));
                        if (ObjectUtils.isEmpty((Object)salesUnitPrice)) {
                            rspBO.setRespDesc("\u9500\u552e\u5355\u4ef7\uff08\u8c03\u4ef7\u540e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                            rspBO.setRespCode("190000");
                            return rspBO;
                        }
                    }
                    bo.setSkuUpcCode(skuUpcCode);
                    bo.setProcureUnitPrice(procureUnitPrice);
                    bo.setSalesUnitPrice(salesUnitPrice);
                    bos.add(bo);
                    rspBO.setList(bos);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rspBO;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        if (!StringUtils.isEmpty((Object)cell)) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                        break;
                    }
                    DataFormatter dataFormatter = new DataFormatter();
                    cellValue = dataFormatter.formatCellValue(cell);
                    break;
                }
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    cellValue = cell.getBooleanCellValue() + "";
                    break;
                }
                case FORMULA: {
                    cellValue = cell.getCellFormula() + "";
                    break;
                }
                case BLANK: {
                    cellValue = "";
                    break;
                }
                case ERROR: {
                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                    break;
                }
                default: {
                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                }
            }
        }
        return cellValue;
    }

    public boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        int firstCellNum = row.getFirstCellNum();
        short lastCellNum = row.getLastCellNum();
        int nullCellNum = 0;
        for (int c = firstCellNum; c < lastCellNum; ++c) {
            Cell cell = row.getCell(c);
            if (null == cell || CellType.BLANK == cell.getCellType()) {
                ++nullCellNum;
                continue;
            }
            cell.setCellType(CellType.STRING);
            String cellValue = cell.getStringCellValue().trim();
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)cellValue)) continue;
            ++nullCellNum;
        }
        return nullCellNum == lastCellNum - firstCellNum;
    }
}

