/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscClaimChangeReceiveYcStatusAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscClaimChangeReceiveYcStatusAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimChangeReceiveYcStatusAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscClaimChangeReceiveYcStatusRenovBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeReceiveYcStatusBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimChangeReceiveYcStatusBusiRspBO;
import com.tydic.fsc.common.consumer.bo.ClaimChangeSettleOrderStateBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscClaimChangeReceiveYcStatusAbilityService"})
public class FscClaimChangeReceiveYcStatusAbilityServiceImpl
implements FscClaimChangeReceiveYcStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimChangeReceiveYcStatusAbilityServiceImpl.class);
    @Autowired
    private FscClaimChangeReceiveYcStatusRenovBusiService fscClaimChangeReceiveYcStatusRenovBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Resource(name="fscClaimChangeSettleOrderStateMqServiceProvider")
    private ProxyMessageProducer fscClaimChangeSettleOrderStateMqServiceProvider;
    @Value(value="${es.FSC_CLAIM_CHANGE_SETTLE_ORDER_STATE_SYNC_TOPIC:FSC_CLAIM_CHANGE_SETTLE_ORDER_STATE_SYNC_TOPIC}")
    private String syncTopic;
    @Value(value="${es.FSC_CLAIM_CHANGE_SETTLE_ORDER_STATE_SYNC_TAG:FSC_CLAIM_CHANGE_SETTLE_ORDER_STATE_SYNC_TAG}")
    private String syncTag;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"receiveYcStatus"})
    public FscClaimChangeReceiveYcStatusAbilityRspBO receiveYcStatus(@RequestBody FscClaimChangeReceiveYcStatusAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId((Long)reqBO.getChangeIdList().get(0));
        logAbilityReqBO.setType(FscConstants.FscPushType.CLAIM_CHANGE_POSTING_STATUS);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)reqBO));
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        FscClaimChangeReceiveYcStatusBusiReqBO busiReqBO = new FscClaimChangeReceiveYcStatusBusiReqBO();
        busiReqBO.setChangeIdList(reqBO.getChangeIdList());
        busiReqBO.setStatus("1");
        busiReqBO.setPostingDate(reqBO.getPostingDate());
        FscClaimChangeReceiveYcStatusBusiRspBO busiRspBO = this.fscClaimChangeReceiveYcStatusRenovBusiService.dealReceiveYcStatus(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        this.sendMq(busiRspBO);
        FscClaimChangeReceiveYcStatusAbilityRspBO rspBO = new FscClaimChangeReceiveYcStatusAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscClaimChangeReceiveYcStatusAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeIdList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[changeIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(FscClaimChangeReceiveYcStatusBusiRspBO busiRspBO) {
        ClaimChangeSettleOrderStateBO claimChangeSettleOrderStateBO = new ClaimChangeSettleOrderStateBO();
        claimChangeSettleOrderStateBO.setSettleList(busiRspBO.getSettleList());
        claimChangeSettleOrderStateBO.setPreList(busiRspBO.getPreList());
        ProxySendResult proxySendResult = this.fscClaimChangeSettleOrderStateMqServiceProvider.send(new ProxyMessage(this.syncTopic, this.syncTag, JSONObject.toJSONString((Object)claimChangeSettleOrderStateBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeStateFailLog(JSONObject.toJSONString((Object)claimChangeSettleOrderStateBO));
        }
        if (!CollectionUtils.isEmpty(busiRspBO.getFscOrderIdList())) {
            FscComOrderListSyncAbilityReqBO reqBO = new FscComOrderListSyncAbilityReqBO();
            reqBO.setIsThread(Boolean.valueOf(false));
            reqBO.setFscOrderIds(busiRspBO.getFscOrderIdList());
            reqBO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
            log.info("\u8ba4\u9886\u53d8\u66f4\u8fc7\u8d26\u56de\u8c03\u540c\u6b65\u7ed3\u7b97\u5355\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reqBO));
            this.fscComOrderSyncAbilityService.dealSyncAllOrder(reqBO);
        }
    }

    private void writeStateFailLog(String objNo) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(objNo);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_CLAIM_CHANGE_SETTLE_ORDER_STATE_SYNC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

