/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.common.ability.api.FscClaimCreateNewYCCashAbilityService;
import com.tydic.fsc.common.ability.bo.FscAttachmentExtensionBO;
import com.tydic.fsc.common.ability.bo.FscClaimCreateNewYCCashAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscClaimCreateNewYCCashAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscClaimCreateNewYCCashBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscClaimCreateNewYCCashAbilityService"})
public class FscClaimCreateNewYCCashAbilityServiceImpl
implements FscClaimCreateNewYCCashAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimCreateNewYCCashAbilityServiceImpl.class);
    @Autowired
    private FscClaimCreateNewYCCashBusiService fscClaimCreateNewYCCashBusiService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;

    @PostMapping(value={"createNewYCCash"})
    public FscClaimCreateNewYCCashAbilityRspBO createNewYCCash(@RequestBody FscClaimCreateNewYCCashAbilityReqBO reqBO) {
        log.info("\u63a5\u6536\u65b0\u4e1a\u8d22\u94f6\u884c\u6d41\u6c34\u751f\u6210\u8ba4\u9886\u5355\u5165\u53c2{}" + JSON.toJSONString((Object)reqBO));
        String rspStr = null;
        try {
            this.valid(reqBO);
            FscClaimCreateNewYCCashAbilityRspBO rspBO = this.fscClaimCreateNewYCCashBusiService.createNewYCCash(reqBO);
            rspStr = JSONObject.toJSONString((Object)rspBO);
            FscClaimCreateNewYCCashAbilityRspBO fscClaimCreateNewYCCashAbilityRspBO = rspBO;
            return fscClaimCreateNewYCCashAbilityRspBO;
        }
        catch (Exception e) {
            rspStr = e.getMessage();
            throw new FscBusinessException("191000", e.getMessage());
        }
        finally {
            this.saveLog(reqBO, rspStr);
        }
    }

    private void valid(FscClaimCreateNewYCCashAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getInfoBos())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[infoBos]\u4e3a\u7a7a");
        }
        HashSet set = new HashSet();
        HashSet setHeaderId = new HashSet();
        reqBO.getInfoBos().forEach(obj -> {
            if (StringUtils.isEmpty((Object)obj.getRecvDeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[recvDeptName]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getSerialNumber())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[serialNumber]\u4e3a\u7a7a");
            }
            if (obj.getHeaderId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[headerId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getBankAccount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[bankAccount]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getBankName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[bankName]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getAccountBranch())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[accountBranch]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getCustomerName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[customerName]\u4e3a\u7a7a");
            }
            if (obj.getCustomerNo() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[customerNo]\u4e3a\u7a7a");
            }
            if (obj.getRecvAmt() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[recvAmt]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getUserAccount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[userAccount]\u4e3a\u7a7a");
            }
            if (obj.getHandleUserId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[handleUserId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getHandleUserName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[handleUserName]\u4e3a\u7a7a");
            }
            if (obj.getHandledeptId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[handledeptId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getHandledeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[handledeptName]\u4e3a\u7a7a");
            }
            if (obj.getRecvDate() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[recvDate]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)obj.getRecvType())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[recvType]\u4e3a\u7a7a");
            }
            if (obj.getBankId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[bankId]\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)obj.getAttachmentExtensionBOS())) {
                for (FscAttachmentExtensionBO attachmentExtensionBO : obj.getAttachmentExtensionBOS()) {
                    if (StringUtils.isEmpty((Object)attachmentExtensionBO.getCreateUser())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[createUser]\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)attachmentExtensionBO.getFormatType())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[formatType]\u4e3a\u7a7a");
                    }
                    if (attachmentExtensionBO.getFileSize() == null) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[fileSize]\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)attachmentExtensionBO.getAttachmentName())) {
                        throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[attachmentName]\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isEmpty((Object)attachmentExtensionBO.getAttachmentUrl())) continue;
                    throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[attachmentUrl]\u4e3a\u7a7a");
                }
            }
            set.add(obj.getSerialNumber());
            setHeaderId.add(obj.getHeaderId());
        });
        if (set.size() != reqBO.getInfoBos().size()) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u660e\u7ec6\u94f6\u884c\u6d41\u6c34\u53f7\u91cd\u590d\uff01");
        }
        if (setHeaderId.size() != reqBO.getInfoBos().size()) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u660e\u7ec6\u94f6\u884c\u6d41\u6c34\u53f7id\u91cd\u590d\uff01");
        }
    }

    private void saveLog(FscClaimCreateNewYCCashAbilityReqBO reqBO, String rspStr) {
        try {
            FscBillDealPushLogAbilityReqBO fscBillDealPushLogAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
            fscBillDealPushLogAbilityReqBO.setObjectId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBillDealPushLogAbilityReqBO.setType(FscConstants.FscPushType.NEW_YCCASH);
            fscBillDealPushLogAbilityReqBO.setObjData(JSONObject.toJSONString((Object)reqBO));
            fscBillDealPushLogAbilityReqBO.setRespData(rspStr);
            fscBillDealPushLogAbilityReqBO.setCreateTime(new Date());
            this.fscBillAddPushLogAbilityService.savePushLog(fscBillDealPushLogAbilityReqBO);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
        }
    }
}

