/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComAccountListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComAccountListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComAccountListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComAccountListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.umc.general.ability.api.UmcBuyerPermissionRecvAcceptQryAbilityService;
import com.tydic.umc.general.ability.api.UmcEntityOrgQryFscAbilityService;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryReqBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComAccountListQueryAbilityService"})
public class FscComAccountListQueryAbilityServiceImpl
implements FscComAccountListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComAccountListQueryAbilityServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private UmcEntityOrgQryFscAbilityService umcEntityOrgQryFscAbilityService;
    @Autowired
    private UmcBuyerPermissionRecvAcceptQryAbilityService umcBuyerPermissionRecvAcceptQryAbilityService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    private static final String ALL = "0";
    private static final String EMPLOYEE = "4";
    private static final Integer EXP_FLAG = 1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"qryAccountList"})
    public FscComAccountListQueryAbilityRspBO qryAccountList(@RequestBody FscComAccountListQueryAbilityReqBO reqBO) {
        FscAccountPO fscAccountPO = new FscAccountPO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            fscAccountPO.setIds(reqBO.getIds());
        }
        if (null != reqBO.getAccountName()) {
            fscAccountPO.setAccountName(reqBO.getAccountName());
        }
        if (null != reqBO.getAccountNo()) {
            fscAccountPO.setAccountNo(reqBO.getAccountNo());
        }
        if (null != reqBO.getStatus()) {
            fscAccountPO.setStatus(reqBO.getStatus());
        }
        if (null != reqBO.getCreateTimeStart()) {
            fscAccountPO.setCreateTimeStart(reqBO.getCreateTimeStart());
        }
        if (null != reqBO.getCreateTimeEnd()) {
            fscAccountPO.setCreateTimeEnd(reqBO.getCreateTimeEnd());
        }
        if (null != reqBO.getAccountCategory()) {
            fscAccountPO.setAccountCategory(reqBO.getAccountCategory());
        }
        if (null != reqBO.getCreateMethod()) {
            fscAccountPO.setCreateMethod(reqBO.getCreateMethod());
        }
        if (null != reqBO.getBusiType()) {
            fscAccountPO.setBusiType(reqBO.getBusiType().toString());
        }
        FscComAccountListQueryAbilityRspBO rspBO = new FscComAccountListQueryAbilityRspBO();
        if (null != reqBO.getIsprofess() && "1".equals(reqBO.getIsprofess())) {
            UmcBuyerPermissionRecvAcceptQryReqBO umcBuyerPermissionRecvAcceptQryReqBO = new UmcBuyerPermissionRecvAcceptQryReqBO();
            umcBuyerPermissionRecvAcceptQryReqBO.setErpCode(reqBO.getOccupation());
            umcBuyerPermissionRecvAcceptQryReqBO.setPageSize(Integer.valueOf(100));
            UmcBuyerPermissionRecvAcceptQryRspBO qry = this.umcBuyerPermissionRecvAcceptQryAbilityService.qry(umcBuyerPermissionRecvAcceptQryReqBO);
            if (CollectionUtils.isEmpty((Collection)qry.getRows())) return rspBO;
            List collect = qry.getRows().stream().map(UmcBuyerPermissionRecvAcceptBO::getOrgId).collect(Collectors.toList());
            fscAccountPO.setOrgIds(collect);
        } else if (null != reqBO.getIsprofess() && !ALL.equals(reqBO.getIsprofess())) {
            if (null != reqBO.getMechanismOrgId()) {
                fscAccountPO.setOrgId(reqBO.getMechanismOrgId());
            }
            if (reqBO.getMechanismOrgId() == null) {
                fscAccountPO.setOrgId(reqBO.getCompanyId());
            }
        } else if (null != reqBO.getIsprofess() && ALL.equals(reqBO.getIsprofess())) {
            if (null != reqBO.getMechanismOrgId()) {
                fscAccountPO.setOrgId(reqBO.getMechanismOrgId());
            }
            if (reqBO.getMechanismOrgId() == null) {
                fscAccountPO.setOrgId(null);
                fscAccountPO.setOrgName(null);
            }
        }
        fscAccountPO.setOrgName(reqBO.getMechanismOrgName());
        String orderBy = "create_time desc";
        fscAccountPO.setOrderBy(orderBy);
        log.info(JSON.toJSONString((Object)fscAccountPO));
        if ("1".equals(reqBO.getBusiTypeFlag())) {
            fscAccountPO.setBusiType(EMPLOYEE);
        }
        fscAccountPO.setExcept(EMPLOYEE);
        List fscAccountPOList = this.fscAccountMapper.getListPage(fscAccountPO, page);
        if (CollectionUtils.isEmpty((Collection)fscAccountPOList)) {
            return new FscComAccountListQueryAbilityRspBO();
        }
        Map fscAccountCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_CATEGORY");
        Map fscAccountCreateMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_CREATE_METHOD");
        Map fscAccountStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_STATUS");
        Map fscBusiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
        List fscComAccountListBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscAccountPOList), FscComAccountListBO.class);
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        Long merchantId = fscMerchantPo.getMerchantId();
        BigDecimal remindCredit = fscMerchantPo.getRemindCredit();
        BigDecimal remindOverdraft = fscMerchantPo.getRemindOverdraft();
        for (FscComAccountListBO fscComAccountListBO : fscComAccountListBOS) {
            ArrayList<Object> strings;
            fscComAccountListBO.setOverdraft(fscComAccountListBO.getOverdraft().subtract(fscComAccountListBO.getDistributeOverdraftAmount()));
            fscComAccountListBO.setRemindCredit(remindCredit);
            fscComAccountListBO.setRemindOverdraft(remindOverdraft);
            if (fscComAccountListBO.getRemainAmount().compareTo(BigDecimal.ZERO) < 0) {
                fscComAccountListBO.setRemainAmount(BigDecimal.ZERO);
            }
            if (fscComAccountListBO.getOverDraftRemaining().compareTo(BigDecimal.ZERO) < 0) {
                fscComAccountListBO.setOverDraftRemaining(BigDecimal.ZERO);
            }
            fscComAccountListBO.setAccountCategoryStr((String)fscAccountCategoryMap.get(fscComAccountListBO.getAccountCategory().toString()));
            fscComAccountListBO.setCreateMethodStr((String)fscAccountCreateMethodMap.get(fscComAccountListBO.getCreateMethod().toString()));
            fscComAccountListBO.setStatusStr((String)fscAccountStatusMap.get(fscComAccountListBO.getStatus().toString()));
            if (StringUtils.isEmpty((Object)fscComAccountListBO.getBusiType()) || ALL.equals(fscComAccountListBO.getBusiType())) {
                fscComAccountListBO.setBusiType(ALL);
                strings = new ArrayList(fscBusiTypeMap.keySet());
                strings.remove(ALL);
            } else {
                strings = new ArrayList<String>(Arrays.asList(fscComAccountListBO.getBusiType().split(",")));
            }
            if ("1".equals(reqBO.getBusiTypeFlag())) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(EMPLOYEE);
                strings = list;
            } else {
                strings.remove(EMPLOYEE);
            }
            ArrayList<String> busiType = new ArrayList<String>();
            for (int i = 0; i < strings.size(); ++i) {
                String s = (String)fscBusiTypeMap.get(strings.get(i));
                busiType.add(s);
            }
            fscComAccountListBO.setBusiTypeStr(String.join((CharSequence)",", busiType));
            if (fscComAccountListBO.getAccountCategory() != null && fscComAccountListBO.getAccountCategory() == 3) {
                fscComAccountListBO.setAvailableOverdraftAmount(fscComAccountListBO.getOverdraft().subtract(fscComAccountListBO.getOverdraftAmount()));
                BigDecimal subtract1 = fscComAccountListBO.getOverdraft().subtract(fscComAccountListBO.getDistributeOverdraftAmount() == null ? BigDecimal.ZERO : fscComAccountListBO.getDistributeOverdraftAmount());
                fscComAccountListBO.setAvailableOverdraftAmount(subtract1.subtract(fscComAccountListBO.getOverDraftRemaining()));
                fscComAccountListBO.setRemainingOrderAmount(fscComAccountListBO.getRemainAmount().add(fscComAccountListBO.getAvailableOverdraftAmount()));
                continue;
            }
            if (merchantId != null) {
                FscMerchantPO merchant = new FscMerchantPO();
                if (EXP_FLAG.equals(fscMerchantPo.getPayAllowExceptionFlag())) {
                    merchant.setPayBusiSceneRangeLike("1");
                    merchant.setParentId(merchantId);
                    merchant.setDelFlag(FscConstants.DicDelFlag.NO);
                    merchant.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE);
                    merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                    merchant.setPayObjId(fscComAccountListBO.getOrgId());
                    merchant.setEnable(Integer.valueOf(1));
                    merchant = this.fscMerchantMapper.getModelBy(merchant);
                }
                BigDecimal overdraftAmount = fscComAccountListBO.getOverdraftAmount();
                if (merchant != null && merchant.getMerchantId() != null) {
                    fscComAccountListBO.setOverdraftAmount(merchant.getOverdraft() == null ? BigDecimal.ZERO : merchant.getOverdraft());
                    fscComAccountListBO.setAvailableOverdraftAmount(merchant.getOverdraft() == null ? BigDecimal.ZERO : merchant.getOverdraft().subtract(overdraftAmount));
                } else {
                    fscComAccountListBO.setOverdraftAmount(fscMerchantPo.getOverdraft() == null ? BigDecimal.ZERO : fscMerchantPo.getOverdraft());
                    fscComAccountListBO.setAvailableOverdraftAmount(fscMerchantPo.getOverdraft() == null ? BigDecimal.ZERO : fscMerchantPo.getOverdraft().subtract(overdraftAmount));
                    if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscMerchantPo.getPayType())) {
                        fscComAccountListBO.setAvailableOverdraftAmount(BigDecimal.ZERO);
                    }
                }
                if (!strings.contains("1") && !strings.contains(ALL)) continue;
                BigDecimal subtract1 = fscComAccountListBO.getOverdraft().subtract(fscComAccountListBO.getDistributeOverdraftAmount() == null ? BigDecimal.ZERO : fscComAccountListBO.getDistributeOverdraftAmount());
                fscComAccountListBO.setAvailableOverdraftAmount(subtract1.subtract(fscComAccountListBO.getOverDraftRemaining()));
                fscComAccountListBO.setRemainingOrderAmount(fscComAccountListBO.getRemainAmount().add(fscComAccountListBO.getAvailableOverdraftAmount()));
                continue;
            }
            fscComAccountListBO.setAvailableOverdraftAmount(fscComAccountListBO.getOverdraft().subtract(fscComAccountListBO.getOverdraftAmount()));
        }
        if (null != reqBO.getIsprofess() && ALL.equals(reqBO.getIsprofess())) {
            this.getFscMerchantPO(fscComAccountListBOS);
        }
        rspBO.setRows(fscComAccountListBOS);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void getFscMerchantPO(List<FscComAccountListBO> fscComAccountListBOS) {
        List orgIds = fscComAccountListBOS.stream().map(FscComAccountListBO::getOrgId).collect(Collectors.toList());
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        Long merchantId = fscMerchantPo.getMerchantId();
        String payBusiSceneRange = fscMerchantPo.getPayBusiSceneRange();
        List<Long> merChantIds = new ArrayList<Long>();
        Map<Object, Object> ListOutMapELECTRICITY = new HashMap();
        Map<Object, Object> ListOutMapNOAGREE = new HashMap();
        Map<Object, Object> ListOutMapAGREE = new HashMap();
        if (EXP_FLAG.equals(fscMerchantPo.getPayAllowExceptionFlag())) {
            FscMerchantPO merchant = new FscMerchantPO();
            merchant.setParentId(merchantId);
            merchant.setDelFlag(FscConstants.DicDelFlag.NO);
            merchant.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
            merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            merchant.setPayObjIds(orgIds);
            merchant.setEnable(Integer.valueOf(1));
            List listOut = this.fscMerchantMapper.getList(merchant);
            Map<String, List<FscMerchantPO>> listOutGroup = listOut.stream().collect(Collectors.groupingBy(FscMerchantPO::getPayBusiSceneRange));
            if (!CollectionUtils.isEmpty((Collection)listOutGroup.get("1"))) {
                ListOutMapELECTRICITY = listOutGroup.get("1").stream().collect(Collectors.toMap(FscMerchantPO::getPayObjId, Function.identity(), (e1, e2) -> e1));
            }
            if (!CollectionUtils.isEmpty((Collection)listOutGroup.get("3"))) {
                ListOutMapNOAGREE = listOutGroup.get("3").stream().collect(Collectors.toMap(FscMerchantPO::getPayObjId, Function.identity(), (e1, e2) -> e1));
            }
            if (!CollectionUtils.isEmpty((Collection)listOutGroup.get("2"))) {
                ListOutMapAGREE = listOutGroup.get("2").stream().collect(Collectors.toMap(FscMerchantPO::getPayObjId, Function.identity(), (e1, e2) -> e1));
            }
            merChantIds = listOut.stream().map(FscMerchantPO::getMerchantId).collect(Collectors.toList());
        }
        merChantIds.add(fscMerchantPo.getMerchantId());
        FscCreditBalancePO fscCreditBalancePO = new FscCreditBalancePO();
        fscCreditBalancePO.setMerchantIds(merChantIds);
        fscCreditBalancePO.setPurOrgIds(orgIds);
        List list = this.fscCreditBalanceMapper.getList(fscCreditBalancePO);
        Map<Long, List<FscCreditBalancePO>> balanceMap = list.stream().collect(Collectors.groupingBy(FscCreditBalancePO::getPurOrgId));
        for (FscComAccountListBO bo : fscComAccountListBOS) {
            List<FscCreditBalancePO> fscCreditBalancePOS = balanceMap.get(bo.getOrgId());
            String busiType = null;
            busiType = !StringUtils.isEmpty((Object)bo.getBusiType()) ? bo.getBusiType() : ALL;
            List<String> strings = Arrays.asList(busiType.split(","));
            if (!CollectionUtils.isEmpty(fscCreditBalancePOS)) {
                BigDecimal available;
                Map<String, List<FscCreditBalancePO>> balanceMapGroup = fscCreditBalancePOS.stream().collect(Collectors.groupingBy(FscCreditBalancePO::getPayBusiness));
                if (strings.contains("1") || strings.contains(ALL)) {
                    available = this.getAvailable(ListOutMapELECTRICITY, fscMerchantPo, bo, balanceMapGroup, "1");
                    bo.setElectricityAvailable(available);
                }
                if (strings.contains("3") || strings.contains(ALL)) {
                    available = this.getAvailable(ListOutMapNOAGREE, fscMerchantPo, bo, balanceMapGroup, "3");
                    bo.setNoAgreeAvailable(available);
                }
                if (!strings.contains("2") && !strings.contains(ALL)) continue;
                available = this.getAvailable(ListOutMapAGREE, fscMerchantPo, bo, balanceMapGroup, "2");
                bo.setAgreeAvailable(available);
                continue;
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscMerchantPo.getPayType())) {
                this.setAvailableWithNot(fscMerchantPo, payBusiSceneRange, bo, strings);
            } else {
                bo.setElectricityAvailable(BigDecimal.ZERO);
                bo.setNoAgreeAvailable(BigDecimal.ZERO);
                bo.setAgreeAvailable(BigDecimal.ZERO);
            }
            if (null != ListOutMapELECTRICITY.get(bo.getOrgId()) && (strings.contains("1") || strings.contains(ALL))) {
                bo.setElectricityAvailable(((FscMerchantPO)ListOutMapELECTRICITY.get(bo.getOrgId())).getPayCreditAmount());
            }
            if (null != ListOutMapNOAGREE.get(bo.getOrgId()) && (strings.contains("3") || strings.contains(ALL))) {
                bo.setNoAgreeAvailable(((FscMerchantPO)ListOutMapNOAGREE.get(bo.getOrgId())).getPayCreditAmount());
            }
            if (null == ListOutMapAGREE.get(bo.getOrgId()) || !strings.contains("2") && !strings.contains(ALL)) continue;
            bo.setAgreeAvailable(((FscMerchantPO)ListOutMapAGREE.get(bo.getOrgId())).getPayCreditAmount());
        }
    }

    private void setAvailableWithNot(FscMerchantPO fscMerchantPo, String payBusiSceneRange, FscComAccountListBO bo, List<String> strings) {
        List<String> stringsB = Arrays.asList(payBusiSceneRange.split(","));
        if ((stringsB.contains("1") || stringsB.contains(ALL)) && (strings.contains("1") || strings.contains(ALL))) {
            bo.setElectricityAvailable(fscMerchantPo.getPayCreditAmount());
        }
        if ((stringsB.contains("3") || stringsB.contains(ALL)) && (strings.contains("3") || strings.contains(ALL))) {
            bo.setNoAgreeAvailable(fscMerchantPo.getPayCreditAmount());
        }
        if ((stringsB.contains("2") || stringsB.contains(ALL)) && (strings.contains("2") || strings.contains(ALL))) {
            bo.setAgreeAvailable(fscMerchantPo.getPayCreditAmount());
        }
    }

    private BigDecimal getAvailable(Map<Long, FscMerchantPO> ListOutMap, FscMerchantPO finalFscMerchantPo, FscComAccountListBO bo, Map<String, List<FscCreditBalancePO>> balanceMapGroup, String busiType) {
        List<FscCreditBalancePO> fscCreditBalancePOS1 = balanceMapGroup.get(busiType);
        if (!MapUtils.isEmpty(ListOutMap) && null != ListOutMap.get(bo.getOrgId()) && ListOutMap.get(bo.getOrgId()).getPayBusiSceneRange().contains(busiType) || null != ListOutMap.get(bo.getOrgId()) && ALL.equals(ListOutMap.get(bo.getOrgId()).getPayBusiSceneRange())) {
            if (!CollectionUtils.isEmpty(fscCreditBalancePOS1)) {
                FscCreditBalancePO fscCreditBalancePO1 = fscCreditBalancePOS1.get(0);
                return ListOutMap.get(bo.getOrgId()).getPayCreditAmount().subtract(fscCreditBalancePO1.getUsedAmount());
            }
            return ListOutMap.get(bo.getOrgId()).getPayCreditAmount();
        }
        if (finalFscMerchantPo.getPayBusiSceneRange().contains(busiType) || ALL.equals(finalFscMerchantPo.getPayBusiSceneRange())) {
            if (!FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(finalFscMerchantPo.getPayType())) {
                return BigDecimal.ZERO;
            }
            if (!CollectionUtils.isEmpty(fscCreditBalancePOS1)) {
                FscCreditBalancePO fscCreditBalancePO1 = fscCreditBalancePOS1.get(0);
                return finalFscMerchantPo.getPayCreditAmount().subtract(fscCreditBalancePO1.getUsedAmount());
            }
            return finalFscMerchantPo.getPayCreditAmount();
        }
        if (!CollectionUtils.isEmpty(fscCreditBalancePOS1)) {
            return BigDecimal.ZERO.subtract(fscCreditBalancePOS1.get(0).getUsedAmount());
        }
        return null;
    }
}

