/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcUniteParamQryAutoBillEnableDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryAutoBillEnableDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryAutoBillEnableDetailAbilityRspBO;
import com.tydic.fsc.common.ability.api.FscBusinessPendingTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscNoticeEcomCancelInvoiceAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderInvoiceBackAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderCancelAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNoticeEcomCancelInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNoticeEcomCancelInvoiceAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceBackAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoiceBackAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscTodoBusinessWaitDoneDealReqBo;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderCancelAbilityService"})
public class FscComOrderCancelAbilityServiceImpl
implements FscComOrderCancelAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderCancelBusiService fscComOrderCancelBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscNoticeEcomCancelInvoiceAbilityService fscNoticeEcomCancelInvoiceAbilityService;
    @Autowired
    private CfcUniteParamQryAutoBillEnableDetailAbilityService cfcUniteParamQryAutoBillEnableDetailAbilityService;
    @Autowired
    private FscOrderInvoiceBackAbilityService fscOrderInvoiceBackAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private PebUpdateOrderAbilityService pebUpdateOrderAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscBusinessPendingTodoAbilityService fscBusinessPendingTodoAbilityService;
    private static final String TWELVE = "12";
    private static final Integer CANCEL_ONE = 1;
    private static final Integer OBJ_TYPE_SEVEN = 7;

    @PostMapping(value={"dealOrderCancel"})
    public FscComOrderCancelAbilityRspBO dealOrderCancel(@RequestBody FscComOrderCancelAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u7528\u6237\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191125", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        if (!(!FscConstants.FscOrderMakeType.SUPPLIER.equals(fscOrderPO.getMakeType()) || FscBillStatus.TO_BE_RECONCILED.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_RJECT.getCode().equals(fscOrderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.BILLSIGNFAIL.equals(fscOrderPO.getOrderState()) || FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(fscOrderPO.getOrderState()))) {
            throw new FscBusinessException("191125", "\u4f9b\u5e94\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u6216\u5df2\u786e\u8ba4\u72b6\u6001");
        }
        if (!(!FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) || FscBillStatus.PENDING_FEEDBACK.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.TO_BE_INVOICED.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_AUDIT_REJECT.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_TO_BE_CONFIRM.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_RJECT.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.INVOICING_AUDITING.getCode().equals(fscOrderPO.getOrderState()) || FscBillStatus.PUSH_FAIL.getCode().equals(fscOrderPO.getOrderState()))) {
            throw new FscBusinessException("191125", "\u8d38\u6613\u6a21\u5f0f\u7ed3\u7b97\u5355\u53d6\u6d88\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u6216\u5f85\u786e\u8ba4\u72b6\u6001");
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && !FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState()) && !FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191125", "\u7535\u5546\u4fa7\u7ed3\u7b97\u5355\u53d6\u6d88\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\uff0c\u540e\u7eed\u72b6\u6001\u5f85\u4e0e\u7535\u5546\u5bf9\u63a5\u53d6\u6d88\u53d1\u7968\u63a5\u53e3\u540e\u542f\u7528");
        }
        if (FscBillStatus.INVOICING_AUDITING.getCode().equals(fscOrderPO.getOrderState())) {
            UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
            uacQryAuditLogReqBO.setObjId(reqBO.getOrderId().toString());
            uacQryAuditLogReqBO.setObjType(OBJ_TYPE_SEVEN);
            log.info("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u5165\u53c2================" + JSON.toJSONString((Object)uacQryAuditLogReqBO));
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(uacQryAuditLogReqBO);
            log.info("\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u51fa\u53c2================" + JSON.toJSONString((Object)uacQryAuditLogRspBO));
            if (uacQryAuditLogRspBO.getLogInfo().getAuditResult() != null) {
                throw new FscBusinessException("191125", "\u5df2\u6709\u5ba1\u6279\u8bb0\u5f55\uff0c\u4e0d\u80fd\u53d6\u6d88\u7ed3\u7b97\u5355");
            }
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) && FscBillStatus.INVOICING_DEALLING.getCode().equals(fscOrderPO.getOrderState())) {
            FscNoticeEcomCancelInvoiceAbilityReqBO abilityReqBO = new FscNoticeEcomCancelInvoiceAbilityReqBO();
            abilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            FscNoticeEcomCancelInvoiceAbilityRspBO abilityRspBO = this.fscNoticeEcomCancelInvoiceAbilityService.cancelInvoice(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
            }
        }
        Boolean autoBillEnable = true;
        if (reqBO.getIsprofess().equals("0") && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && fscOrderPO.getOrderType().equals(FscOrderTypeEnum.ELECTRONIC.getCode())) {
            autoBillEnable = this.queryAutoBillEnableConfig(fscOrderPO.getOrderType(), fscOrderPO.getPayerId());
        }
        if (autoBillEnable.booleanValue() || FscConstants.FscInvoiceOrderState.ROLL_BACK.equals(fscOrderPO.getOrderState()) || FscBillStatus.PUSH_FAIL.getCode().equals(fscOrderPO.getOrderState())) {
            reqBO.setOrderState(fscOrderPO.getOrderState());
            String jsonString = JSON.toJSONString((Object)reqBO);
            FscComOrderCancelBusiReqBO busiReqBO = (FscComOrderCancelBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderCancelBusiReqBO.class));
            busiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
            busiReqBO.setOrderNo(fscOrderPO.getOrderNo());
            busiReqBO.setRefundId(fscOrderPO.getRefundId());
            FscComOrderCancelBusiRspBO fscComOrderCancelBusiRspBO = this.fscComOrderCancelBusiService.dealOrderCancel(busiReqBO);
            if (!"0000".equals(fscComOrderCancelBusiRspBO.getRespCode())) {
                throw new FscBusinessException("191125", fscComOrderCancelBusiRspBO.getRespDesc());
            }
            if (reqBO.getCancelOperType() != null && reqBO.getCancelOperType().equals(CANCEL_ONE)) {
                FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
                fscOrderRelationPO.setFscOrderId(reqBO.getOrderId());
                List list = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
                for (FscOrderRelationPO po : list) {
                    PebUpdateOrderReqBO orderReqBO = new PebUpdateOrderReqBO();
                    orderReqBO.setOrderId(po.getOrderId());
                    orderReqBO.setFscStatus(TWELVE);
                    orderReqBO.setFscStatusType(TWELVE);
                    log.debug("\u5458\u5de5\u4e2a\u4eba\u53d6\u6d88\u7ed3\u7b97\u5355\u3001\u4fee\u6539\u8d85\u5e02\u8ba2\u5355fscStatus\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderReqBO));
                    PebUpdateOrderRspBO pebUpdateOrderRspBO = this.pebUpdateOrderAbilityService.updateFscStatus(orderReqBO);
                    if (pebUpdateOrderRspBO.getRespCode().equals("0000")) continue;
                    throw new FscBusinessException(pebUpdateOrderRspBO.getRespCode(), pebUpdateOrderRspBO.getRespDesc());
                }
            }
        } else {
            FscOrderInvoiceBackAbilityReqBO abilityReqBO = new FscOrderInvoiceBackAbilityReqBO();
            abilityReqBO.setFscOrderIds(Collections.singletonList(reqBO.getOrderId()));
            FscOrderInvoiceBackAbilityRspBO abilityRspBO = this.fscOrderInvoiceBackAbilityService.dealOrderInvoiceBack(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
            }
        }
        this.sendMq(reqBO, fscOrderPO);
        try {
            this.dealWaitDone(reqBO, fscOrderPO);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5f85\u529e", (Throwable)e);
        }
        return new FscComOrderCancelAbilityRspBO();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealWaitDone(FscComOrderCancelAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        FscTodoBusinessWaitDoneDealReqBo fscTodoBusinessWaitDoneDealReqBo = new FscTodoBusinessWaitDoneDealReqBo();
        if (FscConstants.FscInvoiceOrderState.BILL_UN_CONFIRMED.equals(fscOrderPO.getOrderState())) {
            if ("0".equals(fscOrderPO.getOrderType().toString())) {
                fscTodoBusinessWaitDoneDealReqBo.setBusiCode("1034");
            } else {
                if (!"1".equals(fscOrderPO.getOrderSource().toString())) return;
                fscTodoBusinessWaitDoneDealReqBo.setBusiCode("1035");
            }
        } else if (FscConstants.FscInvoiceOrderState.UNBILLED.equals(fscOrderPO.getOrderState())) {
            fscTodoBusinessWaitDoneDealReqBo.setBusiCode("1020");
        } else {
            log.error("\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u7528\u63a8\u9001\u5f85\u529e{}", (Object)JSON.toJSONString((Object)fscOrderPO));
            return;
        }
        fscTodoBusinessWaitDoneDealReqBo.setDealUserNo(String.valueOf(reqBO.getUserName()));
        fscTodoBusinessWaitDoneDealReqBo.setDealUserName(reqBO.getName());
        fscTodoBusinessWaitDoneDealReqBo.setHandleUserNo(String.valueOf(reqBO.getUserName()));
        fscTodoBusinessWaitDoneDealReqBo.setObjId(String.valueOf(reqBO.getOrderId()));
        this.fscBusinessPendingTodoAbilityService.dealWaitDone(fscTodoBusinessWaitDoneDealReqBo);
    }

    private void sendMq(FscComOrderCancelAbilityReqBO reqBO, FscOrderPO orderPO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        if (orderPO.getRefundId() != null) {
            FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
            syncAbilityReqBO.setRefundIds(Collections.singletonList(orderPO.getRefundId()));
            this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
        }
    }

    public Boolean queryAutoBillEnableConfig(Integer orderType, Long orgId) {
        CfcUniteParamQryAutoBillEnableDetailAbilityReqBO abilityReqBO = new CfcUniteParamQryAutoBillEnableDetailAbilityReqBO();
        abilityReqBO.setGroupCode("AOTU_BILL_ENABLE");
        abilityReqBO.setCenter("FSC");
        abilityReqBO.setBusiType(orderType.toString());
        abilityReqBO.setOrgIgWeb(orgId);
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u914d\u7f6e\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
        CfcUniteParamQryAutoBillEnableDetailAbilityRspBO abilityRspBO = this.cfcUniteParamQryAutoBillEnableDetailAbilityService.qryAutoBillEnableDetail(abilityReqBO);
        log.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u914d\u7f6e\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u662f\u5426\u5e26\u52a8\u4e0a\u6e38\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
        }
        return abilityRspBO.getAutoBillEnable();
    }
}

