/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.common.ability.api.FscComOrderConfirmAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderConfirmAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderConfirmAbilityService"})
public class FscComOrderConfirmAbilityServiceImpl
implements FscComOrderConfirmAbilityService {
    @Autowired
    private FscComOrderConfirmBusiService fscComOrderConfirmBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;

    @PostMapping(value={"dealOrderConfirm"})
    public FscComOrderConfirmAbilityRspBO dealOrderConfirm(@RequestBody FscComOrderConfirmAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_CONFIRM.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191126", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u80fd\u786e\u8ba4");
        }
        this.verifyServiceFeeConfirmTime(fscOrderPo);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscComOrderConfirmBusiReqBO busiReqBO = (FscComOrderConfirmBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderConfirmBusiReqBO.class));
        this.calShouldPayInfo(fscOrder, busiReqBO);
        FscComOrderConfirmBusiRspBO busiRspBO = this.fscComOrderConfirmBusiService.dealOrderConfirm(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191126", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscComOrderConfirmAbilityRspBO();
    }

    private void verifyServiceFeeConfirmTime(FscOrderPO fscOrderPo) {
        if ((FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPo.getOrderFlow())) && System.currentTimeMillis() > fscOrderPo.getCreditConfirmDueDate().getTime()) {
            throw new FscBusinessException("191126", "\u8d85\u8fc7\u786e\u8ba4\u65f6\u9650\u65f6\u9650");
        }
    }

    private void val(FscComOrderConfirmAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscComOrderConfirmAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void calShouldPayInfo(FscOrderPO fscOrderPO, FscComOrderConfirmBusiReqBO fscComOrderConfirmBusiReqBO) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PALATFORM_USE_PAY);
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.USR_ORDER);
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP);
        } else {
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.DEAL_ORDER);
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        }
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        if (fscOrderPO.getActualAmount() == null || BigDecimal.ZERO.compareTo(fscOrderPO.getActualAmount()) == 0) {
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
        } else {
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getActualAmount());
        }
        fscShouldPayBO.setPayeeId(fscOrderPO.getProOrgId());
        fscShouldPayBO.setPayeeName(fscOrderPO.getProOrgName());
        fscShouldPayBO.setPayerId(fscOrderPO.getSupplierId());
        fscShouldPayBO.setPayerName(fscOrderPO.getSupplierName());
        if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
            if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
                fscShouldPayBO.setProContractId(((FscOrderRelationPO)relationPOList.get(0)).getProContractId());
                fscShouldPayBO.setProContractName(((FscOrderRelationPO)relationPOList.get(0)).getProContractName());
                fscShouldPayBO.setProContractNo(((FscOrderRelationPO)relationPOList.get(0)).getProContractNo());
                fscShouldPayBO.setProContractType(((FscOrderRelationPO)relationPOList.get(0)).getProContractType());
                fscShouldPayBO.setProContractSource(((FscOrderRelationPO)relationPOList.get(0)).getProContractSource());
            }
        }
        fscShouldPayBOS.add(fscShouldPayBO);
        fscComOrderConfirmBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscComOrderConfirmBusiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
    }
}

