/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscComRefundAbnormalOrderListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAbnormalOrderBO;
import com.tydic.fsc.common.ability.bo.FscComRefundAbnormalOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundAbnormalOrderListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.api.UocAbnormalSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreOrdShipAbnormalItemBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComRefundAbnormalOrderListQueryAbilityService"})
public class FscComRefundAbnormalOrderListQueryAbilityServiceImpl
implements FscComRefundAbnormalOrderListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComRefundAbnormalOrderListQueryAbilityServiceImpl.class);
    @Autowired
    private UocAbnormalSingleDetailsListQueryAbilityService uocAbnormalSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    private static final Integer ABNORMAL_ALL_TAB_ID = 41001;
    private static final String ABNORMAL_STATE_TWO = "2";
    private static final String ABNORMAL_STATE_THREE = "3";
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @PostMapping(value={"qryRefundAbnormalOrderList"})
    public FscComRefundAbnormalOrderListQueryAbilityRspBO qryRefundAbnormalOrderList(@RequestBody FscComRefundAbnormalOrderListQueryAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscComRefundAbnormalOrderListQueryAbilityRspBO rspBO = new FscComRefundAbnormalOrderListQueryAbilityRspBO();
        if (FscRefundReasonEnum.RETURN_OR_EXCHANGE_PROBLEM.getCode().equals(reqBO.getRefundReason())) {
            this.valid(reqBO);
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (null == fscOrderPO) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
            }
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderRelationPO.setContractId(reqBO.getContractId());
            List fscOrderRelationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRows(new ArrayList(0));
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRecordsTotal(Integer.valueOf(0));
                rspBO.setTotal(Integer.valueOf(0));
                return rspBO;
            }
            List acceptOrderIdList = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
            List orderIdList = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
            UocAbnormalSingleDetailsListQueryReqBO uocAbnormalSingleDetailsListQueryReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
            uocAbnormalSingleDetailsListQueryReqBO.setTabId(ABNORMAL_ALL_TAB_ID);
            uocAbnormalSingleDetailsListQueryReqBO.setAbnormalVoucherIds(reqBO.getAbnormalVoucherIds());
            uocAbnormalSingleDetailsListQueryReqBO.setNotAbnormalVoucherIds(reqBO.getNotAbnormalVoucherIds());
            if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(fscOrderPO.getOrderSource())) {
                uocAbnormalSingleDetailsListQueryReqBO.setAbnormalState(ABNORMAL_STATE_TWO);
            } else {
                uocAbnormalSingleDetailsListQueryReqBO.setAbnormalState(ABNORMAL_STATE_THREE);
            }
            if (FscConstants.SettleType.ORDER.equals(fscOrderPO.getSettleType())) {
                uocAbnormalSingleDetailsListQueryReqBO.setOrderIds(orderIdList);
            } else {
                uocAbnormalSingleDetailsListQueryReqBO.setInspectionVoucherIds(acceptOrderIdList);
            }
            uocAbnormalSingleDetailsListQueryReqBO.setSaleVoucherNo(reqBO.getOrderNo());
            uocAbnormalSingleDetailsListQueryReqBO.setPageNo(reqBO.getPageNo().intValue());
            uocAbnormalSingleDetailsListQueryReqBO.setPageSize(reqBO.getPageSize().intValue());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                uocAbnormalSingleDetailsListQueryReqBO.setRefundDownFlag(FscConstants.FscRefundFlag.NO);
            } else {
                uocAbnormalSingleDetailsListQueryReqBO.setRefundUpFlag(FscConstants.FscRefundFlag.NO);
            }
            if (!StringUtils.isEmpty((Object)reqBO.getSaleVoucherNo())) {
                uocAbnormalSingleDetailsListQueryReqBO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getAbnormalVoucherNo())) {
                uocAbnormalSingleDetailsListQueryReqBO.setAbnormalVoucherNo(reqBO.getAbnormalVoucherNo());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getSupplierName())) {
                uocAbnormalSingleDetailsListQueryReqBO.setSupName(reqBO.getSupplierName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getAcceptOrderNo())) {
                uocAbnormalSingleDetailsListQueryReqBO.setInspectionVoucherCode(reqBO.getAcceptOrderNo());
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getInvoiceList())) {
                FscInvoiceItemPO searchInvoiceItemPO = new FscInvoiceItemPO();
                searchInvoiceItemPO.setInvoiceIds(reqBO.getInvoiceList());
                searchInvoiceItemPO.setOrderBy("ID");
                List invoiceItemPOS = this.fscInvoiceItemMapper.getList(searchInvoiceItemPO);
                ArrayList orderItemIds = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)invoiceItemPOS)) {
                    Set orderItemIdSet = invoiceItemPOS.stream().filter(e -> e.getOrderItemId() != null).map(FscInvoiceItemPO::getOrderItemId).collect(Collectors.toSet());
                    orderItemIds.addAll(orderItemIdSet);
                }
                if (!CollectionUtils.isEmpty(orderItemIds)) {
                    if (FscConstants.SettleType.ORDER.equals(fscOrderPO.getSettleType())) {
                        uocAbnormalSingleDetailsListQueryReqBO.setOrderItemIds(orderItemIds);
                    } else {
                        uocAbnormalSingleDetailsListQueryReqBO.setInspectionItemIds(orderItemIds);
                    }
                }
                Date createTime = fscOrderPO.getCreateTime();
                if (fscOrderPO.getRefundId() != null) {
                    FscOrderPO beforeFscOrder;
                    Object refundId = fscOrderPO.getRefundId();
                    Date beforeCreateTime = null;
                    int i = 0;
                    while ((beforeFscOrder = this.getBeforeFscOrder((Long)refundId)) != null) {
                        beforeCreateTime = beforeFscOrder.getCreateTime();
                        refundId = beforeFscOrder.getRefundId();
                        if (refundId != null && ++i < 10) continue;
                    }
                    if (beforeCreateTime != null) {
                        createTime = beforeCreateTime;
                    }
                }
                uocAbnormalSingleDetailsListQueryReqBO.setCreateTimeAfter(createTime);
                uocAbnormalSingleDetailsListQueryReqBO.setIsNegativeFlag(Integer.valueOf(1));
            }
            if (reqBO.getRefundId() != null) {
                FscOrderRelationPO qryFscOrderRelationPO = new FscOrderRelationPO();
                qryFscOrderRelationPO.setRefundId(reqBO.getRefundId());
                List qryFscOrderRelationPOList = this.fscOrderRelationMapper.getListNoPage(qryFscOrderRelationPO);
                if (!CollectionUtils.isEmpty((Collection)qryFscOrderRelationPOList)) {
                    List abnormalVoucherIds = qryFscOrderRelationPOList.stream().filter(e -> e.getAbnormalVoucherId() != null).map(FscOrderRelationPO::getAbnormalVoucherId).collect(Collectors.toList());
                    uocAbnormalSingleDetailsListQueryReqBO.setRefundAbnormalVoucherIds(abnormalVoucherIds);
                }
            }
            log.debug("\u5f02\u5e38\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocAbnormalSingleDetailsListQueryReqBO));
            UocAbnormalSingleDetailsListQueryRspBO uocAbnormalSingleDetailsListQueryRspBO = this.uocAbnormalSingleDetailsListQueryAbilityService.getAbnormalSingleDetailsListQuery(uocAbnormalSingleDetailsListQueryReqBO);
            if (!CollectionUtils.isEmpty((Collection)uocAbnormalSingleDetailsListQueryRspBO.getRows())) {
                for (Object row : uocAbnormalSingleDetailsListQueryRspBO.getRows()) {
                    Long purchaseChangeFee = 0L;
                    for (UocCoreOrdShipAbnormalItemBO itemBO : row.getAbnormalItemList()) {
                        purchaseChangeFee = purchaseChangeFee + itemBO.getPurchaseChangeFee();
                    }
                    try {
                        row.setPurchaseChangeFeeMoney(MoneyUtil.l2B((Long)purchaseChangeFee) + "");
                    }
                    catch (Exception e2) {
                        log.error("\u8f6c\u5316\u6570\u636e\u5f02\u5e38\uff1a{}", (Throwable)e2);
                    }
                }
            }
            log.debug("\u5f02\u5e38\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocAbnormalSingleDetailsListQueryRspBO));
            List fscAbnormalOrderBOList = JSONArray.parseArray((String)JSON.toJSONString((Object)uocAbnormalSingleDetailsListQueryRspBO.getRows()), FscAbnormalOrderBO.class);
            if (!CollectionUtils.isEmpty((Collection)fscAbnormalOrderBOList)) {
                for (FscAbnormalOrderBO fscAbnormalOrderBO : fscAbnormalOrderBOList) {
                    if (!StringUtils.isEmpty((Object)fscAbnormalOrderBO.getSupNo())) {
                        fscAbnormalOrderBO.setSupplierId(Long.valueOf(fscAbnormalOrderBO.getSupNo()));
                    }
                    fscAbnormalOrderBO.setSupplierName(fscAbnormalOrderBO.getSupName());
                    if (!StringUtils.isEmpty((Object)fscAbnormalOrderBO.getInspectionVoucherId())) {
                        fscAbnormalOrderBO.setAcceptOrderId(Long.valueOf(fscAbnormalOrderBO.getInspectionVoucherId()));
                    }
                    fscAbnormalOrderBO.setAcceptOrderNo(fscAbnormalOrderBO.getInspectionVoucherCode());
                }
            }
            if (reqBO.getRefundId() != null) {
                FscOrderRelationPO qryFscOrderRelationPO = new FscOrderRelationPO();
                qryFscOrderRelationPO.setRefundId(reqBO.getRefundId());
                List qryFscOrderRelationPOList = this.fscOrderRelationMapper.getListNoPage(qryFscOrderRelationPO);
                if (!CollectionUtils.isEmpty((Collection)qryFscOrderRelationPOList)) {
                    Map<Long, List<FscOrderRelationPO>> abnormalVoucherIdMap = qryFscOrderRelationPOList.stream().filter(e -> e.getAbnormalVoucherId() != null).collect(Collectors.groupingBy(FscOrderRelationPO::getAbnormalVoucherId));
                    if (!CollectionUtils.isEmpty((Collection)fscAbnormalOrderBOList) && !CollectionUtils.isEmpty(abnormalVoucherIdMap)) {
                        for (FscAbnormalOrderBO fscAbnormalOrderBO : fscAbnormalOrderBOList) {
                            if (!abnormalVoucherIdMap.containsKey(fscAbnormalOrderBO.getAbnormalVoucherId())) continue;
                            fscAbnormalOrderBO.setFscRefundAmt(abnormalVoucherIdMap.get(fscAbnormalOrderBO.getAbnormalVoucherId()).get(0).getSettleAmt());
                        }
                    }
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(fscAbnormalOrderBOList);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(uocAbnormalSingleDetailsListQueryRspBO.getRecordsTotal()));
            rspBO.setTotal(Integer.valueOf(uocAbnormalSingleDetailsListQueryRspBO.getTotal()));
            return rspBO;
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderRelationPO.setOrderNo(reqBO.getOrderNo());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getRefundAbnormalListPage(fscOrderRelationPO, page);
        ArrayList<FscAbnormalOrderBO> fscAbnormalOrderBOList = new ArrayList<FscAbnormalOrderBO>();
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
            for (FscOrderRelationPO po : fscOrderRelationPOList) {
                FscAbnormalOrderBO abnormalOrderBO = (FscAbnormalOrderBO)JSON.parseObject((String)JSON.toJSONString((Object)po), FscAbnormalOrderBO.class);
                abnormalOrderBO.setOutOrderNo(po.getExtOrderNo());
                abnormalOrderBO.setSaleVoucherNo(po.getOrderNo());
                abnormalOrderBO.setOrderId(po.getOrderId().toString());
                abnormalOrderBO.setChangeFeeMoney(po.getAmount());
                abnormalOrderBO.setPurchaseChangeFeeMoney(po.getAmount());
                fscAbnormalOrderBOList.add(abnormalOrderBO);
            }
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setRows(fscAbnormalOrderBOList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void valid(FscComRefundAbnormalOrderListQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355\u636eId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRefundReason())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u7968\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private FscOrderPO getBeforeFscOrder(Long refundId) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(refundId);
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO != null && refundPO.getFscOrderId() != null) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(refundPO.getFscOrderId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            return fscOrderPO;
        }
        return null;
    }
}

