/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscComRefundOrderListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundOrderListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscRefundOrderInfoBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComRefundOrderListQueryAbilityService"})
public class FscComRefundOrderListQueryAbilityServiceImpl
implements FscComRefundOrderListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComRefundOrderListQueryAbilityServiceImpl.class);
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;

    @PostMapping(value={"qryRefundOrderList"})
    public FscComRefundOrderListQueryAbilityRspBO qryRefundOrderList(@RequestBody FscComRefundOrderListQueryAbilityReqBO reqBO) {
        FscComRefundOrderListQueryAbilityRspBO rspBO = new FscComRefundOrderListQueryAbilityRspBO();
        this.validParam(reqBO);
        UocSalesSingleDetailsListQueryReqBO uocSalesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        uocSalesSingleDetailsListQueryReqBO.setPageNo(reqBO.getPageNo().intValue());
        uocSalesSingleDetailsListQueryReqBO.setPageSize(reqBO.getPageSize().intValue());
        uocSalesSingleDetailsListQueryReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        this.setUocSalesSingleDetailsListQueryReqBO(reqBO, uocSalesSingleDetailsListQueryReqBO);
        log.info("\u9000\u7968\u7533\u8bf7\u8ba2\u5355\u5217\u8868\u67e5\u8be2|\u9500\u552e\u5355\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)uocSalesSingleDetailsListQueryReqBO));
        UocSalesSingleDetailsListQueryRspBO uocSalesSingleDetailsListQueryRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(uocSalesSingleDetailsListQueryReqBO);
        log.info("\u9000\u7968\u7533\u8bf7\u8ba2\u5355\u5217\u8868\u67e5\u8be2|\u9500\u552e\u5355\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)uocSalesSingleDetailsListQueryRspBO));
        if (ObjectUtil.isEmpty((Object)uocSalesSingleDetailsListQueryRspBO) || CollectionUtils.isEmpty((Collection)uocSalesSingleDetailsListQueryRspBO.getRows())) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setRows(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        this.setRspInfo(uocSalesSingleDetailsListQueryRspBO, rspBO, reqBO);
        this.setFscRefundOrderRefundAmt(rspBO, reqBO);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(Integer.valueOf(uocSalesSingleDetailsListQueryRspBO.getTotal()));
        rspBO.setRecordsTotal(Integer.valueOf(uocSalesSingleDetailsListQueryRspBO.getRecordsTotal()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validParam(FscComRefundOrderListQueryAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private FscOrderPO getFscOrderInfo(Long fscOrderId) {
        FscOrderPO qryFscOrder = new FscOrderPO();
        qryFscOrder.setFscOrderId(fscOrderId);
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(qryFscOrder);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        return fscOrderPO;
    }

    private List<FscInvoiceItemPO> getFscInvoiceItemList(List<Long> invoiceList, Long contractId) {
        if (CollectionUtils.isEmpty(invoiceList)) {
            return new ArrayList<FscInvoiceItemPO>();
        }
        FscInvoiceItemPO qryFscInvoiceItem = new FscInvoiceItemPO();
        qryFscInvoiceItem.setInvoiceIds(invoiceList);
        qryFscInvoiceItem.setContractId(contractId);
        return this.fscInvoiceItemMapper.getListWithNo(qryFscInvoiceItem);
    }

    private List<FscOrderRelationPO> getFscOrderRelationList(Long fscOrderId, Long contractId) {
        FscOrderRelationPO qryFscOrderRelation = new FscOrderRelationPO();
        qryFscOrderRelation.setFscOrderId(fscOrderId);
        qryFscOrderRelation.setContractId(contractId);
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getListNoPage(qryFscOrderRelation);
        if (ObjectUtil.isEmpty((Object)fscOrderRelationPOList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
        }
        return fscOrderRelationPOList;
    }

    private List<FscOrderRelationPO> getFscOrderRelationListByRefund(Long refundId) {
        FscOrderRelationPO qryFscOrderRelation = new FscOrderRelationPO();
        qryFscOrderRelation.setRefundId(refundId);
        return this.fscOrderRelationMapper.getListNoPage(qryFscOrderRelation);
    }

    private void setUocSalesSingleDetailsListQueryReqBO(FscComRefundOrderListQueryAbilityReqBO reqBO, UocSalesSingleDetailsListQueryReqBO uocSalesSingleDetailsListQueryReqBO) {
        FscOrderPO fscOrderInfo = this.getFscOrderInfo(reqBO.getFscOrderId());
        List<FscInvoiceItemPO> fscInvoiceItemList = this.getFscInvoiceItemList(reqBO.getInvoiceList(), reqBO.getContractId());
        if (CollectionUtils.isEmpty(fscInvoiceItemList)) {
            List<FscOrderRelationPO> fscOrderRelationList = this.getFscOrderRelationList(reqBO.getFscOrderId(), reqBO.getContractId());
            List orderIdList = fscOrderRelationList.stream().map(FscOrderRelationPO::getOrderId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            uocSalesSingleDetailsListQueryReqBO.setOrderIdList(orderIdList);
        }
        if (!CollectionUtils.isEmpty(fscInvoiceItemList)) {
            List orderIdList = fscInvoiceItemList.stream().map(FscInvoiceItemPO::getOrderId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            uocSalesSingleDetailsListQueryReqBO.setOrderIdList(orderIdList);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderInfo.getReceiveType())) {
            uocSalesSingleDetailsListQueryReqBO.setRefundDownFlag(FscConstants.FscRefundFlag.NO);
        }
        if (!FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderInfo.getReceiveType())) {
            uocSalesSingleDetailsListQueryReqBO.setRefundUpFlag(FscConstants.FscRefundFlag.NO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNotOrderIds())) {
            uocSalesSingleDetailsListQueryReqBO.setOrderIdList(reqBO.getNotOrderIds());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSaleVoucherNo())) {
            uocSalesSingleDetailsListQueryReqBO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSupplierName())) {
            uocSalesSingleDetailsListQueryReqBO.setSupplierName(reqBO.getSupplierName());
        }
    }

    private void setRspInfo(UocSalesSingleDetailsListQueryRspBO uocSalesSingleDetailsListQueryRspBO, FscComRefundOrderListQueryAbilityRspBO rspBO, FscComRefundOrderListQueryAbilityReqBO reqBO) {
        ArrayList<FscRefundOrderInfoBO> fscRefundOrderInfoBOList = new ArrayList<FscRefundOrderInfoBO>(1);
        for (UocPebUpperOrderAbilityBO row : uocSalesSingleDetailsListQueryRspBO.getRows()) {
            UocPebChildOrderAbilityBO uocPebChildOrderAbilityBO = (UocPebChildOrderAbilityBO)row.getChildOrderList().get(0);
            if (ObjectUtil.isEmpty((Object)uocPebChildOrderAbilityBO)) continue;
            FscRefundOrderInfoBO fscRefundOrderInfoBO = (FscRefundOrderInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)uocPebChildOrderAbilityBO), FscRefundOrderInfoBO.class);
            fscRefundOrderInfoBO.setSupNo(row.getSupNo());
            fscRefundOrderInfoBO.setSupName(row.getSupName());
            fscRefundOrderInfoBO.setSupplierId(Long.valueOf(uocPebChildOrderAbilityBO.getSupplier()));
            fscRefundOrderInfoBO.setFscRefundAmt(new BigDecimal("0"));
            fscRefundOrderInfoBOList.add(fscRefundOrderInfoBO);
        }
        rspBO.setRows(fscRefundOrderInfoBOList);
    }

    private void setFscRefundOrderRefundAmt(FscComRefundOrderListQueryAbilityRspBO rspBO, FscComRefundOrderListQueryAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getRefundId())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return;
        }
        List<FscOrderRelationPO> fscOrderRelationPOList = this.getFscOrderRelationListByRefund(reqBO.getRefundId());
        if (!CollectionUtils.isEmpty(fscOrderRelationPOList)) {
            Map<Long, List<FscOrderRelationPO>> abnormalVoucherIdVsPoMap = fscOrderRelationPOList.stream().filter(po -> ObjectUtil.isNotEmpty((Object)po.getAbnormalVoucherId())).collect(Collectors.groupingBy(FscOrderRelationPO::getAbnormalVoucherId));
            for (FscRefundOrderInfoBO row : rspBO.getRows()) {
                if (CollectionUtils.isEmpty(abnormalVoucherIdVsPoMap) || !abnormalVoucherIdVsPoMap.containsKey(Long.valueOf(row.getOrderId()))) continue;
                row.setFscRefundAmt(abnormalVoucherIdVsPoMap.get(Long.valueOf(row.getOrderId())).get(0).getSettleAmt());
            }
        }
    }
}

