/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscCreditDeductBatchAbilityService;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductBatchAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductBatchAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscCreditDeductBatchBusiService;
import com.tydic.fsc.common.busi.bo.FscCreditDeductBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscCreditDeductBatchBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPayLogPO;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCreditDeductBatchAbilityService"})
public class FscCreditDeductBatchAbilityServiceImpl
implements FscCreditDeductBatchAbilityService {
    @Autowired
    private FscCreditDeductBatchBusiService fscCreditDeductBatchBusiService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;

    @PostMapping(value={"dealAccountDeductBatch"})
    public FscCreditDeductBatchAbilityRspBO dealAccountDeductBatch(@RequestBody FscCreditDeductBatchAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscCreditDeductBatchBusiReqBO busiReqBO = (FscCreditDeductBatchBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscCreditDeductBatchBusiReqBO.class));
        FscCreditDeductBatchBusiRspBO busiRspBO = this.fscCreditDeductBatchBusiService.dealAccountDeductBatch(busiReqBO);
        return (FscCreditDeductBatchAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscCreditDeductBatchAbilityRspBO.class);
    }

    private void valid(FscCreditDeductBatchAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getDeductList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscCreditDeductAbilityReqBO reqBO : abilityReqBO.getDeductList()) {
            if (null == reqBO.getOrderNo()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[orderNo]\u4e3a\u7a7a");
            }
            if (null == reqBO.getCreditOrgId() && null == reqBO.getCreditOrgCode()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[creditOrgId]\u548c[creditOrgCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (null == reqBO.getSupId()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[supId]\u4e3a\u7a7a");
            }
            if (reqBO.getObjId() != null) continue;
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            fscPayLogPO.setBusiOrderNo((String)reqBO.getOrderNo().get(0));
            fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
            fscPayLogPO.setObjId(reqBO.getObjId());
            int count = this.fscPayLogMapper.getCheckBy(fscPayLogPO);
            if (count <= 0) continue;
            FscCreditDeductAbilityRspBO rspBO = new FscCreditDeductAbilityRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u5355\u5df2\u8fdb\u884c\u8fc7\u9000\u6b3e,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c!");
        }
    }
}

