/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscFinanceInvoiceRefundApprovalAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscFinanceInvoiceRefundApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscFinanceInvoiceRefundApprovalAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushRefundInvoiceAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscFinanceInvoiceRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiRspBO;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscFinanceInvoiceRefundApprovalAbilityService"})
public class FscFinanceInvoiceRefundApprovalAbilityServiceImpl
implements FscFinanceInvoiceRefundApprovalAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscFinanceInvoiceRefundApprovalBusiService fscFinanceInvoiceRefundApprovalBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Resource(name="fscPushFinanceInvoiceListMqServiceProvider")
    private ProxyMessageProducer fscPushFinanceInvoiceListMqServiceProvider;
    @Value(value="${es.FSC_PUSH_FINANCE_INVOICE_TOPIC:FSC_PUSH_FINANCE_INVOICE_TOPIC}")
    private String fscPushFinanceInvoiceTopic;
    @Value(value="${es.FSC_PUSH_FINANCE_INVOICE_TAG:FSC_PUSH_FINANCE_INVOICE_TAG}")
    private String fscPushFinanceInvoiceTag;

    @PostMapping(value={"dealFinanceInvoiceRefundApproval"})
    public FscFinanceInvoiceRefundApprovalAbilityRspBO dealFinanceInvoiceRefundApproval(@RequestBody FscFinanceInvoiceRefundApprovalAbilityReqBO reqBO) {
        FscFinanceInvoiceRefundApprovalAbilityRspBO rspBO = new FscFinanceInvoiceRefundApprovalAbilityRspBO();
        for (Long thisRefundId : reqBO.getRefundIds()) {
            this.approvalAuthVerify(thisRefundId, reqBO);
            FscFinanceInvoiceRefundApprovalBusiReqBO fscFinanceInvoiceRefundApprovalBusiReqBO = (FscFinanceInvoiceRefundApprovalBusiReqBO)((Object)JUtil.js((Object)reqBO, FscFinanceInvoiceRefundApprovalBusiReqBO.class));
            fscFinanceInvoiceRefundApprovalBusiReqBO.setRefundId(thisRefundId);
            FscFinanceInvoiceRefundApprovalBusiRspBO fscFinanceInvoiceRefundApprovalBusiRspBO = this.fscFinanceInvoiceRefundApprovalBusiService.dealFinanceInvoiceRefundApproval(fscFinanceInvoiceRefundApprovalBusiReqBO);
            if (!"0000".equals(fscFinanceInvoiceRefundApprovalBusiRspBO.getRespCode())) {
                return (FscFinanceInvoiceRefundApprovalAbilityRspBO)JUtil.js((Object)((Object)fscFinanceInvoiceRefundApprovalBusiRspBO), FscFinanceInvoiceRefundApprovalAbilityRspBO.class);
            }
            this.syncEs(thisRefundId);
            if (CollectionUtils.isEmpty(fscFinanceInvoiceRefundApprovalBusiRspBO.getRefundIds())) continue;
            for (Long refundId : fscFinanceInvoiceRefundApprovalBusiRspBO.getRefundIds()) {
                FscFinancePushRefundInvoiceAbilityReqBO abilityReqBO = new FscFinancePushRefundInvoiceAbilityReqBO();
                abilityReqBO.setRefundId(refundId);
                this.fscPushFinanceInvoiceListMqServiceProvider.send(new ProxyMessage(this.fscPushFinanceInvoiceTopic, this.fscPushFinanceInvoiceTag, JSON.toJSONString((Object)abilityReqBO)));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEs(Long thisRefundId) {
        ArrayList<Long> refundIds = new ArrayList<Long>(1);
        refundIds.add(thisRefundId);
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void approvalAuthVerify(Long thisRefundId, FscFinanceInvoiceRefundApprovalAbilityReqBO reqBO) {
        Integer orderAuditCount = this.fscOrderRefundMapper.getOrderAuditCount(thisRefundId, reqBO.getStationsList());
        if (orderAuditCount == 0) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u65e0\u5ba1\u6279\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
    }
}

