/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushInvoiceToErpReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushInvoiceToErpRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushInvoiceToErpService;
import com.tydic.fsc.common.ability.api.FscOrderInvoicePushToErpAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderInvoicePushToErpAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInvoicePushToErpAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.uoc.common.ability.api.UocOrdRhItemQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemBO;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemQueryRspBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscOrderInvoicePushToErpAbilityServiceImpl
implements FscOrderInvoicePushToErpAbilityService {
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private UocOrdRhItemQueryAbilityService uocOrdRhItemQueryAbilityService;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscPushInvoiceToErpService fscPushInvoiceToErpService;

    public FscOrderInvoicePushToErpAbilityRspBO pushInvoiceToErp(FscOrderInvoicePushToErpAbilityReqBO reqBO) {
        FscOrderInvoicePushToErpAbilityRspBO rspBO = new FscOrderInvoicePushToErpAbilityRspBO();
        StringBuilder respDesc = new StringBuilder();
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
            fscInvoiceItemPO.setFscOrderId(fscOrderId);
            List fscInvoiceItemPOList = this.fscInvoiceItemMapper.getListWithNo(fscInvoiceItemPO);
            if (CollectionUtils.isEmpty((Collection)fscInvoiceItemPOList)) {
                this.writeFailLog(fscOrderId, null, "\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a", FscConstants.FscOrderFailRetansBusiType.FSC_QEURY_ERP_INVOICE_FAIL);
                respDesc.append("\u7ed3\u7b97\u5355").append(fscOrderId).append("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
                continue;
            }
            List ordItemIdList = fscInvoiceItemPOList.stream().map(FscInvoiceItemPO::getOrderItemId).collect(Collectors.toList());
            UocOrdRhItemQueryReqBO queryReqBO = new UocOrdRhItemQueryReqBO();
            queryReqBO.setItemIdList(ordItemIdList);
            UocOrdRhItemQueryRspBO queryRspBO = this.uocOrdRhItemQueryAbilityService.getOrdRhItem(queryReqBO);
            if (!"0000".equals(queryRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)queryRspBO.getItemList())) {
                this.writeFailLog(fscOrderId, null, "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u4e8b\u52a1\u4fe1\u606f\u4e3a\u7a7a", FscConstants.FscOrderFailRetansBusiType.FSC_QEURY_ERP_INVOICE_FAIL);
                respDesc.append("\u7ed3\u7b97\u5355").append(fscOrderId).append("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u4e8b\u52a1\u4fe1\u606f\u4e3a\u7a7a");
                continue;
            }
            HashMap transactionMap = new HashMap();
            for (UocOrdRhItemBO bo : queryRspBO.getItemList()) {
                if (transactionMap.get(bo.getTransactionId()) != null) {
                    ((Set)transactionMap.get(bo.getTransactionId())).add(bo.getOrdItemId());
                    continue;
                }
                HashSet<Long> ordItemIdSet = new HashSet<Long>();
                ordItemIdSet.add(bo.getOrdItemId());
                transactionMap.put(bo.getTransactionId(), ordItemIdSet);
            }
            HashMap<Long, StringBuilder> invoiceMap = new HashMap<Long, StringBuilder>();
            for (FscInvoiceItemPO po : fscInvoiceItemPOList) {
                if (invoiceMap.get(po.getOrderItemId()) != null) {
                    ((StringBuilder)invoiceMap.get(po.getOrderItemId())).append(",").append(po.getInvoiceNo());
                    continue;
                }
                invoiceMap.put(po.getOrderItemId(), new StringBuilder(po.getInvoiceNo()));
            }
            for (Long key : transactionMap.keySet()) {
                Set ordItemIdSet = (Set)transactionMap.get(key);
                for (Long ordItemId : ordItemIdSet) {
                    FscPushInvoiceToErpReqBO fscPushInvoiceToErpReqBO = new FscPushInvoiceToErpReqBO();
                    fscPushInvoiceToErpReqBO.setP_TRANSACTION_ID(key.toString());
                    fscPushInvoiceToErpReqBO.setP_INVOICE_STR(((StringBuilder)invoiceMap.get(ordItemId)).toString());
                    FscPushInvoiceToErpRspBO fscPushInvoiceToErpRspBO = this.fscPushInvoiceToErpService.pushInvoiceToErp(fscPushInvoiceToErpReqBO);
                    if ("0000".equals(fscPushInvoiceToErpRspBO.getRespCode())) continue;
                    this.writeFailLog(ordItemId, JSONObject.toJSONString((Object)fscPushInvoiceToErpReqBO), fscPushInvoiceToErpRspBO.getMessage(), FscConstants.FscOrderFailRetansBusiType.FSC_PUSH_ERP_INVOICE_FAIL);
                    respDesc.append("\u8ba2\u5355\u660e\u7ec6").append(ordItemId).append(fscPushInvoiceToErpRspBO.getMessage());
                }
            }
        }
        if (StringUtils.isEmpty((Object)respDesc.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("193146");
            rspBO.setRespDesc(respDesc.toString());
        }
        return rspBO;
    }

    private void writeFailLog(Long fscOrderId, String data, String failDesc, Integer busiType) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailReq(data);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(failDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(busiType);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

