/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscOrderPageListQueryByOrderAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderListQueryByOrderAbilityBO;
import com.tydic.fsc.common.ability.bo.FscOrderPageListQueryByOrderAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderPageListQueryByOrderAbilityRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderPageListQueryByOrderAbilityService"})
public class FscOrderPageListQueryByOrderAbilityServiceImpl
implements FscOrderPageListQueryByOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderPageListQueryByOrderAbilityServiceImpl.class);
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;

    @PostMapping(value={"qryOrderPageListByOrderId"})
    public FscOrderPageListQueryByOrderAbilityRspBO qryOrderPageListByOrderId(@RequestBody FscOrderPageListQueryByOrderAbilityReqBO reqBO) {
        FscOrderPageListQueryByOrderAbilityRspBO rspBO = new FscOrderPageListQueryByOrderAbilityRspBO();
        if (Objects.isNull(reqBO.getOrderId()) && Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u8ba2\u5355\u7f16\u7801\u6216\u5408\u540cID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (reqBO.isFinance()) {
            return this.qryFinanceInfo(reqBO);
        }
        boolean operationFlag = !StringUtils.isEmpty((Object)reqBO.getIsprofess()) && "0".equals(reqBO.getIsprofess());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderItemPO.class);
        if (operationFlag) {
            fscOrderItemPO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        } else {
            if (Objects.nonNull(reqBO.getOrgId())) {
                UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(reqBO.getOrgId());
                UmcEnterpriseOrgQryDetailAbilityRspBO orgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
                if (!("0000".equals(orgQryDetailAbilityRspBO.getRespCode()) && Objects.nonNull(orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO()) && Objects.nonNull(orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn()) && (FscConstants.YES.equals(orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn()) || FscConstants.SettlePlatform.YES_Y.equals(orgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn())))) {
                    fscOrderItemPO.setOrderState(FscBillStatus.SIGNED_SUCCEED.getCode());
                }
            }
            fscOrderItemPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        }
        List allList = this.fscOrderItemMapper.getFscByOrderId(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)allList)) {
            rspBO.setRows(null);
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List fscOrderIdList = allList.stream().map(FscOrderPO::getFscOrderId).distinct().collect(Collectors.toList());
        fscOrderItemPO.setFscOrderIdList(fscOrderIdList);
        fscOrderItemPO.setToPayAmountStart(BigDecimal.ZERO);
        List fscOrderPOList = this.fscOrderItemMapper.queryListPageByOrderId(fscOrderItemPO, page);
        ArrayList orderAbilityBOList = new ArrayList();
        fscOrderPOList.forEach(e -> {
            if (e.getToPayAmount().add(e.getPaidAmount()).add(e.getPayingAmount()).add(e.getRefundAmount()).compareTo(e.getTotalCharge()) != 0) {
                e.setToPayAmount(e.getTotalCharge().subtract(e.getPayingAmount()).subtract(e.getPaidAmount()).subtract(e.getRefundAmount()));
                this.fscOrderMapper.updateById(e);
            }
            FscOrderListQueryByOrderAbilityBO fscOrderListQueryByOrderAbilityBO = (FscOrderListQueryByOrderAbilityBO)JSON.parseObject((String)JSON.toJSONString((Object)e), FscOrderListQueryByOrderAbilityBO.class);
            fscOrderListQueryByOrderAbilityBO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            orderAbilityBOList.add(fscOrderListQueryByOrderAbilityBO);
        });
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(orderAbilityBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscOrderPageListQueryByOrderAbilityRspBO qryFinanceInfo(FscOrderPageListQueryByOrderAbilityReqBO reqBO) {
        FscOrderPageListQueryByOrderAbilityRspBO rspBO = new FscOrderPageListQueryByOrderAbilityRspBO();
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setOrderId(reqBO.getOrderId());
        fscOrderRelationPO.setContractId(reqBO.getContractId());
        fscOrderRelationPO.setOrderFlow(reqBO.getOrderFlow());
        List orderRelationPOS = this.fscOrderRelationMapper.getOrderSettleInfo(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)orderRelationPOS)) {
            rspBO.setRows(null);
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List<Long> fscOrderIds = orderRelationPOS.stream().map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList());
        Map<Long, FscOrderRelationPO> roderRelationMap = orderRelationPOS.stream().collect(Collectors.toMap(FscOrderRelationPO::getFscOrderId, po -> po));
        List<FscContractRelationPO> relationList = this.getFinancePayInfoList(reqBO, fscOrderIds);
        if (CollectionUtils.isEmpty(relationList)) {
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List rows = JSONObject.parseArray((String)JSONObject.toJSONString(relationList), FscOrderListQueryByOrderAbilityBO.class);
        rows.stream().forEach(row -> {
            FscContractRelationPO fscContractRelationPO = relationList.stream().filter(relation -> Objects.equals(relation.getFscOrderId(), row.getFscOrderId())).findFirst().orElse(new FscContractRelationPO());
            row.setOrderNo(fscContractRelationPO.getFscOrderNo());
            if (Objects.nonNull(roderRelationMap.get(row.getFscOrderId()))) {
                row.setCashItemCode(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getCashItemCode());
                row.setCashItemName(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getCashItemName());
                row.setCashDetailCode(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getCashDetailCode());
                row.setCashDetailName(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getCashDetailName());
                row.setBusinessItemCode(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getBusinessItemCode());
                row.setBusinessItemName(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getCashDetailName());
                row.setBizTypeCode(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getBizTypeCode());
                row.setBizTypeName(((FscOrderRelationPO)roderRelationMap.get(row.getFscOrderId())).getBizTypeName());
            }
        });
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setRecordsTotal(Integer.valueOf(rows.size()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<FscContractRelationPO> getFinancePayInfoList(FscOrderPageListQueryByOrderAbilityReqBO reqBO, List<Long> fscOrderIds) {
        FscOrderRelationPO qryFscOrderRelation = (FscOrderRelationPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderRelationPO.class);
        List financePayInfoList = this.fscOrderRelationMapper.getFinancePayInfoList(qryFscOrderRelation);
        if (CollectionUtils.isEmpty((Collection)financePayInfoList)) {
            return null;
        }
        FscShouldPayPO qryInPayFscShouldPay = new FscShouldPayPO();
        qryInPayFscShouldPay.setPayStatusNot(Integer.valueOf(1008));
        qryInPayFscShouldPay.setOrderId(reqBO.getOrderId());
        qryInPayFscShouldPay.setContractId(reqBO.getContractId());
        List inPayFscShouldPay = this.fscShouldPayMapper.getFinancePayAmountList(qryInPayFscShouldPay);
        FscShouldPayPO qryHavePayFscShouldPay = new FscShouldPayPO();
        qryInPayFscShouldPay.setPayStatusNot(null);
        qryHavePayFscShouldPay.setPayStatusList((List)CollectionUtil.newArrayList((Object[])new Integer[]{1008}));
        qryHavePayFscShouldPay.setOrderId(reqBO.getOrderId());
        qryHavePayFscShouldPay.setContractId(reqBO.getContractId());
        List havePayFscShouldPay = this.fscShouldPayMapper.getFinancePayAmountList(qryHavePayFscShouldPay);
        Map<Object, Object> inPayFscShouldPayMap = new HashMap(1);
        if (!CollectionUtils.isEmpty((Collection)inPayFscShouldPay)) {
            inPayFscShouldPayMap = inPayFscShouldPay.stream().collect(Collectors.toMap(FscShouldPayPO::getFscBillOrderId, po -> po, (k1, k2) -> k2));
        }
        Map<Object, Object> havePayFscShouldPayMap = new HashMap(1);
        if (!CollectionUtils.isEmpty((Collection)havePayFscShouldPay)) {
            havePayFscShouldPayMap = havePayFscShouldPay.stream().collect(Collectors.toMap(FscShouldPayPO::getFscBillOrderId, po -> po, (k1, k2) -> k2));
        }
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setFscOrderIdList(fscOrderIds);
        orderItemPO.setOrderId(reqBO.getOrderId());
        List refundList = this.fscOrderItemMapper.sumRefundAmtByOrder(orderItemPO);
        Map<Long, FscOrderItemPO> refundMap = refundList.stream().collect(Collectors.toMap(FscOrderItemPO::getFscOrderId, po -> po, (k1, k2) -> k2));
        List<FscContractRelationPO> fscContractRelationList = JSON.parseArray((String)JSON.toJSONString((Object)financePayInfoList), FscContractRelationPO.class);
        for (FscContractRelationPO fscContractRelationPO : fscContractRelationList) {
            BigDecimal havePayPaidAmountLocal;
            BigDecimal inPayPaidAmountLocal;
            FscShouldPayPO inPayFscShouldPayPO = (FscShouldPayPO)inPayFscShouldPayMap.get(String.valueOf(fscContractRelationPO.getFscOrderId()));
            FscShouldPayPO havePayFscShouldPayPO = (FscShouldPayPO)havePayFscShouldPayMap.get(String.valueOf(fscContractRelationPO.getFscOrderId()));
            BigDecimal refundAmt = BigDecimal.ZERO;
            BigDecimal refundAmtLocal = BigDecimal.ZERO;
            if (refundMap.containsKey(fscContractRelationPO.getFscOrderId())) {
                FscOrderItemPO refundAmtPO = refundMap.get(fscContractRelationPO.getFscOrderId());
                refundAmt = refundAmtPO.getRefundAmt();
                refundAmtLocal = refundAmtPO.getRefundAmtLocal();
            }
            BigDecimal inPayPaidAmount = ObjectUtil.isNotEmpty((Object)inPayFscShouldPayPO) ? inPayFscShouldPayPO.getPayingAmount() : new BigDecimal("0");
            BigDecimal bigDecimal = inPayPaidAmountLocal = ObjectUtil.isNotEmpty((Object)inPayFscShouldPayPO) ? inPayFscShouldPayPO.getPayingAmountLocal() : new BigDecimal("0");
            if (inPayFscShouldPayPO != null && inPayFscShouldPayPO.getReduceAmt() != null && inPayPaidAmountLocal != null) {
                BigDecimal exchangeRate = inPayPaidAmountLocal.divide(inPayPaidAmount, 4, RoundingMode.HALF_UP);
                inPayPaidAmount = inPayPaidAmount.add(inPayFscShouldPayPO.getReduceAmt());
                inPayPaidAmountLocal = inPayPaidAmountLocal.add(inPayFscShouldPayPO.getReduceAmt().multiply(exchangeRate));
            }
            BigDecimal havePayPaidAmount = ObjectUtil.isNotEmpty((Object)havePayFscShouldPayPO) ? havePayFscShouldPayPO.getPaidAmount() : new BigDecimal("0");
            BigDecimal bigDecimal2 = havePayPaidAmountLocal = ObjectUtil.isNotEmpty((Object)havePayFscShouldPayPO) ? havePayFscShouldPayPO.getPaidAmountLocal() : new BigDecimal("0");
            if (havePayFscShouldPayPO != null && havePayFscShouldPayPO.getReduceAmt() != null && havePayPaidAmountLocal != null) {
                BigDecimal exchangeRate = havePayPaidAmountLocal.divide(havePayPaidAmount, 4, RoundingMode.HALF_UP);
                havePayPaidAmount = havePayPaidAmount.add(havePayFscShouldPayPO.getReduceAmt());
                havePayPaidAmountLocal = havePayPaidAmountLocal.add(havePayFscShouldPayPO.getReduceAmt().multiply(exchangeRate));
            }
            fscContractRelationPO.setPayingAmount(inPayPaidAmount);
            fscContractRelationPO.setInPayPaidAmount(inPayPaidAmount);
            fscContractRelationPO.setPayingAmountLocal(inPayPaidAmountLocal);
            fscContractRelationPO.setInPayPaidAmountLocal(inPayPaidAmountLocal);
            fscContractRelationPO.setPaidAmount(havePayPaidAmount);
            fscContractRelationPO.setHavePayPaidAmount(havePayPaidAmount);
            fscContractRelationPO.setPaidAmountLocal(havePayPaidAmountLocal);
            fscContractRelationPO.setHavePayPaidAmountLocal(havePayPaidAmountLocal);
            fscContractRelationPO.setResidualPayAmount(fscContractRelationPO.getSettleAmt().subtract(havePayPaidAmount));
            fscContractRelationPO.setResidualPayAmountLocal(fscContractRelationPO.getSettleAmtLocal().subtract(havePayPaidAmountLocal));
            fscContractRelationPO.setToPayAmount(fscContractRelationPO.getSettleAmt().subtract(havePayPaidAmount).subtract(inPayPaidAmount).subtract(refundAmt));
            fscContractRelationPO.setToPayAmountLocal(fscContractRelationPO.getSettleAmtLocal().subtract(havePayPaidAmountLocal).subtract(inPayPaidAmountLocal).subtract(refundAmtLocal));
        }
        fscContractRelationList = this.financePayInfoResidualPayAmountFilter(reqBO, fscContractRelationList);
        return fscContractRelationList;
    }

    private List<FscContractRelationPO> financePayInfoResidualPayAmountFilter(FscOrderPageListQueryByOrderAbilityReqBO reqBO, List<FscContractRelationPO> fscContractRelationList) {
        if (CollectionUtils.isEmpty(fscContractRelationList = fscContractRelationList.stream().filter(po -> po.getToPayAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()))) {
            return null;
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getResidualPayAmountStart()) && ObjectUtil.isEmpty((Object)reqBO.getResidualPayAmountEnd())) {
            return fscContractRelationList.stream().filter(po -> po.getResidualPayAmount().compareTo(reqBO.getResidualPayAmountStart()) >= 0).collect(Collectors.toList());
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getResidualPayAmountStart()) && ObjectUtil.isNotEmpty((Object)reqBO.getResidualPayAmountEnd())) {
            return fscContractRelationList.stream().filter(po -> po.getResidualPayAmount().compareTo(reqBO.getResidualPayAmountEnd()) <= 0).collect(Collectors.toList());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getResidualPayAmountStart()) && ObjectUtil.isNotEmpty((Object)reqBO.getResidualPayAmountEnd())) {
            return fscContractRelationList.stream().filter(po -> po.getResidualPayAmount().compareTo(reqBO.getResidualPayAmountStart()) >= 0 && po.getResidualPayAmount().compareTo(reqBO.getResidualPayAmountEnd()) <= 0).collect(Collectors.toList());
        }
        return fscContractRelationList;
    }

    @PostMapping(value={"qryOrderTradeModePageListByOrderId"})
    public FscOrderPageListQueryByOrderAbilityRspBO qryOrderTradeModePageListByOrderId(@RequestBody FscOrderPageListQueryByOrderAbilityReqBO reqBO) {
        FscOrderPageListQueryByOrderAbilityRspBO rspBO = new FscOrderPageListQueryByOrderAbilityRspBO();
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderItemPO.class);
        fscOrderItemPO.setOrderState(Integer.valueOf(1003));
        fscOrderItemPO.setTradeMode("2");
        fscOrderItemPO.setOrderFlow(Integer.valueOf(0));
        fscOrderItemPO.setToPayAmountStart(BigDecimal.ZERO);
        List fscOrderPOList = this.fscOrderItemMapper.queryListPageByOrderId(fscOrderItemPO, page);
        if (CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            rspBO.setRows(null);
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList orderAbilityBOList = new ArrayList();
        fscOrderPOList.forEach(e -> {
            FscOrderListQueryByOrderAbilityBO fscOrderListQueryByOrderAbilityBO = (FscOrderListQueryByOrderAbilityBO)JSON.parseObject((String)JSON.toJSONString((Object)e), FscOrderListQueryByOrderAbilityBO.class);
            fscOrderListQueryByOrderAbilityBO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            orderAbilityBOList.add(fscOrderListQueryByOrderAbilityBO);
        });
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(orderAbilityBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @BigDecimalConvert(value=2)
    @PostMapping(value={"engineerQryOrderPageListByOrderId"})
    public FscOrderPageListQueryByOrderAbilityRspBO engineerQryOrderPageListByOrderId(@RequestBody FscOrderPageListQueryByOrderAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "contractId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean operationFlag = !StringUtils.isEmpty((Object)reqBO.getIsprofess()) && "0".equals(reqBO.getIsprofess());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderItemPO.class);
        fscOrderItemPO.setOrderNo(reqBO.getFscOrderNo());
        if (operationFlag) {
            fscOrderItemPO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        } else {
            fscOrderItemPO.setOrderState(FscBillStatus.SIGNED_SUCCEED.getCode());
            fscOrderItemPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        }
        FscOrderPageListQueryByOrderAbilityRspBO rspBO = new FscOrderPageListQueryByOrderAbilityRspBO();
        List orderPOList = this.fscOrderItemMapper.getEngineerFscOrder(fscOrderItemPO, page);
        if (CollectionUtils.isEmpty((Collection)orderPOList)) {
            rspBO.setRows(null);
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList orderAbilityBOList = new ArrayList();
        orderPOList.forEach(e -> {
            FscOrderListQueryByOrderAbilityBO fscOrderListQueryByOrderAbilityBO = (FscOrderListQueryByOrderAbilityBO)JSON.parseObject((String)JSON.toJSONString((Object)e), FscOrderListQueryByOrderAbilityBO.class);
            fscOrderListQueryByOrderAbilityBO.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            fscOrderListQueryByOrderAbilityBO.setFscOrderNo(e.getOrderNo());
            fscOrderListQueryByOrderAbilityBO.setPaidAmountLocal(e.getPaidAmount().multiply(e.getExchangeRate()));
            fscOrderListQueryByOrderAbilityBO.setToPayAmountLocal(e.getToPayAmount().multiply(e.getExchangeRate()));
            fscOrderListQueryByOrderAbilityBO.setPayingAmountLocal(e.getPayingAmount().multiply(e.getExchangeRate()));
            fscOrderListQueryByOrderAbilityBO.setResidualPayAmountLocal(e.getResidualPayAmount().multiply(e.getExchangeRate()));
            fscOrderListQueryByOrderAbilityBO.setTotalChargeLocal(e.getTotalCharge().multiply(e.getExchangeRate()));
            orderAbilityBOList.add(fscOrderListQueryByOrderAbilityBO);
        });
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(orderAbilityBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

