/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillListPrintService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillListPrintReqBO;
import com.tydic.fsc.bill.busi.api.FscBillValidOverdraftBusiService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderReceiveYcStatusAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderReceiveYcStatusAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderReceiveYcStatusAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscOrderReceiveYcStatusBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderReceiveYcStatusBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderReceiveYcStatusBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderReceiveYcStatusAbilityService"})
public class FscOrderReceiveYcStatusAbilityServiceImpl
implements FscOrderReceiveYcStatusAbilityService {
    @Autowired
    private FscOrderReceiveYcStatusBusiService FscOrderReceiveYcStatusBusiService;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillListPrintService fscBillListPrintService;
    @Autowired
    private FscBillValidOverdraftBusiService fscBillValidOverdraftBusiService;

    @PostMapping(value={"receiveYcStatus"})
    public FscOrderReceiveYcStatusAbilityRspBO receiveYcStatus(@RequestBody FscOrderReceiveYcStatusAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscBillDealPushLogAbilityReqBO logAbilityReqBO = new FscBillDealPushLogAbilityReqBO();
        logAbilityReqBO.setObjectId((Long)reqBO.getFscOrderIds().get(0));
        logAbilityReqBO.setType(FscConstants.FscPushType.FSC_ORDER_POSTING_STATUS);
        logAbilityReqBO.setCreateTime(new Date());
        logAbilityReqBO.setObjData(JSONObject.toJSONString((Object)reqBO));
        this.fscBillAddPushLogAbilityService.savePushLog(logAbilityReqBO);
        FscOrderReceiveYcStatusBusiReqBO busiReqBO = new FscOrderReceiveYcStatusBusiReqBO();
        busiReqBO.setFscOrderIds(reqBO.getFscOrderIds());
        busiReqBO.setStatus("1");
        busiReqBO.setPostingDate(reqBO.getPostingDate());
        FscOrderReceiveYcStatusBusiRspBO busiRspBO = this.FscOrderReceiveYcStatusBusiService.receiveYcStatus(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(reqBO.getFscOrderIds());
        fscOrderPO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        List fscOrderPOs = this.fscOrderMapper.getList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOs)) {
            CompletableFuture.runAsync(() -> this.dealPrint(fscOrderPOs.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList())));
        }
        FscOrderReceiveYcStatusAbilityRspBO rspBO = new FscOrderReceiveYcStatusAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscOrderReceiveYcStatusAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(FscOrderReceiveYcStatusAbilityReqBO reqBO) {
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
            syncReqBO.setFscOrderId(fscOrderId);
            this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        }
    }

    private void dealPrint(List<Long> fscOrderIds) {
        fscOrderIds.forEach(x -> {
            FscBillListPrintReqBO fscBillListPrintReqBO = new FscBillListPrintReqBO();
            fscBillListPrintReqBO.setOrderId(x);
            this.fscBillListPrintService.fscBillListPrint(fscBillListPrintReqBO);
        });
    }
}

