/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscBillClaimPayOrderBO;
import com.tydic.fsc.bo.FscPayRefundClaimDetailBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscPayRefundClaimDetailListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayRefundClaimDetailListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayRefundClaimDetailListQryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayRefundClaimDetailListQryAbilityService"})
public class FscPayRefundClaimDetailListQryAbilityServiceImpl
implements FscPayRefundClaimDetailListQryAbilityService {
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @PostMapping(value={"qryPayRefundClaimDetailList"})
    public FscPayRefundClaimDetailListQryAbilityRspBO qryPayRefundClaimDetailList(@RequestBody FscPayRefundClaimDetailListQryAbilityReqBO reqBO) {
        FscPayRefundClaimDetailListQryAbilityRspBO rspBO = new FscPayRefundClaimDetailListQryAbilityRspBO();
        FscRecvClaimPO fscRecvClaimPO = new FscRecvClaimPO();
        fscRecvClaimPO.setRefundShouldPayId(reqBO.getRefundShouldPayId());
        fscRecvClaimPO.setClaimNo(reqBO.getClaimNo());
        fscRecvClaimPO.setSerialNumber(reqBO.getSerialNumber());
        fscRecvClaimPO.setCustomerName(reqBO.getCustomerName());
        fscRecvClaimPO.setChildAccount(reqBO.getChildAccount());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscPayShouldRefundPO fscPayShouldRefundPO = this.fscPayShouldRefundMapper.queryById(reqBO.getRefundShouldPayId());
        if (fscPayShouldRefundPO == null) {
            throw new FscBusinessException("198888", "\u5e94\u9000\u5355\u4e0d\u5b58\u5728");
        }
        List list = new ArrayList();
        list = fscPayShouldRefundPO.getRefundId() == null ? this.fscOrderRefundPayRelationMapper.getClaimListPagePre(fscRecvClaimPO, page) : this.fscOrderRefundPayRelationMapper.getClaimListPageSettle(fscRecvClaimPO, page);
        if (!CollectionUtils.isEmpty(list)) {
            for (FscPayRefundClaimDetailBO bo : list) {
                bo.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)bo.getClaimType()));
                if (bo.getNotRefundAmt().compareTo(bo.getRefundAmt()) < 0) {
                    bo.setRefundAmt(bo.getNotRefundAmt());
                }
                if (bo.getPayOrderId() == null) continue;
                bo.setPayOrderInfo(this.queryPayOrderInfo(bo.getPayOrderId()));
            }
        }
        rspBO.setRows(list);
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscBillClaimPayOrderBO queryPayOrderInfo(Long payOrderId) {
        FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(payOrderId);
        FscBillClaimPayOrderBO fscBillClaimPayOrderBO = (FscBillClaimPayOrderBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscOrderPO), FscBillClaimPayOrderBO.class);
        fscBillClaimPayOrderBO.setPayAmount(fscOrderPO.getPaidAmount());
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        fscBillClaimPayOrderBO.setOrderTypeStr((String)orderTypeMap.get(fscBillClaimPayOrderBO.getOrderType().toString()));
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(fscBillClaimPayOrderBO.getFscOrderId());
        List payItems = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)payItems)) {
            Integer shouldPayMethod = ((FscOrderPayItemPO)payItems.get(0)).getShouldPayMethod();
            fscBillClaimPayOrderBO.setShouldPayMethodStr(Objects.nonNull(FscPayTypeEnum.getEnum((Integer)shouldPayMethod)) ? FscPayTypeEnum.getEnum((Integer)shouldPayMethod).getDesc() : null);
        }
        Map orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE");
        fscBillClaimPayOrderBO.setOrderStateStr((String)orderStateMap.get(fscBillClaimPayOrderBO.getOrderState() + ""));
        return fscBillClaimPayOrderBO;
    }
}

