/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.UocApprovalLogBO;
import com.tydic.fsc.common.ability.api.FscPushEngTodoAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceReqBO;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceRspBO;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.UocApprovalLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.WaitDoneLogAtomService;
import com.tydic.fsc.pay.busi.bo.WaitDoneLogReqBO;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.todo.ability.api.TodoAuditWaitDoneQueryConfigInfoAbilityService;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoBo;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoReqBo;
import com.tydic.todo.ability.bo.TodoAuditWaitDoneQueryConfigInfoRspBo;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityParamBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityRspBO;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushEngTodoAbilityService"})
public class FscPushEngTodoAbilityServiceImpl
implements FscPushEngTodoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushEngTodoAbilityServiceImpl.class);
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private WaitDoneLogAtomService waitDoneLogAtomService;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;
    @Autowired
    private TodoAuditWaitDoneQueryConfigInfoAbilityService todoAuditWaitDoneQueryConfigInfoAbilityService;

    @PostMapping(value={"dealEngPushTodo"})
    public FscPushEngTodoAbilityServiceRspBO dealEngPushTodo(@RequestBody FscPushEngTodoAbilityServiceReqBO reqBO) {
        FscPushEngTodoAbilityServiceRspBO rspBO = new FscPushEngTodoAbilityServiceRspBO();
        log.info("\u63a8\u9001\u5de5\u7a0b\u670d\u52a1\u5f85\u529e\u5904\u7406\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)reqBO));
        this.valDealPushTodoParam(reqBO);
        UocApprovalLogPO uocApprovalLogPO = this.listApproval(reqBO.getObjId());
        if (TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT.equals(reqBO.getOperatorType())) {
            this.pushWaitDone(reqBO, uocApprovalLogPO);
        }
        if (TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT.equals(reqBO.getOperatorType())) {
            this.pushAlreadyDone(reqBO, uocApprovalLogPO);
            this.cancelWaitDone(reqBO, uocApprovalLogPO);
            this.pushWaitDone(reqBO, uocApprovalLogPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valDealPushTodoParam(FscPushEngTodoAbilityServiceReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBusiCode())) {
            throw new FscBusinessException("198888", "\u5f85\u529e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOperatorType())) {
            throw new FscBusinessException("198888", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT.equals(reqBO.getOperatorType()) && !TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT.equals(reqBO.getOperatorType())) {
            throw new FscBusinessException("198888", "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
    }

    private UocApprovalLogPO listApproval(Long objId) {
        UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
        uocApprovalLogBO.setOrderId(objId);
        return this.uocApprovalLogMapper.listByParam(uocApprovalLogBO).stream().filter(Objects::nonNull).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    public UocApprovalLogPO listApprovalForSub(Long objId) {
        UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
        uocApprovalLogBO.setOrderId(objId);
        List approvalListForSub = this.uocApprovalLogMapper.getApprovalListForSub(uocApprovalLogBO);
        if (!CollectionUtils.isEmpty((Collection)approvalListForSub)) {
            return (UocApprovalLogPO)approvalListForSub.get(0);
        }
        return null;
    }

    private List<MemberAbilityBO> getUserCode(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
        umcTaskReqBO.setMemIds(userIds);
        UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
        if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
            return null;
        }
        return user.getList();
    }

    private void pushWaitDone(FscPushEngTodoAbilityServiceReqBO reqBO, UocApprovalLogPO uocApprovalLogPO) {
        if (ObjectUtil.isEmpty((Object)uocApprovalLogPO)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6700\u65b0\u4e00\u6761\u5ba1\u6279\u8bb0\u5f55\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocApprovalLogPO.getOperid())) {
            throw new FscBusinessException("198888", "\u64cd\u4f5c\u4ebaID\u4e3a\u7a7a");
        }
        UocApprovalLogPO approvalForSub = this.listApprovalForSub(reqBO.getObjId());
        if (ObjectUtil.isEmpty((Object)approvalForSub)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u4e3a\u7a7a");
        }
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(Long.valueOf(approvalForSub.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(userIds);
        if (CollectionUtils.isEmpty(userCode)) {
            throw new FscBusinessException("198888", "\u64cd\u4f5c\u4eba\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocApprovalLogPO.getNextStationId())) {
            throw new FscBusinessException("198888", "\u4e0b\u4e00\u6b65\u5c97\u4f4d\u4e3a\u7a7a");
        }
        ArrayList<Long> stationIds = new ArrayList<Long>(1);
        for (String stationId : uocApprovalLogPO.getNextStationId().split(",")) {
            stationIds.add(Long.valueOf(stationId));
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationIds(stationIds);
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserNameList(dycStationOrgSelectUserNameReqBO);
        if (CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
            throw new FscBusinessException("198888", "\u4e0b\u4e00\u6b65\u5c97\u4f4d\u5ba1\u6279\u4eba\u4e3a\u7a7a");
        }
        TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
        todoAddWaitDoneAbilityReqBO.setBusiCode(reqBO.getBusiCode());
        todoAddWaitDoneAbilityReqBO.setBusiName(reqBO.getBusiName());
        todoAddWaitDoneAbilityReqBO.setSystemCode("1");
        todoAddWaitDoneAbilityReqBO.setCenterCode("settle");
        todoAddWaitDoneAbilityReqBO.setCreateId(userCode.get(0).getRegAccount());
        todoAddWaitDoneAbilityReqBO.setCreateName(uocApprovalLogPO.getOperName());
        todoAddWaitDoneAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
        todoAddWaitDoneAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        String objNo = this.getBusinessObjNo(reqBO);
        ArrayList<TodoAddWaitDoneAbilityParamBO> waitDoneList = new ArrayList<TodoAddWaitDoneAbilityParamBO>(1);
        for (UserBO userBO : dycStationOrgSelectUserNameRspBO.getUserList()) {
            TodoAddWaitDoneAbilityParamBO waitDone = new TodoAddWaitDoneAbilityParamBO();
            waitDone.setObjId(String.valueOf(reqBO.getObjId()));
            waitDone.setObjNo(objNo);
            waitDone.setHandleUserNo(userBO.getLoginName());
            waitDone.setHandleUserName(userBO.getName());
            waitDone.setStepId(uocApprovalLogPO.getNextStepId());
            if (TaskWaitDoneEnum.PUSH_TODO_OPERATOR_SUBMIT.equals(reqBO.getOperatorType())) {
                waitDone.setObjSubTime(new Date());
            }
            waitDoneList.add(waitDone);
        }
        todoAddWaitDoneAbilityReqBO.setWaitDoneList(waitDoneList);
        this.coverWaitDoneUrl(reqBO, todoAddWaitDoneAbilityReqBO);
        try {
            if (!reqBO.getBeforePushStatus().booleanValue()) {
                throw new FscBusinessException("198888", "\u4e0a\u4e00\u6b65\u5f85\u529e\u5904\u7406\u63a8\u9001\u5931\u8d25");
            }
            TodoAddWaitDoneAbilityRspBO todoAddWaitDoneAbilityRspBO = this.todoWaitDoneWriteAbilityService.addWaitDone(todoAddWaitDoneAbilityReqBO);
            if ("0000".equals(todoAddWaitDoneAbilityRspBO.getRespCode())) {
                this.addWaitDoneLog(reqBO, 1, 1, null, JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
            }
            if (!"0000".equals(todoAddWaitDoneAbilityRspBO.getRespCode())) {
                this.addWaitDoneLog(reqBO, 2, 1, JSON.toJSONString((Object)todoAddWaitDoneAbilityRspBO), JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
                reqBO.setBeforePushStatus(Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (ObjectUtil.isNotEmpty((Object)message) && message.length() > 200) {
                message = message.substring(0, 200);
            }
            this.addWaitDoneLog(reqBO, 2, 1, JSON.toJSONString((Object)message), JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
            reqBO.setBeforePushStatus(Boolean.valueOf(false));
        }
    }

    private void coverWaitDoneUrl(FscPushEngTodoAbilityServiceReqBO reqBO, TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO) {
        TodoAuditWaitDoneQueryConfigInfoReqBo todoAuditWaitDoneQueryConfigInfoReqBo = new TodoAuditWaitDoneQueryConfigInfoReqBo();
        todoAuditWaitDoneQueryConfigInfoReqBo.setBusiCode(todoAddWaitDoneAbilityReqBO.getBusiCode());
        todoAuditWaitDoneQueryConfigInfoReqBo.setCenter(todoAddWaitDoneAbilityReqBO.getCenterCode());
        log.info("\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u67e5\u8be2\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)todoAuditWaitDoneQueryConfigInfoReqBo));
        TodoAuditWaitDoneQueryConfigInfoRspBo todoAuditWaitDoneQueryConfigInfoRspBo = this.todoAuditWaitDoneQueryConfigInfoAbilityService.queryAuditConfigInfo(todoAuditWaitDoneQueryConfigInfoReqBo);
        log.info("\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u67e5\u8be2\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)todoAuditWaitDoneQueryConfigInfoRspBo));
        if (!"0000".equals(todoAuditWaitDoneQueryConfigInfoRspBo.getRespCode())) {
            throw new FscBusinessException("198888", "\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u67e5\u8be2\u5931\u8d25");
        }
        if (ObjectUtil.isEmpty((Object)todoAuditWaitDoneQueryConfigInfoRspBo) || CollectionUtils.isEmpty((Collection)todoAuditWaitDoneQueryConfigInfoRspBo.getRows())) {
            throw new FscBusinessException("198888", "\u5de5\u4f5c\u53f0\u5ba1\u6279\u94fe\u63a5\u914d\u7f6e\u4e3a\u7a7a");
        }
        TodoAuditWaitDoneQueryConfigInfoBo waitDoneConfigInfoBo = (TodoAuditWaitDoneQueryConfigInfoBo)todoAuditWaitDoneQueryConfigInfoRspBo.getRows().get(0);
        if ("1303".equals(reqBO.getBusiCode())) {
            this.packageFinanceAccountChargeUrl(todoAddWaitDoneAbilityReqBO, waitDoneConfigInfoBo);
        }
        if ("1204".equals(reqBO.getBusiCode())) {
            this.packageFinanceAccountChargeUrl(todoAddWaitDoneAbilityReqBO, waitDoneConfigInfoBo);
        }
        log.info("\u7ec4\u88c5\u5f85\u529eUrl\u53c2\u6570|\u65b0\u589e\u5f85\u529e\u5165\u53c2\u5bf9\u8c61: {}", (Object)JSON.toJSONString((Object)todoAddWaitDoneAbilityReqBO));
    }

    private void addWaitDoneLog(FscPushEngTodoAbilityServiceReqBO reqBO, Integer waitDoneStatus, Integer waitDoneType, String errorMsg, String pushMsg) {
        WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
        waitDoneLogReqBO.setBusiCode(reqBO.getBusiCode());
        waitDoneLogReqBO.setBusiName(reqBO.getBusiName());
        waitDoneLogReqBO.setMsgContent(pushMsg);
        waitDoneLogReqBO.setObjId(reqBO.getObjId());
        waitDoneLogReqBO.setWaitDoneStatus(waitDoneStatus);
        waitDoneLogReqBO.setWaitDoneType(waitDoneType);
        waitDoneLogReqBO.setExt1(errorMsg);
        this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
    }

    private void pushAlreadyDone(FscPushEngTodoAbilityServiceReqBO reqBO, UocApprovalLogPO uocApprovalLogPO) {
        if (ObjectUtil.isEmpty((Object)uocApprovalLogPO)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6700\u65b0\u4e00\u6761\u5ba1\u6279\u8bb0\u5f55\u4e3a\u7a7a");
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(Long.valueOf(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(userIds);
        if (CollectionUtils.isEmpty(userCode)) {
            throw new FscBusinessException("198888", "\u64cd\u4f5c\u4eba\u67e5\u8be2\u4e3a\u7a7a");
        }
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setBusiCode(reqBO.getBusiCode());
        todoAddAlreadyDoneAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
        todoAddAlreadyDoneAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        todoAddAlreadyDoneAbilityReqBO.setCenterCode("settle");
        todoAddAlreadyDoneAbilityReqBO.setHandleUserNo(userCode.get(0).getRegAccount());
        ArrayList<TodoAddAlreadyDoneAbilityParamBO> alreadyDoneList = new ArrayList<TodoAddAlreadyDoneAbilityParamBO>(1);
        TodoAddAlreadyDoneAbilityParamBO alreadyDone = new TodoAddAlreadyDoneAbilityParamBO();
        alreadyDone.setAuditTime(new Date());
        alreadyDone.setStepId(uocApprovalLogPO.getStepId());
        alreadyDone.setObjId(String.valueOf(reqBO.getObjId()));
        alreadyDone.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
        alreadyDone.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
        alreadyDone.setFinishTime(new Date());
        alreadyDone.setAuditTime(new Date());
        alreadyDoneList.add(alreadyDone);
        todoAddAlreadyDoneAbilityReqBO.setDoneList(alreadyDoneList);
        try {
            TodoAddAlreadyDoneAbilityRspBO todoAddAlreadyDoneAbilityRspBO = this.todoWaitDoneWriteAbilityService.AddAlreadyDone(todoAddAlreadyDoneAbilityReqBO);
            if ("0000".equals(todoAddAlreadyDoneAbilityRspBO.getRespCode())) {
                this.addWaitDoneLog(reqBO, 1, 3, null, JSON.toJSONString((Object)todoAddAlreadyDoneAbilityReqBO));
            }
            if (!"0000".equals(todoAddAlreadyDoneAbilityRspBO.getRespCode())) {
                this.addWaitDoneLog(reqBO, 2, 3, JSON.toJSONString((Object)todoAddAlreadyDoneAbilityRspBO), JSON.toJSONString((Object)todoAddAlreadyDoneAbilityReqBO));
                reqBO.setBeforePushStatus(Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (ObjectUtil.isNotEmpty((Object)message) && message.length() > 200) {
                message = message.substring(0, 200);
            }
            this.addWaitDoneLog(reqBO, 2, 3, JSON.toJSONString((Object)message), JSON.toJSONString((Object)todoAddAlreadyDoneAbilityReqBO));
            reqBO.setBeforePushStatus(Boolean.valueOf(false));
        }
    }

    private void cancelWaitDone(FscPushEngTodoAbilityServiceReqBO reqBO, UocApprovalLogPO uocApprovalLogPO) {
        if (ObjectUtil.isEmpty((Object)uocApprovalLogPO)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u6700\u65b0\u4e00\u6761\u5ba1\u6279\u8bb0\u5f55\u4e3a\u7a7a");
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(Long.valueOf(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(userIds);
        if (CollectionUtils.isEmpty(userCode)) {
            throw new FscBusinessException("198888", "\u64cd\u4f5c\u4eba\u67e5\u8be2\u4e3a\u7a7a");
        }
        TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new TodoCancelWaitDoneAbilityReqBO();
        todoCancelWaitDoneAbilityReqBO.setBusiCode(reqBO.getBusiCode());
        todoCancelWaitDoneAbilityReqBO.setCenterCode("settle");
        ArrayList<TodoCancelWaitDoneAbilityParamBO> cancelWaitDoneList = new ArrayList<TodoCancelWaitDoneAbilityParamBO>(1);
        TodoCancelWaitDoneAbilityParamBO cancelWaitDone = new TodoCancelWaitDoneAbilityParamBO();
        cancelWaitDone.setObjId(String.valueOf(reqBO.getObjId()));
        if (TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT.equals(reqBO.getOperatorType())) {
            todoCancelWaitDoneAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
            todoCancelWaitDoneAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
            cancelWaitDone.setStepId(uocApprovalLogPO.getStepId());
        }
        cancelWaitDoneList.add(cancelWaitDone);
        todoCancelWaitDoneAbilityReqBO.setCancelList(cancelWaitDoneList);
        try {
            TodoCancelWaitDoneAbilityRspBO todoCancelWaitDoneAbilityRspBO = this.todoWaitDoneWriteAbilityService.cancelWaitDone(todoCancelWaitDoneAbilityReqBO);
            if ("0000".equals(todoCancelWaitDoneAbilityRspBO.getRespCode())) {
                this.addWaitDoneLog(reqBO, 1, 2, null, JSON.toJSONString((Object)todoCancelWaitDoneAbilityReqBO));
            }
            if (!"0000".equals(todoCancelWaitDoneAbilityRspBO.getRespCode())) {
                this.addWaitDoneLog(reqBO, 2, 2, JSON.toJSONString((Object)todoCancelWaitDoneAbilityRspBO), JSON.toJSONString((Object)todoCancelWaitDoneAbilityReqBO));
                reqBO.setBeforePushStatus(Boolean.valueOf(false));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (ObjectUtil.isNotEmpty((Object)message) && message.length() > 200) {
                message = message.substring(0, 200);
            }
            this.addWaitDoneLog(reqBO, 2, 2, JSON.toJSONString((Object)message), JSON.toJSONString((Object)todoCancelWaitDoneAbilityReqBO));
            reqBO.setBeforePushStatus(Boolean.valueOf(false));
        }
    }

    private void packageFinanceAccountChargeUrl(TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO, TodoAuditWaitDoneQueryConfigInfoBo waitDoneConfigInfoBo) {
        for (TodoAddWaitDoneAbilityParamBO paramBO : todoAddWaitDoneAbilityReqBO.getWaitDoneList()) {
            String suffix;
            paramBO.setAuditUrl(waitDoneConfigInfoBo.getAuditUrl());
            JSONObject logParams = new JSONObject();
            logParams.put("fscOrderId", (Object)paramBO.getObjId());
            logParams.put("objType", (Object)5);
            paramBO.setAuditLogParma(logParams.toJSONString());
            paramBO.setTitle(waitDoneConfigInfoBo.getAuditMenuName() + "_" + paramBO.getObjNo());
            paramBO.setAuditLogUrl(waitDoneConfigInfoBo.getAuditLogUrl());
            if (ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getAuditAlreadyUrl())) {
                suffix = "?chargeId=" + paramBO.getObjId() + "&type=2&approveType=2&isOptionType=approveDetail";
                paramBO.setAuditAlreadyUrl(waitDoneConfigInfoBo.getAuditAlreadyUrl() + suffix);
            }
            if (ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getAuditWaitUrl())) {
                suffix = "?chargeId=" + paramBO.getObjId() + "&type=2&approveType=1&isYc=1&isOptionType=approveUpdate";
                paramBO.setAuditWaitUrl(waitDoneConfigInfoBo.getAuditWaitUrl() + suffix);
            }
            if (ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getExt1())) {
                String infoBeforeCondition = "?chargeId=" + paramBO.getObjId() + "&type=2&isOptionType=detail";
                paramBO.setInfoBeforeUrl(waitDoneConfigInfoBo.getExt1() + infoBeforeCondition);
            }
            if (ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getExt2())) {
                suffix = "?chargeId=" + paramBO.getObjId() + "&type=2&isOptionType=detail";
                paramBO.setInfoAfterUrl(waitDoneConfigInfoBo.getExt2() + suffix);
            }
            if (ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getAuditTodoUrl())) {
                suffix = "?chargeId=" + paramBO.getObjId() + "&type=2&approveType=2&isOptionType=approveDetail";
                paramBO.setAuditTodoUrl(waitDoneConfigInfoBo.getAuditTodoUrl() + suffix);
            }
            if (ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getAuditWaitUrl())) {
                suffix = "?chargeId=" + paramBO.getObjId() + "&type=2&approveType=1&radioS=0&isYc=1&isOptionType=approveUpdate";
                paramBO.setAuditWaitPassUrl(waitDoneConfigInfoBo.getAuditWaitUrl() + suffix);
            }
            if (!ObjectUtil.isNotEmpty((Object)waitDoneConfigInfoBo.getAuditWaitUrl())) continue;
            suffix = "?chargeId=" + paramBO.getObjId() + "&type=2&approveType=1&radioS=1&isYc=1&isOptionType=approveUpdate";
            paramBO.setAuditWaitRejectUrl(waitDoneConfigInfoBo.getAuditWaitUrl() + suffix);
        }
    }

    private String getBusinessObjNo(FscPushEngTodoAbilityServiceReqBO reqBO) {
        String objNo = "";
        if ("1204".equals(reqBO.getBusiCode())) {
            objNo = this.getFinanceAccountChargeObjNo(reqBO);
        }
        return objNo;
    }

    private String getFinanceAccountChargeObjNo(FscPushEngTodoAbilityServiceReqBO reqBO) {
        FscAccountChargePO qryFscAccountCharge = new FscAccountChargePO();
        qryFscAccountCharge.setChargeId(reqBO.getObjId());
        FscAccountChargePO fscAccountChargePO = this.fscAccountChargeMapper.getModelBy(qryFscAccountCharge);
        if (ObjectUtil.isEmpty((Object)fscAccountChargePO)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8d26\u6237\u5145\u503c\u8bb0\u5f55\u4fe1\u606f\u4e3a\u7a7a");
        }
        return ObjectUtil.isNotEmpty((Object)fscAccountChargePO.getAdvanceDepositNo()) ? fscAccountChargePO.getAdvanceDepositNo() : "";
    }
}

