/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPushNewYcClaimRefundBillAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscNewYcClaimRefundBillBO;
import com.tydic.fsc.common.ability.bo.FscNewYcClaimRefundBillLineBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcClaimRefundBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcClaimRefundBillAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscUnifyAttachmentBO;
import com.tydic.fsc.common.busi.api.FscPushNewYcClaimRefundBillBusiService;
import com.tydic.fsc.common.busi.api.FscPushNewYcFailBusiService;
import com.tydic.fsc.common.busi.bo.FscPushNewYcClaimRefundBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcClaimRefundBillBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscPushNewYcFailBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayClaimRefundDetailPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtUnifyFileUploadAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifyFileUploadAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleEncryptionAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPushNewYcClaimRefundBillAbilityService"})
public class FscPushNewYcClaimRefundBillAbilityServiceImpl
implements FscPushNewYcClaimRefundBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcClaimRefundBillAbilityServiceImpl.class);
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private PebExtUnifyFileUploadAbilityService pebExtUnifyFileUploadAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscPushNewYcFailBusiService fscPushNewYcFailBusiService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Value(value="${settle.stage:TWO}")
    private String settleStage;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;
    @Autowired
    private FscPushNewYcClaimRefundBillBusiService fscPushNewYcClaimRefundBillBusiService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushNewYcClaimRefundBill"})
    public FscPushNewYcClaimRefundBillAbilityRspBO dealPushNewYcClaimRefundBill(@RequestBody FscPushNewYcClaimRefundBillAbilityReqBO reqBO) {
        FscPushNewYcClaimRefundBillBusiRspBO pushRspBO;
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscPushNewYcClaimRefundBillAbilityRspBO rspBO = new FscPushNewYcClaimRefundBillAbilityRspBO();
        FscPushYcAttachmentAbilityReqBO attachmentReqBO = new FscPushYcAttachmentAbilityReqBO();
        attachmentReqBO.setObjId(refundPO.getRefundId());
        attachmentReqBO.setObjNo(refundPO.getRefundNo());
        attachmentReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.CLAIM_REFUND);
        try {
            FscPushNewYcClaimRefundBillBusiReqBO pushReqBO = this.buildClaimRefundBillInfo(refundPO, reqBO);
            pushRspBO = this.fscPushNewYcClaimRefundBillBusiService.dealPushClaimRefundBill(pushReqBO);
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
            this.dealFail(reqBO.getRefundId(), e.getMessage());
            this.sendMq(reqBO.getRefundId());
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        attachmentReqBO.setAgentName(refundPO.getAgentUserName());
        attachmentReqBO.setAgentAccount(refundPO.getExt1());
        this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(attachmentReqBO);
        this.sendMq(reqBO.getRefundId());
        return (FscPushNewYcClaimRefundBillAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)pushRspBO)), FscPushNewYcClaimRefundBillAbilityRspBO.class);
    }

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushNewYcClaimBatch"})
    public FscPushNewYcClaimRefundBillAbilityRspBO dealPushNewYcClaimBatch(@RequestBody FscPushNewYcClaimRefundBillAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u9000\u6b3e\u5355id\u96c6\u5408[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long refundId : reqBO.getRefundIds()) {
            FscPushNewYcClaimRefundBillAbilityReqBO billAbilityReqBO = new FscPushNewYcClaimRefundBillAbilityReqBO();
            billAbilityReqBO.setRefundId(refundId);
            FscPushNewYcClaimRefundBillAbilityRspBO rspBO = this.dealPushNewYcClaimRefundBill(billAbilityReqBO);
            if (rspBO.getRespCode().equals("0000")) continue;
            sb.append("\u9000\u6b3e\u5355[").append(refundId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(rspBO.getRespDesc());
        }
        FscPushNewYcClaimRefundBillAbilityRspBO rspBO = new FscPushNewYcClaimRefundBillAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private FscPushNewYcClaimRefundBillBusiReqBO buildClaimRefundBillInfo(FscOrderRefundPO refundPO, FscPushNewYcClaimRefundBillAbilityReqBO reqBO) {
        FscPushNewYcClaimRefundBillBusiReqBO pushReqBO = new FscPushNewYcClaimRefundBillBusiReqBO();
        FscNewYcClaimRefundBillBO REREC = new FscNewYcClaimRefundBillBO();
        ArrayList<FscNewYcClaimRefundBillLineBO> REREC_LINE = new ArrayList<FscNewYcClaimRefundBillLineBO>();
        this.buildClaimRefundInfo(refundPO, REREC, REREC_LINE);
        pushReqBO.setRefundId(reqBO.getRefundId());
        pushReqBO.setToken(REREC.getToken());
        REREC.setToken(null);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("REREC", (Object)REREC);
        jsonObject.put("REREC_LINE", REREC_LINE);
        jsonArray.add((Object)jsonObject);
        PebExtUnifySettleEncryptionAbilityReqBO encryptionAbilityReqBO = new PebExtUnifySettleEncryptionAbilityReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toJSONString());
        log.info("--------\u63a8\u9001\u65b0\u4e1a\u8d22\u4ed8\u6b3e\u4fe1\u606f\u660e\u6587\u6253\u5370\uff1a" + JSON.toJSON((Object)jsonArray.toJSONString()));
        PebExtUnifySettleEncryptionAbilityRspBO encryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamEncryption(encryptionAbilityReqBO);
        if (!encryptionAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionAbilityRspBO.getRespCode(), "\u8c03\u7528\u52a0\u5bc6\u53c2\u6570\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionAbilityRspBO.getRespDesc());
        }
        pushReqBO.setReqData(jsonArray.toJSONString());
        pushReqBO.setParseData(encryptionAbilityRspBO.getData());
        return pushReqBO;
    }

    private void buildFileInfo(List<FscUnifyAttachmentBO> attachmentBOList, FscOrderRefundPO refundPO, FscNewYcClaimRefundBillBO claimRefundBillBO) {
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(refundPO.getRefundId());
        List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
        for (FscAttachmentPO fscAttachmentPO : attachmentPOS) {
            PebExtUnifyFileUploadAbilityReqBO uploadAbilityReqBO = new PebExtUnifyFileUploadAbilityReqBO();
            uploadAbilityReqBO.setFileName(fscAttachmentPO.getAttachmentName());
            uploadAbilityReqBO.setFileUrl(fscAttachmentPO.getAttachmentUrl());
            PebExtUnifyFileUploadAbilityRspBO uploadAbilityRspBO = this.pebExtUnifyFileUploadAbilityService.dealUnifyUpload(uploadAbilityReqBO);
            if (!uploadAbilityRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException(uploadAbilityRspBO.getRespCode(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadAbilityRspBO.getRespDesc());
            }
            FscUnifyAttachmentBO attachmentBO = new FscUnifyAttachmentBO();
            attachmentBO.setDOC_NAME(uploadAbilityRspBO.getFileName());
            attachmentBO.setUPLOAD_TIME(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBO.setUSER_NAME(claimRefundBillBO.getPERSON_NAME());
            attachmentBO.setDOC_FORMAT(fscAttachmentPO.getAttachmentName().substring(fscAttachmentPO.getAttachmentName().lastIndexOf(".") + 1));
            attachmentBO.setFILE_URL(uploadAbilityRspBO.getUrl());
            attachmentBO.setDOC_TYPE("9003");
            attachmentBO.setUUID("zjht");
            attachmentBO.setLAST_UPDATE_DATE(DateUtil.dateToStr((Date)new Date(), (String)"yyyyMMdd"));
            attachmentBO.setDOC_SIZE(uploadAbilityRspBO.getSize());
            attachmentBOList.add(attachmentBO);
        }
    }

    private void buildClaimRefundInfo(FscOrderRefundPO refundPO, FscNewYcClaimRefundBillBO claimRefundBillBO, List<FscNewYcClaimRefundBillLineBO> claimRefundBillLine) {
        if (FscConstants.FscPushStatus.SUCCESS.equals(refundPO.getPushStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u6b3e\u5355\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        if (StringUtils.isEmpty((Object)refundPO.getExt1())) {
            throw new FscBusinessException("198888", "erp\u7528\u6237\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(refundPO.getExt1());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getMsg());
        }
        claimRefundBillBO.setToken(tokenQryAbilityRspBO.getData());
        FscPayClaimRefundDetailPO fscPayClaimRefundDetailPO = new FscPayClaimRefundDetailPO();
        fscPayClaimRefundDetailPO.setRefundId(refundPO.getRefundId());
        List claimDetailList = this.fscPayClaimRefundDetailMapper.getClaimInfoByRefundId(fscPayClaimRefundDetailPO);
        fscPayClaimRefundDetailPO = (FscPayClaimRefundDetailPO)claimDetailList.get(0);
        Map<Object, Object> changeItemMap = new HashMap();
        if (FscConstants.RefundType.REFUND_INVOICE.equals(refundPO.getRefundReasonType())) {
            Long againstId = this.fscOrderRefundMapper.queryRefundIdByRefundId(refundPO.getRefundId());
            List changeItemList = this.fscRefundChangeItemMapper.queryByRefundId(againstId);
            changeItemMap = changeItemList.stream().collect(Collectors.toMap(FscRefundChangeItemPO::getPreClaimDetailId, Function.identity()));
        }
        claimRefundBillBO.setREC_ID(fscPayClaimRefundDetailPO.getClaimId());
        claimRefundBillBO.setREC_NUM(fscPayClaimRefundDetailPO.getClaimNo());
        claimRefundBillBO.setORG_ID(this.operationOrgId);
        claimRefundBillBO.setORG_NAME(this.operOrgName);
        claimRefundBillBO.setPERSON_ID(refundPO.getAgentUserId());
        claimRefundBillBO.setPERSON_NAME(refundPO.getAgentUserName());
        claimRefundBillBO.setDEPT_ID(refundPO.getAgentDeptId());
        claimRefundBillBO.setDEPT_NAME(refundPO.getAgentDeptName());
        claimRefundBillBO.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime(), (String)"yyyy-MM-dd"));
        claimRefundBillBO.setSTATUS("Y");
        claimRefundBillBO.setGENERAL_STATUS("V");
        claimRefundBillBO.setVENDOR_ID(fscPayClaimRefundDetailPO.getCustomerNo());
        claimRefundBillBO.setVENDOR_NAME(fscPayClaimRefundDetailPO.getCustomerName());
        claimRefundBillBO.setBANK_ID(fscPayClaimRefundDetailPO.getBankId());
        claimRefundBillBO.setBANK_NAME(fscPayClaimRefundDetailPO.getAccountBranch());
        claimRefundBillBO.setBANK_ACC(fscPayClaimRefundDetailPO.getBankAccount());
        claimRefundBillBO.setREC_AMOUNT(fscPayClaimRefundDetailPO.getRecvAmt().setScale(2, RoundingMode.HALF_UP));
        claimRefundBillBO.setREFUND_AMOUNT(refundPO.getRefundAmount().setScale(2, RoundingMode.HALF_UP));
        claimRefundBillBO.setDESCRIPTIONS(refundPO.getRefundNote());
        claimRefundBillBO.setEG_TESCO_ID(refundPO.getRefundId());
        claimRefundBillBO.setEG_BILL_NUM(refundPO.getRefundNo());
        claimRefundBillBO.setTASK_FLAG("Y");
        for (FscPayClaimRefundDetailPO po : claimDetailList) {
            FscNewYcClaimRefundBillLineBO fscNewYcClaimRefundBillLineBO = new FscNewYcClaimRefundBillLineBO();
            fscNewYcClaimRefundBillLineBO.setBALANCE_ID(po.getFscOrderId());
            fscNewYcClaimRefundBillLineBO.setBALANCE_NUM(po.getFscOrderNo());
            fscNewYcClaimRefundBillLineBO.setBANK_BILL_ID(po.getLedgerId());
            fscNewYcClaimRefundBillLineBO.setBANK_BILL_NUM(po.getSerialNumber());
            fscNewYcClaimRefundBillLineBO.setCLAIM_AMOUNT(po.getClaimAmt().setScale(2, RoundingMode.HALF_UP));
            fscNewYcClaimRefundBillLineBO.setTY_AMOUNT(po.getLeaveRefundAmt().setScale(2, RoundingMode.HALF_UP));
            fscNewYcClaimRefundBillLineBO.setAMOUNT(po.getRefundAmt().setScale(2, RoundingMode.HALF_UP));
            FscDicDictionaryExernalPO eternal = new FscDicDictionaryExernalPO();
            eternal.setPCode("FSC_YC_CLAIM_TYPE");
            Map<String, FscDicDictionaryExernalPO> dicMapE = this.getDicMap(eternal);
            if (FscConstants.RefundType.REFUND_INVOICE.equals(refundPO.getRefundReasonType())) {
                FscRefundChangeItemPO fscRefundChangeItemPO = (FscRefundChangeItemPO)changeItemMap.get(po.getClaimDetailId());
                fscNewYcClaimRefundBillLineBO.setPERSON_ID(fscRefundChangeItemPO.getHandleUserId());
                fscNewYcClaimRefundBillLineBO.setPERSON_NAME(fscRefundChangeItemPO.getHandleUserName());
                fscNewYcClaimRefundBillLineBO.setDEPT_ID(fscRefundChangeItemPO.getHandleDeptId());
                fscNewYcClaimRefundBillLineBO.setDEPT_NAME(fscRefundChangeItemPO.getHandleDeptName());
                fscNewYcClaimRefundBillLineBO.setREC_LINE_ID(String.valueOf(fscRefundChangeItemPO.getChangeItemId()));
                FscDicDictionaryExernalPO recDic = dicMapE.get(fscRefundChangeItemPO.getClaimType() + "");
                if (recDic == null) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u65b0\u4e1a\u8d22\u8ba4\u9886\u7c7b\u578b\u4e3a\u7a7a\uff01");
                }
                fscNewYcClaimRefundBillLineBO.setCLAIM_TYPE(recDic.getExernalCode());
                fscNewYcClaimRefundBillLineBO.setCLAIM_TYPE_DIS(recDic.getTitle());
            } else {
                fscNewYcClaimRefundBillLineBO.setPERSON_ID(po.getHandleUserId());
                fscNewYcClaimRefundBillLineBO.setPERSON_NAME(po.getHandleUserName());
                fscNewYcClaimRefundBillLineBO.setDEPT_ID(po.getHandleDeptId());
                fscNewYcClaimRefundBillLineBO.setDEPT_NAME(po.getHandleDeptName());
                fscNewYcClaimRefundBillLineBO.setREC_LINE_ID(String.valueOf(po.getClaimDetailId()));
                FscDicDictionaryExernalPO recDic = dicMapE.get(po.getClaimType());
                if (recDic == null) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u65b0\u4e1a\u8d22\u8ba4\u9886\u7c7b\u578b\u4e3a\u7a7a\uff01");
                }
                fscNewYcClaimRefundBillLineBO.setCLAIM_TYPE(recDic.getExernalCode());
                fscNewYcClaimRefundBillLineBO.setCLAIM_TYPE_DIS(recDic.getTitle());
            }
            fscNewYcClaimRefundBillLineBO.setEG_TESCO_ID(String.valueOf(po.getId()));
            claimRefundBillLine.add(fscNewYcClaimRefundBillLineBO);
        }
    }

    private void dealFail(Long fscOrderId, String failMsg) {
        FscPushNewYcFailBusiReqBO failBusiReqBO = new FscPushNewYcFailBusiReqBO();
        failBusiReqBO.setFailMsg(failMsg);
        failBusiReqBO.setFscOrderId(fscOrderId);
        failBusiReqBO.setPushType(FscConstants.FscPurchasePushType.PAY);
        this.fscPushNewYcFailBusiService.dealPushNewYcFail(failBusiReqBO);
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncReqBO = new FscComRefundSyncAbilityReqBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        refundIds.add(refundId);
        syncReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(syncReqBO);
    }

    private Map<String, FscDicDictionaryExernalPO> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, Function.identity()));
    }
}

