/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bo.FscClaimDetailChangeRenovBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscRecvClaimChangeCreateRenovAbilityService;
import com.tydic.fsc.common.ability.bo.FscRecvClaimChangeCreateRenovAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvClaimChangeCreateRenovAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimChangeCreateRenovBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimChangeCreateRenovBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvClaimChangeCreateRenovBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRecvClaimChangeCreateRenovAbilityService"})
public class FscRecvClaimChangeCreateRenovAbilityServiceImpl
implements FscRecvClaimChangeCreateRenovAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvClaimChangeCreateRenovAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimChangeCreateRenovBusiService fscRecvClaimChangeCreateRenovBusiService;
    @Resource(name="fscPushYcRecvClaimChangeMqServiceProvider")
    private ProxyMessageProducer fscPushYcRecvClaimChangeMqServiceProvider;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC}")
    private String pushTopic;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG}")
    private String pushTag;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealCreate"})
    public FscRecvClaimChangeCreateRenovAbilityRspBO dealCreate(@RequestBody FscRecvClaimChangeCreateRenovAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscRecvClaimChangeCreateRenovBusiReqBO busiReqBO = (FscRecvClaimChangeCreateRenovBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscRecvClaimChangeCreateRenovBusiReqBO.class));
        FscRecvClaimChangeCreateRenovBusiRspBO busiRspBO = this.fscRecvClaimChangeCreateRenovBusiService.dealCreate(busiReqBO);
        log.info("----------------------------\u6536\u6b3e\u8ba4\u9886\u53d8\u66f4\u51fa\u53c2\u4e3a\uff1a" + JSONObject.toJSON((Object)((Object)busiRspBO)));
        if ("0000".equals(busiRspBO.getRespCode())) {
            if (busiRspBO.getPushFlag().booleanValue()) {
                try {
                    this.taskTodoWaitService.syncNotifyRecvFoundWaitDone(busiRspBO.getConfirmedList().get(0));
                }
                catch (Exception e) {
                    log.error("dealOrderInvoiceSignApproval get stationId error:{}", (Throwable)e);
                }
            }
            if (!(CollectionUtils.isEmpty(busiRspBO.getConfirmedList()) || reqBO.getChangeType() != null && reqBO.getChangeType() == 1)) {
                try {
                    FscClaimChangeConfirmBusiRspBO rspBO = new FscClaimChangeConfirmBusiRspBO();
                    rspBO.setChangeIdList(busiRspBO.getConfirmedList());
                    rspBO.setAgentAccount(reqBO.getAgentAccount());
                    rspBO.setChangeType(reqBO.getChangeType());
                    this.sendMqs(rspBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String respString = JSONObject.toJSONString((Object)((Object)busiRspBO));
        return (FscRecvClaimChangeCreateRenovAbilityRspBO)JSONObject.parseObject((String)respString, FscRecvClaimChangeCreateRenovAbilityRspBO.class);
    }

    private void sendMqs(FscClaimChangeConfirmBusiRspBO busiRspBO) {
        ProxySendResult proxySendResult = this.fscPushYcRecvClaimChangeMqServiceProvider.send(new ProxyMessage(this.pushTopic, this.pushTag, JSONObject.toJSONString((Object)((Object)busiRspBO))));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeStateFailLog(JSONObject.toJSONString(busiRspBO.getChangeIdList()));
        }
    }

    private void writeStateFailLog(String objNo) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(objNo);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_CLAIM_CHANGE_SETTLE_PUSH_YC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void valid(FscRecvClaimChangeCreateRenovAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba4\u9886\u5355id[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeType() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeAmt() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u91d1\u989d[changeAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeDate() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u8d77\u53d8\u66f4\u65e5\u671f[changeDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeDeptId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u90e8\u95e8id[changeDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeDeptName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u90e8\u95e8[changeDeptName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeUserId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u4ebaid[changeUserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeUserName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ecf\u529e\u4eba[changeUserName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getChangeType() == 0 && CollectionUtils.isEmpty((Collection)reqBO.getDetailChangeList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u660e\u7ec6[changeList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean changeFlag = false;
        for (FscClaimDetailChangeRenovBO bo : reqBO.getDetailChangeList()) {
            if (bo.getChangeSource() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u540e\u6765\u6e90[changeSource]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeAmt() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u660e\u7ec6\u53d8\u66f4\u91d1\u989d[changeAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getChangeClaimType() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u8ba4\u9886\u7c7b\u578b[changeClaimType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!FscSystemSourceEnum.YG.getCode().equals(bo.getChangeSource())) continue;
            if (bo.getChangeFscOrderId() == null && bo.getChangeOrderId() == null && bo.getChangeAccountId() == null) {
                changeFlag = true;
            }
            if (bo.getChangeFscOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeFscOrderNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u7ed3\u7b97\u5355\u53f7[changeFscOrderNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getChangeFscOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeAcceptId())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u5165\u5e93\u5355\u53f7[changeAcceptId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bo.getChangeClaimType() != null && bo.getChangeClaimType() != 6) {
                if (bo.getChangeOrderId() != null && StringUtils.isEmpty((Object)bo.getChangeOrderCode())) {
                    throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u8ba2\u5355\u7f16\u53f7[changeOrderCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else {
                bo.setChangeOrderCode(bo.getChangeFscOrderNo());
            }
            if (bo.getChangeAccountId() == null || !StringUtils.isEmpty((Object)bo.getChangeAccountNo())) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d8\u66f4\u9884\u5b58\u6b3e\u8d26\u6237[changeAccountNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (changeFlag && reqBO.getDetailChangeList().size() != 1) {
            throw new FscBusinessException("191000", "\u6362\u7968\u9884\u8ba4\u9886\u53ea\u80fd\u6709\u4e00\u6761\u660e\u7ec6\uff01");
        }
        if (reqBO.getChangeType() == 1 && !CollectionUtils.isEmpty((Collection)reqBO.getDetailChangeList())) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u53d8\u66f4\u9000\u6b3e\uff0c\u53d8\u66f4\u660e\u7ec6\u9519\u8bef\uff01");
        }
    }
}

