/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscRecvReceivePaymentAbilityService;
import com.tydic.fsc.common.ability.bo.FscRecvReceivePaymentApprovalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRecvReceivePaymentApprovalAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRecvReceivePaymentBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscRecvReceivePaymentApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvReceivePaymentApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRecvReceivePaymentAbilityService"})
public class FscRecvReceivePaymentAbilityServiceImpl
implements FscRecvReceivePaymentAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvReceivePaymentAbilityServiceImpl.class);
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscRecvReceivePaymentBusiService fscRecvReceivePaymentBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Resource(name="fscPushYcRecvClaimChangeMqServiceProvider")
    private ProxyMessageProducer fscPushYcRecvClaimChangeMqServiceProvider;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TOPIC}")
    private String pushTopic;
    @Value(value="${es.FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG:FSC_PUSH_YC_RECV_CLAIM_CHANGE_TAG}")
    private String pushTag;

    @PostMapping(value={"receivePaymentApproval"})
    public FscRecvReceivePaymentApprovalAbilityRspBO receivePaymentApproval(@RequestBody FscRecvReceivePaymentApprovalAbilityReqBO reqBO) {
        FscRecvReceivePaymentApprovalAbilityRspBO abilityRspBO = new FscRecvReceivePaymentApprovalAbilityRspBO();
        this.val(reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        StringBuilder errorInfo = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            for (Long orderId : reqBO.getOrderIds()) {
                reqBO.setOrderId(orderId);
                FscRecvReceivePaymentApprovalBusiRspBO rspBO = this.signBusi(reqBO);
                errorInfo.append(rspBO.getResult());
                if (!rspBO.getAuditResult().booleanValue() || !rspBO.getFinish().booleanValue()) continue;
                FscClaimChangeConfirmBusiRspBO fscClaimChangeConfirmBusiRspBO = new FscClaimChangeConfirmBusiRspBO();
                fscClaimChangeConfirmBusiRspBO.setChangeIdList(Collections.singletonList(reqBO.getOrderId()));
                fscClaimChangeConfirmBusiRspBO.setAgentAccount(reqBO.getAgentAccount());
                fscClaimChangeConfirmBusiRspBO.setChangeType(1);
                this.sendMqs(fscClaimChangeConfirmBusiRspBO);
            }
        } else if (reqBO.getOrderId() != null) {
            FscRecvReceivePaymentApprovalBusiRspBO rspBO = this.signBusi(reqBO);
            errorInfo = new StringBuilder(rspBO.getResult());
            if (rspBO.getAuditResult().booleanValue() && rspBO.getFinish().booleanValue()) {
                FscClaimChangeConfirmBusiRspBO fscClaimChangeConfirmBusiRspBO = new FscClaimChangeConfirmBusiRspBO();
                fscClaimChangeConfirmBusiRspBO.setChangeIdList(Collections.singletonList(reqBO.getOrderId()));
                fscClaimChangeConfirmBusiRspBO.setAgentAccount(reqBO.getAgentAccount());
                fscClaimChangeConfirmBusiRspBO.setChangeType(1);
                this.sendMqs(fscClaimChangeConfirmBusiRspBO);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errorInfo.toString())) {
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(errorInfo.toString());
        } else {
            abilityRspBO.setRespCode("0000");
            abilityRspBO.setRespDesc("\u6210\u529f");
        }
        return abilityRspBO;
    }

    private FscRecvReceivePaymentApprovalBusiRspBO signBusi(FscRecvReceivePaymentApprovalAbilityReqBO reqBO) {
        String result = "";
        FscRecvClaimChangePO fscRecvClaimChangePO = this.fscRecvClaimChangeMapper.queryById(reqBO.getOrderId());
        if (null == fscRecvClaimChangePO) {
            throw new FscBusinessException("191019", "\u6536\u6b3e\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        if (fscRecvClaimChangePO.getAuitState() == null) {
            throw new FscBusinessException("191019", "\u6536\u6b3e\u9000\u6b3e\u5355\u5ba1\u6279\u6743\u9650\u5f02\u5e38");
        }
        Integer count = this.fscRecvClaimChangeMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList());
        if (count == 0 || CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        if (!FscConstants.ChangeBillStatus.CONFIRMED.equals(fscRecvClaimChangePO.getBillStatus())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscRecvClaimChangePO.getBillStatus() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        FscRecvReceivePaymentApprovalBusiReqBO fscRecvReceivePaymentApprovalBusiReqBO = (FscRecvReceivePaymentApprovalBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscRecvReceivePaymentApprovalBusiReqBO.class));
        FscRecvReceivePaymentApprovalBusiRspBO fscRecvReceivePaymentApprovalBusiRspBO = this.fscRecvReceivePaymentBusiService.receivePaymentApproval(fscRecvReceivePaymentApprovalBusiReqBO);
        if (!"0000".equals(fscRecvReceivePaymentApprovalBusiRspBO.getRespCode())) {
            result = result + "\u6536\u6b3e\u9000\u6b3e\u5355" + fscRecvClaimChangePO.getChangeNo() + "\u5ba1\u6279\u5931\u8d25\uff0c" + fscRecvReceivePaymentApprovalBusiRspBO.getRespDesc() + ";";
        }
        fscRecvReceivePaymentApprovalBusiRspBO.setResult(result);
        return fscRecvReceivePaymentApprovalBusiRspBO;
    }

    private void val(FscRecvReceivePaymentApprovalAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId() && CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void sendMqs(FscClaimChangeConfirmBusiRspBO busiRspBO) {
        ProxySendResult proxySendResult = this.fscPushYcRecvClaimChangeMqServiceProvider.send(new ProxyMessage(this.pushTopic, this.pushTag, JSONObject.toJSONString((Object)((Object)busiRspBO))));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeStateFailLog(JSONObject.toJSONString(busiRspBO.getChangeIdList()));
        }
    }

    private void writeStateFailLog(String objNo) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjNo(objNo);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_CLAIM_CHANGE_SETTLE_PUSH_YC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

