/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundConfirmAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscRefundClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushNewYcPayRefundBillAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundBillAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundClaimConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscRefundClaimConfirmAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscRefundClaimConfirmBusiService;
import com.tydic.fsc.common.busi.api.FscRefundPayClaimConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundPayClaimConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundPayClaimConfirmBusiRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscRefundClaimConfirmAbilityService"})
public class FscRefundClaimConfirmAbilityServiceImpl
implements FscRefundClaimConfirmAbilityService {
    @Autowired
    private FscRefundClaimConfirmBusiService fscRefundClaimConfirmBusiService;
    @Autowired
    private FscRefundPayClaimConfirmBusiService fscRefundPayClaimConfirmBusiService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscBillPayRefundConfirmAbilityService fscBillPayRefundConfirmAbilityService;
    @Autowired
    private FscSyncPushNewYcPayRefundBillAbilityService fscSyncPushNewYcPayRefundBillAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    private static final Integer CONFIRM_TYPE_UP = 2;

    @PostMapping(value={"dealRefundClaimConfirm"})
    public FscRefundClaimConfirmAbilityRspBO dealRefundClaimConfirm(@RequestBody FscRefundClaimConfirmAbilityReqBO reqBO) {
        FscRefundPayClaimConfirmBusiRspBO busiRspBO;
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscRefundPayClaimConfirmBusiReqBO busiReqBO = (FscRefundPayClaimConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscRefundPayClaimConfirmBusiReqBO.class));
        if (CONFIRM_TYPE_UP.equals(reqBO.getConfirmType())) {
            busiRspBO = this.fscRefundPayClaimConfirmBusiService.dealOperationRefundPayClaimConfirm(busiReqBO);
            this.syncEs(busiRspBO.getRefundIdList());
            if (busiRspBO.isClaim()) {
                FscPushNewYcPayRefundBillAbilityReqBO pushReqBO = new FscPushNewYcPayRefundBillAbilityReqBO();
                pushReqBO.setClaimId(reqBO.getClaimId());
                this.fscSyncPushNewYcPayRefundBillAbilityService.syncPushNewYcPayRefundBill(pushReqBO);
            }
        } else {
            busiRspBO = this.fscRefundPayClaimConfirmBusiService.dealRefundPayClaimConfirm(busiReqBO);
        }
        return (FscRefundClaimConfirmAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscRefundClaimConfirmAbilityRspBO.class);
    }

    private void valid(FscRefundClaimConfirmAbilityReqBO reqBO) {
        if (reqBO.getClaimId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getNoClaimAmt() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[noClaimAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getClaimDetailList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[claimDetailList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void syncEs(List<Long> refundIds) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(refundIds);
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }
}

