/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinancePrintInvoiceAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePrintInvoiceAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePrintInvoiceAbilityRspBO;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.utils.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinancePrintInvoiceAbilityService"})
public class FscFinancePrintInvoiceAbilityServiceImpl
implements FscFinancePrintInvoiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePrintInvoiceAbilityServiceImpl.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    public int presentFontSize = 12;

    @PostMapping(value={"dealFinanceInvoicePrint"})
    public FscFinancePrintInvoiceAbilityRspBO dealFinanceInvoicePrint(@RequestBody FscFinancePrintInvoiceAbilityReqBO reqBO) {
        PdfWriter writer;
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", reqBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f");
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", reqBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u5bf9\u63a5\u5171\u4eab\u4fe1\u606f\uff01");
        }
        FscDicDictionaryBO icpBoReq = new FscDicDictionaryBO();
        icpBoReq.setPCode("FSC_FINANCE_PRINT_ICP");
        FscDicDictionaryBO icpBo = this.fscDictionaryBusiService.getDictionaryByBO(icpBoReq);
        FscDicDictionaryBO logoBoReq = new FscDicDictionaryBO();
        logoBoReq.setPCode("FSC_FINANCE_PRINT_LOGO");
        FscDicDictionaryBO logoBo = this.fscDictionaryBusiService.getDictionaryByBO(logoBoReq);
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        }
        catch (DocumentException e) {
            log.error("\u521b\u5efa\u9ed8\u8ba4PDF\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("198888", "\u521b\u5efa\u9ed8\u8ba4PDF\u6a21\u677f\u5931\u8d25!");
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, orderPO, financePO);
        try {
            BaseFont baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontFor11Bold = new Font(baseFont, 11.0f, 1);
            Phrase footer = new Phrase(icpBo.getDescrip(), fontFor11Bold);
            float len = baseFont.getWidthPoint(icpBo.getDescrip(), (float)this.presentFontSize);
            PdfContentByte cb = writer.getDirectContent();
            ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)footer, (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left() - len) / 2.0f + 20.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
        }
        catch (Exception e) {
            log.error("\u5b9a\u4e49\u9875\u811a\u5931\u8d25");
        }
        if (logoBo != null) {
            try (HttpResponse response = HttpUtil.createGet((String)logoBo.getDescrip()).execute();){
                PdfUtils.addLogo((Document)document, (byte[])response.bodyBytes(), (float)100.0f, (float)100.0f, (float)10.0f, (float)500.0f);
            }
            catch (Exception e) {
                throw new FscBusinessException("198888", "\u6dfb\u52a0\u5bf9\u63a5\u5171\u4eab\u6253\u5370\u6a21\u677f\u4e2d\u7164Logo\u5931\u8d25", (Throwable)e);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        FscFinancePrintInvoiceAbilityRspBO rspBO = new FscFinancePrintInvoiceAbilityRspBO();
        rspBO.setPrintUrl(this.uploadFile("\u91c7\u8d2d\u7ed3\u7b97\u5355", outputStream));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void addHeadTable(List<PdfPTable> tableList, FscOrderPO orderPO, FscOrderFinancePO financePO) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u91c7\u8d2d\u7ed3\u7b97\u5355", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable1);
        PdfPTable titleTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u5355\u4f4d:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)financePO.getFinanceOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u90e8\u95e8:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)financePO.getFinanceDeptName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u4eba:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)financePO.getFinanceUserName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        tableList.add(titleTable2);
        PdfPTable titleTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u65e5\u671f:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)DateUtil.dateToStr((Date)orderPO.getCreateTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u7f16\u53f7:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)orderPO.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, (Integer)0);
        tableList.add(titleTable3);
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }
}

