/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bill.ability.api.FscBillSettlAndOrderItemListQueryAbilityService;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinancePurSettlementPrintAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePurSettlementPdfBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePurSettlementPrintReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePurSettlementPrintRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleContractBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleInvoiceBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleItemBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleItemErpBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleWriteItemBO;
import com.tydic.fsc.common.busi.api.FscEsQryComInvoiceListBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscUocOrdRhDetailMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscUocOrdRhDetailPO;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinancePurSettlementPrintAbilityService"})
public class FscFinancePurSettlementPrintAbilityServiceImpl
implements FscFinancePurSettlementPrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePurSettlementPrintAbilityServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    @Autowired
    private FscBillSettlAndOrderItemListQueryAbilityService fscBillSettlAndOrderItemListQueryAbilityService;
    @Autowired
    private FscEsQryComInvoiceListBusiService fscEsQryComInvoiceListBusiService;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscUocOrdRhDetailMapper fscUocOrdRhDetailMapper;
    @Resource
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    private static final String OFF_CONTRACT_CATEGORY_NAME = "\u865a\u62df\u5408\u540c";
    private static final String CON_CONTRACT_CATEGORY_NAME = "\u5408\u540c";
    private static final String AGR_CONTRACT_CATEGORY_NAME = "\u534f\u8bae";

    @PostMapping(value={"purSettlementPrint"})
    public FscFinancePurSettlementPrintRspBO purSettlementPrint(@RequestBody FscFinancePurSettlementPrintReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2OrderId\u4e3a\u7a7a");
        }
        FscFinancePurSettlementPdfBO pdfBO = new FscFinancePurSettlementPdfBO();
        FscFinancePurSettlementPrintRspBO rspBO = new FscFinancePurSettlementPrintRspBO();
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", reqBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f!");
        }
        pdfBO.setSettleAmt(orderPO.getTotalCharge());
        pdfBO.setCreateTimeStr(DateUtil.dateToStr((Date)orderPO.getCreateTime()));
        pdfBO.setSupplierName(orderPO.getPayeeName());
        pdfBO.setOrderNo(orderPO.getOrderNo());
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
        pdfBO.setFinanceDeptName(financePO.getFinanceDeptName());
        pdfBO.setFinanceOrgName(financePO.getFinanceOrgName());
        pdfBO.setFinanceUserName(financePO.getFinanceUserName());
        pdfBO.setExchangeRate(financePO.getExchangeRate());
        pdfBO.setBizItemName(financePO.getBusinessItemName());
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getListByContractId(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List<FscFinancePushSettleContractBO> purSettleContractList = this.buildContractInfo(fscOrderRelationPOList, orderPO, financePO);
        pdfBO.setPurSettleContractList(purSettleContractList);
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
        fscAttachmentPO.setObjType(FscConstants.AttachmentType.FSC_ORDER);
        List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
        pdfBO.setAttachmentNum(Integer.valueOf(fscAttachmentPOList.size()));
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = new FscComApprovalprocessListQryAbilityReqBO();
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.buildPdf(outputStream, approvalList, pdfBO);
        if (reqBO.getMergerFlag().booleanValue()) {
            rspBO.setByteArrayOutputStream(outputStream);
            return rspBO;
        }
        rspBO.setPrintUrl(this.uploadFile("\u91c7\u8d2d\u7ed3\u7b97\u5355", outputStream));
        rspBO.setOrderNo(pdfBO.getOrderNo());
        return rspBO;
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private void buildPdf(ByteArrayOutputStream outputStream, List<FscApprovalprocessListBO> approvalList, FscFinancePurSettlementPdfBO pdfBO) {
        FscDicDictionaryBO icpBoReq = new FscDicDictionaryBO();
        icpBoReq.setPCode("FSC_FINANCE_PRINT_ICP");
        FscDicDictionaryBO icpBo = this.fscDictionaryBusiService.getDictionaryByBO(icpBoReq);
        FscDicDictionaryBO logoBoReq = new FscDicDictionaryBO();
        logoBoReq.setPCode("FSC_FINANCE_PRINT_LOGO");
        FscDicDictionaryBO logoBo = this.fscDictionaryBusiService.getDictionaryByBO(logoBoReq);
        Document document = PdfUtils.newDefaultDocument();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        }
        catch (DocumentException e) {
            log.error("\u521b\u5efa\u9ed8\u8ba4PDF\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, pdfBO);
        this.addMiddleTable(tableList, pdfBO);
        PdfUtils.addAuditTableShare(tableList, approvalList);
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)24, null);
        tableList.add(titleTable1);
        if (icpBo != null) {
            PdfUtils.addIcpTableShare(tableList, (String)icpBo.getDescrip());
        }
        if (logoBo != null) {
            try (HttpResponse response = HttpUtil.createGet((String)logoBo.getDescrip()).execute();){
                PdfUtils.addLogo((Document)document, (byte[])response.bodyBytes(), (float)100.0f, (float)100.0f, (float)10.0f, (float)500.0f);
            }
            catch (Exception e) {
                throw new FscBusinessException("198888", "\u6dfb\u52a0\u5bf9\u63a5\u5171\u4eab\u6253\u5370\u6a21\u677f\u4e2d\u7164Logo\u5931\u8d25", (Throwable)e);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
    }

    public void addHeadTable(List<PdfPTable> tableList, FscFinancePurSettlementPdfBO pdfBO) {
        String title = "\u91c7\u8d2d\u7ed3\u7b97\u5355";
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)title, (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable1);
        PdfPTable titleTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u5355\u4f4d:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)pdfBO.getFinanceOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u90e8\u95e8:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)pdfBO.getFinanceDeptName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u4eba:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)pdfBO.getFinanceUserName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        tableList.add(titleTable2);
        PdfPTable titleTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u65e5\u671f:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)pdfBO.getCreateTimeStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u7f16\u53f7:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)pdfBO.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, (Integer)0);
        tableList.add(titleTable3);
        PdfPTable titleTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable4, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable4);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscFinancePurSettlementPdfBO pdfBO) {
        PdfPTable table1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u4e1a\u52a1\u65e5\u671f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getBizDateStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9644\u4ef6\u5f20\u6570\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getAttachmentNum(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u7ed3\u7b97\u91d1\u989d\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getSettleAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table1);
        PdfPTable table2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u4e1a\u52a1\u4e8b\u9879\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)pdfBO.getBizItemName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table2);
        PdfPTable table3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)pdfBO.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(table3);
        PdfPTable table4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)"\u5408\u540c\u4fe1\u606f", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table4);
        PdfPTable table5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u7c7b\u578b", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u672a\u7ed3\u7b97\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table5);
        for (FscFinancePushSettleContractBO fscFinancePushSettleContractBO : pdfBO.getPurSettleContractList()) {
            PdfPTable table5list = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table5list, (Object)fscFinancePushSettleContractBO.getContractCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table5list, (Object)fscFinancePushSettleContractBO.getContractName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table5list, (Object)fscFinancePushSettleContractBO.getSegContractName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table5list, (Object)fscFinancePushSettleContractBO.getContractAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table5list, (Object)fscFinancePushSettleContractBO.getContractAmt().subtract(fscFinancePushSettleContractBO.getSettleLocalAmt()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table5list, (Object)fscFinancePushSettleContractBO.getSettleLocalAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(table5list);
        }
        PdfPTable table6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u53d1\u7968\u660e\u7ec6", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table6);
        PdfPTable table7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u53d1\u7968\u53f7\u7801", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u53d1\u7968\u7c7b\u578b", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u4e0d\u542b\u7a0e\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u7a0e\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u542b\u7a0e\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        tableList.add(table7);
        for (FscFinancePushSettleContractBO contractBO : pdfBO.getPurSettleContractList()) {
            for (FscFinancePushSettleInvoiceBO invoiceBO : contractBO.getInvoiceList()) {
                PdfPTable table7list = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)table7list, (Object)invoiceBO.getInvoiceNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table7list, (Object)invoiceBO.getInvoiceType(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)table7list, (Object)invoiceBO.getRmbAmount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)table7list, (Object)invoiceBO.getRmbTax(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)table7list, (Object)invoiceBO.getRmbAmountTax(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                tableList.add(table7list);
            }
        }
        PdfPTable table8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table8, (Object)"\u7ed3\u7b97\u660e\u7ec6\uff08\u5339\u914dERP\u8ba2\u5355\uff09", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table8);
        PdfPTable table9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u5339\u914d\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u542b\u7a0e\u603b\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u4e0d\u542b\u7a0e\u603b\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u7a0e\u7387", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u7a0e\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table9);
        for (FscFinancePushSettleContractBO contractBO : pdfBO.getPurSettleContractList()) {
            for (FscFinancePushSettleItemErpBO erpBO : contractBO.getSettleEbdetailList()) {
                PdfPTable table9list = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)table9list, (Object)erpBO.getPurchaseBillCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table9list, (Object)erpBO.getMatchAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table9list, (Object)erpBO.getAllTaxAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table9list, (Object)erpBO.getAllAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table9list, (Object)erpBO.getTaxRateVal(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table9list, (Object)erpBO.getTaxAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(table9list);
            }
        }
        PdfPTable table10 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table10, (Object)"\u7ed3\u7b97\u660e\u7ec6", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table10);
        PdfPTable table11 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table11, (Object)"\u7ed3\u7b97\u4e8b\u9879", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table11, (Object)"\u542b\u7a0e\u603b\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table11, (Object)"\u4e0d\u542b\u7a0e\u603b\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table11, (Object)"\u7a0e\u7387", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table11, (Object)"\u7a0e\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table11, (Object)"\u6210\u672c\u4e2d\u5fc3", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table11);
        for (FscFinancePushSettleContractBO contractBO : pdfBO.getPurSettleContractList()) {
            for (FscFinancePushSettleItemBO itemBO : contractBO.getSettleNodetailList()) {
                PdfPTable table11list = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)table11list, (Object)itemBO.getSettleItemName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table11list, (Object)itemBO.getAllTaxAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table11list, (Object)itemBO.getAllAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table11list, (Object)itemBO.getTaxRateVal(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table11list, (Object)itemBO.getTaxAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table11list, (Object)itemBO.getSegCalcCostName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(table11list);
            }
        }
        PdfPTable table12 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table12, (Object)"\u6838\u9500\u9884\u4ed8\u660e\u7ec6", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table12);
        PdfPTable table13 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table13, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table13, (Object)"\u9884\u4ed8\u6b3e\u5355\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table13, (Object)"\u9884\u4ed8\u6b3e\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table13, (Object)"\u5269\u4f59\u672a\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table13, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        tableList.add(table13);
        int sortNum = 1;
        for (FscFinancePushSettleContractBO contractBO : pdfBO.getPurSettleContractList()) {
            for (FscFinancePushSettleWriteItemBO writeItemBO : contractBO.getAdvCheckList()) {
                PdfPTable table13list = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)table13list, (Object)sortNum, (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)table13list, (Object)writeItemBO.getApplyBillCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)table13list, (Object)writeItemBO.getAdvPayAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)table13list, (Object)writeItemBO.getAdvUncheckAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                PdfUtils.addCellToTable((PdfPTable)table13list, (Object)writeItemBO.getCheckAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
                tableList.add(table13list);
                ++sortNum;
            }
        }
    }

    private List<FscFinancePushSettleContractBO> buildContractInfo(List<FscOrderRelationPO> fscOrderRelationPOList, FscOrderPO orderPO, FscOrderFinancePO financePO) {
        ArrayList<FscFinancePushSettleContractBO> purSettleContractList = new ArrayList<FscFinancePushSettleContractBO>();
        List<Long> contractIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getContractId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u65e0\u5408\u540c\u4fe1\u606f\uff0c\u65e0\u9700\u63a8\u9001");
        }
        Map relationPOMap = fscOrderRelationPOList.stream().sorted(Comparator.comparingLong(FscOrderRelationPO::getId)).collect(Collectors.toMap(FscOrderRelationPO::getContractId, Function.identity(), (k1, k2) -> k1));
        List orderIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setOrderIdList(orderIds);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setPageSize(10000);
        saleDetailsReqBO.setIsAfterSales(Boolean.valueOf(false));
        if (FscConstants.FscOrderType.FL.equals(orderPO.getOrderType())) {
            saleDetailsReqBO.setIndividually("4");
        }
        log.debug("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        log.debug("\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saleDetailsRspBO));
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u7269\u6599\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + saleDetailsRspBO.getRespDesc());
        }
        Map orderInfoMap = saleDetailsRspBO.getRows().stream().map(e -> (UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).collect(Collectors.toMap(UocPebChildOrderAbilityBO::getOrderId, Function.identity(), (k1, k2) -> k1));
        FscFinanceSelectContractAmountReqBO fscFinanceSelectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
        fscFinanceSelectContractAmountReqBO.setContractIds(contractIds);
        FscFinanceSelectContractAmountRspBo fscFinanceSelectContractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(fscFinanceSelectContractAmountReqBO);
        if (Objects.nonNull(fscFinanceSelectContractAmountRspBo) && !"0000".equals(fscFinanceSelectContractAmountRspBo.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u670d\u52a1\u5f02\u5e38\uff01");
        }
        Map<Object, Object> contractMap = CollectionUtils.isEmpty((Collection)fscFinanceSelectContractAmountRspBo.getRows()) ? new HashMap() : fscFinanceSelectContractAmountRspBo.getRows().stream().collect(Collectors.toMap(FscFinanceSelectContractAmountRspBoList::getContractId, Function.identity(), (k1, k2) -> k1));
        contractIds.forEach(contractId -> {
            if (!relationPOMap.containsKey(contractId)) {
                throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38\uff01");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(orderPO.getFscOrderId());
            fscOrderItemPO.setContractId(contractId);
            List fscOrderItemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u660e\u7ec6\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
            }
            BigDecimal settleAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setFscOrderId(orderPO.getFscOrderId());
            fscInvoicePO.setContractId(contractId);
            List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
            if (CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\u53d1\u7968\u5217\u8868\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01\u5408\u540c\u7f16\u7801\uff1a" + ((FscOrderRelationPO)relationPOMap.get(contractId)).getContractNo());
            }
            FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
            fscFinanceWriteOffPO.setFscOrderId(orderPO.getFscOrderId());
            fscFinanceWriteOffPO.setContractId(contractId);
            List fscFinanceWriteOffPOList = this.fscFinanceWriteOffMapper.getList(fscFinanceWriteOffPO);
            List<FscFinancePushSettleInvoiceBO> invoiceList = this.buildInvoiceInfo(fscInvoicePOList);
            ArrayList<FscFinancePushSettleItemErpBO> settleEbdetailList = new ArrayList<FscFinancePushSettleItemErpBO>();
            ArrayList<FscFinancePushSettleItemBO> settleNodetailList = new ArrayList<FscFinancePushSettleItemBO>();
            this.buildSettleItem(fscOrderItemPOList, orderInfoMap, financePO, settleEbdetailList, settleNodetailList);
            List<Object> advCheckList = new ArrayList();
            BigDecimal writeOffAmt = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)fscFinanceWriteOffPOList)) {
                writeOffAmt = fscFinanceWriteOffPOList.stream().map(FscFinanceWriteOffPO::getWriteOffAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                advCheckList = this.buildWriteOff(fscFinanceWriteOffPOList, financePO);
            }
            FscFinancePushSettleContractBO contractBO = new FscFinancePushSettleContractBO();
            contractBO.setContractId(String.valueOf(contractId));
            contractBO.setGuid(String.valueOf(((FscOrderRelationPO)relationPOMap.get(contractId)).getId()));
            contractBO.setContractCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractNo());
            if (contractMap.containsKey(contractId)) {
                contractBO.setContractName(((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getContractName());
                contractBO.setContractAmt(((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getContractAmount());
                if (!StringUtils.isEmpty((Object)((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getOutContractId())) {
                    contractBO.setContractId(((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getOutContractId());
                }
            } else {
                contractBO.setContractName(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractName());
            }
            contractBO.setSettleAmt(settleAmt);
            contractBO.setSettleLocalAmt(settleAmt.multiply(financePO.getExchangeRate()));
            contractBO.setCheckAdvPayAmt(writeOffAmt);
            contractBO.setCheckAdvPayLocalAmt(writeOffAmt.multiply(financePO.getExchangeRate()));
            contractBO.setSegContractCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractSegmentCode());
            contractBO.setSegContractName(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractSegmentName());
            contractBO.setTaxAmt(taxAmt);
            contractBO.setTaxLocalAmt(taxAmt.multiply(financePO.getExchangeRate()));
            String contractType = ((FscOrderRelationPO)relationPOMap.get(contractId)).getContractType();
            if ("3".equals(contractType)) {
                contractBO.setSegContractName(OFF_CONTRACT_CATEGORY_NAME);
            } else if ("2".equals(contractType)) {
                contractBO.setSegContractName(CON_CONTRACT_CATEGORY_NAME);
            } else if ("1".equals(contractType)) {
                contractBO.setSegContractName(AGR_CONTRACT_CATEGORY_NAME);
            }
            contractBO.setInvoiceList(invoiceList);
            contractBO.setSettleEbdetailList(settleEbdetailList);
            contractBO.setSettleNodetailList(settleNodetailList);
            contractBO.setAdvCheckList(advCheckList);
            purSettleContractList.add(contractBO);
        });
        return purSettleContractList;
    }

    private List<FscFinancePushSettleInvoiceBO> buildInvoiceInfo(List<FscInvoicePO> fscInvoicePOList) {
        ArrayList<FscFinancePushSettleInvoiceBO> invoiceList = new ArrayList<FscFinancePushSettleInvoiceBO>();
        fscInvoicePOList.forEach(invoice -> {
            if (Objects.isNull(invoice.getFinanceGuid())) {
                throw new FscBusinessException("198888", "\u5b58\u5728\u53d1\u7968\u672a\u4e0a\u4f20\u5171\u4eab\u7968\u5939\uff0c\u53d1\u7968ID\uff1a" + invoice.getInvoiceId());
            }
            FscFinancePushSettleInvoiceBO fscFinancePushSettleInvoiceBO = new FscFinancePushSettleInvoiceBO();
            fscFinancePushSettleInvoiceBO.setOriginGuid(invoice.getFinanceGuid());
            fscFinancePushSettleInvoiceBO.setGuid(String.valueOf(invoice.getInvoiceId()));
            if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010100");
            } else if ("00".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010101");
            } else if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010102");
            } else if ("00".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010107");
            } else if ("03".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010108");
            } else if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010108");
            }
            if (Objects.nonNull(invoice.getFullElecNo()) && FscConstants.FscInvoiceCategory.FULL.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceNo(invoice.getFullElecNo());
            } else {
                fscFinancePushSettleInvoiceBO.setInvoiceNo(invoice.getInvoiceNo());
            }
            fscFinancePushSettleInvoiceBO.setInvoiceCode(invoice.getInvoiceCode());
            if (!StringUtils.isEmpty((Object)invoice.getBillDate()) && invoice.getBillDate().length() > 10) {
                fscFinancePushSettleInvoiceBO.setInvoiceDate(invoice.getBillDate().substring(0, 10));
            } else {
                fscFinancePushSettleInvoiceBO.setInvoiceDate(invoice.getBillDate());
            }
            fscFinancePushSettleInvoiceBO.setInvoiceHeader(invoice.getBuyName());
            fscFinancePushSettleInvoiceBO.setRmbAmount(invoice.getUntaxAmt());
            fscFinancePushSettleInvoiceBO.setRmbTax(invoice.getTaxAmt());
            fscFinancePushSettleInvoiceBO.setRmbAmountTax(invoice.getAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccAmountTax(invoice.getAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccAmount(invoice.getUntaxAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccTax(invoice.getTaxAmt());
            fscFinancePushSettleInvoiceBO.setIsSimpleTax(invoice.getIsSimpleTax());
            fscFinancePushSettleInvoiceBO.setIsInputOut(invoice.getIsInputOut());
            fscFinancePushSettleInvoiceBO.setInputOutAmt(invoice.getIsInputOutAmt());
            fscFinancePushSettleInvoiceBO.setInputOutTypeCode(invoice.getInputOutTypeCode());
            fscFinancePushSettleInvoiceBO.setInputOutTypeName(invoice.getInputOutTypeName());
            invoiceList.add(fscFinancePushSettleInvoiceBO);
        });
        return invoiceList;
    }

    private void buildSettleItem(List<FscOrderItemPO> fscOrderItemPOList, Map<String, UocPebChildOrderAbilityBO> orderInfoMap, FscOrderFinancePO financePO, List<FscFinancePushSettleItemErpBO> settleEbdetailList, List<FscFinancePushSettleItemBO> settleNodetailList) {
        List ordItemIdList = fscOrderItemPOList.stream().map(FscOrderItemPO::getOrdItemId).collect(Collectors.toList());
        FscUocOrdRhDetailPO fscUocOrdRhDetailPO = new FscUocOrdRhDetailPO();
        fscUocOrdRhDetailPO.setOrdItemIdList(ordItemIdList);
        List rhDetailPOList = this.fscUocOrdRhDetailMapper.getList(fscUocOrdRhDetailPO);
        Map<Object, Object> rhDetailPOMap = CollectionUtils.isEmpty((Collection)rhDetailPOList) ? new HashMap() : rhDetailPOList.stream().collect(Collectors.toMap(FscUocOrdRhDetailPO::getOrdItemId, Function.identity(), (k1, k2) -> k1));
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setFscOrderId(financePO.getFscOrderId());
        List fscInvoiceItemPOList = this.fscInvoiceItemMapper.getList(fscInvoiceItemPO);
        Map<Object, Object> invoiceItemPOMap = CollectionUtils.isEmpty(fscOrderItemPOList) ? new HashMap() : fscInvoiceItemPOList.stream().collect(Collectors.toMap(FscInvoiceItemPO::getOrderItemId, Function.identity(), (k1, k2) -> k1));
        fscOrderItemPOList.forEach(item -> {
            if (!orderInfoMap.containsKey(String.valueOf(item.getOrderId()))) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u660e\u7ec6\u672a\u5339\u914d\u5230\u8ba2\u5355\u4fe1\u606f\uff01\u7ed3\u7b97\u660e\u7ec6ID\uff1a" + item.getId());
            }
            UocPebChildOrderAbilityBO orderInfo = (UocPebChildOrderAbilityBO)orderInfoMap.get(String.valueOf(item.getOrderId()));
            Map orderItemMap = orderInfo.getOrderItemList().stream().collect(Collectors.toMap(UocPebOrderItemAbilityBO::getOrderItemId, Function.identity(), (k1, k2) -> k1));
            FscFinancePushSettleItemErpBO erpBO = new FscFinancePushSettleItemErpBO();
            erpBO.setGuid(String.valueOf(item.getId()));
            erpBO.setSegCompanyCode(null);
            erpBO.setSegCompanyName(null);
            erpBO.setSegProductCode(item.getProductSegmentCode());
            erpBO.setSegProductName(item.getProductSegmentName());
            erpBO.setSegProjectCode(item.getProjectCode());
            erpBO.setSegProjectName(item.getProjectName());
            erpBO.setSegContractCode(financePO.getContractSegmentCode());
            erpBO.setSegContractName(financePO.getContractSegmentName());
            erpBO.setSegMainSubjectCode(null);
            erpBO.setSegMainSubjectName(null);
            erpBO.setSegSubSubjectCode(null);
            erpBO.setSegSubSubjectName(null);
            erpBO.setSegCorrespondentCode(null);
            erpBO.setSegCorrespondentName(null);
            erpBO.setSegCalcCostCode(item.getCostCenterCode());
            erpBO.setSegCalcCostName(item.getCostCenterName());
            erpBO.setSegProduceStageCode(item.getProductionLinkCode());
            erpBO.setSegProduceStageName(item.getProductionLinkName());
            erpBO.setSegBakCode(null);
            erpBO.setSegBakName(null);
            if (orderInfo.getIsPushErp() != 1) {
                erpBO.setSettleItemCode(item.getSettleItemCode());
                erpBO.setSettleItemName(item.getSettleItemName());
                erpBO.setIsSimpleTax(Objects.isNull(item.getIsSimpleTax()) ? "" : String.valueOf(item.getIsSimpleTax()));
                erpBO.setIsInputOut(Objects.isNull(item.getIsInputOut()) ? "" : String.valueOf(item.getIsInputOut()));
                erpBO.setInputOutAmt(item.getIsInputOutAmt());
                erpBO.setInputOutTypeCode(null);
                erpBO.setInputOutTypeName(null);
            }
            erpBO.setIsErp(orderInfo.getIsPushErp() == 1 ? "1" : "0");
            erpBO.setPurchaseBillCode(orderInfo.getSaleVoucherNo());
            erpBO.setBudgetItemCode(item.getBudgetItemCode());
            erpBO.setBudgetItemName(item.getBudgetItemName());
            erpBO.setBudgetItemRemainAmt(item.getBudgetLeaveAmt());
            erpBO.setMaterialCode(item.getSkuNo());
            if (Objects.nonNull(item.getOrdItemId()) && !CollectionUtils.isEmpty(orderItemMap) && orderItemMap.containsKey(String.valueOf(item.getOrdItemId()))) {
                UocPebOrderItemAbilityBO uocPebOrderItemAbilityBO = (UocPebOrderItemAbilityBO)orderItemMap.get(String.valueOf(item.getOrdItemId()));
                if (!StringUtils.isEmpty((Object)uocPebOrderItemAbilityBO.getPlanItemCode())) {
                    erpBO.setMaterialName(uocPebOrderItemAbilityBO.getPlanItemName());
                } else if (!StringUtils.isEmpty((Object)uocPebOrderItemAbilityBO.getSkuMaterialLongDesc())) {
                    erpBO.setMaterialName(uocPebOrderItemAbilityBO.getSkuMaterialLongDesc());
                }
            }
            if (StringUtils.isEmpty((Object)erpBO.getMaterialName())) {
                erpBO.setMaterialName(item.getSkuName());
            }
            erpBO.setUnitCode(null);
            erpBO.setUnitName(item.getSettleUnit());
            erpBO.setRemainNum(orderInfo.getDownTotalLeaveInvoiceNum());
            if (!CollectionUtils.isEmpty((Map)invoiceItemPOMap) && invoiceItemPOMap.containsKey(item.getOrderItemId())) {
                erpBO.setDiffNum(((FscInvoiceItemPO)invoiceItemPOMap.get(item.getOrderItemId())).getUntaxAmt().subtract(item.getUntaxAmt()));
            } else {
                erpBO.setDiffNum(BigDecimal.ZERO);
            }
            erpBO.setMatchAmt(item.getUntaxAmt());
            erpBO.setMatchLocalAmt(item.getAmt().multiply(financePO.getExchangeRate()));
            erpBO.setMatchNum(item.getNum());
            if (Objects.isNull(item.getTaxRate())) {
                throw new FscBusinessException("198888", "\u7ed3\u7b97\u660e\u7ec6\u7a0e\u7387\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01\u7ed3\u7b97\u660e\u7ec6ID\uff1a" + item.getId());
            }
            erpBO.setUnitPrice(item.getPrice().divide(BigDecimal.ONE.add(item.getTaxRate()), 8, RoundingMode.HALF_UP));
            erpBO.setUnitTaxPrice(item.getPrice());
            erpBO.setUnitLocalPrice(erpBO.getUnitPrice().multiply(financePO.getExchangeRate()));
            erpBO.setUnitLocalTaxPrice(item.getPrice().multiply(financePO.getExchangeRate()));
            erpBO.setAllAmt(item.getUntaxAmt());
            erpBO.setAllTaxAmt(item.getAmt());
            erpBO.setAllLocalAmt(item.getUntaxAmt().multiply(financePO.getExchangeRate()));
            erpBO.setAllLocalTaxAmt(item.getAmt().multiply(financePO.getExchangeRate()));
            erpBO.setTaxRateCode(Objects.nonNull(item.getTaxRate()) ? String.valueOf(item.getTaxRate().setScale(0, RoundingMode.HALF_UP)) : null);
            erpBO.setTaxRateName(item.getTaxRate().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + "%");
            erpBO.setTaxRateVal(Objects.nonNull(item.getTaxRate()) ? item.getTaxRate().setScale(2, RoundingMode.HALF_UP) : null);
            erpBO.setTaxAmt(item.getTaxAmt());
            erpBO.setTaxLocalAmt(item.getTaxAmt().multiply(financePO.getExchangeRate()));
            if (orderInfo.getIsPushErp() == 1 && !CollectionUtils.isEmpty((Map)rhDetailPOMap)) {
                if (rhDetailPOMap.containsKey(item.getOrdItemId())) {
                    erpBO.setReceiveNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getReceiveNum());
                    erpBO.setReceiptNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getReceiptNum());
                    erpBO.setReceiveAreaCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getRecvAddressCode());
                    erpBO.setReceiveAreaName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getRecvAddressName());
                    erpBO.setDistributeSubjectCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getDistributeSubjectCode());
                    erpBO.setDistributeSubjectName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getDistributeSubjectName());
                    erpBO.setReceived(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getQuantity());
                    erpBO.setShipToOrgId(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getOrdItemId())).getShipToOrgId());
                } else if (rhDetailPOMap.containsKey(item.getUpperOrdItemId())) {
                    erpBO.setReceiveNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getReceiveNum());
                    erpBO.setReceiptNum(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getReceiptNum());
                    erpBO.setReceiveAreaCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getRecvAddressCode());
                    erpBO.setReceiveAreaName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getRecvAddressName());
                    erpBO.setDistributeSubjectCode(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getDistributeSubjectCode());
                    erpBO.setDistributeSubjectName(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getDistributeSubjectName());
                    erpBO.setReceived(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getQuantity());
                    erpBO.setShipToOrgId(((FscUocOrdRhDetailPO)rhDetailPOMap.get(item.getUpperOrdItemId())).getShipToOrgId());
                    if (!StringUtils.isEmpty((Object)item.getUpperOrderNo())) {
                        erpBO.setPurchaseBillCode(item.getUpperOrderNo());
                    }
                }
            }
            settleEbdetailList.add(erpBO);
        });
    }

    private List<FscFinancePushSettleWriteItemBO> buildWriteOff(List<FscFinanceWriteOffPO> fscFinanceWriteOffPOList, FscOrderFinancePO financePO) {
        ArrayList<FscFinancePushSettleWriteItemBO> advCheckList = new ArrayList<FscFinancePushSettleWriteItemBO>();
        List payOrderIdList = fscFinanceWriteOffPOList.stream().map(FscFinanceWriteOffPO::getPayOrderId).collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(payOrderIdList);
        fscFinanceWriteOffPOList.forEach(e -> {
            FscFinancePushSettleWriteItemBO writeItemBO = new FscFinancePushSettleWriteItemBO();
            writeItemBO.setGuid(String.valueOf(e.getWriteOffId()));
            writeItemBO.setApplyBillGuid(Objects.isNull(e.getPayOrderId()) ? "" : String.valueOf(e.getPayOrderId()));
            writeItemBO.setApplyBillCode(e.getPayOrderNo());
            writeItemBO.setAdvPayAmt(e.getPayAmt());
            writeItemBO.setAdvUncheckAmt(e.getLeaveWriteOffAmount());
            writeItemBO.setAdvUncheckLocalAmt(e.getLeaveWriteOffAmountLocal());
            writeItemBO.setCheckAmt(e.getWriteOffAmt());
            writeItemBO.setAdvPayLocalAmt(e.getPayAmtLocal());
            writeItemBO.setCheckLocalAmt(e.getWriteOffAmtLocal());
            writeItemBO.setWriteOffId(String.valueOf(e.getWriteOffId()));
            writeItemBO.setRate(financePO.getExchangeRate());
            advCheckList.add(writeItemBO);
        });
        return advCheckList;
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }
}

