/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscComOrderPayDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinancePurchaseShouldPayPrintAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscComOrderPayDetailPayItemListBO;
import com.tydic.fsc.common.ability.bo.finance.FscComOrderPayDetailQueryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscComOrderPayDetailQueryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePurchaseShouldPayPrintReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePurchaseShouldPayPrintRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayQueryShouldPayListAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayQueryShouldPayListAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayQueryShouldPayListAbilityRspBO;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.utils.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinancePurchaseShouldPayPrintAbilityService"})
public class FscFinancePurchaseShouldPayPrintAbilityServiceImpl
implements FscFinancePurchaseShouldPayPrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePurchaseShouldPayPrintAbilityServiceImpl.class);
    @Autowired
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    @Autowired
    private FscComOrderPayDetailQueryAbilityService fscComOrderPayDetailQueryAbilityService;
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private FscPayQueryShouldPayListAbilityService fscPayQueryShouldPayListAbilityService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";

    @PostMapping(value={"fscFinancePurchaseShouldPayPrint"})
    public FscFinancePurchaseShouldPayPrintRspBO fscFinancePurchaseShouldPayPrint(@RequestBody FscFinancePurchaseShouldPayPrintReqBO reqBo) {
        FscFinancePurchaseShouldPayPrintRspBO rspBO = new FscFinancePurchaseShouldPayPrintRspBO();
        this.valid(reqBo);
        FscComOrderDetailQueryAbilityReqBO fscComOrderDetailQueryAbilityReqBO = new FscComOrderDetailQueryAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)fscComOrderDetailQueryAbilityReqBO);
        fscComOrderDetailQueryAbilityReqBO.setOrderId(reqBo.getFscOrderId());
        FscComOrderDetailQueryAbilityRspBO detailBo = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(fscComOrderDetailQueryAbilityReqBO);
        log.info("\u8be6\u60c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)detailBo));
        if (!"0000".equals(detailBo.getRespCode())) {
            throw new FscBusinessException("198888", detailBo.getRespDesc());
        }
        ArrayList<FscShouldPayBO> shouldPayList = new ArrayList();
        FscPayQueryShouldPayListAbilityReqBO fscPayQueryShouldPayListAbilityReqBO = new FscPayQueryShouldPayListAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)fscPayQueryShouldPayListAbilityReqBO);
        fscPayQueryShouldPayListAbilityReqBO.setFscOrderIds((List)Lists.newArrayList((Object[])new Long[]{reqBo.getFscOrderId()}));
        fscPayQueryShouldPayListAbilityReqBO.setSkipCheckOperFlag(Boolean.valueOf(true));
        fscPayQueryShouldPayListAbilityReqBO.setPageSize(Integer.valueOf(9999));
        FscPayQueryShouldPayListAbilityRspBO fscPayQueryShouldPayListAbilityRspBO = this.fscPayQueryShouldPayListAbilityService.qryShouldPayList(fscPayQueryShouldPayListAbilityReqBO);
        if ("0000".equals(fscPayQueryShouldPayListAbilityRspBO.getRespCode())) {
            shouldPayList = fscPayQueryShouldPayListAbilityRspBO.getRows();
        }
        ArrayList<FscComOrderPayDetailPayItemListBO> payDetailList = new ArrayList();
        FscComOrderPayDetailQueryReqBO fscComOrderPayDetailQueryReqBO = new FscComOrderPayDetailQueryReqBO();
        fscComOrderPayDetailQueryReqBO.setOrderId(reqBo.getFscOrderId().toString());
        fscComOrderPayDetailQueryReqBO.setPageSize(Integer.valueOf(9999));
        FscComOrderPayDetailQueryRspBO fscComOrderPayDetailQueryRspBO = this.fscComOrderPayDetailQueryAbilityService.qryOrderPayDetail(fscComOrderPayDetailQueryReqBO);
        if ("0000".equals(fscComOrderPayDetailQueryRspBO.getRespCode())) {
            payDetailList = fscComOrderPayDetailQueryRspBO.getRows();
        }
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = new FscComApprovalprocessListQryAbilityReqBO();
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBo.getFscOrderId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(1));
        List approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
        }
        FscDicDictionaryBO icpBoReq = new FscDicDictionaryBO();
        icpBoReq.setPCode("FSC_FINANCE_PRINT_ICP");
        FscDicDictionaryBO icpBo = this.fscDictionaryBusiService.getDictionaryByBO(icpBoReq);
        FscDicDictionaryBO logoBoReq = new FscDicDictionaryBO();
        logoBoReq.setPCode("FSC_FINANCE_PRINT_LOGO");
        FscDicDictionaryBO logoBo = this.fscDictionaryBusiService.getDictionaryByBO(logoBoReq);
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        }
        catch (DocumentException e) {
            log.error("\u521b\u5efa\u9ed8\u8ba4PDF\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, detailBo);
        this.addMiddleTable(tableList, payDetailList, detailBo, shouldPayList);
        PdfUtils.addAuditTableShare(tableList, approvalList);
        if (icpBo != null) {
            PdfUtils.addIcpTableShare(tableList, (String)icpBo.getDescrip());
        }
        if (logoBo != null) {
            try (HttpResponse response = HttpUtil.createGet((String)logoBo.getDescrip()).execute();){
                PdfUtils.addLogo((Document)document, (byte[])response.bodyBytes(), (float)100.0f, (float)100.0f, (float)10.0f, (float)500.0f);
            }
            catch (Exception e) {
                throw new FscBusinessException("198888", "\u6dfb\u52a0\u5bf9\u63a5\u5171\u4eab\u6253\u5370\u6a21\u677f\u4e2d\u7164Logo\u5931\u8d25", (Throwable)e);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        if (reqBo.getMergerFlag().booleanValue()) {
            rspBO.setByteArrayOutputStream(outputStream);
            return rspBO;
        }
        rspBO.setPrintUrl(this.uploadFile("\u91c7\u8d2d\u4ed8\u6b3e\u5355\u636e", outputStream));
        rspBO.setOrderNo(detailBo.getOrderNo());
        return rspBO;
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    public void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO detailBo) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u91c7\u8d2d\u4ed8\u6b3e\u7533\u8bf7\u5355", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable1);
        PdfPTable titleTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u5355\u4f4d:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)detailBo.getFinanceOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u90e8\u95e8:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)detailBo.getFinanceDeptName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u4eba:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)detailBo.getFinanceUserName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        tableList.add(titleTable2);
        PdfPTable titleTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u65e5\u671f:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)DateUtil.dateToStr((Date)detailBo.getCreateTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u7f16\u53f7:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)detailBo.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, (Integer)0);
        tableList.add(titleTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, List<FscComOrderPayDetailPayItemListBO> payDetailList, FscComOrderDetailQueryAbilityRspBO detailBo, List<FscShouldPayBO> shouldPayList) {
        PdfPTable table1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u4e1a\u52a1\u65e5\u671f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)DateUtil.dateToStr((Date)detailBo.getBusinessDate()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9644\u4ef6\u5f20\u6570\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)(detailBo.getAttachmentList() == null ? Integer.valueOf(0) : detailBo.getAttachmentList().size() + "\u5f20"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9884\u4ed8\u91d1\u989d\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)detailBo.getTotalCharge(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table1);
        PdfPTable table2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u4e1a\u52a1\u4e8b\u9879\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)detailBo.getBusinessItemName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)12, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u662f\u5426\u4ee3\u4ed8\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)detailBo.getIsAgentStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table2);
        PdfPTable table3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)detailBo.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u5e01\u79cd\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)detailBo.getCurrency(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u6c47\u7387\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)detailBo.getExchangeRate(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table3);
        PdfPTable table4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)"\u6838\u51cf\u91d1\u989d\uff08\u539f\u5e01\uff09\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)(detailBo.getReduceAmt() == null ? Integer.valueOf(0) : detailBo.getReduceAmt().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)"\u9884\u8ba1\u4ed8\u6b3e\u65e5\u671f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)DateUtil.dateToStr((Date)detailBo.getPayDate()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)"\u4ed8\u6b3e\u7c7b\u578b\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)detailBo.getPaymentTypeStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table4);
        PdfPTable table5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u7ed3\u7b97\u4fe1\u606f", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table5);
        PdfPTable table6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u7ed3\u7b97\u5355\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u7ed3\u7b97\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u7ed3\u7b97\u672a\u4ed8\u6b3e\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u4ed8\u6b3e\u9636\u6bb5", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
        tableList.add(table6);
        List sortedShouldPayList = shouldPayList.stream().sorted(Comparator.comparing(FscShouldPayBO::getItemNo)).collect(Collectors.toList());
        for (FscShouldPayBO shouldPay : sortedShouldPayList) {
            PdfPTable table7 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)shouldPay.getObjectNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)shouldPay.getContractNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)shouldPay.getContractName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)(shouldPay.getPayAmount() == null ? Integer.valueOf(0) : shouldPay.getPayAmount().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)(shouldPay.getPaidAmount() == null ? Integer.valueOf(0) : shouldPay.getPaidAmount().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)(shouldPay.getToPayAmount() == null ? Integer.valueOf(0) : shouldPay.getToPayAmount().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)table7, (Object)shouldPay.getPaymentPhaseStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
            tableList.add(table7);
        }
        PdfPTable table8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table8, (Object)"\u6536\u4ed8\u6b3e\u4fe1\u606f", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table8);
        PdfPTable table9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u6536\u6b3e\u65b9\u540d\u79f0", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u6536\u6b3e\u65b9\u5f00\u6237\u884c", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u6536\u6b3e\u65b9\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u4ed8\u6b3e\u8d26\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table9, (Object)"\u652f\u4ed8\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table9);
        int sortNum = 1;
        List collect = payDetailList.stream().sorted(Comparator.comparing(FscComOrderPayDetailPayItemListBO::getPayItemNo)).collect(Collectors.toList());
        for (FscComOrderPayDetailPayItemListBO payDetail : collect) {
            PdfPTable table10 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table10, (Object)sortNum, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table10, (Object)payDetail.getRecvBankAccountName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table10, (Object)payDetail.getRecvBankName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table10, (Object)payDetail.getRecvBankAccount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table10, (Object)payDetail.getPayerBankAccountNum(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table10, (Object)(payDetail.getPayAmount() == null ? Integer.valueOf(0) : payDetail.getPayAmount().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(table10);
            ++sortNum;
        }
    }

    private void valid(FscFinancePurchaseShouldPayPrintReqBO reqBo) {
        if (null == reqBo) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2fscOrderId\u4e3a\u7a7a");
        }
    }
}

