/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceQueryRefundReturnItemAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceQueryRefundReturnItemListRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceQueryRefundReturnItemReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceQueryRefundReturnItemRspBO;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemTempPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceQueryRefundReturnItemAbilityService"})
public class FscFinanceQueryRefundReturnItemAbilityServiceImpl
implements FscFinanceQueryRefundReturnItemAbilityService {
    @Resource
    private FscFinanceRefundItemTempMapper fscFinanceRefundItemTempMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryRefundReturnItem"})
    public FscFinanceQueryRefundReturnItemRspBO qryRefundReturnItem(@RequestBody FscFinanceQueryRefundReturnItemReqBO reqBo) {
        this.valid(reqBo);
        FscFinanceRefundItemTempPO fscFinanceRefundItemTempReq = new FscFinanceRefundItemTempPO();
        fscFinanceRefundItemTempReq.setTempId(reqBo.getTempId());
        fscFinanceRefundItemTempReq.setContractId(reqBo.getContractId());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List listPage = this.fscFinanceRefundItemTempMapper.getListPage(fscFinanceRefundItemTempReq, page);
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscFinanceQueryRefundReturnItemListRspBO.class);
        this.buildFinanceRefundItem(rows, reqBo.getQryType());
        BigDecimal sumRefundAmt = BigDecimal.ZERO;
        BigDecimal sumRefundAmtLocal = BigDecimal.ZERO;
        BigDecimal sumNoRefundAmt = BigDecimal.ZERO;
        BigDecimal sumNoRefundAmtLocal = BigDecimal.ZERO;
        for (FscFinanceQueryRefundReturnItemListRspBO bo : rows) {
            sumRefundAmt = sumRefundAmt.add(bo.getRefundAmt());
            sumRefundAmtLocal = sumRefundAmtLocal.add(bo.getRefundAmtLocal());
            sumNoRefundAmt = sumNoRefundAmt.add(bo.getNoRefundAmt());
            sumNoRefundAmtLocal = sumNoRefundAmtLocal.add(bo.getNoRefundAmtLocal());
        }
        FscFinanceQueryRefundReturnItemRspBO rspBO = new FscFinanceQueryRefundReturnItemRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setSumRefundAmt(sumRefundAmt);
        rspBO.setSumRefundAmtLocal(sumRefundAmtLocal);
        rspBO.setSumNoRefundAmt(sumNoRefundAmt);
        rspBO.setSumNoRefundAmtLocal(sumNoRefundAmtLocal);
        return rspBO;
    }

    private void buildFinanceRefundItem(List<FscFinanceQueryRefundReturnItemListRspBO> list, Integer qryType) {
        List fscFinancePayItemPOList;
        List payItemIds = list.stream().map(FscFinanceQueryRefundReturnItemListRspBO::getPayItemId).collect(Collectors.toList());
        FscFinancePayItemPO fscFinancePayItemReq = new FscFinancePayItemPO();
        fscFinancePayItemReq.setFinancePayItemIds(payItemIds);
        if (Integer.valueOf(1).equals(qryType)) {
            fscFinancePayItemReq.setFinancePayItemIds(list.stream().map(FscFinanceQueryRefundReturnItemListRspBO::getRefundShouldPayId).collect(Collectors.toList()));
            fscFinancePayItemPOList = this.fscFinancePayItemMapper.getListForEng(fscFinancePayItemReq);
        } else {
            fscFinancePayItemPOList = this.fscFinancePayItemMapper.getList(fscFinancePayItemReq);
        }
        Map fscFinancePayItemMap = fscFinancePayItemPOList.stream().collect(Collectors.toMap(FscFinancePayItemPO::getFinancePayItemId, Function.identity()));
        Map financePayMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
        for (FscFinanceQueryRefundReturnItemListRspBO bo : list) {
            FscFinancePayItemPO fscFinancePayItemPO = (FscFinancePayItemPO)fscFinancePayItemMap.get(bo.getPayItemId());
            bo.setFinancePayItemId(fscFinancePayItemPO.getFinancePayItemId());
            bo.setOrderPayItemId(fscFinancePayItemPO.getOrderPayItemId());
            bo.setShouldPayId(fscFinancePayItemPO.getShouldPayId());
            bo.setFscOrderId(fscFinancePayItemPO.getFscOrderId());
            bo.setPayAmount(fscFinancePayItemPO.getPayAmount());
            bo.setFinancePayMethod(fscFinancePayItemPO.getFinancePayMethod());
            bo.setPayAmountLocal(fscFinancePayItemPO.getPayAmountLocal());
            bo.setRecvBankAccountName(fscFinancePayItemPO.getRecvBankAccountName());
            bo.setRecvBankAccountCode(fscFinancePayItemPO.getRecvBankAccountCode());
            bo.setRecvBankName(fscFinancePayItemPO.getRecvBankName());
            bo.setRecvBankCode(fscFinancePayItemPO.getRecvBankCode());
            bo.setRecvBankLinkCode(fscFinancePayItemPO.getRecvBankLinkCode());
            bo.setRecvBankAccount(fscFinancePayItemPO.getRecvBankAccount());
            bo.setPaidAmount(fscFinancePayItemPO.getPaidAmount());
            bo.setPaidAmountLocal(fscFinancePayItemPO.getPaidAmountLocal());
            bo.setPayerAccountCode(fscFinancePayItemPO.getPayerAccountCode());
            bo.setPayerAccountName(fscFinancePayItemPO.getPayerAccountName());
            bo.setPayerBankCode(fscFinancePayItemPO.getPayerBankCode());
            bo.setPayerBankName(fscFinancePayItemPO.getPayerBankName());
            bo.setPayerLinkBankCode(fscFinancePayItemPO.getPayerLinkBankCode());
            bo.setPayerBankAccountNum(fscFinancePayItemPO.getPayerBankAccountNum());
            bo.setItemNo(fscFinancePayItemPO.getItemNo());
            bo.setRefundingAmt(fscFinancePayItemPO.getRefundingAmt());
            bo.setRefundingAmtLocal(fscFinancePayItemPO.getRefundingAmtLocal());
            bo.setNoRefundAmt(fscFinancePayItemPO.getRefundAmt());
            bo.setNoRefundAmtLocal(fscFinancePayItemPO.getRefundAmtLocal());
            bo.setPayItemNo(fscFinancePayItemPO.getPayItemNo());
            if (!StringUtils.isNotBlank((CharSequence)bo.getFinancePayMethod())) continue;
            bo.setFinancePayMethodStr((String)financePayMethodMap.get(bo.getFinancePayMethod()));
        }
    }

    private void valid(FscFinanceQueryRefundReturnItemReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBo.getTempId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (reqBo.getContractId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

