/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundItemListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryRspListBO;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinanceRefundItemPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundItemListQryAbilityService"})
public class FscFinanceRefundItemListQryAbilityServiceImpl
implements FscFinanceRefundItemListQryAbilityService {
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceRefundItemMapper fscFinanceRefundItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryFinanceRefundItemList"})
    public FscFinanceRefundItemListQryRspBO qryFinanceRefundItemList(@RequestBody FscFinanceRefundItemListQryReqBO reqBo) {
        this.valid(reqBo);
        FscFinanceRefundItemListQryRspBO rspBO = new FscFinanceRefundItemListQryRspBO();
        FscFinanceRefundItemPO fscFinanceRefundItemReq = new FscFinanceRefundItemPO();
        fscFinanceRefundItemReq.setRefundId(reqBo.getRefundId());
        fscFinanceRefundItemReq.setContractId(reqBo.getContractId());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List fscFinanceRefundItemPOList = this.fscFinanceRefundItemMapper.getListPageByPayItem(fscFinanceRefundItemReq, page);
        List rspData = JSON.parseArray((String)JSON.toJSONString((Object)fscFinanceRefundItemPOList), FscFinanceRefundItemListQryRspListBO.class);
        if (rspData != null) {
            List fscFinancePayItemPOList;
            List payItemIds = rspData.stream().map(FscFinanceRefundItemListQryRspListBO::getPayItemId).collect(Collectors.toList());
            FscFinancePayItemPO fscFinancePayItemReq = new FscFinancePayItemPO();
            fscFinancePayItemReq.setFinancePayItemIds(payItemIds);
            if (Integer.valueOf(1).equals(reqBo.getQryType())) {
                fscFinancePayItemReq.setFinancePayItemIds(fscFinanceRefundItemPOList.stream().map(FscFinanceRefundItemPO::getRefundShouldPayId).collect(Collectors.toList()));
                fscFinancePayItemPOList = this.fscFinancePayItemMapper.getListForEng(fscFinancePayItemReq);
            } else {
                fscFinancePayItemPOList = this.fscFinancePayItemMapper.getList(fscFinancePayItemReq);
            }
            Map fscFinancePayItemMap = fscFinancePayItemPOList.stream().collect(Collectors.toMap(FscFinancePayItemPO::getFinancePayItemId, Function.identity()));
            BigDecimal sumRefundAmt = BigDecimal.ZERO;
            BigDecimal sumPaidAmt = BigDecimal.ZERO;
            BigDecimal sumRefundAmtLocal = BigDecimal.ZERO;
            BigDecimal sumNoRefundAmt = BigDecimal.ZERO;
            BigDecimal sumEngNoRefundAmt = BigDecimal.ZERO;
            BigDecimal sumNoRefundAmtLocal = BigDecimal.ZERO;
            Map financePayMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
            for (FscFinanceRefundItemListQryRspListBO rspDatum : rspData) {
                FscFinancePayItemPO fscFinancePayItem = (FscFinancePayItemPO)fscFinancePayItemMap.get(rspDatum.getPayItemId());
                if (fscFinancePayItem == null) continue;
                this.buildFinancePayItem(fscFinancePayItem, rspDatum);
                sumRefundAmt = sumRefundAmt.add(rspDatum.getRefundAmt());
                sumRefundAmtLocal = sumRefundAmtLocal.add(rspDatum.getRefundAmtLocal());
                sumNoRefundAmt = sumNoRefundAmt.add(rspDatum.getNoRefundAmt());
                sumNoRefundAmtLocal = sumNoRefundAmtLocal.add(rspDatum.getNoRefundAmtLocal());
                sumPaidAmt = sumPaidAmt.add(rspDatum.getPaidAmount());
                if (reqBo.getQryType() != null && reqBo.getQryType() == 1) {
                    BigDecimal noRefundAmt = fscFinancePayItem.getRefundAmt().subtract(fscFinancePayItem.getRefundingAmt()).subtract(fscFinancePayItem.getEngRefundedAmt());
                    rspDatum.setNoRefundAmt(noRefundAmt);
                    sumEngNoRefundAmt = sumEngNoRefundAmt.add(noRefundAmt);
                }
                if (!StringUtils.isNotBlank((CharSequence)rspDatum.getFinancePayMethod())) continue;
                rspDatum.setFinancePayMethodStr((String)financePayMethodMap.get(rspDatum.getFinancePayMethod()));
            }
            rspBO.setSumRefundAmt(sumRefundAmt);
            rspBO.setSumEngNoRefundAmt(sumEngNoRefundAmt);
            rspBO.setSumPaidAmt(sumPaidAmt);
            rspBO.setSumRefundAmtLocal(sumRefundAmtLocal);
            rspBO.setSumNoRefundAmt(sumNoRefundAmt);
            if (Integer.valueOf(1).equals(reqBo.getQryType())) {
                rspBO.setSumNoRefundAmt(sumEngNoRefundAmt);
            }
            rspBO.setSumNoRefundAmtLocal(sumNoRefundAmtLocal);
        }
        rspBO.setRows(rspData);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildFinancePayItem(FscFinancePayItemPO fscFinancePayItem, FscFinanceRefundItemListQryRspListBO rspData) {
        rspData.setFinancePayItemId(fscFinancePayItem.getFinancePayItemId());
        rspData.setOrderPayItemId(fscFinancePayItem.getOrderPayItemId());
        rspData.setShouldPayId(fscFinancePayItem.getShouldPayId());
        rspData.setFscOrderId(fscFinancePayItem.getFscOrderId());
        rspData.setPayAmount(fscFinancePayItem.getPayAmount());
        rspData.setFinancePayMethod(fscFinancePayItem.getFinancePayMethod());
        rspData.setPayAmountLocal(fscFinancePayItem.getPayAmountLocal());
        rspData.setRecvBankAccountName(fscFinancePayItem.getRecvBankAccountName());
        rspData.setRecvBankAccountCode(fscFinancePayItem.getRecvBankAccountCode());
        rspData.setRecvBankName(fscFinancePayItem.getRecvBankName());
        rspData.setRecvBankCode(fscFinancePayItem.getRecvBankCode());
        rspData.setRecvBankLinkCode(fscFinancePayItem.getRecvBankLinkCode());
        rspData.setRecvBankAccount(fscFinancePayItem.getRecvBankAccount());
        rspData.setPaidAmount(fscFinancePayItem.getPaidAmount());
        rspData.setPaidAmountLocal(fscFinancePayItem.getPaidAmountLocal());
        rspData.setPayerAccountCode(fscFinancePayItem.getPayerAccountCode());
        rspData.setPayerAccountName(fscFinancePayItem.getPayerAccountName());
        rspData.setPayerBankCode(fscFinancePayItem.getPayerBankCode());
        rspData.setPayerBankName(fscFinancePayItem.getPayerBankName());
        rspData.setPayerLinkBankCode(fscFinancePayItem.getPayerLinkBankCode());
        rspData.setPayerBankAccountNum(fscFinancePayItem.getPayerBankAccountNum());
        rspData.setItemNo(fscFinancePayItem.getItemNo());
        rspData.setPayItemNo(fscFinancePayItem.getPayItemNo());
        rspData.setRefundingAmt(fscFinancePayItem.getRefundingAmt());
        rspData.setRefundingAmtLocal(fscFinancePayItem.getRefundingAmtLocal());
        rspData.setNoRefundAmt(rspData.getPayAmount().subtract(rspData.getRefundingAmt()));
        rspData.setNoRefundAmtLocal(rspData.getPayAmountLocal().subtract(rspData.getRefundingAmtLocal()));
    }

    private void valid(FscFinanceRefundItemListQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRefundId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u51b2\u9500\u5355id[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

