/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundDetailAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundDetailAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundDetailAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscOrderRefundBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundItemListQryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundShouldPaymentPrintAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundItemListQryRspListBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundShouldPaymentPrintReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundShouldPaymentPrintRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.utils.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundShouldPaymentPrintAbilityService"})
public class FscFinanceRefundShouldPaymentPrintAbilityServiceImpl
implements FscFinanceRefundShouldPaymentPrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundShouldPaymentPrintAbilityServiceImpl.class);
    @Autowired
    private FscBillPayRefundDetailAbilityService fscBillPayRefundDetailAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private FscFinanceRefundItemListQryAbilityService fscFinanceRefundItemListQryAbilityService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";

    @PostMapping(value={"fscFinanceRefundShouldPaymentPrint"})
    public FscFinanceRefundShouldPaymentPrintRspBO fscFinanceRefundShouldPaymentPrint(@RequestBody FscFinanceRefundShouldPaymentPrintReqBO reqBo) {
        FscFinanceRefundShouldPaymentPrintRspBO rspBO = new FscFinanceRefundShouldPaymentPrintRspBO();
        this.valid(reqBo);
        FscBillPayRefundDetailAbilityReqBO fscBillPayRefundDetailAbilityReqBO = new FscBillPayRefundDetailAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)fscBillPayRefundDetailAbilityReqBO);
        fscBillPayRefundDetailAbilityReqBO.setRefundId(reqBo.getRefundId());
        FscBillPayRefundDetailAbilityRspBO refundDetail = this.fscBillPayRefundDetailAbilityService.dealPayRefundDetail(fscBillPayRefundDetailAbilityReqBO);
        log.info("\u8be6\u60c5\u6570\u636e{}", (Object)JSON.toJSONString((Object)refundDetail));
        if (!"0000".equals(refundDetail.getRespCode())) {
            throw new FscBusinessException("198888", refundDetail.getRespDesc());
        }
        FscFinanceRefundItemListQryReqBO fscFinanceRefundItemListQryReqBO = new FscFinanceRefundItemListQryReqBO();
        fscFinanceRefundItemListQryReqBO.setRefundId(reqBo.getRefundId());
        fscFinanceRefundItemListQryReqBO.setPageSize(Integer.valueOf(9999));
        FscFinanceRefundItemListQryRspBO refundItemList = this.fscFinanceRefundItemListQryAbilityService.qryFinanceRefundItemList(fscFinanceRefundItemListQryReqBO);
        if (!"0000".equals(refundItemList.getRespCode())) {
            throw new FscBusinessException("198888", refundItemList.getRespDesc());
        }
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = new FscComApprovalprocessListQryAbilityReqBO();
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBo.getRefundId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(6));
        List approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
        }
        FscDicDictionaryBO icpBoReq = new FscDicDictionaryBO();
        icpBoReq.setPCode("FSC_FINANCE_PRINT_ICP");
        FscDicDictionaryBO icpBo = this.fscDictionaryBusiService.getDictionaryByBO(icpBoReq);
        FscDicDictionaryBO logoBoReq = new FscDicDictionaryBO();
        logoBoReq.setPCode("FSC_FINANCE_PRINT_LOGO");
        FscDicDictionaryBO logoBo = this.fscDictionaryBusiService.getDictionaryByBO(logoBoReq);
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        }
        catch (DocumentException e) {
            log.error("\u521b\u5efa\u9ed8\u8ba4PDF\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, refundDetail);
        this.addMiddleTable(tableList, refundDetail, refundItemList);
        PdfUtils.addAuditTableShare(tableList, approvalList);
        if (icpBo != null) {
            PdfUtils.addIcpTableShare(tableList, (String)icpBo.getDescrip());
        }
        if (logoBo != null) {
            try (HttpResponse response = HttpUtil.createGet((String)logoBo.getDescrip()).execute();){
                PdfUtils.addLogo((Document)document, (byte[])response.bodyBytes(), (float)100.0f, (float)100.0f, (float)10.0f, (float)500.0f);
            }
            catch (Exception e) {
                throw new FscBusinessException("198888", "\u6dfb\u52a0\u5bf9\u63a5\u5171\u4eab\u6253\u5370\u6a21\u677f\u4e2d\u7164Logo\u5931\u8d25", (Throwable)e);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
        if (reqBo.getMergerFlag().booleanValue()) {
            rspBO.setByteArrayOutputStream(outputStream);
            return rspBO;
        }
        rspBO.setPrintUrl(this.uploadFile("\u91c7\u8d2d\u4ed8\u6b3e\u5355\u636e", outputStream));
        if (refundDetail.getRefundInfo() != null) {
            rspBO.setRefundNo(refundDetail.getRefundInfo().getRefundNo());
        }
        return rspBO;
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    public void addHeadTable(List<PdfPTable> tableList, FscBillPayRefundDetailAbilityRspBO refundDetail) {
        FscOrderRefundBO refundInfo = new FscOrderRefundBO();
        if (refundDetail.getRefundInfo() != null) {
            refundInfo = refundDetail.getRefundInfo();
        }
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u5e94\u4ed8\u6b3e\u9000\u56de\u5355", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable1);
        PdfPTable titleTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u5355\u4f4d:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)refundInfo.getFinanceOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u90e8\u95e8:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)refundInfo.getFinanceDeptName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u4eba:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)refundInfo.getAgentUserName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        tableList.add(titleTable2);
        PdfPTable titleTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u65e5\u671f:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)DateUtil.dateToStr((Date)refundInfo.getCreateTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u7f16\u53f7:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)refundInfo.getRefundNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, (Integer)0);
        tableList.add(titleTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscBillPayRefundDetailAbilityRspBO refundDetail, FscFinanceRefundItemListQryRspBO refundItemList) {
        FscOrderRefundBO refundInfo = new FscOrderRefundBO();
        if (refundDetail.getRefundInfo() != null) {
            refundInfo = refundDetail.getRefundInfo();
        }
        PdfPTable table1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u4e1a\u52a1\u65e5\u671f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)DateUtil.dateToStr((Date)refundInfo.getRefundDate()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9644\u4ef6\u5f20\u6570\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)(refundDetail.getAttachmentList() == null ? Integer.valueOf(0) : refundDetail.getAttachmentList().size() + "\u5f20"), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9000\u56de\u91d1\u989d\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)(refundItemList.getSumRefundAmt() == null ? Integer.valueOf(0) : refundItemList.getSumRefundAmt().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table1);
        PdfPTable table2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u4e1a\u52a1\u4e8b\u9879\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)refundInfo.getBusinessItemName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)12, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u662f\u5426\u4ee3\u6536\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)refundInfo.getIsAgentStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table2);
        PdfPTable table3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)refundInfo.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u9000\u6b3e\u65b9\u5f0f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)refundInfo.getRefundReasonTypeStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u5e01\u79cd\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)refundInfo.getCurrency(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table3);
        PdfPTable table6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u9000\u56de\u660e\u7ec6", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table6);
        PdfPTable table7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u7ed3\u7b97\u51b2\u9500\u5355\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u51b2\u9500\u5355\u4f59\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u9000\u56de\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        tableList.add(table7);
        List collect = refundItemList.getRows().stream().sorted(Comparator.comparing(FscFinanceRefundItemListQryRspListBO::getPayItemNo)).collect(Collectors.toList());
        for (FscFinanceRefundItemListQryRspListBO refundItem : collect) {
            PdfPTable table8 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)refundItem.getObjectNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)(refundItem.getNoRefundAmt() == null ? Integer.valueOf(0) : refundItem.getNoRefundAmt().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)(refundItem.getRefundAmt() == null ? Integer.valueOf(0) : refundItem.getRefundAmt().setScale(2, RoundingMode.HALF_UP)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)refundItem.getContractNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)refundItem.getContractName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            tableList.add(table8);
        }
    }

    private void valid(FscFinanceRefundShouldPaymentPrintReqBO reqBo) {
        if (null == reqBo) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2refundId\u4e3a\u7a7a");
        }
    }
}

