/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundTempAbnormalQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundTempAbnormalQryListRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundTempAbnormalQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundTempAbnormalQryRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import com.tydic.uoc.common.ability.api.UocAbnormalSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdShipAbnormalBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundTempAbnormalQryAbilityService"})
public class FscFinanceRefundTempAbnormalQryAbilityServiceImpl
implements FscFinanceRefundTempAbnormalQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundTempAbnormalQryAbilityServiceImpl.class);
    private static final Integer ABNORMAL_ALL_TAB_ID = 41001;
    private static final String ABNORMAL_STATE_TWO = "2";
    private static final String ABNORMAL_STATE_THREE = "3";
    private static final Integer ABNORMAL_PAGE_SIZE = 999;
    private static final Integer SALE_ORDER_PAGE_NO = 1;
    private static final Integer SALE_ORDER_PAGE_SIZE = 9999;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UocAbnormalSingleDetailsListQueryAbilityService uocAbnormalSingleDetailsListQueryAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;

    @PostMapping(value={"qryRefundInvoiceTempAbnormal"})
    public FscFinanceRefundTempAbnormalQryRspBO qryRefundInvoiceTempAbnormal(@RequestBody FscFinanceRefundTempAbnormalQryReqBO reqBo) {
        this.valid(reqBo);
        FscOrderPO fscOrderInfo = this.getFscOrderInfo(reqBo);
        FscFinanceRefundTempAbnormalQryRspBO rspBO = new FscFinanceRefundTempAbnormalQryRspBO();
        FscOrderRelationTempPO fscOrderRelationTempPOReq = new FscOrderRelationTempPO();
        fscOrderRelationTempPOReq.setTempId(reqBo.getTempId());
        fscOrderRelationTempPOReq.setFscOrderId(reqBo.getFscOrderId());
        fscOrderRelationTempPOReq.setContractId(reqBo.getContractId());
        fscOrderRelationTempPOReq.setOrderNo(reqBo.getOrderCode());
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List listPage = this.fscOrderRelationTempMapper.getListPage(fscOrderRelationTempPOReq, page);
        if (CollectionUtils.isEmpty((Collection)listPage)) {
            rspBO.setPageNo(reqBo.getPageNo());
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setRows(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List list = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscFinanceRefundTempAbnormalQryListRspBO.class);
        this.packagingAbnormalSingleDetailsData(list, fscOrderInfo, reqBo);
        this.packagingSalesSingleDetailsData(list, fscOrderInfo, reqBo);
        rspBO.setRows(list);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceRefundTempAbnormalQryReqBO reqBo) {
        if (reqBo == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e34\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void packagingAbnormalSingleDetailsData(List<FscFinanceRefundTempAbnormalQryListRspBO> fscFinanceRefundTempAbnormalQryListRspBOList, FscOrderPO fscOrderPO, FscFinanceRefundTempAbnormalQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(fscFinanceRefundTempAbnormalQryListRspBOList)) {
            return;
        }
        List abnormalVoucherIdList = fscFinanceRefundTempAbnormalQryListRspBOList.stream().map(FscFinanceRefundTempAbnormalQryListRspBO::getAbnormalVoucherId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(abnormalVoucherIdList)) {
            return;
        }
        if (!FscConstants.SettleType.INSPECTION.equals(fscOrderPO.getSettleType())) {
            return;
        }
        UocAbnormalSingleDetailsListQueryReqBO uocAbnormalSingleDetailsListQueryReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
        uocAbnormalSingleDetailsListQueryReqBO.setTabId(ABNORMAL_ALL_TAB_ID);
        uocAbnormalSingleDetailsListQueryReqBO.setPageSize(ABNORMAL_PAGE_SIZE.intValue());
        uocAbnormalSingleDetailsListQueryReqBO.setAbnormalVoucherIds(abnormalVoucherIdList);
        uocAbnormalSingleDetailsListQueryReqBO.setAbnormalState(FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(fscOrderPO.getOrderSource()) ? ABNORMAL_STATE_TWO : ABNORMAL_STATE_THREE);
        UocAbnormalSingleDetailsListQueryRspBO uocAbnormalSingleDetailsListQueryRspBO = this.uocAbnormalSingleDetailsListQueryAbilityService.getAbnormalSingleDetailsListQuery(uocAbnormalSingleDetailsListQueryReqBO);
        if (!"0000".equals(uocAbnormalSingleDetailsListQueryRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3|\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\u5355\u8be6\u60c5\u6570\u636e\u5931\u8d25: " + uocAbnormalSingleDetailsListQueryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uocAbnormalSingleDetailsListQueryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3|\u672a\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\u5355\u8be6\u60c5\u6570\u636e");
        }
        Map<String, UocPebOrdShipAbnormalBO> idVsAbnormalSingleListMap = uocAbnormalSingleDetailsListQueryRspBO.getRows().stream().collect(Collectors.toMap(UocPebOrdShipAbnormalBO::getAbnormalVoucherId, bo -> bo, (k1, k2) -> k1));
        for (FscFinanceRefundTempAbnormalQryListRspBO fscFinanceRefundTempAbnormalQryListRspBO : fscFinanceRefundTempAbnormalQryListRspBOList) {
            UocPebOrdShipAbnormalBO uocPebOrdShipAbnormalBO = idVsAbnormalSingleListMap.get(String.valueOf(fscFinanceRefundTempAbnormalQryListRspBO.getAbnormalVoucherId()));
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleVoucherId(uocPebOrdShipAbnormalBO.getSaleVoucherId());
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleVoucherNo(uocPebOrdShipAbnormalBO.getSaleVoucherNo());
            fscFinanceRefundTempAbnormalQryListRspBO.setSupplierId(Long.valueOf(uocPebOrdShipAbnormalBO.getSupNo()));
            fscFinanceRefundTempAbnormalQryListRspBO.setSupplierName(uocPebOrdShipAbnormalBO.getSupName());
            fscFinanceRefundTempAbnormalQryListRspBO.setBuynerNo(uocPebOrdShipAbnormalBO.getBuynerNo());
            fscFinanceRefundTempAbnormalQryListRspBO.setBuynerName(uocPebOrdShipAbnormalBO.getBuynerName());
            fscFinanceRefundTempAbnormalQryListRspBO.setChangeFeeMoney(new BigDecimal(uocPebOrdShipAbnormalBO.getChangeFeeMoney()));
            fscFinanceRefundTempAbnormalQryListRspBO.setCreateOperId(uocPebOrdShipAbnormalBO.getCreateOperId());
            fscFinanceRefundTempAbnormalQryListRspBO.setCreateOperName(uocPebOrdShipAbnormalBO.getCreateOperName());
            fscFinanceRefundTempAbnormalQryListRspBO.setAbnormalTime(this.getFormatStringToDate(uocPebOrdShipAbnormalBO.getAbnormalTime()));
        }
    }

    private Date getFormatStringToDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private FscOrderPO getFscOrderInfo(FscFinanceRefundTempAbnormalQryReqBO reqBO) {
        FscOrderPO qryFscOrder = new FscOrderPO();
        qryFscOrder.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(qryFscOrder);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        return fscOrderPO;
    }

    private void packagingSalesSingleDetailsData(List<FscFinanceRefundTempAbnormalQryListRspBO> fscFinanceRefundTempAbnormalQryListRspBOList, FscOrderPO fscOrderPO, FscFinanceRefundTempAbnormalQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(fscFinanceRefundTempAbnormalQryListRspBOList)) {
            return;
        }
        List orderIdList = fscFinanceRefundTempAbnormalQryListRspBOList.stream().map(FscFinanceRefundTempAbnormalQryListRspBO::getOrderId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIdList)) {
            return;
        }
        if (!FscConstants.SettleType.ORDER.equals(fscOrderPO.getSettleType())) {
            return;
        }
        UocSalesSingleDetailsListQueryReqBO uocSalesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        uocSalesSingleDetailsListQueryReqBO.setPageNo(SALE_ORDER_PAGE_NO.intValue());
        uocSalesSingleDetailsListQueryReqBO.setPageSize(SALE_ORDER_PAGE_SIZE.intValue());
        uocSalesSingleDetailsListQueryReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        uocSalesSingleDetailsListQueryReqBO.setOrderIdList(orderIdList);
        log.info("\u9000\u7968\u5f02\u5e38\u8ba2\u5355\u4e34\u65f6\u8868\u67e5\u8be2|\u9500\u552e\u5355\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)uocSalesSingleDetailsListQueryReqBO));
        UocSalesSingleDetailsListQueryRspBO uocSalesSingleDetailsListQueryRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(uocSalesSingleDetailsListQueryReqBO);
        log.info("\u9000\u7968\u5f02\u5e38\u8ba2\u5355\u4e34\u65f6\u8868\u67e5\u8be2|\u9500\u552e\u5355\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)uocSalesSingleDetailsListQueryRspBO));
        if (!"0000".equals(uocSalesSingleDetailsListQueryRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u5f02\u5e38\u8ba2\u5355\u4e34\u65f6\u8868\u67e5\u8be2|\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3|\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u6570\u636e\u5931\u8d25: " + uocSalesSingleDetailsListQueryRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uocSalesSingleDetailsListQueryRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u5f02\u5e38\u8ba2\u5355\u4e34\u65f6\u8868\u67e5\u8be2|\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3|\u672a\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u6570\u636e");
        }
        Map<String, UocPebUpperOrderAbilityBO> idVsSalesSingleListMap = uocSalesSingleDetailsListQueryRspBO.getRows().stream().collect(Collectors.toMap(UocPebUpperOrderAbilityBO::getOrderId, bo -> bo, (k1, k2) -> k1));
        for (FscFinanceRefundTempAbnormalQryListRspBO fscFinanceRefundTempAbnormalQryListRspBO : fscFinanceRefundTempAbnormalQryListRspBOList) {
            UocPebUpperOrderAbilityBO uocPebUpperOrderAbilityBO = idVsSalesSingleListMap.get(String.valueOf(fscFinanceRefundTempAbnormalQryListRspBO.getOrderId()));
            UocPebChildOrderAbilityBO uocPebChildOrderAbilityBO = (UocPebChildOrderAbilityBO)uocPebUpperOrderAbilityBO.getChildOrderList().get(0);
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleVoucherId(uocPebChildOrderAbilityBO.getSaleVoucherId());
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleVoucherNo(uocPebChildOrderAbilityBO.getSaleVoucherNo());
            fscFinanceRefundTempAbnormalQryListRspBO.setSupplierId(Long.valueOf(uocPebUpperOrderAbilityBO.getSupNo()));
            fscFinanceRefundTempAbnormalQryListRspBO.setSupplierName(uocPebUpperOrderAbilityBO.getSupName());
            fscFinanceRefundTempAbnormalQryListRspBO.setBuynerNo(uocPebChildOrderAbilityBO.getBuynerNo());
            fscFinanceRefundTempAbnormalQryListRspBO.setBuynerName(uocPebChildOrderAbilityBO.getBuynerName());
            fscFinanceRefundTempAbnormalQryListRspBO.setChangeFeeMoney(uocPebChildOrderAbilityBO.getChangeFeeMoney());
            fscFinanceRefundTempAbnormalQryListRspBO.setCreateOperId(uocPebChildOrderAbilityBO.getCreateOperId());
            fscFinanceRefundTempAbnormalQryListRspBO.setCreateOperName(uocPebChildOrderAbilityBO.getCreateOperName());
            fscFinanceRefundTempAbnormalQryListRspBO.setAbnormalTime(this.getFormatStringToDate(uocPebChildOrderAbilityBO.getCreateTime()));
            fscFinanceRefundTempAbnormalQryListRspBO.setSaleFeeMoney(uocPebChildOrderAbilityBO.getSaleFeeMoney());
            fscFinanceRefundTempAbnormalQryListRspBO.setPurchaseFeeMoney(uocPebChildOrderAbilityBO.getPurchaseFeeMoney());
        }
    }
}

