/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.api.AgrFinanceSelectAgreementAbilityService;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementReqBo;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementRspBo;
import com.tydic.agreement.ability.bo.AgrFinanceSelectAgreementRspBoDate;
import com.tydic.contract.ability.FscFinanceSelectContractAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractReqBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractRspBoList;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundablePayContractListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayContractListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayContractListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayContractListQryRspListBO;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundablePayContractListQryAbilityService"})
public class FscFinanceRefundablePayContractListQryAbilityServiceImpl
implements FscFinanceRefundablePayContractListQryAbilityService {
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscFinanceSelectContractAbilityService fscFinanceSelectContractAbilityService;
    @Autowired
    private AgrFinanceSelectAgreementAbilityService agrFinanceSelectAgreementAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"qryRefundablePayContractList"})
    public FscFinanceRefundablePayContractListQryRspBO qryRefundablePayContractList(@RequestBody FscFinanceRefundablePayContractListQryReqBO reqBo) {
        Page page;
        List list;
        FscFinanceRefundablePayContractListQryRspBO rspBO = new FscFinanceRefundablePayContractListQryRspBO();
        if (null == reqBo.getRefundId()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setRefundId(reqBo.getRefundId());
        if (CollUtil.isNotEmpty((Collection)reqBo.getFilterContractIds())) {
            fscOrderRelationPo.setExcludeContractIds(reqBo.getFilterContractIds());
        }
        if (CollUtil.isEmpty((Collection)(list = this.fscOrderRelationMapper.getListPage(fscOrderRelationPo, page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue()))))) {
            return rspBO;
        }
        List<FscFinanceRefundablePayContractListQryRspListBO> rspListBOList = this.buildBo(list);
        List contractIdList = list.stream().map(FscOrderRelationPO::getContractId).collect(Collectors.toList());
        if (CollUtil.isEmpty(contractIdList)) {
            rspBO.setRespCode("0000");
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        if ("2".equals(reqBo.getContractType())) {
            AgrFinanceSelectAgreementReqBo queryReq = (AgrFinanceSelectAgreementReqBo)JUtil.js((Object)reqBo, AgrFinanceSelectAgreementReqBo.class);
            queryReq.setAgreementIds(contractIdList);
            AgrFinanceSelectAgreementRspBo agreementRspBo = this.agrFinanceSelectAgreementAbilityService.selectAgreementPage(queryReq);
            List rows = agreementRspBo.getRows();
            if (CollUtil.isNotEmpty((Collection)rows)) {
                Map map = rows.stream().collect(Collectors.toMap(AgrFinanceSelectAgreementRspBoDate::getContractId, Function.identity()));
                for (FscFinanceRefundablePayContractListQryRspListBO bo : rspListBOList) {
                    AgrFinanceSelectAgreementRspBoDate boDate = (AgrFinanceSelectAgreementRspBoDate)map.get(bo.getContractId());
                    bo.setContractCode(boDate.getContractCode());
                    bo.setContractAmount(new BigDecimal(boDate.getContractAmount()));
                    bo.setContractSignDate(boDate.getContractSignDate());
                    bo.setProjectSegment(boDate.getProjectSegment());
                    bo.setProjectSegmentName(boDate.getProjectSegmentName());
                }
            }
            rspBO.setRows(JSON.parseArray((String)JSON.toJSONString((Object)agreementRspBo.getRows()), FscFinanceRefundablePayContractListQryRspListBO.class));
        } else {
            FscFinanceSelectContractReqBo queryReq = (FscFinanceSelectContractReqBo)JUtil.js((Object)reqBo, FscFinanceSelectContractReqBo.class);
            queryReq.setContractList(contractIdList);
            FscFinanceSelectContractRspBo fscFinanceSelectContractRspBo = this.fscFinanceSelectContractAbilityService.selectContractPage(queryReq);
            List rows = fscFinanceSelectContractRspBo.getRows();
            if (CollUtil.isNotEmpty((Collection)rows)) {
                Map map = rows.stream().collect(Collectors.toMap(FscFinanceSelectContractRspBoList::getContractId, Function.identity()));
                for (FscFinanceRefundablePayContractListQryRspListBO bo : rspListBOList) {
                    FscFinanceSelectContractRspBoList boDate = (FscFinanceSelectContractRspBoList)map.get(bo.getContractId());
                    bo.setContractCode(boDate.getContractCode());
                    bo.setContractAmount(new BigDecimal(boDate.getContractAmount()));
                    bo.setContractSignDate(boDate.getContractSignDate());
                    bo.setProjectSegment(boDate.getProjectSegment());
                    bo.setProjectSegmentName(boDate.getProjectSegmentName());
                }
            }
        }
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rspListBOList);
        return rspBO;
    }

    private List<FscFinanceRefundablePayContractListQryRspListBO> buildBo(List<FscOrderRelationPO> list) {
        ArrayList<FscFinanceRefundablePayContractListQryRspListBO> rspListBOList = new ArrayList<FscFinanceRefundablePayContractListQryRspListBO>(list.size());
        Map engContractTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_CONTRACT_TYPE");
        for (FscOrderRelationPO fscOrderRelationPO : list) {
            FscFinanceRefundablePayContractListQryRspListBO bo = new FscFinanceRefundablePayContractListQryRspListBO();
            bo.setContractId(fscOrderRelationPO.getContractId());
            bo.setContractName(fscOrderRelationPO.getContractName());
            bo.setContractType(fscOrderRelationPO.getContractType());
            if (StrUtil.isNotBlank((CharSequence)fscOrderRelationPO.getContractType())) {
                bo.setContractTypeStr((String)engContractTypeMap.get(fscOrderRelationPO.getContractType()));
            }
            bo.setContractCode(fscOrderRelationPO.getContractNo());
            bo.setContractAmount(null);
            bo.setContractSignDate("");
            bo.setContractSegment(fscOrderRelationPO.getContractSegmentCode());
            bo.setContractSegmentName(fscOrderRelationPO.getContractSegmentName());
            bo.setProjectSegment("");
            bo.setProjectSegmentName("");
            bo.setProjectName("");
            bo.setSupplierName(fscOrderRelationPO.getSupplierName());
            bo.setConBuyerName(fscOrderRelationPO.getBuynerName());
            rspListBOList.add(bo);
        }
        return rspListBOList;
    }
}

