/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceRefundablePayItemListQryAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayItemListQryReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayItemListQryRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceRefundablePayItemListQryRspListBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinancePayItemAndShouldPayPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceRefundablePayItemListQryAbilityService"})
public class FscFinanceRefundablePayItemListQryAbilityServiceImpl
implements FscFinanceRefundablePayItemListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceRefundablePayItemListQryAbilityServiceImpl.class);
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"qryRefundablePayItemList"})
    public FscFinanceRefundablePayItemListQryRspBO qryRefundablePayItemList(@RequestBody FscFinanceRefundablePayItemListQryReqBO reqBo) {
        List fscFinancePayItemAndShouldPayPOS;
        FscFinanceRefundablePayItemListQryRspBO rspBO = new FscFinanceRefundablePayItemListQryRspBO();
        FscFinancePayItemAndShouldPayPO fscFinancePayItemAndShouldPayReq = new FscFinancePayItemAndShouldPayPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)fscFinancePayItemAndShouldPayReq);
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        if (Integer.valueOf(1).equals(reqBo.getQryType())) {
            if (null == reqBo.getContractId() && FscConstants.PaymentMethod.PRE_PAY.equals(reqBo.getShouldPayMethod())) {
                throw new FscBusinessException("190000", "\u5fc5\u4f20\u53c2\u6570\u3010contractId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (FscConstants.PaymentMethod.SHOULD_PAY.equals(reqBo.getShouldPayMethod())) {
                fscFinancePayItemAndShouldPayPOS = this.fscFinancePayItemMapper.qryRefundablePayItemListForEngShould(fscFinancePayItemAndShouldPayReq, page);
            } else {
                if (!FscConstants.PaymentMethod.PRE_PAY.equals(reqBo.getShouldPayMethod())) throw new FscBusinessException("190000", "\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b\uff01shouldPayMethod:" + reqBo.getShouldPayMethod());
                fscFinancePayItemAndShouldPayPOS = this.fscFinancePayItemMapper.qryRefundablePayItemListForEng(fscFinancePayItemAndShouldPayReq, page);
            }
        } else {
            fscFinancePayItemAndShouldPayPOS = this.fscFinancePayItemMapper.qryRefundablePayItemList(fscFinancePayItemAndShouldPayReq, page);
        }
        List rspData = JSON.parseArray((String)JSON.toJSONString((Object)fscFinancePayItemAndShouldPayPOS), FscFinanceRefundablePayItemListQryRspListBO.class);
        if (!rspData.isEmpty()) {
            List fscOrderIds = rspData.stream().map(FscFinanceRefundablePayItemListQryRspListBO::getFscOrderId).collect(Collectors.toList());
            List orderByFscOrderIds = this.fscOrderMapper.getOrderByFscOrderIds(fscOrderIds);
            Map orderMap = orderByFscOrderIds.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, Function.identity()));
            Map financePayMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
            for (FscFinanceRefundablePayItemListQryRspListBO data : rspData) {
                data.setFscOrderNo(((FscOrderPO)orderMap.get(data.getFscOrderId())).getOrderNo());
                if (!StringUtils.isNotBlank((CharSequence)data.getFinancePayMethod())) continue;
                data.setFinancePayMethodStr((String)financePayMethodMap.get(data.getFinancePayMethod()));
            }
        }
        rspBO.setRows(rspData);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

