/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePushEngineeringSettleAbilityService;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePushSettleAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityRspBO;
import com.tydic.fsc.bo.finance.FscFinanceCmVoucherInfoBO;
import com.tydic.fsc.common.ability.api.finance.FscFinancePushChargeAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceVoucherPreviewAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushChargeAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceVoucherPreviewAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceVoucherPreviewAbilityRspBO;
import com.tydic.fsc.common.ability.enums.FinanceVoucherPreviewTypeEnum;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinancePushPayBillAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityRspBO;
import com.tydic.fsc.po.FscOrderFinancePO;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceVoucherPreviewAbilityService"})
public class FscFinanceVoucherPreviewAbilityServiceImpl
implements FscFinanceVoucherPreviewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceVoucherPreviewAbilityServiceImpl.class);
    @Autowired
    private FscFinancePushSettleAbilityService fscFinancePushSettleAbilityService;
    @Autowired
    private FscFinancePushEngineeringSettleAbilityService fscFinancePushEngineeringSettleAbilityService;
    @Autowired
    private FscFinancePushPayBillAbilityService fscFinancePushPayBillAbilityService;
    @Autowired
    private FscFinancePushChargeAbilityService fscFinancePushChargeAbilityService;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"financeVoucherPreview"})
    public FscFinanceVoucherPreviewAbilityRspBO financeVoucherPreview(@RequestBody FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        this.checkInput(reqBO);
        FscFinanceVoucherPreviewAbilityRspBO rspBO = new FscFinanceVoucherPreviewAbilityRspBO();
        FscFinanceCmVoucherInfoBO fscFinanceCmVoucherInfoBO = null;
        if (FinanceVoucherPreviewTypeEnum.INVOICE.getCode().equals(reqBO.getObjectType())) {
            fscFinanceCmVoucherInfoBO = this.dealInvoice(reqBO);
        } else if (FinanceVoucherPreviewTypeEnum.PRE_PAY.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.SHOULD_PAY.getCode().equals(reqBO.getObjectType())) {
            fscFinanceCmVoucherInfoBO = this.dealPay(reqBO);
        } else if (FinanceVoucherPreviewTypeEnum.ENGINEERING_INVOICE.getCode().equals(reqBO.getObjectType())) {
            fscFinanceCmVoucherInfoBO = this.dealEngineeringInvoice(reqBO);
        } else if (!(FinanceVoucherPreviewTypeEnum.ENGINEERING_PRE_PAY.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.ENGINEERING_SHOULD_PAY.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.REFUND.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.REFUND_PRE_PAY.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.REFUND_SHOULD_PAY.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.ADJUST.getCode().equals(reqBO.getObjectType()) || FinanceVoucherPreviewTypeEnum.CANCEL_ADJUST.getCode().equals(reqBO.getObjectType()) || !FinanceVoucherPreviewTypeEnum.CHARGE.getCode().equals(reqBO.getObjectType()))) {
            fscFinanceCmVoucherInfoBO = this.dealCharge(reqBO);
        }
        log.info("\u51ed\u8bc1\u9884\u89c8\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)fscFinanceCmVoucherInfoBO));
        rspBO.setFscFinanceCmVoucherInfoBO(fscFinanceCmVoucherInfoBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscFinanceCmVoucherInfoBO dealInvoice(FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        this.updateFinanceInfo(reqBO);
        FscFinancePushSettleAbilityReqBO fscFinancePushSettleAbilityReqBO = new FscFinancePushSettleAbilityReqBO();
        fscFinancePushSettleAbilityReqBO.setFscOrderId(reqBO.getObjectId());
        fscFinancePushSettleAbilityReqBO.setFlowNode("START");
        FscFinancePushSettleAbilityRspBO fscFinancePushSettleAbilityRspBO = this.fscFinancePushSettleAbilityService.pushFinanceSettle(fscFinancePushSettleAbilityReqBO);
        if (Objects.nonNull(fscFinancePushSettleAbilityRspBO) && !"0000".equals(fscFinancePushSettleAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", fscFinancePushSettleAbilityRspBO.getRespDesc());
        }
        return fscFinancePushSettleAbilityRspBO.getFscFinanceCmVoucherInfoBO();
    }

    private FscFinanceCmVoucherInfoBO dealPay(FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        this.updateFinanceInfo(reqBO);
        FscFinancePushPayBillAbilityReqBO fscFinancePushPayBillAbilityReqBO = new FscFinancePushPayBillAbilityReqBO();
        fscFinancePushPayBillAbilityReqBO.setFscOrderId(reqBO.getObjectId());
        fscFinancePushPayBillAbilityReqBO.setFlowNode("START");
        FscFinancePushPayBillAbilityRspBO fscFinancePushPayBillAbilityRspBO = this.fscFinancePushPayBillAbilityService.pushFinancePayBill(fscFinancePushPayBillAbilityReqBO);
        if (Objects.nonNull(fscFinancePushPayBillAbilityRspBO) && !"0000".equals(fscFinancePushPayBillAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", fscFinancePushPayBillAbilityRspBO.getRespDesc());
        }
        return fscFinancePushPayBillAbilityRspBO.getFscFinanceCmVoucherInfoBO();
    }

    private FscFinanceCmVoucherInfoBO dealCharge(FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        this.updateFinanceInfo(reqBO);
        FscFinancePushChargeAbilityReqBO fscFinancePushChargeAbilityReqBO = new FscFinancePushChargeAbilityReqBO();
        fscFinancePushChargeAbilityReqBO.setChargeId(reqBO.getObjectId());
        fscFinancePushChargeAbilityReqBO.setFlowNode("START");
        FscFinancePushChargeAbilityRspBO fscFinancePushChargeAbilityRspBO = this.fscFinancePushChargeAbilityService.dealPushCharge(fscFinancePushChargeAbilityReqBO);
        if (Objects.nonNull(fscFinancePushChargeAbilityRspBO) && !"0000".equals(fscFinancePushChargeAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", fscFinancePushChargeAbilityRspBO.getRespDesc());
        }
        return fscFinancePushChargeAbilityRspBO.getFscFinanceCmVoucherInfoBO();
    }

    private FscFinanceCmVoucherInfoBO dealEngineeringInvoice(FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        this.updateFinanceInfo(reqBO);
        FscFinancePushSettleAbilityReqBO fscFinancePushSettleAbilityReqBO = new FscFinancePushSettleAbilityReqBO();
        fscFinancePushSettleAbilityReqBO.setFscOrderId(reqBO.getObjectId());
        fscFinancePushSettleAbilityReqBO.setFlowNode("START");
        FscFinancePushSettleAbilityRspBO fscFinancePushSettleAbilityRspBO = this.fscFinancePushEngineeringSettleAbilityService.pushEngineeringSettle(fscFinancePushSettleAbilityReqBO);
        if (Objects.nonNull(fscFinancePushSettleAbilityRspBO) && !"0000".equals(fscFinancePushSettleAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", fscFinancePushSettleAbilityRspBO.getRespDesc());
        }
        return fscFinancePushSettleAbilityRspBO.getFscFinanceCmVoucherInfoBO();
    }

    private void updateFinanceInfo(FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
        fscOrderFinancePO.setFscOrderId(reqBO.getObjectId());
        fscOrderFinancePO.setCashItemCode(reqBO.getCashItemCode());
        fscOrderFinancePO.setCashItemName(reqBO.getCashItemName());
        fscOrderFinancePO.setCashDetailCode(reqBO.getCashDetailCode());
        fscOrderFinancePO.setCashDetailName(reqBO.getCashDetailName());
        this.fscOrderFinanceMapper.updateById(fscOrderFinancePO);
    }

    private void checkInput(FscFinanceVoucherPreviewAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getObjectId())) {
            throw new FscBusinessException("191000", "\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getObjectType())) {
            throw new FscBusinessException("191000", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!(FinanceVoucherPreviewTypeEnum.ADJUST.getCode().equals(reqBO.getObjectType()) && FinanceVoucherPreviewTypeEnum.CANCEL_ADJUST.getCode().equals(reqBO.getObjectType()) || !StringUtils.isEmpty((Object)reqBO.getCashItemCode()) && !StringUtils.isEmpty((Object)reqBO.getCashItemName()))) {
            throw new FscBusinessException("191000", "\u73b0\u91d1\u6d41\u91cf\u8868\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

