/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl.finance;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscDicDictionaryBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceWriteOffPrintAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceWriteOffPrintAddPdfBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceWriteOffPrintReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceWriteOffPrintRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustDetailPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.base.utils.DateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.finance.FscFinanceWriteOffPrintAbilityService"})
public class FscFinanceWriteOffPrintAbilityServiceImpl
implements FscFinanceWriteOffPrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffPrintAbilityServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";

    @PostMapping(value={"addWriteOffPrint"})
    public FscFinanceWriteOffPrintRspBO addWriteOffPrint(@RequestBody FscFinanceWriteOffPrintReqBO reqBo) {
        FscFinanceWriteOffPrintRspBO rspBO = new FscFinanceWriteOffPrintRspBO();
        FscFinanceWriteOffPrintAddPdfBO pdfBO = new FscFinanceWriteOffPrintAddPdfBO();
        if (reqBo.getAdjustId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[adjustId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.buildPdfInfo(reqBo, pdfBO);
        FscFinanceWriteOffAdjustDetailPO fscFinanceWriteOffAdjustDetailPo = new FscFinanceWriteOffAdjustDetailPO();
        fscFinanceWriteOffAdjustDetailPo.setAdjustId(reqBo.getAdjustId());
        List fscFinanceWriteOffAdjustDetailPOList = this.fscFinanceWriteOffAdjustDetailMapper.getList(fscFinanceWriteOffAdjustDetailPo);
        ArrayList<FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo> writeOffInfos = new ArrayList<FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo>();
        for (FscFinanceWriteOffAdjustDetailPO adjustDetailPO : fscFinanceWriteOffAdjustDetailPOList) {
            FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo writeOffInfo = new FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo();
            writeOffInfo.setAdvPayAmt(adjustDetailPO.getPaidAmount());
            writeOffInfo.setAdvUncheckAmt(adjustDetailPO.getRemainWriteOffAmount());
            writeOffInfo.setCheckAmt(adjustDetailPO.getWriteOffAmt());
            writeOffInfo.setApplyBillCode(adjustDetailPO.getPayOrderNo());
            writeOffInfos.add(writeOffInfo);
        }
        pdfBO.setWriteOffInfoList(writeOffInfos);
        Set collect = fscFinanceWriteOffAdjustDetailPOList.stream().map(e -> e.getContractId()).collect(Collectors.toSet());
        FscFinanceSelectContractAmountReqBO reqBO = new FscFinanceSelectContractAmountReqBO();
        reqBO.setContractIds(new ArrayList(collect));
        FscFinanceSelectContractAmountRspBo contractAmount = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(reqBO);
        ArrayList<FscFinanceWriteOffPrintAddPdfBO.ContractInfo> contractInfos = new ArrayList<FscFinanceWriteOffPrintAddPdfBO.ContractInfo>();
        for (FscFinanceSelectContractAmountRspBoList contractAmountRspBoList : contractAmount.getRows()) {
            FscFinanceWriteOffPrintAddPdfBO.ContractInfo contractInfo = new FscFinanceWriteOffPrintAddPdfBO.ContractInfo();
            contractInfo.setContractName(contractAmountRspBoList.getContractName());
            contractInfo.setContractAmt(contractAmountRspBoList.getContractAmount());
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setContractId(contractAmountRspBoList.getContractId());
            List list = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
            list = list.stream().filter(e -> e.getFscOrderId() != null).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                BigDecimal settAmt = BigDecimal.ZERO;
                for (FscOrderRelationPO orderRelationPO : list) {
                    if (Objects.equals(orderRelationPO.getFscOrderId(), pdfBO.getFscOrderId())) {
                        contractInfo.setSettleAmt(orderRelationPO.getSettleAmt().setScale(6, RoundingMode.HALF_UP));
                    }
                    if (FscBillStatus.MAIN_ORDER_DEL.getCode().equals(orderRelationPO.getOrderState()) || FscBillStatus.MAIN_ORDER_CANCELLATION.getCode().equals(orderRelationPO.getOrderState()) || !FscConstants.FscOrderReceiveType.PURCHASE.equals(orderRelationPO.getReceiveType())) continue;
                    settAmt = settAmt.add(orderRelationPO.getSettleAmt());
                }
                BigDecimal contractLeaveAmt = contractAmountRspBoList.getContractAmount().subtract(settAmt).setScale(6, RoundingMode.HALF_UP);
                contractInfo.setContractLeaveAmt(contractLeaveAmt.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : contractLeaveAmt);
                contractInfo.setContractType(((FscOrderRelationPO)list.get(0)).getContractType());
                contractInfo.setContractCode(((FscOrderRelationPO)list.get(0)).getContractNo());
            }
            contractInfos.add(contractInfo);
        }
        pdfBO.setContractInfoList(contractInfos);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = new FscComApprovalprocessListQryAbilityReqBO();
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBo.getAdjustId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(FscConstants.AuditObjType.FINANCE_WRITEOFF);
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.buildPdf(outputStream, approvalList, pdfBO);
        if (reqBo.getMergerFlag().booleanValue()) {
            rspBO.setByteArrayOutputStream(outputStream);
            return rspBO;
        }
        rspBO.setPrintUrl(this.uploadFile("\u9884\u4ed8\u6b3e\u6838\u9500\u5355", outputStream));
        rspBO.setOrderNo(pdfBO.getOrderNo());
        return rspBO;
    }

    private void buildPdfInfo(FscFinanceWriteOffPrintReqBO reqBo, FscFinanceWriteOffPrintAddPdfBO pdfBO) {
        FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPO = new FscFinanceWriteOffAdjustPO();
        fscFinanceWriteOffAdjustPO.setAdjustId(reqBo.getAdjustId());
        fscFinanceWriteOffAdjustPO = this.fscFinanceWriteOffAdjustMapper.getModelBy(fscFinanceWriteOffAdjustPO);
        if (fscFinanceWriteOffAdjustPO == null) {
            throw new FscBusinessException("198888", reqBo.getAdjustId() + "\u672a\u67e5\u8be2\u6838\u9500\u5355\u4fe1\u606f!");
        }
        pdfBO.setCreateTimeStr(DateUtil.dateToStr((Date)fscFinanceWriteOffAdjustPO.getCreateTime()));
        pdfBO.setFscOrderId(fscFinanceWriteOffAdjustPO.getFscOrderId());
        pdfBO.setWriteOffAmt(fscFinanceWriteOffAdjustPO.getWriteOffAmt().setScale(6, RoundingMode.HALF_UP));
        pdfBO.setBillType(fscFinanceWriteOffAdjustPO.getBillType());
        pdfBO.setBizDateStr(DateUtil.dateToStr((Date)new Date()));
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(pdfBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", pdfBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f!");
        }
        pdfBO.setOrderNo(orderPO.getOrderNo());
        pdfBO.setSupplierName(orderPO.getSupplierName());
        pdfBO.setSettleAmt(orderPO.getTotalCharge().setScale(6, RoundingMode.HALF_UP));
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(pdfBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
        pdfBO.setFinanceDeptName(financePO.getFinanceDeptName());
        pdfBO.setFinanceUserName(financePO.getFinanceUserName());
        pdfBO.setFinanceOrgName(financePO.getFinanceOrgName());
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(reqBo.getAdjustId());
        fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.FINANCE_WRITEOFF_FILE);
        List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
        pdfBO.setAttachmentNum(Integer.valueOf(fscAttachmentPOList.size()));
        pdfBO.setBizItemCode("1003000100090001");
        pdfBO.setBizItemName("\u91c7\u8d2d\u9884\u4ed8\u6838\u9500");
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(fscFinanceWriteOffAdjustPO.getBillType())) {
            pdfBO.setBizItemCode("1003000100100001");
            pdfBO.setBizItemName("\u9884\u4ed8\u6838\u9500\u51b2\u9500");
        }
    }

    @PostMapping(value={"cancelWriteOffPrint"})
    public FscFinanceWriteOffPrintRspBO cancelWriteOffPrint(@RequestBody FscFinanceWriteOffPrintReqBO reqBo) {
        if (reqBo.getAdjustId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[adjustId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscFinanceWriteOffPrintAddPdfBO pdfBO = new FscFinanceWriteOffPrintAddPdfBO();
        FscFinanceWriteOffPrintRspBO rspBO = new FscFinanceWriteOffPrintRspBO();
        this.buildPdfInfo(reqBo, pdfBO);
        FscFinanceWriteOffAdjustDetailPO fscFinanceWriteOffAdjustDetailPo = new FscFinanceWriteOffAdjustDetailPO();
        fscFinanceWriteOffAdjustDetailPo.setAdjustId(reqBo.getAdjustId());
        List fscFinanceWriteOffAdjustDetailPOList = this.fscFinanceWriteOffAdjustDetailMapper.getList(fscFinanceWriteOffAdjustDetailPo);
        Set collect = fscFinanceWriteOffAdjustDetailPOList.stream().map(e -> e.getContractId()).collect(Collectors.toSet());
        FscFinanceSelectContractAmountReqBO reqBO = new FscFinanceSelectContractAmountReqBO();
        reqBO.setContractIds(new ArrayList(collect));
        FscFinanceSelectContractAmountRspBo selectContractAmount = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(reqBO);
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setContractIds(new ArrayList(collect));
        fscOrderRelationPo.setFscOrderId(pdfBO.getFscOrderId());
        List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        ArrayList contractInfos = new ArrayList();
        ArrayList writeOffInfos = new ArrayList();
        fscFinanceWriteOffAdjustDetailPOList.stream().collect(Collectors.groupingBy(FscFinanceWriteOffAdjustDetailPO::getContractId)).forEach((id, fscFinanceWriteOffAdjustDetailPOS) -> {
            FscFinanceWriteOffPrintAddPdfBO.ContractInfo contractInfo = new FscFinanceWriteOffPrintAddPdfBO.ContractInfo();
            for (FscFinanceSelectContractAmountRspBoList contractAmountRow : selectContractAmount.getRows()) {
                if (!Objects.equals(contractAmountRow.getContractId(), id)) continue;
                contractInfo.setContractAmt(contractAmountRow.getContractAmount());
            }
            for (FscOrderRelationPO fscOrderRelationPO : relationPOList) {
                if (!Objects.equals(fscOrderRelationPO.getContractId(), id)) continue;
                contractInfo.setContractType(fscOrderRelationPO.getContractType());
                contractInfo.setContractName(fscOrderRelationPO.getContractName());
                contractInfo.setContractCode(fscOrderRelationPO.getContractNo());
            }
            BigDecimal thisContractAmt = BigDecimal.ZERO;
            for (FscFinanceWriteOffAdjustDetailPO fscFinanceWriteOffAdjustDetailPO : fscFinanceWriteOffAdjustDetailPOS) {
                FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo writeOffInfo = new FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo();
                writeOffInfo.setApplyBillCode(fscFinanceWriteOffAdjustDetailPO.getPayOrderNo());
                writeOffInfo.setCheckAmt(fscFinanceWriteOffAdjustDetailPO.getWriteOffAmt());
                thisContractAmt = thisContractAmt.add(fscFinanceWriteOffAdjustDetailPO.getWriteOffAmt());
                writeOffInfos.add(writeOffInfo);
            }
            contractInfo.setSettleAmt(thisContractAmt);
            contractInfos.add(contractInfo);
        });
        pdfBO.setContractInfoList(contractInfos);
        pdfBO.setWriteOffInfoList(writeOffInfos);
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = new FscComApprovalprocessListQryAbilityReqBO();
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBo.getAdjustId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(FscConstants.AuditObjType.FINANCE_WRITEOFF_CANCEL);
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.buildPdf(outputStream, approvalList, pdfBO);
        if (reqBo.getMergerFlag().booleanValue()) {
            rspBO.setByteArrayOutputStream(outputStream);
            return rspBO;
        }
        rspBO.setPrintUrl(this.uploadFile("\u9884\u4ed8\u6b3e\u6838\u9500\u5355", outputStream));
        rspBO.setOrderNo(pdfBO.getOrderNo());
        return rspBO;
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private void buildPdf(ByteArrayOutputStream outputStream, List<FscApprovalprocessListBO> approvalList, FscFinanceWriteOffPrintAddPdfBO pdfBO) {
        FscDicDictionaryBO icpBoReq = new FscDicDictionaryBO();
        icpBoReq.setPCode("FSC_FINANCE_PRINT_ICP");
        FscDicDictionaryBO icpBo = this.fscDictionaryBusiService.getDictionaryByBO(icpBoReq);
        FscDicDictionaryBO logoBoReq = new FscDicDictionaryBO();
        logoBoReq.setPCode("FSC_FINANCE_PRINT_LOGO");
        FscDicDictionaryBO logoBo = this.fscDictionaryBusiService.getDictionaryByBO(logoBoReq);
        Document document = PdfUtils.newDefaultDocument();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        }
        catch (DocumentException e) {
            log.error("\u521b\u5efa\u9ed8\u8ba4PDF\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, pdfBO);
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(pdfBO.getBillType())) {
            this.addMiddleTableForCancel(tableList, pdfBO);
        } else {
            this.addMiddleTable(tableList, pdfBO);
        }
        PdfUtils.addAuditTableShare(tableList, approvalList);
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)24, null);
        tableList.add(titleTable1);
        if (icpBo != null) {
            PdfUtils.addIcpTableShare(tableList, (String)icpBo.getDescrip());
        }
        if (logoBo != null) {
            try (HttpResponse response = HttpUtil.createGet((String)logoBo.getDescrip()).execute();){
                PdfUtils.addLogo((Document)document, (byte[])response.bodyBytes(), (float)100.0f, (float)100.0f, (float)10.0f, (float)500.0f);
            }
            catch (Exception e) {
                throw new FscBusinessException("198888", "\u6dfb\u52a0\u5bf9\u63a5\u5171\u4eab\u6253\u5370\u6a21\u677f\u4e2d\u7164Logo\u5931\u8d25", (Throwable)e);
            }
        }
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
    }

    public void addHeadTable(List<PdfPTable> tableList, FscFinanceWriteOffPrintAddPdfBO pdfBO) {
        String title = "\u9884\u4ed8\u6b3e\u6838\u9500\u5355";
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(pdfBO.getBillType())) {
            title = "\u9884\u4ed8\u6b3e\u53d6\u6d88\u6838\u9500\u7533\u8bf7\u5355";
        }
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)title, (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable1);
        PdfPTable titleTable2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u5355\u4f4d:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)pdfBO.getFinanceOrgName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u90e8\u95e8:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)pdfBO.getFinanceDeptName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ecf\u529e\u4eba:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)pdfBO.getFinanceUserName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        tableList.add(titleTable2);
        PdfPTable titleTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u65e5\u671f:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)pdfBO.getCreateTimeStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)"\u5355\u636e\u7f16\u53f7:", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, (Object)pdfBO.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)4, (Integer)0);
        PdfUtils.addCellToTable((PdfPTable)titleTable3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)8, (Integer)0);
        tableList.add(titleTable3);
        PdfPTable titleTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable4, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)2, (Integer)5, (Float)Float.valueOf(15.0f), (Integer)24, (Integer)0);
        tableList.add(titleTable4);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscFinanceWriteOffPrintAddPdfBO pdfBO) {
        PdfPTable table1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u4e1a\u52a1\u65e5\u671f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getBizDateStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9644\u4ef6\u5f20\u6570\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getAttachmentNum(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u6838\u9500\u91d1\u989d\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getWriteOffAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table1);
        PdfPTable table2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u4e1a\u52a1\u4e8b\u9879\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)pdfBO.getBizItemCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u7ed3\u7b97\u5355\u53f7\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)pdfBO.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u7ed3\u7b97\u91d1\u989d\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)pdfBO.getSettleAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table2);
        PdfPTable table3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)pdfBO.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(table3);
        PdfPTable table4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)"\u5408\u540c\u4fe1\u606f", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table4);
        PdfPTable table5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u7c7b\u578b", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u672a\u7ed3\u7b97\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table5);
        for (FscFinanceWriteOffPrintAddPdfBO.ContractInfo contractInfo : pdfBO.getContractInfoList()) {
            PdfPTable table6 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractType(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractLeaveAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getSettleAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            tableList.add(table6);
        }
        PdfPTable table6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u6838\u9500\u9884\u4ed8\u660e\u7ec6", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table6);
        PdfPTable table7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u9884\u4ed8\u6b3e\u5355\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u9884\u4ed8\u6b3e\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u5269\u4f59\u672a\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        tableList.add(table7);
        int sortNum = 1;
        for (FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo writeOffInfo : pdfBO.getWriteOffInfoList()) {
            PdfPTable table8 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)sortNum, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getApplyBillCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getAdvPayAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getAdvUncheckAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getCheckAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            tableList.add(table8);
            ++sortNum;
        }
    }

    private void addMiddleTableForCancel(List<PdfPTable> tableList, FscFinanceWriteOffPrintAddPdfBO pdfBO) {
        PdfPTable table1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u4e1a\u52a1\u65e5\u671f\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getBizDateStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u9644\u4ef6\u5f20\u6570\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getAttachmentNum(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)"\u53d6\u6d88\u6838\u9500\u603b\u91d1\u989d\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table1, (Object)pdfBO.getWriteOffAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table1);
        PdfPTable table2 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)"\u4e1a\u52a1\u4e8b\u9879\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table2, (Object)pdfBO.getBizItemName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(table2);
        PdfPTable table3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)pdfBO.getSupplierName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)"\u7ed3\u7b97\u5355\u53f7\uff1a", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, (Object)pdfBO.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table3, null, (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(table3);
        PdfPTable table4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table4, (Object)"\u5408\u540c\u4fe1\u606f", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table4);
        PdfPTable table5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u7c7b\u578b", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u5408\u540c\u91d1\u989d", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        PdfUtils.addCellToTable((PdfPTable)table5, (Object)"\u672c\u6b21\u53d6\u6d88\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
        tableList.add(table5);
        for (FscFinanceWriteOffPrintAddPdfBO.ContractInfo contractInfo : pdfBO.getContractInfoList()) {
            PdfPTable table6 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractType(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getContractAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            PdfUtils.addCellToTable((PdfPTable)table6, (Object)contractInfo.getSettleAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)5, null);
            tableList.add(table6);
        }
        PdfPTable table6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table6, (Object)"\u53d6\u6d88\u6838\u9500\u9884\u4ed8\u660e\u7ec6", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)24, null);
        tableList.add(table6);
        PdfPTable table7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u9884\u4ed8\u6b3e\u5355\u53f7", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)table7, (Object)"\u672c\u6b21\u53d6\u6d88\u6838\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09", (Font)PdfUtils.DEFAULT_CONTENT_FONT_BOLD, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        tableList.add(table7);
        int sortNum = 1;
        for (FscFinanceWriteOffPrintAddPdfBO.WriteOffInfo writeOffInfo : pdfBO.getWriteOffInfoList()) {
            PdfPTable table8 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)sortNum, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getApplyBillCode(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getCheckAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
            PdfUtils.addCellToTable((PdfPTable)table8, (Object)writeOffInfo.getCheckAmt(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
            tableList.add(table8);
            ++sortNum;
        }
    }
}

