/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.common.ability.bo.FscUseAccountBO;
import com.tydic.fsc.common.busi.api.FscAccountChargePurBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBatchBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountChargeBusiRspBO;
import com.tydic.fsc.common.enums.DeleteYnEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMainMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountMainPO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcBuyerCustomerQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocExtensionOfflineContractSelectAbilityService;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractSelectBo;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractSelectReqBo;
import com.tydic.uoc.common.ability.bo.UocExtensionOfflineContractSelectRspBo;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAccountChargePurBusiServiceImpl
implements FscAccountChargePurBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountChargePurBusiServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountMainMapper fscAccountMainMapper;
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private UmcBuyerCustomerQueryAbilityService umcBuyerCustomerQueryAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Value(value="${finance.charge.supplier.no:20110100966}")
    private String supplierNo;
    @Value(value="${finance.charge.supplier.erp.no:10010106}")
    private String supplierErpNo;
    @Autowired
    private UocExtensionOfflineContractSelectAbilityService uocExtensionOfflineContractSelectAbilityService;

    @Override
    public FscAccountChargeBusiRspBO dealAccountCharge(FscAccountChargeBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRecvDeptCode())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u6536\u6b3e\u5355\u4f4d\u7f16\u7801[recvDeptCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getUseDeptId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4f7f\u7528\u5355\u4f4did[useDeptId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setOrgId(reqBO.getUseDeptId());
        queryVo.setBusiType("1");
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (fscAccountPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscAccountMainPO mainQueryVo = new FscAccountMainPO();
        mainQueryVo.setBusiType("1");
        mainQueryVo.setOrgCode(this.operationOrgCode);
        FscAccountMainPO fscAccountMainPo = this.fscAccountMainMapper.getModelBy(mainQueryVo);
        if (fscAccountMainPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5f00\u53d1\u516c\u53f8\u4e3b\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscAccountChargePO fscAccountChargePo = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountChargePo);
        if (reqBO.getOperationType() == null || reqBO.getOperationType() == 1) {
            fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
            if (reqBO.getChargeId() == null) {
                fscAccountChargePo.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAccountChargePo.setCreateTime(new Date());
            }
        } else {
            fscAccountChargePo.setAuditStatus(FscConstants.AuditStatus.SAVE);
            if (reqBO.getChargeId() == null) {
                fscAccountChargePo.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAccountChargePo.setCreateTime(new Date());
            }
        }
        fscAccountChargePo.setAccountId(fscAccountPo.getId());
        fscAccountChargePo.setRecvDeptCode(this.operationOrgCode);
        fscAccountChargePo.setRecvDeptName(reqBO.getRecvDeptName());
        fscAccountChargePo.setRecvBankAccount(fscAccountMainPo.getBankAccount());
        fscAccountChargePo.setUserId(reqBO.getUserId());
        fscAccountChargePo.setBusiType(Integer.valueOf("1"));
        fscAccountChargePo.setUserName(reqBO.getName());
        fscAccountChargePo.setChargeStatus(FscConstants.ChargeStatus.AUDITING);
        if (reqBO.getChargeId() == null) {
            int insert = this.fscAccountChargeMapper.insert(fscAccountChargePo);
            if (insert < 0) {
                throw new FscBusinessException("198888", "\u65b0\u589e\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
            }
        } else {
            this.fscAccountChargeMapper.update(fscAccountChargePo);
        }
        FscAttachmentPO attachment = new FscAttachmentPO();
        attachment.setObjId(fscAccountChargePo.getChargeId());
        this.fscAttachmentMapper.deleteBy(attachment);
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
        for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setObjId(fscAccountChargePo.getChargeId());
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
            attachmentList.add(fscAttachmentPo);
        }
        this.fscAttachmentMapper.insertBatch(attachmentList);
        FscAccountChargeBusiRspBO rspBO = new FscAccountChargeBusiRspBO();
        if (reqBO.getOperationType() == null || reqBO.getOperationType() == 1) {
            this.invokeUacNoTask(reqBO, fscAccountChargePo.getChargeId(), fscAccountChargePo.getAdvanceDepositNo(), fscAccountChargePo);
            rspBO.setPushFlag(true);
            FscTaskCandidatePO fscTaskCandidatePO = new FscTaskCandidatePO();
            fscTaskCandidatePO.setFscOrderId(fscAccountChargePo.getChargeId());
            List auditedPostIdAndOperIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(fscTaskCandidatePO);
            if (!CollectionUtils.isEmpty((Collection)auditedPostIdAndOperIdList)) {
                StringBuilder auditedPostIds = new StringBuilder();
                auditedPostIds.append(",");
                for (FscApprovalTaskQueryBO fscApprovalTaskQueryBO : auditedPostIdAndOperIdList) {
                    auditedPostIds.append(fscApprovalTaskQueryBO.getTaskOperId()).append(",");
                }
                fscAccountChargePo.setTaskOperId(auditedPostIds.toString());
                this.fscAccountChargeMapper.updateTaskOperById(fscAccountChargePo);
            }
        }
        rspBO.setChargeId(fscAccountChargePo.getChargeId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveFinanceInfo(FscAccountChargeBatchBusiReqBO reqBO, Long chargeId, String chargeNo, String busiType) {
        ArrayList<FscOrderPayItemBO> payItemList = new ArrayList<FscOrderPayItemBO>();
        for (FscUseAccountBO accountBO : reqBO.getUseAccountBOList()) {
            FscOrderPayItemBO payItemBO = new FscOrderPayItemBO();
            BeanUtils.copyProperties((Object)accountBO, (Object)payItemBO);
            payItemBO.setShouldPayId(accountBO.getItemId());
            payItemBO.setOrderPayItemId(accountBO.getItemId());
            payItemBO.setItemNo(accountBO.getItemNo());
            payItemBO.setSerialList(accountBO.getSerialList());
            payItemBO.setFinanceItemList(accountBO.getFinanceItemList());
            payItemList.add(payItemBO);
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)financePO);
        financePO.setFscOrderId(chargeId);
        if (reqBO.getChargeId() == null) {
            UocExtensionOfflineContractSelectRspBo selectRspBo;
            UocExtensionOfflineContractSelectReqBo selectReqBo = new UocExtensionOfflineContractSelectReqBo();
            selectReqBo.setBuyerNo(reqBO.getChargeDeptCode());
            selectReqBo.setSupplierNo(this.supplierNo);
            selectReqBo.setOrderType(Integer.valueOf(0));
            if (busiType.equals("4")) {
                selectReqBo.setOrderType(Integer.valueOf(4));
            }
            if (CollectionUtils.isEmpty((Collection)(selectRspBo = this.uocExtensionOfflineContractSelectAbilityService.selectOfflineContract(selectReqBo)).getData())) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f");
            }
            if (selectRspBo.getData().size() != 1) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u7ebf\u4e0b\u5408\u540c\u751f\u6548\u4e2a\u6570\u4e3a" + selectRspBo.getData().size() + "\u4e2a!\u8bf7\u5148\u7ea0\u6b63\u7ef4\u62a4\u7ebf\u4e0b\u5408\u540c\u4fe1\u606f");
            }
            financePO.setCreateTime(new Date());
            financePO.setCreateUserId(reqBO.getUserName());
            financePO.setCreateUserName(reqBO.getName());
            financePO.setFinanceUserId(reqBO.getUserName());
            financePO.setFinanceUserName(reqBO.getName());
            financePO.setExt1(this.supplierErpNo);
            this.fscOrderFinanceMapper.insert(financePO);
            FscAccountChargePO updateChargePO = new FscAccountChargePO();
            updateChargePO.setChargeId(chargeId);
            updateChargePO.setContractNo(((UocExtensionOfflineContractSelectBo)selectRspBo.getData().get(0)).getContractNo());
            updateChargePO.setContractName(((UocExtensionOfflineContractSelectBo)selectRspBo.getData().get(0)).getContractName());
            updateChargePO.setContractId(((UocExtensionOfflineContractSelectBo)selectRspBo.getData().get(0)).getContractId());
            updateChargePO.setContractType(Integer.valueOf("3"));
            this.fscAccountChargeMapper.update(updateChargePO);
        } else {
            financePO.setUpdateTime(new Date());
            financePO.setUpdateUserId(reqBO.getUserName());
            financePO.setUpdateUserName(reqBO.getName());
            this.fscOrderFinanceMapper.updateById(financePO);
            this.fscFinancePayItemMapper.deleteByFscOrderId(chargeId);
            this.fscFinanceCapitalPlanMapper.deleteByFscOrderId(chargeId);
            this.fscFinanceDraftInfoMapper.deleteByFscOrderId(chargeId);
            this.fscFinanceBankStatementMapper.deleteByFscOrderId(chargeId);
            this.fscFinancePayReduceMapper.deleteByFscOrderId(chargeId);
        }
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(chargeId);
        atomReqBO.setObjNo(chargeNo);
        atomReqBO.setObjType(Integer.valueOf(2));
        atomReqBO.setFscOrderPayItemBOS(payItemList);
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    @Override
    public FscAccountChargeBatchBusiRspBO dealAccountChargeBatch(FscAccountChargeBatchBusiReqBO reqBO) {
        int deleteCount;
        if (reqBO.getOperationType() == 1 && StringUtils.isEmpty((Object)reqBO.getRecvDeptCode())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u6536\u6b3e\u5355\u4f4d\u7f16\u7801[recvDeptCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List orgIds = reqBO.getUseAccountBOList().stream().map(FscUseAccountBO::getUseDeptId).distinct().collect(Collectors.toList());
        String busiType = null;
        busiType = "1".equals(reqBO.getEmployeeChargeFlag()) ? "4" : "1";
        List accountPOList = this.fscAccountMapper.queryByOrgIds(orgIds, busiType);
        if (CollectionUtils.isEmpty((Collection)accountPOList) || accountPOList.size() != orgIds.size()) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        Map<Long, FscAccountPO> accountPOMap = accountPOList.stream().collect(Collectors.toMap(FscAccountPO::getOrgId, e -> e, (k1, k2) -> k1));
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setEnable(Integer.valueOf(1));
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (fscMerchantPo.getMerchantId() != null) {
            FscMerchantPO merchantElectricity = new FscMerchantPO();
            merchantElectricity.setPayBusiSceneRangeLike("1");
            merchantElectricity.setParentId(fscMerchantPo.getMerchantId());
            merchantElectricity.setDelFlag(FscConstants.DicDelFlag.NO);
            merchantElectricity.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            merchantElectricity.setPayObjIds(orgIds);
            merchantElectricity.setEnable(Integer.valueOf(1));
            List merchantPOList = this.fscMerchantMapper.getList(merchantElectricity);
            List filterList = merchantPOList.stream().filter(merchant -> FscConstants.FscPayType.FSC_PAY_TYPE_ADVANCE.equals(merchant.getPayType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterList) && !FscConstants.FscPayType.FSC_PAY_TYPE_ADVANCE.equals(fscMerchantPo.getPayType())) {
                throw new FscBusinessException("198888", "\u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u662f\u9884\u5b58\u6b3e\u652f\u4ed8\uff0c\u65e0\u6cd5\u5145\u503c\uff01");
            }
        }
        boolean addFlag = StringUtils.isEmpty((Object)reqBO.getChargeId());
        FscAccountMainPO mainQueryVO = new FscAccountMainPO();
        if (!"1".equals(reqBO.getEmployeeChargeFlag())) {
            mainQueryVO.setBusiType("1");
        }
        mainQueryVO.setOrgCode(this.operationOrgCode);
        FscAccountMainPO fscAccountMainPO = this.fscAccountMainMapper.getModelBy(mainQueryVO);
        if (fscAccountMainPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5f00\u53d1\u516c\u53f8\u4e3b\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscAccountChargePO fscAccountChargePO = new FscAccountChargePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountChargePO);
        fscAccountChargePO.setAccountId(null);
        fscAccountChargePO.setAuditStatus(reqBO.getOperationType() == null ? FscConstants.AuditStatus.AUDITING : reqBO.getOperationType());
        fscAccountChargePO.setRecvDeptCode(this.operationOrgCode);
        fscAccountChargePO.setRecvDeptName(reqBO.getRecvDeptName());
        fscAccountChargePO.setRecvBankAccount(fscAccountMainPO.getBankAccount());
        fscAccountChargePO.setUserId(reqBO.getUserId());
        if (!"1".equals(reqBO.getEmployeeChargeFlag())) {
            fscAccountChargePO.setBusiType(Integer.valueOf("1"));
        } else {
            fscAccountChargePO.setBusiType(Integer.valueOf("4"));
        }
        fscAccountChargePO.setUserName(reqBO.getName());
        fscAccountChargePO.setChargeStatus(FscConstants.ChargeStatus.AUDITING);
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId())) {
            fscAccountChargePO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        }
        if (addFlag) {
            fscAccountChargePO.setChargeId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAccountChargePO.setCreateTime(new Date());
            int insertCount = this.fscAccountChargeMapper.insert(fscAccountChargePO);
            if (insertCount < 1) {
                throw new FscBusinessException("198888", "\u65b0\u589e\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
            }
        } else {
            this.updateFinanceRejectStatus(reqBO, fscAccountChargePO);
            int updateCount = this.fscAccountChargeMapper.update(fscAccountChargePO);
            if (updateCount < 1) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
            }
        }
        ArrayList detailPOList = new ArrayList();
        reqBO.getUseAccountBOList().forEach(e -> {
            FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
            BeanUtils.copyProperties((Object)e, (Object)fscAccountChargeDetailPO);
            fscAccountChargeDetailPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAccountChargeDetailPO.setChargeId(fscAccountChargePO.getChargeId());
            fscAccountChargeDetailPO.setAdvanceDepositNo(reqBO.getAdvanceDepositNo());
            if (accountPOMap.get(e.getUseDeptId()) == null) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u76f8\u5173\u4fe1\u606f, \u4f7f\u7528\u5355\u4f4d\u8d26\u6237\u4e3a\uff1a" + e.getUseDeptName());
            }
            fscAccountChargeDetailPO.setAccountId(((FscAccountPO)accountPOMap.get(e.getUseDeptId())).getId());
            fscAccountChargeDetailPO.setCreateId(reqBO.getUserId());
            fscAccountChargeDetailPO.setCreateTime(new Date());
            fscAccountChargeDetailPO.setUpdateId(reqBO.getUserId());
            fscAccountChargeDetailPO.setUpdateTime(new Date());
            fscAccountChargeDetailPO.setDeleteYn(DeleteYnEnum.NORMAL.getCode());
            if ("1".equals(reqBO.getEmployeeChargeFlag())) {
                fscAccountChargeDetailPO.setCompanyAmount(e.getCompanyChargeAmount());
                fscAccountChargeDetailPO.setUnionAmount(e.getUnionChargeAmount());
            }
            e.setItemId(fscAccountChargeDetailPO.getId());
            detailPOList.add(fscAccountChargeDetailPO);
        });
        if (!addFlag && (deleteCount = this.fscAccountChargeDetailMapper.deleteByChargeId(reqBO.getChargeId())) < 1) {
            throw new FscBusinessException("198888", "\u4fdd\u5b58\u8d26\u6237\u5145\u503c\u5931\u8d25\uff01");
        }
        int insertCount = this.fscAccountChargeDetailMapper.insertBatch(detailPOList);
        if (insertCount < 1) {
            throw new FscBusinessException("198888", "\u8d26\u6237\u5145\u503c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        FscAttachmentPO attachment = new FscAttachmentPO();
        attachment.setObjId(fscAccountChargePO.getChargeId());
        this.fscAttachmentMapper.deleteBy(attachment);
        ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
        for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setObjId(fscAccountChargePO.getChargeId());
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
            attachmentList.add(fscAttachmentPo);
        }
        if (!CollectionUtils.isEmpty(attachmentList)) {
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getFinanceOrgId())) {
            this.saveFinanceInfo(reqBO, fscAccountChargePO.getChargeId(), fscAccountChargePO.getAdvanceDepositNo(), busiType);
        }
        FscAccountChargeBatchBusiRspBO rspBO = new FscAccountChargeBatchBusiRspBO();
        if ("0".equals(reqBO.getIsDock()) && (reqBO.getOperationType() == null || reqBO.getOperationType() == 1)) {
            this.invokeUacNoTask(reqBO, fscAccountChargePO.getChargeId(), fscAccountChargePO);
            rspBO.setPushFlag(true);
            FscTaskCandidatePO fscTaskCandidatePO = new FscTaskCandidatePO();
            fscTaskCandidatePO.setFscOrderId(fscAccountChargePO.getChargeId());
            List auditedPostIdAndOperIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(fscTaskCandidatePO);
            if (!CollectionUtils.isEmpty((Collection)auditedPostIdAndOperIdList)) {
                StringBuilder auditedPostIds = new StringBuilder();
                auditedPostIds.append(",");
                for (FscApprovalTaskQueryBO fscApprovalTaskQueryBO : auditedPostIdAndOperIdList) {
                    auditedPostIds.append(fscApprovalTaskQueryBO.getTaskOperId()).append(",");
                }
                fscAccountChargePO.setTaskOperId(auditedPostIds.toString());
                this.fscAccountChargeMapper.updateTaskOperById(fscAccountChargePO);
            }
        }
        rspBO.setChargeId(fscAccountChargePO.getChargeId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateFinanceRejectStatus(FscAccountChargeBatchBusiReqBO reqBO, FscAccountChargePO updateFscAccountCharge) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getOperationType()) && reqBO.getOperationType() == 1) {
            return;
        }
        FscAccountChargePO qryFscAccountCharge = new FscAccountChargePO();
        qryFscAccountCharge.setChargeId(reqBO.getChargeId());
        FscAccountChargePO fscAccountChargePO = this.fscAccountChargeMapper.getModelBy(qryFscAccountCharge);
        if (ObjectUtil.isEmpty((Object)fscAccountChargePO)) {
            throw new FscBusinessException("198888", "\u8d26\u6237\u5145\u503c\u8bb0\u5f55\u4e3a\u7a7a");
        }
        if (FscConstants.AuditStatus.FINANCE_REJECT.equals(fscAccountChargePO.getAuditStatus())) {
            updateFscAccountCharge.setAuditStatus(FscConstants.AuditStatus.FINANCE_REJECT);
            FscOrderFinancePO fscOrderFinanceSet = new FscOrderFinancePO();
            fscOrderFinanceSet.setPushFinanceStatus(Integer.valueOf(3));
            FscOrderFinancePO fscOrderFinanceWhere = new FscOrderFinancePO();
            fscOrderFinanceWhere.setFscOrderId(reqBO.getChargeId());
            this.fscOrderFinanceMapper.updateBy(fscOrderFinanceSet, fscOrderFinanceWhere);
        }
    }

    private void invokeUacNoTask(FscAccountChargeBusiReqBO busiReqBO, Long chargeOrderId, String advanceDepositNo, FscAccountChargePO fscAccountChargePo) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("M001006");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(chargeOrderId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(chargeOrderId.toString());
        approvalObjBO.setObjName("\u8d26\u6237\u5145\u503c\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("194203", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5ba1\u6279\u6d41\uff01");
        }
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(chargeOrderId);
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(advanceDepositNo + "\u9884\u5b58\u6b3e\u5145\u503c_" + (String)busiTypeMap.get(fscAccountChargePo.getBusiType() + "") + "_" + fscAccountChargePo.getChargeAmount().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9884\u5b58\u6b3e\u7533\u8bf7\u5355" + advanceDepositNo + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(busiReqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
    }

    private void invokeUacNoTask(FscAccountChargeBatchBusiReqBO busiReqBO, Long chargeOrderId, FscAccountChargePO fscAccountChargePO) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        if (StringUtils.isEmpty((Object)busiReqBO.getFinanceOrgId())) {
            uacNoTaskAuditCreateReqBO.setMenuId("M001006");
        } else {
            uacNoTaskAuditCreateReqBO.setMenuId("M003048");
        }
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(chargeOrderId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(chargeOrderId.toString());
        approvalObjBO.setObjName("\u8d26\u6237\u5145\u503c\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ACCOUNT_CHARGE_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("194203", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5ba1\u6279\u6d41\uff01");
        }
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(chargeOrderId);
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            Map busiTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUSI_TYPE");
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList()) && !FscConstants.SettlePlatform.FINANCE.equals(fscAccountChargePO.getSettlePlatform())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscAccountChargePO.getAdvanceDepositNo() + "\u9884\u5b58\u6b3e\u5145\u503c_" + (String)busiTypeMap.get(fscAccountChargePO.getBusiType() + "") + "_" + fscAccountChargePO.getChargeAmount().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9884\u5b58\u6b3e\u7533\u8bf7\u5355" + fscAccountChargePO.getAdvanceDepositNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(busiReqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
    }
}

