/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscClaimChangeConfirmStatusBusiService;
import com.tydic.fsc.common.busi.api.FscCreditDeductBatchBusiService;
import com.tydic.fsc.common.busi.bo.FscClaimChangeCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmStatusBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscClaimChangeConfirmStatusBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscCreditDeductBatchBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscCreditDeductBatchBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPushClaimDetailMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPushClaimDetailPo;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscClaimChangeConfirmStatusBusiServiceImpl
implements FscClaimChangeConfirmStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscClaimChangeConfirmStatusBusiServiceImpl.class);
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscPushClaimDetailMapper fscPushClaimDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCreditDeductBatchBusiService fscCreditDeductBatchBusiService;

    @Override
    public FscClaimChangeConfirmStatusBusiRspBO dealClaimChangeConfirmStatus(FscClaimChangeConfirmStatusBusiReqBO reqBO) {
        FscClaimChangeConfirmStatusBusiRspBO rspBO = new FscClaimChangeConfirmStatusBusiRspBO();
        FscClaimDetailChangePO fscClaimDetailChangePO = new FscClaimDetailChangePO();
        fscClaimDetailChangePO.setChangeDetailIdList(reqBO.getChangeDetailIdList());
        fscClaimDetailChangePO.setConfirmStatus(reqBO.getType());
        fscClaimDetailChangePO.setReturnReason(reqBO.getReason());
        int result = this.fscClaimDetailChangeMapper.updateConfirmStatus(fscClaimDetailChangePO);
        if (result != reqBO.getChangeDetailIdList().size()) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u53d8\u66f4\u660e\u7ec6\u72b6\u6001\u5931\u8d25\uff01");
        }
        if (FscConstants.ChangeConfirmStatus.RETURN.equals(fscClaimDetailChangePO.getConfirmStatus())) {
            FscClaimDetailChangePO detailChangePO = new FscClaimDetailChangePO();
            detailChangePO.setChangeDetailIdList(reqBO.getChangeDetailIdList());
            List detailChangeList = this.fscClaimDetailChangeMapper.queryAll(detailChangePO);
            List changeIdList = detailChangeList.stream().map(FscClaimDetailChangePO::getChangeId).distinct().collect(Collectors.toList());
            FscRecvClaimChangePO fscRecvClaimChangePO = new FscRecvClaimChangePO();
            fscRecvClaimChangePO.setConfirmDate(new Date());
            fscRecvClaimChangePO.setChangeIdList(changeIdList);
            fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.PART_CONFIRMED);
            this.fscRecvClaimChangeMapper.updateBillStatus(fscRecvClaimChangePO);
        } else if (FscConstants.ChangeConfirmStatus.CANCEL.equals(fscClaimDetailChangePO.getConfirmStatus())) {
            FscClaimDetailChangePO detailChangePO = new FscClaimDetailChangePO();
            detailChangePO.setChangeDetailIdList(reqBO.getChangeDetailIdList());
            List detailChangeList = this.fscClaimDetailChangeMapper.queryAll(detailChangePO);
            Map<Long, FscShouldPayPO> shouldPayMap = this.queryOrderInfo(detailChangeList);
            Map<Long, FscOrderPO> orderMap = this.queryFscOrderInfo(detailChangeList);
            this.assembleBusiData(detailChangeList, shouldPayMap, orderMap);
            rspBO.setChangeIdList(this.updateChangeBillStatus(detailChangeList));
        }
        return rspBO;
    }

    @Override
    public FscClaimChangeConfirmStatusBusiRspBO dealClaimChangeCancel(FscClaimChangeCancelBusiReqBO reqBO) {
        FscClaimChangeConfirmStatusBusiRspBO rspBO = new FscClaimChangeConfirmStatusBusiRspBO();
        for (Long changeId : reqBO.getChangeId()) {
            FscClaimDetailChangePO detailChangePO = new FscClaimDetailChangePO();
            detailChangePO.setChangeId(changeId);
            List detailChangeList = this.fscClaimDetailChangeMapper.queryAll(detailChangePO);
            if (!CollectionUtils.isEmpty((Collection)detailChangeList)) {
                for (FscClaimDetailChangePO d : detailChangeList) {
                    if (ObjectUtil.isNotEmpty((Object)d.getChangeSource()) && "2".equals(d.getChangeSource().toString())) {
                        if (d.getChangeFscOrderId() == null) continue;
                        FscPushClaimDetailPo updatePo = new FscPushClaimDetailPo();
                        updatePo.setChangeOccupyState(Integer.valueOf(0));
                        ArrayList<Long> updateByFscOrderIds = new ArrayList<Long>();
                        updateByFscOrderIds.add(d.getChangeFscOrderId());
                        updatePo.setFscOrderIds(updateByFscOrderIds);
                        this.fscPushClaimDetailMapper.updateByChanges(updatePo);
                        continue;
                    }
                    if (ObjectUtil.isNotEmpty((Object)d.getChangeBusiType()) && "1".equals(d.getChangeBusiType().toString()) && d.getChangeFscOrderId() != null) {
                        this.fscOrderRelationMapper.updateChangeOccupyStateFscOrderIdList(d.getChangeFscOrderId());
                    }
                    if (!ObjectUtil.isNotEmpty((Object)d.getChangeBusiType()) || !"2".equals(d.getChangeBusiType().toString()) || d.getChangeOrderId() == null) continue;
                    this.fscShouldPayMapper.updateChangeOccupyStateFscOrderIdList(d.getChangeOrderId());
                }
                FscClaimDetailChangePO setPo = new FscClaimDetailChangePO();
                setPo.setDelFlag(Integer.valueOf(1));
                FscClaimDetailChangePO wherePo = new FscClaimDetailChangePO();
                wherePo.setChangeId(changeId);
                this.fscClaimDetailChangeMapper.updateBy(setPo, wherePo);
            }
            try {
                FscRecvClaimChangePO changePO = new FscRecvClaimChangePO();
                changePO.setDelFlag(Integer.valueOf(1));
                changePO.setPostingStatus("1");
                changePO.setChangeId(changeId);
                this.fscRecvClaimChangeMapper.update(changePO);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u8ba4\u9886\u5355\u53d8\u66f4\u5931\u8d25", (Throwable)e);
                throw new ZTBusinessException("\u53d6\u6d88\u8ba4\u9886\u5355\u53d8\u66f4\u5931\u8d25" + e.getMessage());
            }
        }
        return rspBO;
    }

    private Map<Long, FscShouldPayPO> queryOrderInfo(List<FscClaimDetailChangePO> detailChangeList) {
        HashMap<Long, FscShouldPayPO> shouldPayMap = new HashMap<Long, FscShouldPayPO>();
        List shouldPayIdList = detailChangeList.stream().filter(detail -> detail.getShouldPayId() != null).map(FscClaimDetailChangePO::getShouldPayId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(shouldPayIdList)) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayIds(shouldPayIdList);
            List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
            for (FscShouldPayPO po : fscShouldPayPOList) {
                shouldPayMap.put(po.getShouldPayId(), po);
            }
        }
        return shouldPayMap;
    }

    private Map<Long, FscOrderPO> queryFscOrderInfo(List<FscClaimDetailChangePO> detailChangeList) {
        HashMap<Long, FscOrderPO> orderMap = new HashMap<Long, FscOrderPO>();
        List fscOrderIdList = detailChangeList.stream().filter(detail -> detail.getFscOrderId() != null).map(FscClaimDetailChangePO::getFscOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fscOrderIdList)) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIdList);
            List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
            for (FscOrderPO po : fscOrderPOList) {
                orderMap.put(po.getFscOrderId(), po);
            }
        }
        return orderMap;
    }

    private void assembleBusiData(List<FscClaimDetailChangePO> detailChangeList, Map<Long, FscShouldPayPO> shouldPayMap, Map<Long, FscOrderPO> orderMap) {
        int result;
        HashMap<Long, FscClaimDetailPO> detailMap = new HashMap<Long, FscClaimDetailPO>();
        HashMap<Long, FscRecvClaimPO> claimMap = new HashMap<Long, FscRecvClaimPO>();
        HashMap<Long, FscAccountPO> accountMap = new HashMap<Long, FscAccountPO>();
        HashMap<String, FscOrderRelationPO> relationMap = new HashMap<String, FscOrderRelationPO>();
        HashMap<Long, FscPushClaimDetailPo> ycOrderMap = new HashMap<Long, FscPushClaimDetailPo>();
        HashMap<Long, FscShouldPayPO> fscShouldPayMap = new HashMap<Long, FscShouldPayPO>();
        HashMap<Long, FscOrderPO> fscOrderMap = new HashMap<Long, FscOrderPO>();
        ArrayList<FscCreditDeductAbilityReqBO> deductList = new ArrayList<FscCreditDeductAbilityReqBO>();
        for (FscClaimDetailChangePO fscClaimDetailChangePO : detailChangeList) {
            ArrayList<String> orderNo;
            FscCreditDeductAbilityReqBO deductReqBO;
            FscShouldPayPO fscShouldPayPO;
            FscClaimDetailPO fscClaimDetailPO = (FscClaimDetailPO)detailMap.get(fscClaimDetailChangePO.getClaimDetailId());
            if (fscClaimDetailPO == null) {
                fscClaimDetailPO = new FscClaimDetailPO();
                fscClaimDetailPO.setClaimDetailId(fscClaimDetailChangePO.getClaimDetailId());
                fscClaimDetailPO.setChangedAmt(fscClaimDetailChangePO.getChangeAmt());
            } else {
                fscClaimDetailPO.setChangedAmt(fscClaimDetailPO.getChangedAmt().add(fscClaimDetailChangePO.getChangeAmt()));
            }
            detailMap.put(fscClaimDetailChangePO.getClaimDetailId(), fscClaimDetailPO);
            FscRecvClaimPO fscRecvClaimPO = (FscRecvClaimPO)claimMap.get(fscClaimDetailChangePO.getClaimId());
            if (fscRecvClaimPO == null) {
                fscRecvClaimPO = new FscRecvClaimPO();
                fscRecvClaimPO.setClaimId(fscClaimDetailChangePO.getClaimId());
                fscRecvClaimPO.setChangedAmt(fscClaimDetailChangePO.getChangeAmt());
            } else {
                fscRecvClaimPO.setChangedAmt(fscRecvClaimPO.getChangedAmt().add(fscClaimDetailChangePO.getChangeAmt()));
            }
            claimMap.put(fscClaimDetailChangePO.getClaimId(), fscRecvClaimPO);
            if (FscConstants.ChangeBusiType.SETTLE.equals(fscClaimDetailChangePO.getChangeBusiType())) {
                if (FscSystemSourceEnum.YG.getCode().equals(fscClaimDetailChangePO.getChangeSource())) {
                    FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)relationMap.get(fscClaimDetailChangePO.getChangeFscOrderId() + fscClaimDetailChangePO.getChangeAcceptId() + "");
                    if (fscOrderRelationPO == null) {
                        fscOrderRelationPO = new FscOrderRelationPO();
                        fscOrderRelationPO.setFscOrderId(fscClaimDetailChangePO.getChangeFscOrderId());
                        fscOrderRelationPO.setAcceptOrderId(fscClaimDetailChangePO.getChangeAcceptId());
                        fscOrderRelationPO.setOperationClaimAmt(fscClaimDetailChangePO.getChangeAmt());
                    } else {
                        fscOrderRelationPO.setOperationClaimAmt(fscOrderRelationPO.getOperationClaimAmt().add(fscClaimDetailChangePO.getChangeAmt()));
                    }
                    relationMap.put(fscClaimDetailChangePO.getChangeFscOrderId() + fscClaimDetailChangePO.getChangeAcceptId() + "", fscOrderRelationPO);
                } else if (FscSystemSourceEnum.YC.getCode().equals(fscClaimDetailChangePO.getChangeSource())) {
                    FscPushClaimDetailPo fscPushClaimDetailPo = (FscPushClaimDetailPo)ycOrderMap.get(fscClaimDetailChangePO.getChangeFscOrderId());
                    if (fscPushClaimDetailPo == null) {
                        fscPushClaimDetailPo = new FscPushClaimDetailPo();
                        fscPushClaimDetailPo.setFscOrderId(fscClaimDetailChangePO.getChangeFscOrderId());
                        fscPushClaimDetailPo.setClaimAmt(fscClaimDetailChangePO.getClaimAmt());
                    } else {
                        fscPushClaimDetailPo.setClaimAmt(fscPushClaimDetailPo.getClaimAmt().add(fscClaimDetailChangePO.getChangeAmt()));
                    }
                    ycOrderMap.put(fscClaimDetailChangePO.getChangeFscOrderId(), fscPushClaimDetailPo);
                }
            } else if (FscConstants.ChangeBusiType.ORDER.equals(fscClaimDetailChangePO.getChangeBusiType())) {
                fscShouldPayPO = (FscShouldPayPO)fscShouldPayMap.get(fscClaimDetailChangePO.getChangeShouldPayId());
                if (fscShouldPayPO == null) {
                    fscShouldPayPO = new FscShouldPayPO();
                    fscShouldPayPO.setShouldPayId(fscClaimDetailChangePO.getChangeShouldPayId());
                    fscShouldPayPO.setClaimAmt(fscClaimDetailChangePO.getChangeAmt());
                } else {
                    fscShouldPayPO.setClaimAmt(fscShouldPayPO.getClaimAmt().add(fscClaimDetailChangePO.getChangeAmt()));
                }
                fscShouldPayMap.put(fscClaimDetailChangePO.getChangeShouldPayId(), fscShouldPayPO);
                if (fscClaimDetailChangePO.getChangePayOrderId() != null) {
                    FscOrderPO fscOrderPO = (FscOrderPO)fscOrderMap.get(fscClaimDetailChangePO.getChangePayOrderId());
                    if (fscOrderPO == null) {
                        fscOrderPO = new FscOrderPO();
                        fscOrderPO.setFscOrderId(fscClaimDetailChangePO.getChangePayOrderId());
                        fscOrderPO.setShouldPayId(fscClaimDetailChangePO.getChangeShouldPayId());
                        fscOrderPO.setClaimAmount(fscClaimDetailChangePO.getChangeAmt());
                    } else {
                        fscOrderPO.setClaimAmount(fscOrderPO.getClaimAmount().add(fscClaimDetailChangePO.getClaimAmt()));
                    }
                    fscOrderMap.put(fscClaimDetailChangePO.getChangePayOrderId(), fscOrderPO);
                }
            }
            if (!FscSystemSourceEnum.YG.getCode().equals(fscClaimDetailChangePO.getSysSource())) continue;
            if (FscConstants.ChangeBusiType.ADVANCE.equals(fscClaimDetailChangePO.getBusiType())) {
                FscAccountPO fscAccountPO = (FscAccountPO)accountMap.get(fscClaimDetailChangePO.getAccountId());
                if (fscAccountPO == null) {
                    fscAccountPO = new FscAccountPO();
                    fscAccountPO.setId(fscClaimDetailChangePO.getAccountId());
                    fscAccountPO.setOrderAmount(fscClaimDetailChangePO.getChangeAmt());
                } else {
                    fscAccountPO.setOrderAmount(fscAccountPO.getOrderAmount().add(fscClaimDetailChangePO.getChangeAmt()));
                }
                accountMap.put(fscClaimDetailChangePO.getAccountId(), fscAccountPO);
                continue;
            }
            if (FscConstants.ChangeBusiType.SETTLE.equals(fscClaimDetailChangePO.getBusiType())) {
                FscOrderPO fscOrderPO = orderMap.get(fscClaimDetailChangePO.getFscOrderId());
                if (!FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) continue;
                deductReqBO = new FscCreditDeductAbilityReqBO();
                deductReqBO.setSupId(fscOrderPO.getPayeeId());
                if ("1".equals(fscOrderPO.getOrderSource().toString())) {
                    deductReqBO.setPayBusiness("2");
                } else if ("2".equals(fscOrderPO.getOrderSource().toString())) {
                    deductReqBO.setPayBusiness("1");
                }
                deductReqBO.setCreditOrgId(fscClaimDetailChangePO.getOrgId());
                deductReqBO.setCreditOrgCode(fscOrderPO.getBuynerNo());
                deductReqBO.setNoLog(Boolean.FALSE);
                orderNo = new ArrayList();
                orderNo.add(fscClaimDetailChangePO.getFscOrderNo());
                deductReqBO.setOrderNo(orderNo);
                deductReqBO.setAmount(fscClaimDetailChangePO.getChangeAmt().multiply(new BigDecimal(-1)));
                deductList.add(deductReqBO);
                continue;
            }
            if (!FscConstants.ChangeBusiType.ORDER.equals(fscClaimDetailChangePO.getBusiType()) || !FscConstants.FscPayType.FSC_PAY_TYPE_PERIOD.equals((fscShouldPayPO = shouldPayMap.get(fscClaimDetailChangePO.getShouldPayId())).getPayType())) continue;
            deductReqBO = new FscCreditDeductAbilityReqBO();
            deductReqBO.setSupId(fscShouldPayPO.getPayeeId());
            deductReqBO.setPayBusiness("2");
            deductReqBO.setCreditOrgId(fscClaimDetailChangePO.getOrgId());
            deductReqBO.setCreditOrgCode(fscShouldPayPO.getBuyerNo());
            deductReqBO.setNoLog(Boolean.FALSE);
            orderNo = new ArrayList<String>();
            orderNo.add(fscClaimDetailChangePO.getOrderCode());
            deductReqBO.setOrderNo(orderNo);
            deductReqBO.setAmount(fscClaimDetailChangePO.getChangeAmt().multiply(new BigDecimal(-1)));
            deductList.add(deductReqBO);
        }
        if (!CollectionUtils.isEmpty(detailMap.values()) && (result = this.fscClaimDetailMapper.updateChangeAmtSubBatch(new ArrayList(detailMap.values()))) != detailMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u8ba4\u9886\u5355\u53d8\u66f4\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(claimMap.values()) && (result = this.fscRecvClaimMapper.updateChangeAmtSubBatch(new ArrayList(claimMap.values()))) != claimMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u8ba4\u9886\u5355\u660e\u7ec6\u53d8\u66f4\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(accountMap.values()) && (result = this.fscAccountMapper.updateFreezeAmtSubBatch(new ArrayList(accountMap.values()))) != accountMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u8d26\u6237\u9884\u5b58\u6b3e\u51bb\u7ed3\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(relationMap.values()) && (result = this.fscOrderRelationMapper.updateOperationClaimAmtSubBatchCancel(new ArrayList(relationMap.values()))) != relationMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u6613\u8d2d\u7ed3\u7b97\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(ycOrderMap.values()) && (result = this.fscPushClaimDetailMapper.updateClaimAmtSubBatch(new ArrayList(ycOrderMap.values()))) != ycOrderMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u4e1a\u8d22\u7ed3\u7b97\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(fscShouldPayMap.values()) && (result = this.fscShouldPayMapper.updateClaimAmountSub(new ArrayList(fscShouldPayMap.values()))) != fscShouldPayMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u5e94\u4ed8\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(fscOrderMap.values()) && (result = this.fscOrderPayItemMapper.updateOperationClaimAmountSub(new ArrayList(fscOrderMap.values()))) != fscOrderMap.values().size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u4ed8\u6b3e\u5355\u8ba4\u9886\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(deductList)) {
            HashMap<String, FscCreditDeductAbilityReqBO> deductMap = new HashMap<String, FscCreditDeductAbilityReqBO>();
            for (FscCreditDeductAbilityReqBO reqBO : deductList) {
                FscCreditDeductAbilityReqBO map = (FscCreditDeductAbilityReqBO)deductMap.get(reqBO.getCreditOrgId().toString() + reqBO.getPayBusiness());
                if (map == null) {
                    map = reqBO;
                } else {
                    map.setAmount(map.getAmount().add(reqBO.getAmount()));
                }
                deductMap.put(reqBO.getCreditOrgId().toString() + reqBO.getPayBusiness(), map);
            }
            FscCreditDeductBatchBusiReqBO fscCreditDeductBatchBusiReqBO = new FscCreditDeductBatchBusiReqBO();
            fscCreditDeductBatchBusiReqBO.setDeductList(new ArrayList<FscCreditDeductAbilityReqBO>(deductMap.values()));
            FscCreditDeductBatchBusiRspBO fscCreditDeductBatchBusiRspBO = this.fscCreditDeductBatchBusiService.dealAccountDeductBatch(fscCreditDeductBatchBusiReqBO);
            if (!"0000".equals(fscCreditDeductBatchBusiRspBO.getRespCode())) {
                throw new FscBusinessException(fscCreditDeductBatchBusiRspBO.getRespCode(), fscCreditDeductBatchBusiRspBO.getRespDesc());
            }
        }
    }

    private List<Long> updateChangeBillStatus(List<FscClaimDetailChangePO> detailChangeList) {
        List changeIdList = detailChangeList.stream().map(FscClaimDetailChangePO::getChangeId).distinct().collect(Collectors.toList());
        FscClaimDetailChangePO detailChangePO = new FscClaimDetailChangePO();
        detailChangePO.setChangeIdList(changeIdList);
        detailChangeList = this.fscClaimDetailChangeMapper.queryAll(detailChangePO);
        HashMap<Long, Integer> changeStatusMap = new HashMap<Long, Integer>();
        for (FscClaimDetailChangePO po : detailChangeList) {
            Integer confirmStatus = (Integer)changeStatusMap.get(po.getChangeId());
            if (confirmStatus == null || FscConstants.ChangeConfirmStatus.CANCEL.equals(confirmStatus)) {
                changeStatusMap.put(po.getChangeId(), po.getConfirmStatus());
                continue;
            }
            if (!FscConstants.ChangeConfirmStatus.CONFIRMED.equals(confirmStatus) || FscConstants.ChangeConfirmStatus.CANCEL.equals(po.getConfirmStatus())) continue;
            changeStatusMap.put(po.getChangeId(), po.getConfirmStatus());
        }
        ArrayList<Long> cancelList = new ArrayList<Long>();
        ArrayList<Long> confirmedList = new ArrayList<Long>();
        for (Long changeId : changeStatusMap.keySet()) {
            if (FscConstants.ChangeConfirmStatus.CANCEL.equals(changeStatusMap.get(changeId))) {
                cancelList.add(changeId);
                continue;
            }
            if (!FscConstants.ChangeConfirmStatus.CONFIRMED.equals(changeStatusMap.get(changeId))) continue;
            confirmedList.add(changeId);
        }
        FscRecvClaimChangePO fscRecvClaimChangePO = new FscRecvClaimChangePO();
        if (!CollectionUtils.isEmpty(cancelList)) {
            fscRecvClaimChangePO.setChangeIdList(cancelList);
            fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CANCEL);
            this.fscRecvClaimChangeMapper.updateBillStatus(fscRecvClaimChangePO);
        }
        if (!CollectionUtils.isEmpty(confirmedList)) {
            fscRecvClaimChangePO.setChangeIdList(confirmedList);
            fscRecvClaimChangePO.setBillStatus(FscConstants.ChangeBillStatus.CONFIRMED);
            this.fscRecvClaimChangeMapper.updateBillStatus(fscRecvClaimChangePO);
        }
        return confirmedList;
    }
}

