/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.enums.FscOperatorTypeEnum;
import com.tydic.fsc.bill.atom.api.finance.FscSyncContractSettlementDetailAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscSyncContractSettlementDetailAtomRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderCancelAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderCancelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.UocApprovalLogPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscComOrderCancelBusiServiceImpl
implements FscComOrderCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderCancelBusiServiceImpl.class);
    @Autowired
    private FscOrderCancelAtomService fscOrderCancelAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscSyncContractSettlementDetailAtomService fscSyncContractSettlementDetailAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    public static final String JSD_WXY_NAME = "JSD-WXY";
    public static final String JSD_NAME = "CG";
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @Override
    public FscComOrderCancelBusiRspBO dealOrderCancel(FscComOrderCancelBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString((Object)((Object)reqBO));
        FscOrderCancelAtomReqBO fscOrderCancelAtomReqBO = (FscOrderCancelAtomReqBO)JSON.parseObject((String)jsonString, FscOrderCancelAtomReqBO.class);
        FscOrderCancelAtomRspBO fscOrderCancelAtomRspBO = this.fscOrderCancelAtomService.dealCancelStatus(fscOrderCancelAtomReqBO);
        if (!"0000".equals(fscOrderCancelAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193124", fscOrderCancelAtomRspBO.getRespDesc());
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO.setCancelOperId(reqBO.getUserId().toString());
        fscOrderPO.setCancelTime(new Date());
        fscOrderPO.setCancelOperName(reqBO.getName());
        this.fscOrderMapper.updateById(fscOrderPO);
        FscOrderItemPO itemQueryVo = new FscOrderItemPO();
        itemQueryVo.setFscOrderId(reqBO.getOrderId());
        List orderItemPOList = this.fscOrderItemMapper.getList(itemQueryVo);
        List inspectionIdList = orderItemPOList.stream().map(FscOrderItemPO::getAcceptOrderId).collect(Collectors.toList());
        FscShouldPayPO shouldPayQueryVo = new FscShouldPayPO();
        shouldPayQueryVo.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_FREEZE);
        shouldPayQueryVo.setInspectionIdList(inspectionIdList);
        List shouldPayPOList = this.fscShouldPayMapper.getList(shouldPayQueryVo);
        for (FscShouldPayPO fscShouldPayPO : shouldPayPOList) {
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        }
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            this.fscShouldPayMapper.updateStatusByBatch(shouldPayPOList);
        }
        this.fscShouldPayMapper.deleteFinanceAndPay(reqBO.getOrderId());
        if (null != reqBO.getRefundId()) {
            FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
            fscOrderRefundPO.setRefundId(reqBO.getRefundId());
            fscOrderRefundPO.setReopenFlag(FscConstants.ReopenFlag.NO);
            this.fscOrderRefundMapper.updateById(fscOrderRefundPO);
        }
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getOrderId());
        }
        catch (Exception e) {
            log.error("getApprovalResult get stationId error:{}", (Throwable)e);
        }
        if (reqBO.getIsEngineering().booleanValue()) {
            this.syncContract(reqBO.getOrderId());
        } else {
            try {
                if (Objects.nonNull(reqBO.getOrderNo()) && Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                    TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                    todoFscWaitAbilityReqBO.setCenterCode("settle");
                    todoFscWaitAbilityReqBO.setBusiCode("1032");
                    todoFscWaitAbilityReqBO.setBusiName("\u9500\u552e\u7ed3\u7b97\u5355");
                    if (!reqBO.getOrderNo().contains(JSD_WXY_NAME)) {
                        if (reqBO.getOrderNo().contains(JSD_NAME)) {
                            todoFscWaitAbilityReqBO.setBusiCode("1031");
                            todoFscWaitAbilityReqBO.setBusiName("\u91c7\u8d2d\u7ed3\u7b97\u5355");
                        }
                    } else {
                        todoFscWaitAbilityReqBO.setBusiCode("1036");
                        todoFscWaitAbilityReqBO.setBusiName("\u804c\u80fd\u7ed3\u7b97\u4ed8\u6b3e");
                    }
                    todoFscWaitAbilityReqBO.setObjId(reqBO.getOrderId());
                    todoFscWaitAbilityReqBO.setOperatorType("2");
                    todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                    this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
                }
            }
            catch (Exception e) {
                log.error("dealOrderApproval error:{}", (Throwable)e);
            }
            this.syncOrderStatus(reqBO.getOrderId());
        }
        return new FscComOrderCancelBusiRspBO();
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void syncContract(Long fscOrderId) {
        FscSyncContractSettlementDetailAtomReqBO fscSyncContractSettlementDetailAtomReqBO = new FscSyncContractSettlementDetailAtomReqBO();
        fscSyncContractSettlementDetailAtomReqBO.setFscOrderId(fscOrderId);
        fscSyncContractSettlementDetailAtomReqBO.setOperatorType(FscOperatorTypeEnum.SUBTRACT.getCode());
        FscSyncContractSettlementDetailAtomRspBO fscSyncContractSettlementDetailAtomRspBO = this.fscSyncContractSettlementDetailAtomService.syncContractSettlementDetail(fscSyncContractSettlementDetailAtomReqBO);
        if (!"0000".equals(fscSyncContractSettlementDetailAtomRspBO.getRespCode())) {
            throw new FscBusinessException("191125", "\u5de5\u7a0b\u670d\u52a1\u540c\u6b65\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u51fa\u9519\uff1a" + fscSyncContractSettlementDetailAtomRspBO.getRespDesc());
        }
    }
}

