/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceOccupyRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleaseRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomBankBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomDraftBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceOccupyRefundInfoAtomSupplyBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.common.ability.api.FscPushEngTodoAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushEngTodoAbilityServiceReqBO;
import com.tydic.fsc.common.busi.api.FscEngineeringRefundPayApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscEngineeringRefundPayApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscEngineeringRefundPayApprovalBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalReqBankStatementBusiBO;
import com.tydic.fsc.common.busi.bo.FscFinancePayRefundApprovalReqDraftInfoBusiBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscEngineeringRefundPayApprovalBusiServiceImpl
implements FscEngineeringRefundPayApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringRefundPayApprovalBusiServiceImpl.class);
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceOccupyRefundInfoAtomService fscFinanceOccupyRefundInfoAtomService;
    @Autowired
    private FscFinanceReleaseRefundInfoAtomService fscFinanceReleaseRefundInfoAtomService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscPushEngTodoAbilityService fscPushEngTodoAbilityService;
    private static final String BUSI_NAME = "\u5bf9\u63a5\u5171\u4eab\u5ba1\u6279";

    @Override
    public FscEngineeringRefundPayApprovalBusiRspBO dealEngineeringRefundPayApproval(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        FscEngineeringRefundPayApprovalBusiRspBO rspBO = new FscEngineeringRefundPayApprovalBusiRspBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(reqBO.getRefundId());
        FscPayRefundDetailPO fscPayRefundDetailPO = this.getPayRefundDetail(reqBO.getRefundId());
        FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(reqBO.getRefundId());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.processTaskApproval(reqBO, reqBO.getRefundId(), fscOrderRefundPO);
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
            refundIds.add(reqBO.getRefundId());
            paramMap.put("auditFlag", "0");
            this.dealRefundStatusFlow(fscOrderRefundPO, paramMap);
        } else if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 1) {
            paramMap.put("auditFlag", "1");
            this.dealRefundStatusFlow(fscOrderRefundPO, paramMap);
        }
        this.updateRefundFinance(reqBO, reqBO.getRefundId(), auditRspBO);
        if (!CollectionUtils.isEmpty(reqBO.getBankStatementList()) || !CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            this.releaseRefundInfo(reqBO.getRefundId(), fscOrderRefundPO);
            this.dealAddFinanceBankStatement(reqBO, fscPayRefundDetailPO);
            this.dealAddFinanceDraftInfo(reqBO, fscPayRefundDetailPO);
            this.dealAddFinanceCapitalPlan(reqBO);
            if (reqBO.getAuditResult() == 0) {
                this.occupyRefundInfo(reqBO, fscOrderRefundPO, fscRefundFinancePO);
            }
        }
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList()) && CollectionUtils.isEmpty(reqBO.getDraftInfoList()) && reqBO.getAuditResult() == 1) {
            this.releaseRefundInfo(reqBO.getRefundId(), fscOrderRefundPO);
        }
        try {
            FscPushEngTodoAbilityServiceReqBO todoAbilityServiceReqBO = new FscPushEngTodoAbilityServiceReqBO();
            todoAbilityServiceReqBO.setBusiCode("1015");
            todoAbilityServiceReqBO.setBusiName("\u5de5\u7a0b\u670d\u52a1\u9000\u6b3e\u5355");
            todoAbilityServiceReqBO.setObjId(reqBO.getRefundId());
            todoAbilityServiceReqBO.setOperatorType(TaskWaitDoneEnum.PUSH_TODO_OPERATOR_AUDIT);
            this.fscPushEngTodoAbilityService.dealEngPushTodo(todoAbilityServiceReqBO);
        }
        catch (Exception e) {
            log.error("dealEngineeringRefundPayApproval -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
        this.toSendText(reqBO, fscOrderRefundPO);
        rspBO.setRefundIds(refundIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void toSendText(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        String type = this.getTypeByRefundId(reqBO.getRefundId());
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderRefundPO.getRefundNo() + "\u9000\u6b3e\u7533\u8bf7\u5355_" + type + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setReceiveIds((List)CollectionUtil.newArrayList((Object[])new Long[]{fscOrderRefundPO.getCreateUserId()}));
            if (FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            }
            if (FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u9000\u6b3e\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            }
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("dealEngineeringInvoiceAudit\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private String getTypeByRefundId(Long refundId) {
        List fscPayRefundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(refundId);
        if (CollectionUtils.isEmpty((Collection)fscPayRefundDetailList)) {
            return null;
        }
        FscPayShouldRefundPO fscPayShouldRefundPO = this.fscPayShouldRefundMapper.queryById(((FscPayRefundDetailPO)fscPayRefundDetailList.get(0)).getRefundShouldPayId());
        if (null == fscPayShouldRefundPO) {
            return null;
        }
        Integer businessType = fscPayShouldRefundPO.getBusinessType();
        String type = Integer.valueOf(1).equals(businessType) ? "\u5de5\u7a0b\u6b3e" : (Integer.valueOf(2).equals(businessType) ? "\u670d\u52a1\u6b3e" : null);
        return type;
    }

    private void dealAddFinanceBankStatement(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceBankStatement(reqBO, fscPayRefundDetailPO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceBankStatementByTemp(reqBO, fscPayRefundDetailPO);
        }
    }

    private void addFinanceBankStatement(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return;
        }
        List addBankStatementList = JUtil.jsl(reqBO.getBankStatementList(), FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void addFinanceBankStatementByTemp(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceBankStatementPO deleteFscFinanceBankStatement = new FscFinanceBankStatementPO();
        deleteFscFinanceBankStatement.setRefundId(reqBO.getRefundId());
        this.fscFinanceBankStatementMapper.deleteBy(deleteFscFinanceBankStatement);
        List<FscFinanceBankStatementTempPO> financeBankStatementTempList = this.getFinanceBankStatementTempList(reqBO);
        if (CollectionUtils.isEmpty(financeBankStatementTempList)) {
            return;
        }
        List addBankStatementList = JUtil.jsl(financeBankStatementTempList, FscFinanceBankStatementPO.class);
        for (FscFinanceBankStatementPO bankStatement : addBankStatementList) {
            bankStatement.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatement.setCreateTime(new Date());
        }
        this.fscFinanceBankStatementMapper.insertBatch(addBankStatementList);
    }

    private void dealAddFinanceDraftInfo(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceDraftInfo(reqBO, fscPayRefundDetailPO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceDraftInfoByTemp(reqBO, fscPayRefundDetailPO);
        }
    }

    private void addFinanceDraftInfo(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(reqBO.getDraftInfoList(), FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void addFinanceDraftInfoByTemp(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscPayRefundDetailPO fscPayRefundDetailPO) {
        FscFinanceDraftInfoPO deleteFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        deleteFscFinanceDraftInfo.setRefundId(reqBO.getRefundId());
        this.fscFinanceDraftInfoMapper.deleteBy(deleteFscFinanceDraftInfo);
        List<FscFinanceDraftInfoTempPO> financeDraftTempList = this.getFinanceDraftTempList(reqBO);
        if (CollectionUtils.isEmpty(financeDraftTempList)) {
            return;
        }
        List addDraftInfoList = JUtil.jsl(financeDraftTempList, FscFinanceDraftInfoPO.class);
        for (FscFinanceDraftInfoPO draftInfo : addDraftInfoList) {
            draftInfo.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
            draftInfo.setCreateTime(new Date());
        }
        this.fscFinanceDraftInfoMapper.insertBatch(addDraftInfoList);
    }

    private void updateRefundFinance(FscEngineeringRefundPayApprovalBusiReqBO reqBO, Long thisRefundId, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        FscRefundFinancePO refundFinancePO = new FscRefundFinancePO();
        refundFinancePO.setRefundId(thisRefundId);
        refundFinancePO = this.fscRefundFinanceMapper.getModelBy(refundFinancePO);
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setCashItemCode(reqBO.getCashItemCode());
        updateFscRefundFinanceSet.setCashItemName(reqBO.getCashItemName());
        updateFscRefundFinanceSet.setCashDetailCode(reqBO.getCashDetailCode());
        updateFscRefundFinanceSet.setCashDetailName(reqBO.getCashDetailName());
        updateFscRefundFinanceSet.setIsAgent(reqBO.getIsAgent());
        updateFscRefundFinanceSet.setAgentCompanyCode(reqBO.getAgentCompanyCode());
        updateFscRefundFinanceSet.setAgentCompanyName(reqBO.getAgentCompanyName());
        if (StringUtils.isEmpty((CharSequence)refundFinancePO.getFinanceAuditAccount())) {
            updateFscRefundFinanceSet.setFinanceAuditName(reqBO.getName());
            updateFscRefundFinanceSet.setFinanceAuditAccount(reqBO.getUserName());
        } else if (!refundFinancePO.getFinanceAuditAccount().contains(reqBO.getUserName())) {
            updateFscRefundFinanceSet.setFinanceAuditName(refundFinancePO.getFinanceAuditName() + "," + reqBO.getName());
            updateFscRefundFinanceSet.setFinanceAuditAccount(refundFinancePO.getFinanceAuditAccount() + "," + reqBO.getUserName());
        }
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
        }
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
        }
        updateFscRefundFinanceSet.setRefundId(thisRefundId);
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(thisRefundId);
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private UacNoTaskAuditOrderAuditRspBO processTaskApproval(FscEngineeringRefundPayApprovalBusiReqBO reqBO, Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, Number> variables = new HashMap<String, Number>(1);
        variables.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        variables.put("refundAmount", fscOrderRefundPO.getRefundAmount());
        auditReqBO.setObjId((List)CollectionUtil.newArrayList((Object[])new Long[]{thisRefundId}));
        String stepId = this.fscOrderRefundMapper.selectStepId(fscOrderRefundPO.getRefundId(), FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(variables);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setOperDept(reqBO.getOrgName());
        auditReqBO.setObjType(FscConstants.AuditObjType.ENGINEERING_REFUND_PAY_APPROVAL);
        auditReqBO.setUsername(reqBO.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private FscPayRefundDetailPO getPayRefundDetail(Long thisRefundId) {
        FscPayRefundDetailPO qryFscPayRefundDetail = new FscPayRefundDetailPO();
        qryFscPayRefundDetail.setRefundId(thisRefundId);
        return this.fscPayRefundDetailMapper.getModelBy(qryFscPayRefundDetail);
    }

    private FscOrderRefundPO getOrderRefund(Long thisRefundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(thisRefundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long thisRefundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(thisRefundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private List<FscFinanceDraftInfoPO> getFinanceDraftList(Long refundId) {
        FscFinanceDraftInfoPO qryFscFinanceDraftInfo = new FscFinanceDraftInfoPO();
        qryFscFinanceDraftInfo.setRefundId(refundId);
        return this.fscFinanceDraftInfoMapper.getList(qryFscFinanceDraftInfo);
    }

    private List<FscFinanceBankStatementPO> getFinanceBankStatementList(Long refundId) {
        FscFinanceBankStatementPO qryFscFinanceBankStatement = new FscFinanceBankStatementPO();
        qryFscFinanceBankStatement.setRefundId(refundId);
        return this.fscFinanceBankStatementMapper.getList(qryFscFinanceBankStatement);
    }

    private List<FscFinanceBankStatementTempPO> getFinanceBankStatementTempList(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getBankStatementList())) {
            return null;
        }
        List tempIdList = reqBO.getBankStatementList().stream().map(FscFinancePayRefundApprovalReqBankStatementBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceBankStatementTempPO qryFscFinanceBankStatementTemp = new FscFinanceBankStatementTempPO();
        qryFscFinanceBankStatementTemp.setTempIdList(tempIdList);
        return this.fscFinanceBankStatementTempMapper.getList(qryFscFinanceBankStatementTemp);
    }

    private List<FscFinanceDraftInfoTempPO> getFinanceDraftTempList(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getDraftInfoList())) {
            return null;
        }
        List tempIdList = reqBO.getDraftInfoList().stream().map(FscFinancePayRefundApprovalReqDraftInfoBusiBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceDraftInfoTempPO qryFscFinanceDraftInfoTemp = new FscFinanceDraftInfoTempPO();
        qryFscFinanceDraftInfoTemp.setTempIdList(tempIdList);
        return this.fscFinanceDraftInfoTempMapper.getList(qryFscFinanceDraftInfoTemp);
    }

    private void occupyRefundInfo(FscEngineeringRefundPayApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO> draftList = new ArrayList<FscFinanceOccupyRefundInfoAtomDraftBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomBankBO> bankList = new ArrayList<FscFinanceOccupyRefundInfoAtomBankBO>(1);
        ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList = new ArrayList<FscFinanceOccupyRefundInfoAtomSupplyBO>(1);
        ArrayList<FscFinancePlanItemBO> planList = new ArrayList<FscFinancePlanItemBO>(1);
        this.packageOccupyRefundInfo(reqBO.getRefundId(), draftList, bankList, supplyList, planList);
        FscFinanceOccupyRefundInfoAtomReqBO fscFinanceOccupyRefundInfoAtomReqBO = new FscFinanceOccupyRefundInfoAtomReqBO();
        fscFinanceOccupyRefundInfoAtomReqBO.setObjId(fscOrderRefundPO.getRefundId());
        fscFinanceOccupyRefundInfoAtomReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgId(fscRefundFinancePO.getFinanceOrgId());
        fscFinanceOccupyRefundInfoAtomReqBO.setFinanceOrgName(fscRefundFinancePO.getFinanceOrgName());
        fscFinanceOccupyRefundInfoAtomReqBO.setDraftList(draftList);
        fscFinanceOccupyRefundInfoAtomReqBO.setBankList(bankList);
        fscFinanceOccupyRefundInfoAtomReqBO.setSupplyList(supplyList);
        fscFinanceOccupyRefundInfoAtomReqBO.setPlanList(planList);
        fscFinanceOccupyRefundInfoAtomReqBO.setRefundFlag(reqBO.getRefundFlag());
        fscFinanceOccupyRefundInfoAtomReqBO.setName(reqBO.getName());
        fscFinanceOccupyRefundInfoAtomReqBO.setUserName(reqBO.getUserName());
        FscFinanceOccupyRefundInfoAtomRspBO fscFinanceOccupyRefundInfoAtomRspBO = this.fscFinanceOccupyRefundInfoAtomService.dealOccupyRefundInfo(fscFinanceOccupyRefundInfoAtomReqBO);
        if (!fscFinanceOccupyRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceOccupyRefundInfoAtomRspBO.getRespCode(), fscFinanceOccupyRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void packageOccupyRefundInfo(Long thisRefundId, List<FscFinanceOccupyRefundInfoAtomDraftBO> draftList, List<FscFinanceOccupyRefundInfoAtomBankBO> bankList, List<FscFinanceOccupyRefundInfoAtomSupplyBO> supplyList, List<FscFinancePlanItemBO> planList) {
        List<FscFinanceDraftInfoPO> fscFinanceDraftInfoList = this.getFinanceDraftList(thisRefundId);
        List<FscFinanceBankStatementPO> financeBankStatementList = this.getFinanceBankStatementList(thisRefundId);
        List<FscFinanceCapitalPlanPO> financeCapitalPlanList = this.getFinanceCapitalPlanList(thisRefundId);
        for (FscFinanceDraftInfoPO fscFinanceDraftInfoPO : fscFinanceDraftInfoList) {
            if (FscConstants.FinanceDraftType.SUPPLY.equals(fscFinanceDraftInfoPO.getDraftType())) {
                FscFinanceOccupyRefundInfoAtomSupplyBO fscFinanceOccupyRefundInfoAtomSupplyBO = (FscFinanceOccupyRefundInfoAtomSupplyBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomSupplyBO.class);
                supplyList.add(fscFinanceOccupyRefundInfoAtomSupplyBO);
                continue;
            }
            FscFinanceOccupyRefundInfoAtomDraftBO fscFinanceOccupyRefundInfoAtomDraftBO = (FscFinanceOccupyRefundInfoAtomDraftBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceDraftInfoPO), FscFinanceOccupyRefundInfoAtomDraftBO.class);
            draftList.add(fscFinanceOccupyRefundInfoAtomDraftBO);
        }
        for (FscFinanceBankStatementPO fscFinanceBankStatementPO : financeBankStatementList) {
            FscFinanceOccupyRefundInfoAtomBankBO fscFinanceOccupyRefundInfoAtomBankBO = (FscFinanceOccupyRefundInfoAtomBankBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceBankStatementPO), FscFinanceOccupyRefundInfoAtomBankBO.class);
            bankList.add(fscFinanceOccupyRefundInfoAtomBankBO);
        }
        for (FscFinanceCapitalPlanPO fscFinanceCapitalPlanPO : financeCapitalPlanList) {
            FscFinancePlanItemBO fscFinancePlanItemBO = (FscFinancePlanItemBO)JSON.parseObject((String)JSON.toJSONString((Object)fscFinanceCapitalPlanPO), FscFinancePlanItemBO.class);
            planList.add(fscFinancePlanItemBO);
        }
    }

    private void releaseRefundInfo(Long thisRefundId, FscOrderRefundPO fscOrderRefundPO) {
        FscFinanceReleaseRefundInfoAtomReqBO fscFinanceReleaseRefundInfoAtomReqBO = new FscFinanceReleaseRefundInfoAtomReqBO();
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundId(thisRefundId);
        fscFinanceReleaseRefundInfoAtomReqBO.setRefundNo(fscOrderRefundPO.getRefundNo());
        FscFinanceReleaseRefundInfoAtomRspBO fscFinanceReleaseRefundInfoAtomRspBO = this.fscFinanceReleaseRefundInfoAtomService.dealReleaseRefundInfo(fscFinanceReleaseRefundInfoAtomReqBO);
        if (!fscFinanceReleaseRefundInfoAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscFinanceReleaseRefundInfoAtomRspBO.getRespCode(), fscFinanceReleaseRefundInfoAtomRspBO.getRespDesc());
        }
    }

    private void dealRefundStatusFlow(FscOrderRefundPO fscOrderRefundPO, Map<String, Object> paramMap) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderRefundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderRefundPO.getRefundStatus());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void dealAddFinanceCapitalPlan(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        if (reqBO.getRefundFlag() == 1) {
            this.addFinanceCapitalPlan(reqBO);
        }
        if (reqBO.getRefundFlag() == 2) {
            this.addFinanceCapitalPlanByTemp(reqBO);
        }
    }

    private void addFinanceCapitalPlan(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        FscFinanceCapitalPlanPO deleteFscFinanceCapitalPlan = new FscFinanceCapitalPlanPO();
        deleteFscFinanceCapitalPlan.setRefundId(reqBO.getRefundId());
        this.fscFinanceCapitalPlanMapper.deleteBy(deleteFscFinanceCapitalPlan);
        if (CollectionUtils.isEmpty(reqBO.getPlanList())) {
            return;
        }
        List addCapitalPlanList = JUtil.jsl(reqBO.getPlanList(), FscFinanceCapitalPlanPO.class);
        for (FscFinanceCapitalPlanPO capitalPlan : addCapitalPlanList) {
            capitalPlan.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
            capitalPlan.setCreateTime(new Date());
        }
        this.fscFinanceCapitalPlanMapper.insertBatch(addCapitalPlanList);
    }

    private void addFinanceCapitalPlanByTemp(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        FscFinanceCapitalPlanPO deleteFscFinanceCapitalPlan = new FscFinanceCapitalPlanPO();
        deleteFscFinanceCapitalPlan.setRefundId(reqBO.getRefundId());
        this.fscFinanceCapitalPlanMapper.deleteBy(deleteFscFinanceCapitalPlan);
        List<FscFinanceCapitalPlanTempPO> financeCapitalPlanTempList = this.getFinanceCapitalPlanTempList(reqBO);
        if (CollectionUtils.isEmpty(financeCapitalPlanTempList)) {
            return;
        }
        List addCapitalPlanList = JUtil.jsl(financeCapitalPlanTempList, FscFinanceCapitalPlanPO.class);
        for (FscFinanceCapitalPlanPO capitalPlan : addCapitalPlanList) {
            capitalPlan.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
            capitalPlan.setCreateTime(new Date());
        }
        this.fscFinanceCapitalPlanMapper.insertBatch(addCapitalPlanList);
    }

    private List<FscFinanceCapitalPlanTempPO> getFinanceCapitalPlanTempList(FscEngineeringRefundPayApprovalBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getPlanList())) {
            return null;
        }
        List tempIdList = reqBO.getPlanList().stream().map(FscFinancePlanItemBO::getTempId).filter(ObjectUtil::isNotEmpty).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tempIdList)) {
            return null;
        }
        FscFinanceCapitalPlanTempPO qryFscFinanceCapitalPlanTemp = new FscFinanceCapitalPlanTempPO();
        qryFscFinanceCapitalPlanTemp.setTempIdList(tempIdList);
        return this.fscFinanceCapitalPlanTempMapper.getList(qryFscFinanceCapitalPlanTemp);
    }

    private List<FscFinanceCapitalPlanPO> getFinanceCapitalPlanList(Long refundId) {
        FscFinanceCapitalPlanPO qryFscFinanceCapitalPlan = new FscFinanceCapitalPlanPO();
        qryFscFinanceCapitalPlan.setRefundId(refundId);
        return this.fscFinanceCapitalPlanMapper.getList(qryFscFinanceCapitalPlan);
    }
}

