/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.busi.api.FscFinanceInvoiceRefundApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFinanceInvoiceRefundApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscRefundFinancePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceInvoiceRefundApprovalBusiServiceImpl
implements FscFinanceInvoiceRefundApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceRefundApprovalBusiServiceImpl.class);
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    private static final String BUSI_NAME = "\u9000\u7968\u4e1a\u8d22\u5ba1\u6279";
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;

    @Override
    public FscFinanceInvoiceRefundApprovalBusiRspBO dealFinanceInvoiceRefundApproval(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO) {
        FscFinanceInvoiceRefundApprovalBusiRspBO rspBO = new FscFinanceInvoiceRefundApprovalBusiRspBO();
        ArrayList<Long> refundIds = new ArrayList<Long>();
        FscOrderRefundPO fscOrderRefundPO = this.getOrderRefund(reqBO.getRefundId());
        FscRefundFinancePO fscRefundFinancePO = this.getRefundFinance(reqBO.getRefundId());
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.processTaskApproval(reqBO, reqBO.getRefundId(), fscOrderRefundPO, fscRefundFinancePO);
        this.dealRefundStatusFlow(reqBO, fscOrderRefundPO, auditRspBO);
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
            refundIds.add(reqBO.getRefundId());
        }
        this.updateRefundFinance(reqBO, reqBO.getRefundId(), auditRspBO);
        this.sendFinanceApprovalNotice(reqBO, fscOrderRefundPO, auditRspBO);
        this.sendFinanceApprovalTodo(reqBO, fscOrderRefundPO);
        rspBO.setRefundIds(refundIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateRefundFinance(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, Long thisRefundId, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        FscRefundFinancePO updateFscRefundFinanceSet = new FscRefundFinancePO();
        updateFscRefundFinanceSet.setRefundId(thisRefundId);
        updateFscRefundFinanceSet.setCashItemCode(reqBO.getCashItemCode());
        updateFscRefundFinanceSet.setCashItemName(reqBO.getCashItemName());
        updateFscRefundFinanceSet.setCashDetailCode(reqBO.getCashDetailCode());
        updateFscRefundFinanceSet.setCashDetailName(reqBO.getCashDetailName());
        updateFscRefundFinanceSet.setFinanceAuditName(reqBO.getName());
        updateFscRefundFinanceSet.setFinanceAuditAccount(reqBO.getUserName());
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_PASS);
            updateFscRefundFinanceSet.setPushFinanceStatus(FscConstants.FscPushStatus.NO_PUSH);
        }
        if (auditRspBO.getNoneInstanceBO().getFinish().booleanValue() && FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
            updateFscRefundFinanceSet.setFinanceAuditStatus(FscConstants.AuditStatus.AUDIT_REJECT);
        }
        FscRefundFinancePO updateFscRefundFinanceWhere = new FscRefundFinancePO();
        updateFscRefundFinanceWhere.setRefundId(thisRefundId);
        this.fscRefundFinanceMapper.updateBy(updateFscRefundFinanceSet, updateFscRefundFinanceWhere);
    }

    private UacNoTaskAuditOrderAuditRspBO processTaskApproval(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, Long thisRefundId, FscOrderRefundPO fscOrderRefundPO, FscRefundFinancePO fscRefundFinancePO) {
        String stepId = this.fscOrderMapper.selectRefundStepId(thisRefundId, FscConstants.AuditObjType.FINANCE_PURCHASE_REFUND_INVOICE_PROCESS, fscRefundFinancePO.getFinanceAuditStatus());
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, Number> variables = new HashMap<String, Number>(1);
        variables.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        variables.put("refundAmount", fscOrderRefundPO.getRefundAmount());
        auditReqBO.setObjId((List)CollectionUtil.newArrayList((Object[])new Long[]{thisRefundId}));
        auditReqBO.setStepId(stepId);
        auditReqBO.setVariables(variables);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setOperDept(reqBO.getOrgName());
        auditReqBO.setObjType(FscConstants.AuditObjType.FINANCE_PURCHASE_REFUND_INVOICE_PROCESS);
        auditReqBO.setUsername(reqBO.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u6d41\u7a0b\u4efb\u52a1\u5ba1\u6279\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    private void dealRefundStatusFlow(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        if (!auditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
            return;
        }
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        paramMap.put("auditResult", reqBO.getAuditResult());
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderRefundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderRefundPO.getRefundStatus());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private FscOrderRefundPO getOrderRefund(Long thisRefundId) {
        FscOrderRefundPO qryFscOrderRefund = new FscOrderRefundPO();
        qryFscOrderRefund.setRefundId(thisRefundId);
        return this.fscOrderRefundMapper.getModelBy(qryFscOrderRefund);
    }

    private FscRefundFinancePO getRefundFinance(Long refundId) {
        FscRefundFinancePO qryFscRefundFinance = new FscRefundFinancePO();
        qryFscRefundFinance.setRefundId(refundId);
        return this.fscRefundFinanceMapper.getModelBy(qryFscRefundFinance);
    }

    private void sendFinanceApprovalNotice(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO, UacNoTaskAuditOrderAuditRspBO auditRspBO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        if (!auditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
            return;
        }
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String orderTypeStr = (String)orderTypeMap.get(String.valueOf(fscOrderRefundPO.getOrderType()));
        if (FscConstants.OrderFlow.ENGINEERING_INVOICE_REFUND.equals(fscOrderRefundPO.getOrderFlow())) {
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setRefundId(reqBO.getRefundId());
            List poList = this.fscOrderRelationMapper.getList(orderRelationPO);
            if (CollectionUtils.isEmpty((Collection)poList) || null == ((FscOrderRelationPO)poList.get(0)).getBusinessType()) {
                log.info("\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u5931\u8d25");
                return;
            }
            Integer businessType = ((FscOrderRelationPO)poList.get(0)).getBusinessType();
            if (Integer.valueOf(1).equals(businessType)) {
                orderTypeStr = "\u5de5\u7a0b\u6b3e";
            } else if (Integer.valueOf(2).equals(businessType)) {
                orderTypeStr = "\u670d\u52a1\u6b3e";
            } else {
                log.info("\u672a\u77e5\u4e1a\u52a1\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)businessType);
                return;
            }
        }
        try {
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderRefundPO.getRefundNo() + "\u9000\u7968\u7533\u8bf7\u5355_" + "_" + orderTypeStr + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
            fscSendNotificationExtAtomReqBO.setReceiveIds((List)CollectionUtil.newArrayList((Object[])new Long[]{fscOrderRefundPO.getCreateUserId()}));
            if (FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u9000\u7968\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            }
            if (FscConstants.AuditResultStatus.REFUSE.equals(reqBO.getAuditResult())) {
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u63d0\u4ea4\u7684\u9000\u7968\u7533\u8bf7\u5355" + fscOrderRefundPO.getRefundNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            }
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u9000\u7968\u4e1a\u8d22\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5ba1\u6279\u901a\u77e5\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void sendFinanceApprovalTodo(FscFinanceInvoiceRefundApprovalBusiReqBO reqBO, FscOrderRefundPO fscOrderRefundPO) {
        if (!FscConstants.SettlePlatform.FINANCE.equals(fscOrderRefundPO.getSettlePlatform())) {
            return;
        }
        try {
            UocApprovalLogPO uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getRefundId());
            if (ObjectUtil.isEmpty((Object)uocApprovalLogPO) || ObjectUtil.isEmpty((Object)uocApprovalLogPO.getNextStationId())) {
                log.info("\u9000\u7968\u4e1a\u8d22\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5ba1\u6279\u5f85\u529e\u5931\u8d25: {}", (Object)"\u83b7\u53d6\u5ba1\u6279\u6d41\u7a0b\u8282\u70b9\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
            todoFscWaitAbilityReqBO.setCenterCode("settle");
            todoFscWaitAbilityReqBO.setBusiCode("1301");
            todoFscWaitAbilityReqBO.setBusiName("\u91c7\u8d2d\u9000\u7968\u5ba1\u6279(\u8d22\u52a1\u5171\u4eab)");
            todoFscWaitAbilityReqBO.setObjId(reqBO.getRefundId());
            todoFscWaitAbilityReqBO.setOperatorType("1");
            todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
            this.taskTodoWaitService.saleRefundHandler(todoFscWaitAbilityReqBO);
        }
        catch (Exception e) {
            log.error("\u9000\u7968\u4e1a\u8d22\u5ba1\u6279|\u53d1\u9001\u8d22\u52a1\u5171\u4eab\u91c7\u8d2d\u5ba1\u6279\u5f85\u529e\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }
}

