/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.busi.api.FscOrderInvoiceBackBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceBackBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderInvoiceBackBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderInvoiceBackBusiServiceImpl
implements FscOrderInvoiceBackBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    public static final String BUSI_NAME = "\u8fd0\u8425\u9000\u56de";
    public static final String BUSI_CODE = "1032";

    @Override
    public FscOrderInvoiceBackBusiRspBO dealOrderInvoiceBack(FscOrderInvoiceBackBusiReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPo = this.fscOrderMapper.getModelBy(orderPO);
        if (fscOrderPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscOrderInvoiceBackBusiRspBO busiRspBO = new FscOrderInvoiceBackBusiRspBO();
        if (!(fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED) || fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.APPROVAL_REJECT) || fscOrderPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_UN_CONFIRMED))) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u4e0d\u6ee1\u8db3\u9000\u56de\u72b6\u6001\uff01");
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.REJECT_ORDER);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194308", flowAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(fscOrderPo.getFscOrderId());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.BACK);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

