/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.common.busi.api.FscRecvReceivePaymentBusiService;
import com.tydic.fsc.common.busi.bo.FscRecvReceivePaymentApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRecvReceivePaymentApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRecvReceivePaymentBusiServiceImpl
implements FscRecvReceivePaymentBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRecvReceivePaymentBusiServiceImpl.class);
    public static final String PASS = "0";
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;

    @Override
    public FscRecvReceivePaymentApprovalBusiRspBO receivePaymentApproval(FscRecvReceivePaymentApprovalBusiReqBO reqBO) {
        FscRecvReceivePaymentApprovalBusiRspBO busiRspBO = new FscRecvReceivePaymentApprovalBusiRspBO();
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBO.getOrderId());
        }
        catch (Exception e) {
            log.error("dealOrderInvoiceSignApproval get stationId error:{}", (Throwable)e);
        }
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscRecvClaimChangePO fscRecvClaimChangePO = this.fscRecvClaimChangeMapper.queryById(reqBO.getOrderId());
        FscTaskCandidatePO fscTaskCandidateQueryVo = new FscTaskCandidatePO();
        fscTaskCandidateQueryVo.setFscOrderId(fscRecvClaimChangePO.getChangeId());
        List auditedList = this.fscTaskCandidateMapper.getAuditedPostIdAndOperIdList(fscTaskCandidateQueryVo);
        List auditedIdList = auditedList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
        String auditedIds = String.join((CharSequence)",", auditedIdList);
        fscRecvClaimChangePO.setAuitOperId("," + auditedIds + ",");
        if (PASS.equals(auditResult)) {
            if (finish.booleanValue()) {
                fscRecvClaimChangePO.setAuitState(FscConstants.auitState.CODE_1002);
                fscRecvClaimChangePO.setAuitTime(new Date());
            } else {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(reqBO.getOrderId());
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                if (CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    throw new FscBusinessException("198888", "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38");
                }
                List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                fscRecvClaimChangePO.setTaskOperId(Joiner.on((String)",").join(auditedPostIdList) + ",");
            }
        } else {
            fscRecvClaimChangePO.setAuitState(FscConstants.auitState.CODE_1003);
        }
        this.fscRecvClaimChangeMapper.update(fscRecvClaimChangePO);
        try {
            if (Objects.nonNull(uocApprovalLogPO) && Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
                todoFscWaitAbilityReqBO.setCenterCode("settle");
                todoFscWaitAbilityReqBO.setBusiCode("2300");
                todoFscWaitAbilityReqBO.setBusiName("\u6536\u6b3e\u9000\u6b3e\u5355");
                todoFscWaitAbilityReqBO.setObjId(reqBO.getOrderId());
                todoFscWaitAbilityReqBO.setOperatorType("1");
                todoFscWaitAbilityReqBO.setStationId(uocApprovalLogPO.getNextStationId());
                this.taskTodoWaitService.handler(todoFscWaitAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("dealOrderApproval error:{}", (Throwable)e);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        busiRspBO.setFinish(finish);
        busiRspBO.setAuditResult(PASS.equals(auditResult));
        return busiRspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscRecvReceivePaymentApprovalBusiReqBO reqBO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.REFUND_PAY;
        String stepId = this.fscRecvClaimChangeMapper.selectStepId(reqBO.getOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        auditReqBO.setStepId(stepId);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }
}

