/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.busi.api.FscRefundPayReceiveYcStatusBusiService;
import com.tydic.fsc.common.busi.bo.FscRefundPayReceiveYcStatusBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRefundPayReceiveYcStatusBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscClaimChangeOrginalDetailMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscClaimChangeOrginalDetailPO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRefundPayReceiveYcStatusBusiServiceImpl
implements FscRefundPayReceiveYcStatusBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscClaimChangeOrginalDetailMapper fscClaimChangeOrginalDetailMapper;
    private static final String BUSI_NAME = "\u9000\u6b3e\u4e3b\u5355\u8fc7\u8d26";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @Override
    public FscRefundPayReceiveYcStatusBusiRspBO dealRefundPayReceiveYcStatus(FscRefundPayReceiveYcStatusBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundIdList(reqBO.getRefundIdList());
        refundPO.setPostStatus(FscConstants.FscPostingStatus.POST);
        refundPO.setPostTime(reqBO.getPostingDate() == null ? new Date() : reqBO.getPostingDate());
        refundPO.setBillStatus(FscConstants.RefundBillStatus.PAIED);
        this.fscOrderRefundMapper.updateByRefundIds(refundPO);
        for (Long refundId : reqBO.getRefundIdList()) {
            refundPO = this.fscOrderRefundMapper.queryById(refundId);
            if (!FscConstants.RefundUserType.PURCHASE.equals(refundPO.getUserType()) || !FscConstants.RefundPayOrderState.REFUNDING.equals(refundPO.getRefundStatus())) continue;
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("registerFlag", FscConstants.BillRegisterFlag.REGISTER);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) continue;
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        FscRefundPayReceiveYcStatusBusiRspBO rspBO = new FscRefundPayReceiveYcStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscRefundPayReceiveYcStatusBusiRspBO dealClaimChangeReceiveYcStatus(FscRefundPayReceiveYcStatusBusiReqBO reqBO) {
        Map<Object, Object> chargeMap;
        FscRecvClaimChangePO changePO = new FscRecvClaimChangePO();
        changePO.setChangeIdList(reqBO.getRefundIdList());
        List fscRecvClaimChangePOS = this.fscRecvClaimChangeMapper.queryAll(changePO);
        FscClaimChangeOrginalDetailPO orginalDetailPO = new FscClaimChangeOrginalDetailPO();
        orginalDetailPO.setChangeIds(reqBO.getRefundIdList());
        List orginalDetailPOS = this.fscClaimChangeOrginalDetailMapper.selectList(orginalDetailPO);
        Map<Long, List<FscClaimChangeOrginalDetailPO>> orginalMap = orginalDetailPOS.stream().collect(Collectors.groupingBy(FscClaimChangeOrginalDetailPO::getChangeId));
        List fscClaimDetailPOS = this.fscClaimDetailMapper.queryItemInfo(orginalDetailPOS.stream().map(FscClaimChangeOrginalDetailPO::getClaimDetailId).collect(Collectors.toList()));
        Map<Long, FscClaimDetailPO> claimDetailMap = fscClaimDetailPOS.stream().collect(Collectors.toMap(FscClaimDetailPO::getClaimDetailId, o -> o));
        List chargeIds = fscClaimDetailPOS.stream().filter(x -> FscClaimTypeEnum.ELECTRONIC_SUPERMARKET_SAVE_CLAIM.getCode().equals(x.getClaimType()) && Objects.nonNull(x.getObjectId())).map(FscClaimDetailPO::getObjectId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(chargeIds)) {
            List fscAccountChargePOS = this.fscAccountChargeMapper.queryByIds(chargeIds);
            chargeMap = fscAccountChargePOS.stream().collect(Collectors.toMap(FscAccountChargePO::getChargeId, o -> o));
        } else {
            chargeMap = new HashMap();
        }
        ArrayList updateClaimDetailPOS = new ArrayList();
        ArrayList updateChargeList = new ArrayList();
        ArrayList updateFscShouldPayPOS = new ArrayList();
        ArrayList updateRealations = new ArrayList();
        ArrayList updateAccountPOS = new ArrayList();
        ArrayList updateClaimList = new ArrayList();
        fscRecvClaimChangePOS.forEach(x -> {
            List orginalDetailPOList = (List)orginalMap.get(x.getChangeId());
            FscRecvClaimPO claimPO = new FscRecvClaimPO();
            claimPO.setClaimId(x.getClaimId());
            claimPO.setRefundAmt(orginalDetailPOList.stream().map(FscClaimChangeOrginalDetailPO::getChangeAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            claimPO.setPreClaimAmt(orginalDetailPOList.stream().filter(o -> "14".equals(o.getClaimType())).map(FscClaimChangeOrginalDetailPO::getChangeAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            updateClaimList.add(claimPO);
            orginalDetailPOList.forEach(y -> {
                FscClaimDetailPO updateDetailPO = new FscClaimDetailPO();
                updateDetailPO.setClaimAmt(y.getChangeAmount());
                updateDetailPO.setClaimDetailId(y.getClaimDetailId());
                updateDetailPO.setWriteOffAmount(BigDecimal.ZERO);
                updateClaimDetailPOS.add(updateDetailPO);
                Integer claimType = Integer.valueOf(y.getClaimType());
                FscClaimDetailPO claimDetailPO = (FscClaimDetailPO)claimDetailMap.get(y.getClaimDetailId());
                if (claimType == 1 || claimType == 11 || claimType == 17 || claimType == 22 || claimType == 8 || claimType == 9 || claimType == 9 || claimType == 38 || claimType == 4 || claimType == 6) {
                    FscOrderRelationPO relationPO = new FscOrderRelationPO();
                    relationPO.setOperationClaimAmt(y.getChangeAmount());
                    relationPO.setFscOrderId(claimDetailPO.getFscOrderId());
                    relationPO.setAcceptOrderId(claimDetailPO.getObjectId());
                    updateRealations.add(relationPO);
                } else if (claimType == 5) {
                    FscAccountChargePO po = new FscAccountChargePO();
                    po.setChargeId(claimDetailPO.getObjectId());
                    FscAccountChargePO fscAccountChargePO = (FscAccountChargePO)chargeMap.get(claimDetailPO.getObjectId());
                    po.setChargeAmount(fscAccountChargePO.getChargeAmount().subtract(y.getChangeAmount()));
                    updateChargeList.add(po);
                    FscAccountPO accountPo = new FscAccountPO();
                    accountPo.setId(fscAccountChargePO.getAccountId());
                    accountPo.setOrderAmount(y.getChangeAmount());
                    updateAccountPOS.add(accountPo);
                } else {
                    FscShouldPayPO bo = new FscShouldPayPO();
                    bo.setShouldPayId(claimDetailPO.getObjectId());
                    bo.setClaimAmt(y.getChangeAmount());
                    updateFscShouldPayPOS.add(bo);
                }
            });
        });
        changePO.setPostingStatus("1");
        changePO.setPostingDate(reqBO.getPostingDate() == null ? new Date() : reqBO.getPostingDate());
        this.fscRecvClaimChangeMapper.updatePostingStatus(changePO);
        if (!CollectionUtils.isEmpty(updateClaimList)) {
            this.fscRecvClaimMapper.updateChangeRefundAmtBatch(updateClaimList);
        }
        if (!CollectionUtils.isEmpty(updateClaimDetailPOS)) {
            this.fscClaimDetailMapper.updateBatchPostingStatus(updateClaimDetailPOS);
        }
        if (!CollectionUtils.isEmpty(updateRealations)) {
            this.fscOrderRelationMapper.updateOperationClaimAmtSubBatchCancel(updateRealations);
        }
        if (!CollectionUtils.isEmpty(updateChargeList)) {
            this.fscAccountChargeMapper.updateBathList(updateChargeList);
        }
        if (!CollectionUtils.isEmpty(updateFscShouldPayPOS)) {
            this.fscShouldPayMapper.updateClaimAmountSub(updateFscShouldPayPOS);
        }
        if (!CollectionUtils.isEmpty(updateAccountPOS)) {
            this.fscAccountMapper.updateSubChangeAmt(updateAccountPOS);
        }
        FscRefundPayReceiveYcStatusBusiRspBO rspBO = new FscRefundPayReceiveYcStatusBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

