/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealRefundTempDelReqBO;
import com.tydic.fsc.common.busi.api.finance.FscFinanceDealRefundTempDelBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscFinanceDealRefundTempDelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinanceRefundItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinanceRefundItemTempPO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceDealRefundTempDelBusiServiceImpl
implements FscFinanceDealRefundTempDelBusiService {
    @Resource
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Resource
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Resource
    private FscFinanceRefundItemTempMapper fscFinanceRefundItemTempMapper;
    @Resource
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscFinanceDealRefundTempDelBusiRspBO dealRefundTempDel(FscFinanceDealRefundTempDelReqBO reqBo) {
        this.valid(reqBo);
        Long tempId = reqBo.getTempId();
        Long contractId = reqBo.getContractId();
        if (reqBo.getContractId() != null) {
            FscFinanceRefundItemTempPO fscFinanceRefundItemTempPO = new FscFinanceRefundItemTempPO();
            fscFinanceRefundItemTempPO.setTempId(tempId);
            fscFinanceRefundItemTempPO.setContractId(contractId);
            this.fscFinanceRefundItemTempMapper.deleteBy(fscFinanceRefundItemTempPO);
        }
        FscFinanceDraftInfoTempPO draftInfoTempPO = new FscFinanceDraftInfoTempPO();
        draftInfoTempPO.setTempId(tempId);
        draftInfoTempPO.setContractId(contractId);
        this.fscFinanceDraftInfoTempMapper.deleteBy(draftInfoTempPO);
        FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO = new FscFinanceBankStatementTempPO();
        fscFinanceBankStatementTempPO.setTempId(tempId);
        fscFinanceBankStatementTempPO.setContractId(contractId);
        this.fscFinanceBankStatementTempMapper.deleteBy(fscFinanceBankStatementTempPO);
        FscAttachmentTempPO attachmentTempPO = new FscAttachmentTempPO();
        attachmentTempPO.setFscOrderId(tempId);
        attachmentTempPO.setContractId(contractId);
        attachmentTempPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
        this.fscAttachmentTempMapper.deleteBy(attachmentTempPO);
        FscFinanceDealRefundTempDelBusiRspBO rspBO = new FscFinanceDealRefundTempDelBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscFinanceDealRefundTempDelReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getTempId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6\u8868ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

