/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.ability.bo.finance.FscRefundInvoiceTempSyncReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscRefundInvoiceTempSyncRspBO;
import com.tydic.fsc.common.busi.api.finance.FscRefundInvoiceTempSyncBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationTempMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationTempPo;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscRefundInvoiceTempSyncBusiServiceImpl
implements FscRefundInvoiceTempSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundInvoiceTempSyncBusiServiceImpl.class);
    @Autowired
    private FscInvoiceRefundRelationTempMapper fscInvoiceRefundRelationTempMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrderRelationTempMapper fscOrderRelationTempMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @Override
    public FscRefundInvoiceTempSyncRspBO dealRefundInvoiceTempSyncBatch(FscRefundInvoiceTempSyncReqBO reqBO) {
        this.valid(reqBO);
        this.saveInvoiceInfo(reqBO);
        this.saveAbnormalInfo(reqBO);
        this.saveFileInfo(reqBO);
        FscRefundInvoiceTempSyncRspBO rspBO = new FscRefundInvoiceTempSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveInvoiceInfo(FscRefundInvoiceTempSyncReqBO reqBO) {
        List invoiceTempPOList = this.fscInvoiceRefundRelationMapper.getInvoiceTempList(reqBO.getRefundId());
        if (!CollectionUtils.isEmpty((Collection)invoiceTempPOList)) {
            for (FscInvoiceRefundRelationTempPo invoiceTempPO : invoiceTempPOList) {
                invoiceTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                invoiceTempPO.setTempId(reqBO.getTempId());
                invoiceTempPO.setCreateTime(new Date());
            }
            int count = this.fscInvoiceRefundRelationTempMapper.insertBatch(invoiceTempPOList);
            if (count != invoiceTempPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void saveAbnormalInfo(FscRefundInvoiceTempSyncReqBO reqBO) {
        FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
        fscOrderRefundPO.setRefundId(reqBO.getRefundId());
        fscOrderRefundPO = this.fscOrderRefundMapper.getModelBy(fscOrderRefundPO);
        if (null == fscOrderRefundPO) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u5355\u4e3a\u7a7a\uff01");
        }
        if (!FscConstants.RefundReasonType.ORDER_REFUND.equals(fscOrderRefundPO.getRefundReasonType())) {
            return;
        }
        List orderRelationTempPOList = this.fscOrderRelationMapper.getOrderRelationTempList(reqBO.getRefundId());
        if (!CollectionUtils.isEmpty((Collection)orderRelationTempPOList)) {
            for (FscOrderRelationTempPO relationTempPO : orderRelationTempPOList) {
                relationTempPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                relationTempPO.setTempId(reqBO.getTempId());
                relationTempPO.setFscOrderId(reqBO.getFscOrderId());
            }
            int count = this.fscOrderRelationTempMapper.insertBatch(orderRelationTempPOList);
            if (count != orderRelationTempPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u5f02\u5e38\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void saveFileInfo(FscRefundInvoiceTempSyncReqBO reqBO) {
        int count;
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setFscOrderId(reqBO.getRefundId());
        List attachmentPOList = this.fscAttachmentMapper.getList(attachmentPO);
        ArrayList<FscAttachmentTempPO> attachmentTempList = new ArrayList<FscAttachmentTempPO>(attachmentPOList.size());
        for (FscAttachmentPO fscAttachmentPO : attachmentPOList) {
            FscAttachmentTempPO tempPO = new FscAttachmentTempPO();
            BeanUtils.copyProperties((Object)fscAttachmentPO, (Object)tempPO);
            tempPO.setFscOrderId(reqBO.getTempId());
            tempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentTempList.add(tempPO);
        }
        if (!CollectionUtils.isEmpty(attachmentTempList) && (count = this.fscAttachmentTempMapper.insertBatch(attachmentTempList)) != attachmentTempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void valid(FscRefundInvoiceTempSyncReqBO reqBO) {
        if (Objects.isNull(reqBO.getTempId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getRefundId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u9000\u7968\u5355ID[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8ba2\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

