/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl.finance;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscPushContractApproveAbilityService;
import com.tydic.fsc.common.ability.bo.FscPushContractPayAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushContractPayAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDealPayResultDetailBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceDraftInfoDetailBO;
import com.tydic.fsc.common.busi.api.FscRecvClaimConfirmBusiService;
import com.tydic.fsc.common.busi.api.finance.FscSyncFinanceDealPayResultBusiService;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRespBO;
import com.tydic.fsc.common.busi.bo.finance.FscSyncFinanceDealPayResultRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayResultConfirmAbilityService;
import com.tydic.fsc.pay.atom.api.FscDealPayResultSuccessAtomService;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPayResultSuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPayResultSuccessAtomRspBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayResultConfirmReqBO;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscSyncFinanceDealPayResultBusiServiceImpl
implements FscSyncFinanceDealPayResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscSyncFinanceDealPayResultBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscDealPayResultSuccessAtomService fscDealPayResultSuccessAtomService;
    @Autowired
    private FscPayResultConfirmAbilityService fscPayResultConfirmAbilityService;
    @Autowired
    private FscPushContractApproveAbilityService fscPushContractApproveAbilityService;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscPayBillDetailAssemblyAtomService fscPayBillDetailAssemblyAtomService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscRecvClaimConfirmBusiService fscRecvClaimConfirmBusiService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    private static final Integer IS_CREDIT = 1;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    @FscDuplicateCommitLimit
    public FscSyncFinanceDealPayResultRspBO dealFinanceDealPayResult(FscSyncFinanceDealPayResultRespBO reqBO) {
        FscSyncFinanceDealPayResultRspBO rspBO = new FscSyncFinanceDealPayResultRspBO();
        log.debug("\u91d1\u878d\u4ea4\u6613\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)((Object)reqBO)));
        FscOrderPO queryFscOrderVo = new FscOrderPO();
        queryFscOrderVo.setOrderNo(reqBO.getPayOrderNo());
        queryFscOrderVo.setFscOrderId(Long.valueOf(reqBO.getPayOrderId()));
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(queryFscOrderVo);
        FscAccountChargePO fscAccountChargePO = new FscAccountChargePO();
        log.debug("\u91d1\u878d\u4ea4\u6613\u67e5\u8be2\u5230\u7684\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
        if (Objects.isNull(fscOrderPO)) {
            FscAccountChargePO queryFscAccountChargeVo = new FscAccountChargePO();
            queryFscAccountChargeVo.setAdvanceDepositNo(reqBO.getPayOrderNo());
            queryFscAccountChargeVo.setChargeId(Long.valueOf(reqBO.getPayOrderId()));
            fscAccountChargePO = this.fscAccountChargeMapper.getModelBy(queryFscAccountChargeVo);
            rspBO.setFscOrderId(fscAccountChargePO.getChargeId());
            log.debug("\u91d1\u878d\u4ea4\u6613\u67e5\u8be2\u5230\u7684\u9884\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscAccountChargePO));
            if (Objects.isNull(fscAccountChargePO.getChargeId())) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f\u6216\u9884\u4ed8\u6b3e\u5355\u4fe1\u606f!");
            }
        } else {
            rspBO.setFscOrderId(fscOrderPO.getFscOrderId());
        }
        boolean isVoluntaryPayment = true;
        if (Objects.nonNull(fscOrderPO)) {
            FscOrderFinancePO orderFinancePO = new FscOrderFinancePO();
            orderFinancePO.setFscOrderId(rspBO.getFscOrderId());
            FscOrderFinancePO orderFinance = this.fscOrderFinanceMapper.getModelBy(orderFinancePO);
            if (Objects.nonNull(orderFinance.getPaymentType()) && Objects.equals(orderFinance.getPaymentType(), FscConstants.FinancePaymentType.PASSIVITY)) {
                isVoluntaryPayment = false;
            }
        }
        if (isVoluntaryPayment) {
            FscOrderFinancePO fscOrderFinancePO = new FscOrderFinancePO();
            fscOrderFinancePO.setFscOrderId(rspBO.getFscOrderId());
            fscOrderFinancePO.setCurrency(reqBO.getDetailList().get(0).getCurrency());
            fscOrderFinancePO.setExchangeRate(reqBO.getDetailList().get(0).getExchangeRate());
            this.fscOrderFinanceMapper.updateExchangeRate(fscOrderFinancePO);
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u7684\u8d22\u52a1\u5171\u4eab\u6838\u9500\u8868\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderFinancePO));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayCertificate())) {
            ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
            for (String attachmentUrl : reqBO.getPayCertificate()) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setFscOrderId(Long.valueOf(reqBO.getPayOrderId()));
                fscAttachmentPO.setAttachmentUrl(attachmentUrl);
                fscAttachmentPO.setCreateTime(new Date());
                fscAttachmentPOList.add(fscAttachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
            log.debug("\u91d1\u878d\u4ea4\u6613\u5b58\u5165\u652f\u4ed8\u51ed\u8bc1\u6570\u636e\uff1a" + JSONObject.toJSONString(fscAttachmentPOList));
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOS = new ArrayList();
        List fscAccountChargeDetailPOS = new ArrayList();
        if (!Objects.isNull(fscOrderPO)) {
            FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
            payItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderPayItemPOS = this.fscOrderPayItemMapper.getList(payItemPO);
            log.debug("fscOrderPayItemPOS:{}", (Object)JSONObject.toJSONString(fscOrderPayItemPOS));
            if (CollectionUtils.isEmpty(fscOrderPayItemPOS)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
            }
        }
        if (!Objects.isNull(fscAccountChargePO.getChargeId())) {
            FscAccountChargeDetailPO accountChargeDetailPO = new FscAccountChargeDetailPO();
            accountChargeDetailPO.setChargeId(fscAccountChargePO.getChargeId());
            fscAccountChargeDetailPOS = this.fscAccountChargeDetailMapper.getListByChargeId(accountChargeDetailPO);
            log.debug("fscAccountChargeDetailPOS:{}", (Object)JSONObject.toJSONString(fscAccountChargeDetailPOS));
            if (CollectionUtils.isEmpty(fscAccountChargeDetailPOS)) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4e3b\u5355\u9884\u4ed8\u6b3e\u5145\u503c\u660e\u7ec6\u76f8\u5173\u4fe1\u606f!");
            }
        }
        FscFinancePayItemPO financePayItemPO = new FscFinancePayItemPO();
        financePayItemPO.setFscOrderId(rspBO.getFscOrderId());
        List fscFinancePayItemPOS = this.fscFinancePayItemMapper.getList(financePayItemPO);
        log.debug("fscFinancePayItemPOS:{}", (Object)JSONObject.toJSONString((Object)fscFinancePayItemPOS));
        if (CollectionUtils.isEmpty((Collection)fscFinancePayItemPOS) && isVoluntaryPayment) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u4fe1\u606f\u76f8\u5173\u4fe1\u606f!");
        }
        FscFinanceBankStatementPO bankStatementPO = new FscFinanceBankStatementPO();
        bankStatementPO.setFscOrderId(rspBO.getFscOrderId());
        List bankStatementPOS = this.fscFinanceBankStatementMapper.getList(bankStatementPO);
        log.debug("bankStatementPOS:{}", (Object)JSONObject.toJSONString((Object)bankStatementPOS));
        if (CollectionUtils.isEmpty((Collection)bankStatementPOS) && !isVoluntaryPayment) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8d22\u52a1\u5171\u4eab\u94f6\u884c\u6d41\u6c34\u76f8\u5173\u4fe1\u606f!");
        }
        FscFinancePayReducePO financePayReducePO = new FscFinancePayReducePO();
        financePayReducePO.setFscOrderId(rspBO.getFscOrderId());
        List fscFinancePayReducePOS = this.fscFinancePayReduceMapper.getList(financePayReducePO);
        log.debug("fscFinancePayReducePOS:{}", (Object)JSONObject.toJSONString((Object)fscFinancePayReducePOS));
        ArrayList<FscFinanceDraftInfoPO> fscFinanceDraftInfoPOS = new ArrayList();
        if (isVoluntaryPayment) {
            FscFinanceDraftInfoPO fscFinanceDraftInfoPO = new FscFinanceDraftInfoPO();
            fscFinanceDraftInfoPO.setFscOrderId(rspBO.getFscOrderId());
            fscFinanceDraftInfoPOS = this.fscFinanceDraftInfoMapper.getList(fscFinanceDraftInfoPO);
        }
        ArrayList<FscShouldPayPO> fscShouldPaySuccessfulPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscShouldPayPO> fscShouldPayfailPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscFinancePayItemPO> fscFinancePayItemPOList = new ArrayList<FscFinancePayItemPO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOList = new ArrayList<FscOrderPayItemPO>();
        ArrayList<FscAccountChargeDetailPO> fscAccountChargeDetailPOList = new ArrayList<FscAccountChargeDetailPO>();
        ArrayList<FscFinanceDraftInfoPO> draftInfoPOList = new ArrayList<FscFinanceDraftInfoPO>();
        ArrayList<String> payFailIdList = new ArrayList<String>();
        BigDecimal allShouldPayAmount = BigDecimal.ZERO;
        if (Objects.nonNull(fscOrderPO)) {
            Object reduceAmtTotal;
            List fscOrderPayItemList;
            FscOrderPayItemPO fscOrderPayItemPO2;
            if (FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY.equals(fscOrderPO.getOrderFlow())) {
                fscOrderPayItemPO2 = new FscOrderPayItemPO();
                fscOrderPayItemPO2.setFscOrderId(fscOrderPO.getFscOrderId());
                fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO2);
                if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                    reduceAmtTotal = fscOrderPayItemList.stream().map(item -> Optional.ofNullable(item.getReduceAmt()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    allShouldPayAmount = ((BigDecimal)reduceAmtTotal).compareTo(BigDecimal.ZERO) > 0 ? fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount() != null ? fscOrderPO.getPaidAmount() : BigDecimal.ZERO).subtract((BigDecimal)reduceAmtTotal) : fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount() != null ? fscOrderPO.getPaidAmount() : BigDecimal.ZERO);
                }
            } else if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
                fscOrderPayItemPO2 = new FscOrderPayItemPO();
                fscOrderPayItemPO2.setFscOrderId(fscOrderPO.getFscOrderId());
                fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO2);
                if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                    reduceAmtTotal = fscOrderPayItemList.stream().map(item -> Optional.ofNullable(item.getReduceAmt()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    allShouldPayAmount = ((BigDecimal)reduceAmtTotal).compareTo(BigDecimal.ZERO) > 0 ? fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount() != null ? fscOrderPO.getPaidAmount() : BigDecimal.ZERO).subtract((BigDecimal)reduceAmtTotal) : fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount() != null ? fscOrderPO.getPaidAmount() : BigDecimal.ZERO);
                }
            } else {
                allShouldPayAmount = fscOrderPO.getTotalCharge().subtract(fscOrderPO.getPaidAmount() != null ? fscOrderPO.getPaidAmount() : BigDecimal.ZERO);
            }
        } else if (Objects.nonNull(fscAccountChargePO.getChargeAmount())) {
            allShouldPayAmount = fscAccountChargePO.getChargeAmount().subtract(fscAccountChargePO.getPaidAmount() != null ? fscAccountChargePO.getPaidAmount() : BigDecimal.ZERO);
        }
        BigDecimal allPayAmount = BigDecimal.ZERO;
        Map<Object, Object> paidAmountMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)fscFinancePayItemPOS) && isVoluntaryPayment) {
            paidAmountMap = fscFinancePayItemPOS.stream().collect(Collectors.toMap(FscFinancePayItemPO::getOrderPayItemId, FscFinancePayItemPO::getPayAmount, BigDecimal::add));
        }
        if (!CollectionUtils.isEmpty((Collection)bankStatementPOS) && !isVoluntaryPayment) {
            paidAmountMap = bankStatementPOS.stream().collect(Collectors.toMap(FscFinanceBankStatementPO::getOrderPayItemId, FscFinanceBankStatementPO::getOccAmt, BigDecimal::add));
        }
        for (FscFinanceDealPayResultDetailBO detailBO : reqBO.getDetailList()) {
            FscFinancePayItemPO fscFinancePayItemPO = fscFinancePayItemPOS.stream().filter(item -> Objects.equals(item.getFinancePayItemId(), Long.valueOf(detailBO.getPayDetailId()))).findFirst().orElse(new FscFinancePayItemPO());
            log.debug("fscFinancePayItemPO:{}", (Object)JSONObject.toJSONString((Object)fscFinancePayItemPO));
            FscFinanceBankStatementPO fscFinanceBankStatementPO = bankStatementPOS.stream().filter(item -> Objects.equals(item.getStatementId(), Long.valueOf(detailBO.getPayDetailId()))).findFirst().orElse(new FscFinanceBankStatementPO());
            log.debug("fscFinanceBankStatementPO:{}", (Object)JSONObject.toJSONString((Object)fscFinanceBankStatementPO));
            if (Objects.isNull(fscFinancePayItemPO.getOrderPayItemId()) && isVoluntaryPayment) {
                payFailIdList.add(detailBO.getPayDetailId());
                continue;
            }
            if (Objects.equals(detailBO.getPayStatus(), "0")) {
                FscOrderPayItemPO orderPayItemPO;
                if (Objects.nonNull(fscFinancePayItemPO.getFinancePayItemId()) && isVoluntaryPayment) {
                    FscFinancePayItemPO fsFinancePayItemPO = new FscFinancePayItemPO();
                    fsFinancePayItemPO.setFinancePayItemId(Long.valueOf(detailBO.getPayDetailId()));
                    fsFinancePayItemPO.setOrderPayItemId(fscFinancePayItemPO.getOrderPayItemId());
                    fsFinancePayItemPO.setPaidFailAmount(detailBO.getPayAmt());
                    fsFinancePayItemPO.setPaidFailAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                    fsFinancePayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAY_FAIL);
                    FscSyncFinanceDealPayResultBusiServiceImpl.updateFscFinancePayItemPO(rspBO.getFscOrderId(), detailBO, fsFinancePayItemPO, draftInfoPOList, false, fscFinanceDraftInfoPOS);
                    fscFinancePayItemPOList.add(fsFinancePayItemPO);
                }
                payFailIdList.add(detailBO.getPayDetailId());
                if (!Objects.nonNull(fscOrderPO) || !Objects.nonNull(orderPayItemPO = (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(fscOrderPayItemPO -> Objects.equals(fscOrderPayItemPO.getOrderPayItemId(), fscFinancePayItemPO.getOrderPayItemId())).findFirst().orElse(null))) continue;
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(orderPayItemPO.getShouldPayId());
                fscShouldPayPO.setPayAmount(detailBO.getPayAmt());
                fscShouldPayfailPOList.add(fscShouldPayPO);
                continue;
            }
            Object paidAmount = BigDecimal.ZERO;
            if (isVoluntaryPayment && Objects.nonNull(fscFinancePayItemPO.getOrderPayItemId())) {
                paidAmount = ((BigDecimal)paidAmount).add(Objects.nonNull(paidAmountMap.get(fscFinancePayItemPO.getOrderPayItemId())) ? (BigDecimal)paidAmountMap.get(fscFinancePayItemPO.getOrderPayItemId()) : BigDecimal.ZERO);
            }
            if (!isVoluntaryPayment && Objects.nonNull(fscFinanceBankStatementPO.getOrderPayItemId())) {
                paidAmount = ((BigDecimal)paidAmount).add(Objects.nonNull(paidAmountMap.get(fscFinanceBankStatementPO.getOrderPayItemId())) ? (BigDecimal)paidAmountMap.get(fscFinanceBankStatementPO.getOrderPayItemId()) : BigDecimal.ZERO);
            }
            log.debug("\u5e94\u4ed8\u6b3e\u91d1\u989d\uff1a{}", (Object)JSONObject.toJSONString((Object)paidAmount));
            if (Objects.nonNull(fscOrderPO)) {
                if (((BigDecimal)paidAmount).compareTo(detailBO.getPayAmt()) >= 0) {
                    FscOrderPayItemPO fscOrderPayItemPO3 = new FscOrderPayItemPO();
                    if (isVoluntaryPayment) {
                        fscOrderPayItemPO3.setOrderPayItemId(fscFinancePayItemPO.getOrderPayItemId());
                    } else {
                        fscOrderPayItemPO3.setOrderPayItemId(fscFinanceBankStatementPO.getOrderPayItemId());
                    }
                    fscOrderPayItemPO3.setPayAmount(detailBO.getPayAmt());
                    fscOrderPayItemPO3.setPayAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                    paidAmountMap.put(fscFinancePayItemPO.getOrderPayItemId(), ((BigDecimal)paidAmount).subtract(detailBO.getPayAmt()));
                    fscOrderPayItemPOList.add(fscOrderPayItemPO3);
                } else {
                    throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5df2\u4ed8\u6b3e\u91d1\u989d!");
                }
            }
            if (Objects.nonNull(fscAccountChargePO.getChargeId())) {
                if (((BigDecimal)paidAmount).compareTo(detailBO.getPayAmt()) >= 0) {
                    paidAmount = (BigDecimal)paidAmountMap.get(fscFinancePayItemPO.getOrderPayItemId());
                    FscAccountChargeDetailPO fscAccountChargeDetailPO = new FscAccountChargeDetailPO();
                    fscAccountChargeDetailPO.setId(fscFinancePayItemPO.getOrderPayItemId());
                    fscAccountChargeDetailPO.setPaidAmount(detailBO.getPayAmt());
                    fscAccountChargeDetailPO.setPaidAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                    paidAmountMap.put(fscFinancePayItemPO.getOrderPayItemId(), ((BigDecimal)paidAmount).subtract(detailBO.getPayAmt()));
                    fscAccountChargeDetailPOList.add(fscAccountChargeDetailPO);
                } else {
                    throw new FscBusinessException("190000", "\u5145\u503c\u9884\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e\u5df2\u4ed8\u6b3e\u91d1\u989d!");
                }
            }
            if (isVoluntaryPayment) {
                FscFinancePayItemPO fsFinancePayItemPO = new FscFinancePayItemPO();
                fsFinancePayItemPO.setFinancePayItemId(Long.valueOf(detailBO.getPayDetailId()));
                fsFinancePayItemPO.setPaidAmount(detailBO.getPayAmt());
                fsFinancePayItemPO.setPaidAmountLocal(detailBO.getPayAmt().multiply(detailBO.getExchangeRate()));
                fsFinancePayItemPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                FscSyncFinanceDealPayResultBusiServiceImpl.updateFscFinancePayItemPO(rspBO.getFscOrderId(), detailBO, fsFinancePayItemPO, draftInfoPOList, true, fscFinanceDraftInfoPOS);
                fscFinancePayItemPOList.add(fsFinancePayItemPO);
            }
            allPayAmount = allPayAmount.add(detailBO.getPayAmt());
            if (!Objects.nonNull(fscOrderPO)) continue;
            FscOrderPayItemPO orderPayItemPO = isVoluntaryPayment ? (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), fscFinancePayItemPO.getOrderPayItemId())).findFirst().orElse(null) : (FscOrderPayItemPO)fscOrderPayItemPOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), fscFinanceBankStatementPO.getOrderPayItemId())).findFirst().orElse(null);
            log.debug("orderPayItemPO\uff1a" + JSONObject.toJSONString((Object)orderPayItemPO));
            if (Objects.nonNull(orderPayItemPO)) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(orderPayItemPO.getShouldPayId());
                fscShouldPayPO.setPayAmount(detailBO.getPayAmt());
                fscShouldPaySuccessfulPOList.add(fscShouldPayPO);
                log.debug("shouldPay\uff1a" + JSONObject.toJSONString((Object)fscShouldPayPO));
                continue;
            }
            throw new FscBusinessException("190000", "\u901a\u8fc7\u4ed8\u6b3e\u4fe1\u606f\u7684orderPayItemId\u65e0\u6cd5\u67e5\u8be2\u5230\u4ed8\u6b3e\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
        boolean syncOrderFlag = false;
        if (Objects.nonNull(fscOrderPO)) {
            fscOrderPO.setPaidAmount(allPayAmount);
            fscOrderPO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
            if (allShouldPayAmount.compareTo(allPayAmount) == 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
                if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
                    FscPayBillDetailAssemblyAtomReqBO assetAtomReqBO = new FscPayBillDetailAssemblyAtomReqBO();
                    assetAtomReqBO.setPayOrderId(fscOrderPO.getFscOrderId());
                    assetAtomReqBO.setSettlePlatform(fscOrderPO.getSettlePlatform());
                    assetAtomReqBO.setUserId(Long.valueOf(9999L));
                    assetAtomReqBO.setSettleType(fscOrderPO.getSettleType());
                    assetAtomReqBO.setFscOrderPayItemBOS(JSON.parseArray((String)JSONObject.toJSONString(fscOrderPayItemPOS), FscOrderPayItemBO.class));
                    if (FscConstants.SettleType.INSPECTION.equals(fscOrderPO.getSettleType())) {
                        this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssembly(assetAtomReqBO);
                    } else {
                        this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssemblyByOrder(assetAtomReqBO);
                    }
                }
                if (FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY.equals(fscOrderPO.getOrderFlow())) {
                    this.updateReduceAmtByOrderId(fscOrderPO.getFscOrderId());
                }
                if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
                    syncOrderFlag = true;
                    this.updateReduceAmtByOrderId(fscOrderPO.getFscOrderId());
                }
            } else if (allPayAmount.compareTo(allShouldPayAmount) < 0 && allPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PART_PAY);
            } else if (allPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAY_FAIL);
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5931\u8d25!");
            }
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u7ed3\u7b97\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
            if ("1".equals(reqBO.getPaySource())) {
                if (allPayAmount.compareTo(fscOrderPO.getPayingAmount()) > 0) {
                    throw new FscBusinessException("190000", "\u5373\u6302\u5373\u4ed8\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u4e2d\u91d1\u989d!");
                }
            } else if (allPayAmount.compareTo(fscOrderPO.getToPayAmount()) > 0) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u5355\u672a\u4ed8\u91d1\u989d!");
            }
            fscOrderPO.setPayConfirmId(String.valueOf(reqBO.getOperAccount()));
            fscOrderPO.setPayConfirmName(reqBO.getOperName());
            fscOrderPO.setPayConfirmTime(new Date());
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscOrderPO));
            int fscOrderResult = this.fscOrderMapper.updatePaidAmountAndToPayAmount(fscOrderPO);
            if (fscOrderResult <= 0) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u6570\u636e\u5931\u8d25!");
            }
            if (!CollectionUtils.isEmpty(fscOrderPayItemPOList)) {
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscOrderPayItemPOList));
                Map<Long, FscOrderPayItemPO> mergedFscOrderPayItemMap = fscOrderPayItemPOList.stream().collect(Collectors.toMap(FscOrderPayItemPO::getOrderPayItemId, po -> {
                    FscOrderPayItemPO newPo = new FscOrderPayItemPO();
                    newPo.setOrderPayItemId(po.getOrderPayItemId());
                    newPo.setPayAmount(po.getPayAmount());
                    newPo.setPayAmountLocal(po.getPayAmountLocal());
                    return newPo;
                }, (po1, po2) -> {
                    po1.setPayAmount(po1.getPayAmount().add(po2.getPayAmount()));
                    po1.setPayAmountLocal(po1.getPayAmountLocal().add(po2.getPayAmountLocal()));
                    return po1;
                }));
                ArrayList<FscOrderPayItemPO> mergedFscOrderPayItemPOList = new ArrayList<FscOrderPayItemPO>(mergedFscOrderPayItemMap.values());
                for (FscOrderPayItemPO payItemPO : mergedFscOrderPayItemPOList) {
                    FscOrderPayItemPO orderPayItemPO = fscOrderPayItemPOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), payItemPO.getOrderPayItemId())).findFirst().orElse(null);
                    if (Objects.nonNull(orderPayItemPO) && orderPayItemPO.getPayAmount().compareTo(payItemPO.getPayAmount()) == 0) {
                        FscFinancePayReducePO fscFinancePayReducePO;
                        payItemPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                        if (!Objects.equals(payItemPO.getIsReduce(), 1) || CollectionUtils.isEmpty((Collection)fscFinancePayReducePOS) || !Objects.nonNull(fscFinancePayReducePO = (FscFinancePayReducePO)fscFinancePayReducePOS.stream().filter(item -> Objects.equals(item.getOrderPayItemId(), payItemPO.getOrderPayItemId())).findFirst().orElse(null)) || CollectionUtils.isEmpty(fscShouldPaySuccessfulPOList)) continue;
                        fscShouldPaySuccessfulPOList.stream().forEach(item -> {
                            if (Objects.equals(item.getShouldPayId(), fscFinancePayReducePO.getShouldPayId())) {
                                item.setPayAmount(item.getPayAmount().add(fscFinancePayReducePO.getReduceAmt()));
                            }
                        });
                        continue;
                    }
                    if (!Objects.nonNull(orderPayItemPO) || orderPayItemPO.getPayAmount().compareTo(payItemPO.getPayAmount()) <= 0) continue;
                    payItemPO.setPayStatus(FscConstants.FscPayOrderState.PART_PAY);
                }
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscOrderPayItemPOList));
                int fscOrderPayItemResult = this.fscOrderPayItemMapper.updatePaidAmountAndPayStatusBatch(mergedFscOrderPayItemPOList);
                if (fscOrderPayItemResult <= 0 || fscOrderPayItemResult != mergedFscOrderPayItemPOList.size()) {
                    throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        if (Objects.nonNull(fscAccountChargePO.getChargeId())) {
            fscAccountChargePO.setPaidAmount(allPayAmount);
            fscAccountChargePO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
            if (allShouldPayAmount.compareTo(allPayAmount) == 0) {
                fscAccountChargePO.setAuditStatus(FscConstants.AuditStatus.PAY_SUCCESS);
            } else if (allPayAmount.compareTo(allShouldPayAmount) < 0 && allPayAmount.compareTo(BigDecimal.ZERO) > 0) {
                fscAccountChargePO.setAuditStatus(FscConstants.AuditStatus.PAY_PART_SUCCESS);
            } else if (allPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                fscAccountChargePO.setAuditStatus(FscConstants.AuditStatus.PAY_FAIL);
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5931\u8d25!");
            }
            if (allPayAmount.compareTo(fscAccountChargePO.getChargeAmount()) > 0) {
                throw new FscBusinessException("190000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5145\u503c\u91d1\u989d!");
            }
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u9884\u4ed8\u6b3e\u4e3b\u5355\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)fscAccountChargePO));
            int fscAccountChargeResult = this.fscAccountChargeMapper.updatePaidAmount(fscAccountChargePO);
            if (fscAccountChargeResult <= 0) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u9884\u4ed8\u6b3e\u4e3b\u5355\u6570\u636e\u5931\u8d25!");
            }
            if (!CollectionUtils.isEmpty(fscAccountChargeDetailPOList)) {
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscAccountChargeDetailPOList));
                Map<Long, FscAccountChargeDetailPO> mergedFscAccountChargeDetailMap = fscAccountChargeDetailPOList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getId, po -> {
                    FscAccountChargeDetailPO newPo = new FscAccountChargeDetailPO();
                    newPo.setId(po.getId());
                    newPo.setPaidAmount(po.getPaidAmount());
                    newPo.setPaidAmountLocal(po.getPaidAmountLocal());
                    return newPo;
                }, (po1, po2) -> {
                    po1.setPaidAmount(po1.getPaidAmount().add(po2.getPaidAmount()));
                    po1.setPaidAmountLocal(po1.getPaidAmountLocal().add(po2.getPaidAmountLocal()));
                    return po1;
                }));
                ArrayList<FscAccountChargeDetailPO> mergedFscAccountChargeDetailPOList = new ArrayList<FscAccountChargeDetailPO>(mergedFscAccountChargeDetailMap.values());
                for (FscAccountChargeDetailPO fscAccountChargeDetailPO : mergedFscAccountChargeDetailPOList) {
                    FscAccountChargeDetailPO chargeDetailPO = fscAccountChargeDetailPOS.stream().filter(item -> Objects.equals(item.getId(), fscAccountChargeDetailPO.getId())).findFirst().orElse(null);
                    if (Objects.nonNull(chargeDetailPO) && chargeDetailPO.getChargeAmount().compareTo(fscAccountChargeDetailPO.getPaidAmount()) == 0) {
                        fscAccountChargeDetailPO.setPayStatus(FscConstants.FscPayOrderState.PAIED);
                        continue;
                    }
                    if (!Objects.nonNull(chargeDetailPO) || chargeDetailPO.getChargeAmount().compareTo(fscAccountChargeDetailPO.getPaidAmount()) <= 0) continue;
                    fscAccountChargeDetailPO.setPayStatus(FscConstants.FscPayOrderState.PART_PAY);
                }
                log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscAccountChargeDetailPOList));
                int fscAccountChargeDetailResult = this.fscAccountChargeDetailMapper.updatePaidAmountAndPayStatusBatch(mergedFscAccountChargeDetailPOList);
                if (fscAccountChargeDetailResult <= 0 || fscAccountChargeDetailResult != mergedFscAccountChargeDetailPOList.size()) {
                    throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u6570\u636e\u5931\u8d25!");
                }
            }
        }
        if (!CollectionUtils.isEmpty(fscFinancePayItemPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u6570\u636e\uff1a" + JSONObject.toJSONString(fscFinancePayItemPOList));
            int fscFinancePayItemResult = this.fscFinancePayItemMapper.updatePayAmountAndPayStatusBatch(fscFinancePayItemPOList);
            if (fscFinancePayItemResult <= 0 || fscFinancePayItemResult != fscFinancePayItemPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u6570\u636e\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty(draftInfoPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u7968\u636e\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(draftInfoPOList));
            int fscFinanceDraftInfoResult = this.fscFinanceDraftInfoMapper.insertBatch(draftInfoPOList);
            if (fscFinanceDraftInfoResult <= 0 || fscFinanceDraftInfoResult != draftInfoPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u8d22\u52a1\u5171\u4eab\u7968\u636e\u4fe1\u606f\u6570\u636e\u5931\u8d25!");
            }
        }
        if (!CollectionUtils.isEmpty(fscShouldPaySuccessfulPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(fscShouldPaySuccessfulPOList));
            Map<Long, FscShouldPayPO> mergedFscShouldPaySuccessfulPOMap = fscShouldPaySuccessfulPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, po -> {
                FscShouldPayPO newPo = new FscShouldPayPO();
                newPo.setShouldPayId(po.getShouldPayId());
                newPo.setPayAmount(po.getPayAmount());
                return newPo;
            }, (po1, po2) -> {
                po1.setPayAmount(po1.getPayAmount().add(po2.getPayAmount()));
                return po1;
            }));
            ArrayList<FscShouldPayPO> mergedFscShouldPaySuccessfulPOList = new ArrayList<FscShouldPayPO>(mergedFscShouldPaySuccessfulPOMap.values());
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscShouldPaySuccessfulPOList));
            int fscShouldPaySuccessfulResult = this.fscShouldPayMapper.updateByPaySuccessAndStatus(mergedFscShouldPaySuccessfulPOList);
            if (fscShouldPaySuccessfulResult <= 0 || fscShouldPaySuccessfulResult != mergedFscShouldPaySuccessfulPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u6570\u636e\u5931\u8d25!");
            }
        }
        if (syncOrderFlag) {
            this.updateOrderState(fscOrderPO, reqBO);
        }
        if (!CollectionUtils.isEmpty(fscShouldPayfailPOList)) {
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u5931\u8d25\u4fe1\u606f\u6570\u636e\uff1a" + JSONObject.toJSONString(fscShouldPayfailPOList));
            Map<Long, FscShouldPayPO> mergedFscShouldPayFailPOMap = fscShouldPayfailPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, po -> {
                FscShouldPayPO newPo = new FscShouldPayPO();
                newPo.setShouldPayId(po.getShouldPayId());
                newPo.setPayAmount(po.getPayAmount());
                return newPo;
            }, (po1, po2) -> {
                po1.setPayAmount(po1.getPayAmount().add(po2.getPayAmount()));
                return po1;
            }));
            ArrayList<FscShouldPayPO> mergedFscShouldPayFailPOList = new ArrayList<FscShouldPayPO>(mergedFscShouldPayFailPOMap.values());
            log.debug("\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u6210\u529f\u4fe1\u606f\u5408\u5e76\u540e\u6570\u636e\uff1a" + JSONObject.toJSONString(mergedFscShouldPayFailPOList));
            int fscShouldPayFailResult = this.fscShouldPayMapper.updateByPayFailAndStatus(mergedFscShouldPayFailPOList);
            if (fscShouldPayFailResult <= 0 || fscShouldPayFailResult != mergedFscShouldPayFailPOList.size()) {
                throw new FscBusinessException("190000", "\u91d1\u878d\u4ea4\u6613\u66f4\u65b0\u5e94\u4ed8\u5931\u8d25\u4fe1\u606f\u6570\u636e\u5931\u8d25!");
            }
        }
        if (fscOrderPO != null && FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode().equals(fscOrderPO.getOrderType())) {
            FscOrderExtPO fscOrderExtPO = new FscOrderExtPO();
            fscOrderExtPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscOrderExtPO = this.fscOrderExtMapper.getModelByPayOrderId(fscOrderExtPO);
            if (fscOrderExtPO != null && "4".equals(fscOrderExtPO.getFscType())) {
                String orgCode = fscOrderPO.getBuynerNo();
                UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                abilityReqBO.setOrgCode(orgCode);
                log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4e70\u53d7\u4eba\u6240\u5c5e\u673a\u6784\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
                UmcEnterpriseOrgQryDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(abilityReqBO);
                log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4e70\u53d7\u4eba\u6240\u5c5e\u673a\u6784\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
                if (!abilityRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(abilityRspBO.getRespCode(), "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
                }
                if (abilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                    throw new FscBusinessException("198888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                FscCreditDeductAtomReqBO atomReqBO = new FscCreditDeductAtomReqBO();
                atomReqBO.setCreditOrgId(abilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId());
                atomReqBO.setCreditOrgCode(orgCode);
                atomReqBO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_RETURN);
                atomReqBO.setPayBusiness("4");
                atomReqBO.setName(fscOrderPO.getCreateOperName());
                atomReqBO.setUserId(fscOrderPO.getCreateOperId());
                ArrayList<FscCreditDeductAtomBO> atomList = new ArrayList<FscCreditDeductAtomBO>();
                FscCreditDeductAtomBO atomBO = new FscCreditDeductAtomBO();
                atomBO.setAmount(fscOrderPO.getTotalCharge());
                atomBO.setObjId(fscOrderPO.getFscOrderId());
                atomBO.setOrderType(fscOrderPO.getOrderType());
                FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
                fscOrderRelationPO.setFscOrderId(fscOrderExtPO.getFscOrderId());
                List relationPOList = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
                atomBO.setAcceptOrderId(((FscOrderRelationPO)relationPOList.get(0)).getAcceptOrderId());
                atomList.add(atomBO);
                atomReqBO.setFscCreditDeductAtomBOS(atomList);
                atomReqBO.setSupId(this.operationOrgId);
                this.dealAccountDeduct(atomReqBO);
            }
        }
        this.dealSyncOrderPayItemToFinancePayItem(fscOrderPayItemPOS, rspBO);
        log.info("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\uff0c\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3-------");
        CompletableFuture.runAsync(() -> {
            try {
                FscPushContractPayAbilityReqBO fscPushContractPayAbilityReqBO = new FscPushContractPayAbilityReqBO();
                fscPushContractPayAbilityReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
                FscPushContractPayAbilityRspBO abilityRspBO = this.fscPushContractApproveAbilityService.dealPushContractPay(fscPushContractPayAbilityReqBO);
                if (Objects.nonNull(abilityRspBO) && "0000".equals(abilityRspBO.getRespCode())) {
                    log.error("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c-\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + abilityRspBO.getRespDesc());
                }
            }
            catch (Exception exception) {
                log.error("\u4e1a\u8d22\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c-\u4ed8\u6b3e\u5355\u4fe1\u606f\u63a8\u9001\u5408\u540c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + exception);
            }
        });
        rspBO.setPayFailIdList(payFailIdList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static void updateFscFinancePayItemPO(Long fscOrderId, FscFinanceDealPayResultDetailBO detailBO, FscFinancePayItemPO fsFinancePayItemPO, List<FscFinanceDraftInfoPO> draftInfoPOList, boolean flag, List<FscFinanceDraftInfoPO> fscDraftInfoPOList) {
        if (Objects.nonNull(detailBO.getRecvBankAccountName())) {
            fsFinancePayItemPO.setRecvBankAccountName(detailBO.getRecvBankAccountName());
        }
        if (Objects.nonNull(detailBO.getRecvBankAccountCode())) {
            fsFinancePayItemPO.setRecvBankAccountCode(detailBO.getRecvBankAccountCode());
        }
        if (Objects.nonNull(detailBO.getRecvBankName())) {
            fsFinancePayItemPO.setRecvBankName(detailBO.getRecvBankName());
        }
        if (Objects.nonNull(detailBO.getRecvBankCode())) {
            fsFinancePayItemPO.setRecvBankCode(detailBO.getRecvBankCode());
        }
        if (Objects.nonNull(detailBO.getRecvBankLinkCode())) {
            fsFinancePayItemPO.setRecvBankLinkCode(detailBO.getRecvBankLinkCode());
        }
        if (Objects.nonNull(detailBO.getRecvBankAccount())) {
            fsFinancePayItemPO.setRecvBankAccount(detailBO.getRecvBankAccount());
        }
        if (flag && !CollectionUtils.isEmpty((Collection)detailBO.getDraftList())) {
            for (FscFinanceDraftInfoDetailBO draftInfo : detailBO.getDraftList()) {
                List draftInfoList;
                if (!CollectionUtils.isEmpty(fscDraftInfoPOList) && !CollectionUtils.isEmpty(draftInfoList = fscDraftInfoPOList.stream().filter(fscDraftInfoPO -> fscDraftInfoPO.getFinancePayItemId().equals(Long.valueOf(draftInfo.getPayDetailId()))).collect(Collectors.toList()))) continue;
                FscFinanceDraftInfoPO fscFinanceDraftInfoPO = new FscFinanceDraftInfoPO();
                BeanUtils.copyProperties((Object)draftInfo, (Object)fscFinanceDraftInfoPO);
                fscFinanceDraftInfoPO.setFinancePayItemId(Long.valueOf(draftInfo.getPayDetailId()));
                fscFinanceDraftInfoPO.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
                fscFinanceDraftInfoPO.setFscOrderId(fscOrderId);
                fscFinanceDraftInfoPO.setCreateTime(new Date());
                draftInfoPOList.add(fscFinanceDraftInfoPO);
            }
        }
    }

    private void updateOrderState(FscOrderPO fscOrderPO, FscSyncFinanceDealPayResultRespBO reqBO) {
        log.debug("\u66f4\u65b0\u540c\u6b65ES\u8ba2\u5355\u72b6\u6001\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)JSONObject.toJSONString((Object)DateUtil.dateToStrLong((Date)new Date())));
        FscPayResultConfirmReqBO confirmReqBO = new FscPayResultConfirmReqBO();
        confirmReqBO.setFscOrderIds(Collections.singletonList(fscOrderPO.getFscOrderId()));
        confirmReqBO.setUserName(reqBO.getOperName());
        confirmReqBO.setUserId(Long.valueOf(reqBO.getOperAccount()));
        confirmReqBO.setYcPayFlag(Boolean.valueOf(true));
        confirmReqBO.setPayFlag(Boolean.valueOf(true));
        confirmReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
        this.invokeFscOrderStatusFlow(confirmReqBO);
        FscDealPayResultSuccessAtomReqBO atomReqBO = new FscDealPayResultSuccessAtomReqBO();
        atomReqBO.setPayFscOrderId(Collections.singletonList(fscOrderPO.getFscOrderId()));
        atomReqBO.setPayTime(DateUtil.strToDateLong((String)reqBO.getPayTime()));
        FscDealPayResultSuccessAtomRspBO atomRspBO = this.fscDealPayResultSuccessAtomService.dealPaySuccess(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            log.error("\u5904\u7406\u4ed8\u6b3e\u7ed3\u679c\u53ca\u540c\u6b65\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u4fe1\u606f\u5931\u8d25\uff1a\uff01{}", (Object)atomRspBO.getRespDesc());
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private void invokeFscOrderStatusFlow(FscPayResultConfirmReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        if (busiReqBO.getYcPayFlag() != null && busiReqBO.getYcPayFlag().booleanValue()) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        } else {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlowResult(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
    }

    private void updateOrderStateSuccess(FscOrderPO fscOrderPO) {
        FscDealPayResultSuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPayResultSuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(Arrays.asList(fscOrderPO.getFscOrderId()));
        fscDealPaySuccessAtomReqBO.setPayTime(new Date());
        FscDealPayResultSuccessAtomRspBO fscDealPayResultSuccessAtomRspBO = this.fscDealPayResultSuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!fscDealPayResultSuccessAtomRspBO.getRespCode().equals("0000")) {
            log.error("\u8c03\u7528\u6d41\u7a0b\u5931\u8d25\uff01" + fscDealPayResultSuccessAtomRspBO.getRespDesc());
            throw new FscBusinessException(fscDealPayResultSuccessAtomRspBO.getRespCode(), fscDealPayResultSuccessAtomRspBO.getRespDesc());
        }
    }

    private void dealSyncOrderPayItemToFinancePayItem(List<FscOrderPayItemPO> fscOrderPayItemPOS, FscSyncFinanceDealPayResultRspBO rspBO) {
        if (CollectionUtils.isEmpty(fscOrderPayItemPOS)) {
            return;
        }
        FscOrderFinancePO qryFscOrderFinance = new FscOrderFinancePO();
        qryFscOrderFinance.setFscOrderId(rspBO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(qryFscOrderFinance);
        if (ObjectUtil.isEmpty((Object)fscOrderFinancePO) || ObjectUtil.isEmpty((Object)fscOrderFinancePO.getPaymentType()) || !FscConstants.FinancePaymentType.PASSIVITY.equals(fscOrderFinancePO.getPaymentType())) {
            return;
        }
        ArrayList<FscFinancePayItemPO> addBatchFinancePayItemList = new ArrayList<FscFinancePayItemPO>(1);
        for (FscOrderPayItemPO fscOrderPayItemPO : fscOrderPayItemPOS) {
            FscFinancePayItemPO addFinancePayItem = (FscFinancePayItemPO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPayItemPO), FscFinancePayItemPO.class);
            addFinancePayItem.setFinancePayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            addFinancePayItem.setItemNo(fscOrderPayItemPO.getPayItemNo());
            addFinancePayItem.setFinancePayMethod("FKFS0001");
            addBatchFinancePayItemList.add(addFinancePayItem);
        }
        int addBatchFinancePayItemRow = this.fscFinancePayItemMapper.insertBatch(addBatchFinancePayItemList);
        if (addBatchFinancePayItemRow <= 0 || addBatchFinancePayItemRow != addBatchFinancePayItemList.size()) {
            log.error("\u540c\u6b65\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u5230\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u5931\u8d25");
            throw new FscBusinessException("190000", "\u540c\u6b65\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u5230\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u5931\u8d25");
        }
    }

    private void updateReduceAmtByOrderId(Long fscOrderId) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(fscOrderId);
        List fscOrderPayItemPOList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemPOList)) {
            BigDecimal reduceAmtTotal = BigDecimal.ZERO;
            for (FscOrderPayItemPO orderPayItemPO : fscOrderPayItemPOList) {
                if (orderPayItemPO.getReduceAmt() == null || orderPayItemPO.getReduceAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                this.fscShouldPayMapper.updateByPaySuccess(orderPayItemPO.getShouldPayId(), orderPayItemPO.getReduceAmt());
                reduceAmtTotal = reduceAmtTotal.add(orderPayItemPO.getReduceAmt());
            }
            if (reduceAmtTotal.compareTo(BigDecimal.ZERO) > 0) {
                this.fscOrderMapper.updateByPaySuccessFscOrder(fscOrderId, reduceAmtTotal, null);
            }
        }
    }

    public void dealAccountDeduct(FscCreditDeductAtomReqBO atomReqBO) {
        FscAccountPO fscAccountPo = new FscAccountPO();
        fscAccountPo.setOrgId(atomReqBO.getCreditOrgId());
        fscAccountPo.setBusiType(atomReqBO.getPayBusiness());
        FscAccountPO modelBy = this.fscAccountMapper.getModelBy(fscAccountPo);
        if (modelBy == null) {
            log.error("orgID:" + fscAccountPo.getOrgId() + " \u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f");
            return;
        }
        if (modelBy.getCompanyCreditAmount() == null || modelBy.getUnionCreditAmount() == null) {
            log.error("\u8d26\u6237:" + modelBy.getId() + " \u6388\u4fe1\u989d\u5ea6\u914d\u7f6e\u4e3anul");
            return;
        }
        BigDecimal companyReturnAmt = BigDecimal.ZERO;
        BigDecimal unionReturnAmt = BigDecimal.ZERO;
        List acceptIds = atomReqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAcceptOrderId).collect(Collectors.toList());
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setTabId(this.TAB_ID);
        uocInspectionDetailsListPageQueryReqBO.setInspectionVoucherIdList(acceptIds);
        uocInspectionDetailsListPageQueryReqBO.setPageSize(10000);
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uocInspectionDetailsListPageQueryReqBO));
        UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uocInspectionDetailsListPageQueryRspBO));
        if ("0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
            Map<String, String> acceptMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getWelfareType())).collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherId, UocInspectionDetailsListBO::getWelfareType, (e1, e2) -> e2));
            Map<String, String> acceptCodeMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherId, UocInspectionDetailsListBO::getInspectionVoucherCode, (e1, e2) -> e2));
            Map<String, String> acceptErpCodeMap = uocInspectionDetailsListPageQueryRspBO.getRows().stream().collect(Collectors.toMap(UocInspectionDetailsListBO::getInspectionVoucherId, UocInspectionDetailsListBO::getErpInspectionVoucherCode, (e1, e2) -> e2));
            for (FscCreditDeductAtomBO atomBO : atomReqBO.getFscCreditDeductAtomBOS()) {
                if (acceptMap.containsKey(atomBO.getAcceptOrderId().toString()) && FscConstants.WelfareType.COMPANY.equals(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString())))) {
                    companyReturnAmt = companyReturnAmt.add(atomBO.getAmount());
                    atomBO.setWelfareType(Integer.valueOf(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString()))));
                } else if (acceptMap.containsKey(atomBO.getAcceptOrderId().toString()) && FscConstants.WelfareType.UNION.equals(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString())))) {
                    unionReturnAmt = unionReturnAmt.add(atomBO.getAmount());
                    atomBO.setWelfareType(Integer.valueOf(Integer.parseInt(acceptMap.get(atomBO.getAcceptOrderId().toString()))));
                }
                atomBO.setAcceptCode(acceptCodeMap.get(atomBO.getAcceptOrderId().toString()));
                atomBO.setErpAcceptCode(acceptErpCodeMap.get(atomBO.getAcceptOrderId().toString()));
            }
        } else {
            if (!"0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode())) {
                throw new FscBusinessException("194304", uocInspectionDetailsListPageQueryRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
                throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u9a8c\u6536\u5355\u4fe1\u606f");
            }
        }
        if (companyReturnAmt.compareTo(modelBy.getCompanyCreditUseAmount()) > 0) {
            throw new FscBusinessException("194304", "orgID:" + fscAccountPo.getOrgId() + " \u516c\u53f8\u8fd8\u6b3e\u91d1\u989d\u5927\u4e8e\u5df2\u7528\u6388\u4fe1\u989d\u5ea6");
        }
        if (unionReturnAmt.compareTo(modelBy.getUnionCreditUseAmount()) > 0) {
            throw new FscBusinessException("194304", "orgID:" + fscAccountPo.getOrgId() + " \u5de5\u4f1a\u8fd8\u6b3e\u91d1\u989d\u5927\u4e8e\u5df2\u7528\u6388\u4fe1\u989d\u5ea6");
        }
        if (companyReturnAmt.compareTo(BigDecimal.ZERO) <= 0 && unionReturnAmt.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (companyReturnAmt.compareTo(BigDecimal.ZERO) > 0) {
            modelBy.setCompanyCreditReturnAmount(companyReturnAmt);
        } else {
            modelBy.setCompanyCreditReturnAmount(null);
        }
        if (unionReturnAmt.compareTo(BigDecimal.ZERO) > 0) {
            modelBy.setUnionCreditReturnAmount(unionReturnAmt);
        } else {
            modelBy.setUnionCreditReturnAmount(null);
        }
        int i = this.fscAccountMapper.updateReturnAmt(modelBy);
        if (i < 0) {
            throw new FscBusinessException("194304", "\u66f4\u65b0\u8d26\u6237\u8868\u6388\u4fe1\u8fd8\u6b3e\u5931\u8d25");
        }
        this.writeLog(modelBy, atomReqBO, companyReturnAmt, unionReturnAmt);
    }

    private void writeLog(FscAccountPO modelBy, FscCreditDeductAtomReqBO atomReqBO, BigDecimal companyReturnAmt, BigDecimal unionReturnAmt) {
        Date now = new Date();
        ArrayList<FscPayLogPO> fscPayLogPos = new ArrayList<FscPayLogPO>();
        BigDecimal companyBeforeAmt = modelBy.getCompanyCreditAmount().subtract(modelBy.getCompanyCreditUseAmount() == null ? BigDecimal.ZERO : modelBy.getCompanyCreditUseAmount());
        BigDecimal unionBeforeAmtl = modelBy.getUnionCreditAmount().subtract(modelBy.getUnionCreditUseAmount() == null ? BigDecimal.ZERO : modelBy.getUnionCreditUseAmount());
        for (FscCreditDeductAtomBO fscCreditDeductAtomBO : atomReqBO.getFscCreditDeductAtomBOS()) {
            FscPayLogPO fscPayLogPo = new FscPayLogPO();
            long nextId = Sequence.getInstance().nextId();
            fscPayLogPo.setId(Long.valueOf(nextId));
            fscPayLogPo.setOrgId(atomReqBO.getCreditOrgId());
            fscPayLogPo.setAccountId(modelBy.getId());
            fscPayLogPo.setUserName(atomReqBO.getName());
            fscPayLogPo.setCreateOperId(atomReqBO.getUserId().toString());
            fscPayLogPo.setBusiTime(now);
            fscPayLogPo.setPayeeId(atomReqBO.getSupId());
            fscPayLogPo.setBusiOrderType(Integer.valueOf(3));
            fscPayLogPo.setCreateTime(now);
            fscPayLogPo.setPayBusiness(atomReqBO.getPayBusiness());
            fscPayLogPo.setOrderType(atomReqBO.getOrderType());
            fscPayLogPo.setOrgCode(atomReqBO.getCreditOrgCode());
            fscPayLogPo.setTradeMode(atomReqBO.getTradeMode());
            fscPayLogPo.setObjId(fscCreditDeductAtomBO.getObjId());
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_WELFARE_RETURN);
            fscPayLogPo.setBusiOrderNo(fscCreditDeductAtomBO.getOrderNo());
            fscPayLogPo.setBusiOrderId(fscCreditDeductAtomBO.getOrderId());
            fscPayLogPo.setIsCredit(IS_CREDIT);
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.PAYMENT_DAYS.getCode());
            fscPayLogPo.setIsBooked(FscConstants.IsBooked.YES);
            fscPayLogPo.setDealType(FscConstants.WelfareDealType.ACCOUNT_RETURN);
            if (fscCreditDeductAtomBO.getAcceptOrderId() != null) {
                fscPayLogPo.setAcceptId(fscCreditDeductAtomBO.getAcceptOrderId().toString());
            }
            fscPayLogPo.setAcceptCode(fscCreditDeductAtomBO.getAcceptCode());
            fscPayLogPo.setErpAcceptCode(fscCreditDeductAtomBO.getErpAcceptCode());
            if (companyReturnAmt.compareTo(BigDecimal.ZERO) > 0 && FscConstants.WelfareType.COMPANY.equals(fscCreditDeductAtomBO.getWelfareType())) {
                fscPayLogPo.setAccountType(FscConstants.WelfareType.COMPANY);
                fscPayLogPo.setBusiBeforeAmount(companyBeforeAmt);
                fscPayLogPo.setBusiAfterAmount(companyBeforeAmt.add(fscCreditDeductAtomBO.getAmount()));
                fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
                FscPayLogPO companyfscPayLogPo = new FscPayLogPO();
                BeanUtils.copyProperties((Object)fscPayLogPo, (Object)companyfscPayLogPo);
                fscPayLogPos.add(companyfscPayLogPo);
                companyBeforeAmt = companyBeforeAmt.add(fscCreditDeductAtomBO.getAmount());
            }
            if (unionReturnAmt.compareTo(BigDecimal.ZERO) <= 0 || !FscConstants.WelfareType.UNION.equals(fscCreditDeductAtomBO.getWelfareType())) continue;
            fscPayLogPo.setAccountType(FscConstants.WelfareType.UNION);
            fscPayLogPo.setBusiBeforeAmount(unionBeforeAmtl);
            fscPayLogPo.setBusiAfterAmount(unionBeforeAmtl.add(fscCreditDeductAtomBO.getAmount()));
            fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
            fscPayLogPos.add(fscPayLogPo);
            unionBeforeAmtl = unionBeforeAmtl.add(fscCreditDeductAtomBO.getAmount());
        }
        this.fscPayLogMapper.insertBatch(fscPayLogPos);
    }
}

