/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.common.ability.api.FscForOrderStatisticalSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscForOrderStatisticalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscForOrderStatisticalAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscEsSyncFscForOrderStatisticalBusiService;
import com.tydic.fsc.common.busi.bo.FscEsSyncFscForOrderStatisticalReqBO;
import com.tydic.fsc.common.busi.bo.FscEsSyncFscForOrderStatisticalRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscForOrderStatisticalServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscForOrderStatisticalServiceConsumer.class);
    @Autowired
    private FscForOrderStatisticalSyncAbilityService fscForOrderStatisticalSyncAbilityService;
    @Autowired
    private FscEsSyncFscForOrderStatisticalBusiService fscEsSyncFscForOrderStatisticalBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscForOrderStatisticalAbilityRspBO abilityRspBO;
            FscForOrderStatisticalAbilityReqBO reqBO = (FscForOrderStatisticalAbilityReqBO)JSON.parseObject((String)message.getContent(), FscForOrderStatisticalAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u7ed3\u7b97-\u8ba2\u5355\u62a5\u8868\u7edf\u8ba1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
            if (!(abilityRspBO = this.fscForOrderStatisticalSyncAbilityService.qryForOrderStatistical(reqBO)).getRespCode().equals("0000")) {
                log.error(reqBO.getOrderId() + "\u67e5\u8be2\u7edf\u8ba1\u62a5\u8868\u5931\u8d25!" + abilityRspBO.getRespDesc());
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
            FscEsSyncFscForOrderStatisticalReqBO statisticalReqBO = (FscEsSyncFscForOrderStatisticalReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)abilityRspBO), FscEsSyncFscForOrderStatisticalReqBO.class));
            FscEsSyncFscForOrderStatisticalRspBO statisticalRspBO = this.fscEsSyncFscForOrderStatisticalBusiService.esSyncFscForOrderStatistical(statisticalReqBO);
            if (!statisticalRspBO.getRespCode().equals("0000")) {
                log.error("\u540c\u6b65\u7edf\u8ba1\u62a5\u8868\u5931\u8d25!" + statisticalRspBO.getRespDesc());
                return ProxyConsumerStatus.RECONSUME_LATER;
            }
        }
        catch (Exception e) {
            log.error("\u7ed3\u7b97-\u8ba2\u5355\u62a5\u8868\u7edf\u8ba1\u6d88\u8d39\u5931\u8d25\uff01" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

