/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FscSendNotificationServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscSendNotificationServiceConsumer.class);
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.debug("\u5f02\u6b65\u63a8\u9001\u901a\u77e5\u5f85\u529e\u5165\u53c2:{}" + message.getContent());
        try {
            FscSendNotificationExtAtomReqBO reqBO = (FscSendNotificationExtAtomReqBO)JSON.parseObject((String)message.getContent(), FscSendNotificationExtAtomReqBO.class);
            FscSendNotificationExtAtomRspBO rspBO = new FscSendNotificationExtAtomRspBO();
            if (reqBO.getNotificationType().equals(FscConstants.FSC_NOTIFICATION_TYPE.PAY_WAIT_AUDIT)) {
                FscOrderPO orderPO = this.qryFscOrderInfo(reqBO.getObjId());
                List<Long> receiveIds = this.qryReceiveIds(reqBO.getObjId());
                if (!CollectionUtils.isEmpty(receiveIds)) {
                    FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                    fscSendNotificationExtAtomReqBO.setTitel(orderPO.getOrderNo() + "\u4ed8\u6b3e\u7533\u8bf7\u5355_" + orderPO.getOrderTypeStr() + "_" + orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                    fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355" + orderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                    fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                    fscSendNotificationExtAtomReqBO.setReceiveIds(receiveIds);
                    rspBO = this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                }
            } else if (reqBO.getNotificationType().equals(FscConstants.FSC_NOTIFICATION_TYPE.SALE_WAIT_AUDIT)) {
                FscOrderPO orderPO = this.qryFscOrderInfo(reqBO.getObjId());
                List<Long> receiveIds = this.qryReceiveIds(reqBO.getObjId());
                if (!CollectionUtils.isEmpty(receiveIds)) {
                    FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                    fscSendNotificationExtAtomReqBO.setTitel(orderPO.getOrderNo() + "\u9500\u552e\u7ed3\u7b97_" + orderPO.getOrderTypeStr() + "_" + orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                    fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9500\u552e\u7ed3\u7b97\u5355" + orderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                    fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                    fscSendNotificationExtAtomReqBO.setReceiveIds(receiveIds);
                    rspBO = this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                }
            } else if (reqBO.getNotificationType().equals(FscConstants.FSC_NOTIFICATION_TYPE.PUR_WAIT_AUDIT)) {
                FscOrderPO orderPO = this.qryFscOrderInfo(reqBO.getObjId());
                List<Long> receiveIds = this.qryReceiveIds(reqBO.getObjId());
                if (!CollectionUtils.isEmpty(receiveIds)) {
                    FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                    fscSendNotificationExtAtomReqBO.setTitel(orderPO.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + orderPO.getOrderTypeStr() + "_" + orderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                    fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355" + orderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                    fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                    fscSendNotificationExtAtomReqBO.setReceiveIds(receiveIds);
                    rspBO = this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                }
            } else if (reqBO.getNotificationType().equals(FscConstants.FSC_NOTIFICATION_TYPE.ENG_WAIT_AUDIT)) {
                String type = this.getTypeByFscOrderId(reqBO.getObjId());
                if (StringUtils.isEmpty((Object)type)) {
                    log.error("\u5de5\u7a0b\u670d\u52a1\u4e1a\u52a1\u7c7b\u578b\u672a\u5b9a\u4e49,\u4e0d\u4e88\u5904\u7406.");
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                FscOrderPO orderPO = this.qryFscOrderInfo(reqBO.getObjId());
                List<Long> receiveIds = this.qryReceiveIds(reqBO.getObjId());
                if (!CollectionUtils.isEmpty(receiveIds)) {
                    FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                    fscSendNotificationExtAtomReqBO.setTitel(orderPO.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + type + "_\u7533\u8bf7\u5f85\u5ba1\u6279");
                    fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355" + orderPO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                    fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                    fscSendNotificationExtAtomReqBO.setReceiveIds(receiveIds);
                    rspBO = this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                }
            } else {
                log.error("\u901a\u77e5\u5f85\u529e\u7c7b\u578b\u672a\u5b9a\u4e49,\u4e0d\u4e88\u5904\u7406.");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (!StringUtils.isEmpty((Object)rspBO.getRespCode()) && !rspBO.getRespCode().equals("0000")) {
                log.error("\u5f02\u6b65\u63a8\u9001\u901a\u77e5\u5f85\u529e\u5904\u7406\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u63a8\u9001\u901a\u77e5\u5f85\u529e\u5904\u7406\u5931\u8d25\uff1a" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private String getTypeByFscOrderId(Long objId) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(objId);
        List relationPOList = this.fscOrderRelationMapper.getList(relationPO);
        if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
            return null;
        }
        Integer businessType = ((FscOrderRelationPO)relationPOList.get(0)).getBusinessType();
        String type = Integer.valueOf(1).equals(businessType) ? "\u5de5\u7a0b\u6b3e" : (Integer.valueOf(2).equals(businessType) ? "\u670d\u52a1\u6b3e" : null);
        return type;
    }

    private FscOrderPO qryFscOrderInfo(Long fscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String orderTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPO.getOrderType() + "");
        fscOrderPO.setOrderTypeStr(orderTypeStr);
        return fscOrderPO;
    }

    private List<Long> qryReceiveIds(Long fscOrderId) {
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(fscOrderId);
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
        if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
            return dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList());
        }
        log.error("\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u5ba1\u6279\u4eba\u4fe1\u606f\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)dycStationOrgSelectUserNameRspBO));
        return null;
    }
}

